/*	Convergent Technologies - System V - Jun 1983	*/
/*	"@(#)hardware.h	1.5"	*/

#ifndef hardware_h
#define hardware_h

#include <sys/types.h>
#include <sys/target.h>

/*	68000	status bits		*/

#define S_TRACE		0x8000
#define S_SUPV		0x2000
#define S_INTMASK	0x700
#define HIGH		(S_SUPV|S_INTMASK) /* high priority supervisor mode (spl 7) */
#define LOW		S_SUPV	/* low priority, supervisor mode (spl 0) */

/*
 *	WARNING:	All these definitions are set up on the assumption
 *	that they are operating on 16 bit quantities read/written from/to
 *	the even address specified as the register address.
 *	It is further assumed that all reads/writes of hardware registers
 *	will be performed as 16 bit transfers to the even byte address.
 *	It is believed that other schemes may work, but this is the way
 *	these definitions are set up.
 */

/*	Memory mapping hardware		*/
/*	see sys/pte.h	*/
/*	General Control Register - GCR		*/
/*	Write only.	Uses most significant byte of 16 bit word */

#define GCR_ADDR		((unsigned short *)0x450000)
#define SYSERR_ENABLE		0x8000		/* EE	1=enable NMI/BERR */
#define PE_INT_ENABLE		0x4000		/* PIE	1=enable PE's */
#define PE_SENSE		0x2000		/* PS	1=write odd parity */
#define ROM_DISABLE		0x1000		/* RMD	1=ROM disabled at low addr */
#define LED_ADDR		GCR_ADDR
#define LED4			0x800		/* DS4	1=off	top	*/
#define LED3			0x400		/* DS3	1=off	top-1	*/
#define LED1			0x200		/* DS1	1=off	bottom+1 */
#define LED0			0x100		/* DS0	1=off	bottom	*/
#define LED_IDLE		(LED0|LED1|LED3|LED4)
#define ALLBUTLED		0xF000		/* mask for all but the LED's */


/*	General Status Register - GSR		*/
/*	Read only.	Uses most significant byte of 16 bit word */

#define GSR_ADDR		((unsigned short *)0x410000)
#define MEM_NOT_EXIST		0x8000		/* MNP	0=no memory there */
#define LOG_WRITE		0x4000		/* LWT	1=read cycle */
#define BUS_GRANT		0x2000		/* BGNT	0=DMA 1=processor */
#define PAGE_FAULT		0x1000		/* PGF	0=page fault */
#define BUS_TIMEOUT		0x800		/* TO	1=no response */
#define PIE_STATE		0x400		/* PIE	0=PE's are disabled */
#define PARITY_ERR		0x200		/* PE	1=parity err occurred */
#define USR_IO_FAULT		0x100		/* UIE	0=user accessed I/O */

/*	Clear Status Register - CSR		*/
/*	Read/Write.	Uses most significant byte of 16 bit word */
/*	Any access to this register clears the GSR and BSR0, BSR1 */

#define CSR_ADDR		((unsigned short *)0x420000)

/*	Reset control Register - RCR		*/
/*	Read/Write.	Uses most significant byte of 16 bit word */
/*	Any access to this register is equivalent to pressing RESET */

#define RCR_ADDR		((unsigned short *)0x460000)

/*	Bus Status Register 0 - BSR0		*/
/*	Read only.	Uses least significant byte of 16 bit word */
/*	Latched at the same time as the GSR, also cleared by CSR */

#define BSR0_ADDR		((unsigned short *)0x430000)
#define MMU_ERR			0x8000		/* 0=mmu error either write
						   violation or page fault */
#define NOT_DGNT		0x4000		/* DGNT	0=bus grant to disk */
#define NOT_FCGNT		0x2000		/* FCGNT 0=bus grant to fast comm */
#define NOT_XGNT		0x1000		/* XGNT	0=bus grant to expansion */
#define	LOW_DATA_STROBE		0x100		/* Lower Data Strobe from 68010 */
#define A21_A16_MASK		0x3f		/* mask of A21 to A16 */

/*	Bus Status Register 1 - BSR1		*/
/*	Read only.	Uses all of 16 bit word */
/*	Latched at the same time as the GSR, also cleared by CSR */

#define BSR1_ADDR		((unsigned short *)0x440000)
#define A15_A00_MASK		0xffff		/* mask of A15 to A0 */
#define UPPER_DATA_STROBE	1		/* from 68010 */


/* to change from 1/2Mb kernel protection space to 1Mb (0-1/2 && 3 1/2 - 4) */
#define HI_K_ENAB_ADDR	((unsigned short *)0xC40018)
#define HI_K_DISAB_ADDR	((unsigned short *)0xC4001C)

/*	Off-board addressing registers		*/

#define MY_SLOT			((slot_t *)0)	/* lie about it */

/*	Hardware Register Definitions */

#define INIT_GCR	ROM_DISABLE+PE_SENSE+LED0+LED1+LED3+LED4	/* inital value of GCR */

/*	ourgcr must be written to whenever the real GCR is written to. */
#ifdef KERNEL
extern short	ourgcr;
#endif

/*	defines to manipulate the LED's */
#define led_init()	(*LED_ADDR = (ourgcr |= (ushort)LED_IDLE))
#define led_on(x)	(*LED_ADDR = (ourgcr &= (ushort)(~(x))))
#define led_off(x)	(*LED_ADDR = (ourgcr |= (ushort)(x)))
#define led_toggle(x)	(*LED_ADDR = (ourgcr ^= (ushort)(x)))

/*	address in vector table of a pointer to the CDT.	*/
#define pCDT	0x3F8	/* software leaves pointer in penultimate int vector */

/*	CDT signature long word	*/
#define SIG1	0x45504A52

/*		Format - to be used by crash in analyzing dump
 *
 *			0000 - 003F:	machine registers
 *			0040 - 0041:	GSR
 *			0042		set to zero
 *			0043 - 0045:	BSR
 *			0046 - 0845	memory map registers
 *			0846 - 08C5	CDT
 */

/*	Displacements from the start of a crash dump plus SAVEAREA.	*/
#define SAVEAREA	0x0000
#define SVREGS	0x0000
#define SVGSR	0x0040
#define SVBSR	0x0042
#define SVMAP	0x0046
#define SVCDT	0x0846

/*		Format of the CDT (128 bytes)
 *		signature		4 bytes
 *		lbolt			4 bytes
 *		time of day		4 bytes
 *		reason			1 byte
 *		(0 = panic, 1 = reset, 2 = poweron)
 *		boot media		1 byte
 *		(2 = fd, 1 = syq, 0 = hd)
 *		panic string		114 bytes
#define CdtSig		0x00
#define CdtLbolt	0x04
#define CdtTOD		0x08
#define CdtReason	0x0C
#define CdtMedia	0x0D
#define CdtPanic	0x0E
 */
#define SZPANIC	114
#define SZCDT	128
struct CDT {
	unsigned int	CdtSig;
	time_t		lbolt;
	time_t		time;
	char		CdtReason;
	char		CdtMedia;
	char		CdtPanic[SZPANIC];
};

/*	Disk types(see gdisk.h).	*/
/* #define HD	0		/* Winchester */
/* #define SY	1		/* syquest */
/* #define FD	2		/* Floppy */

/*	Reasons	*/
#define PANIC	0
#define RESET	1
#define POWERON	2
#define REBOOT	3

/*	Address the loader is loaded at	*/
#define LOADADDR	0x70000
#define BOOTCDT		LOADADDR-SZCDT

#endif hardware_h
