|	Convergent Technologies - System V - Jul 1983
|	"@(#)hardware.m	1.4"

#ifndef hardware_m
#define hardware_m
|MINIFRAME HARDWARE DEFINITION - processor
|	68010 ASSEMBLY INCLUDE FILE
|	(see also iohw.m for peripherals)
|
|	FILE NAME: hardware.m
|

|Memory mapping hardware
|from sys/param.h
MAXUMEM		= 1024		| max user click #
NBPC		= 0x1000	| # bytes per click
BPCSHIFT	= 12		|gets page number from addr
NCPS		= 16		|needed to correspond to megaframe rounding
CPSSHIFT	= 4		|gets segment number from addr
SEGMASK		= NCPS-1	| mask to get remaining clicks in segment
SYSPAGE		= 128		| # clicks for kernel
VPG_BASE	= 0x70000	| starting virtual address of user pages
PTE_OFFSET	= 0x0C00	|offset from start of u page of proto memory map
VUSER_START	= 0x80000	| start address of user process
VUSER_END	= 0x400000	| end address of user process
KSTACK		= 0x70600	|kernel stack address

|from sys/pte.h
PG_BASE		= 0x400000	|address of page table
USER_MAP	= PG_BASE + 256	| address of user part of page table
MAP_TOP		= PG_BASE +2048	| address past end of memory map
UPTE		= 0x4000E0	| address of UPAGE pte

|Page table entry.
|WE	 bit 15		=1 user can write page, =0 user can read page
|USE	 bits 14-13	value 0=not present, 1=present, not accessed
|			value 2=accessed not written, 3=written to
|PAGEADDR bits 8-0	PHYSADDR=(PAGEADDR*4096) + byte within page
|STATES:
|page not in memory:	WE set as needed and rest=0
|page in memory:	WE, PAGEADDR set as needed and USE non zero

PROT_MASK	= 0x8000	|mask for write bit
USE_MASK	= 0x6000	|mask for usage bits
PG_MASK		= 0x1ff		|page address mask
PG_WRITE	= 0x8000	|user write enable
NO_PAGE		= 0x0		|to initialize pte's
PG_IN		= 0x7fff	|AND mask
PG_PRESENT	= 0x2000	|pte&USE_MASK page just in 
PG_NOT_DIRTY	= 0x4000	|pte&USE_MASK = accessed 
PAGE_DIRTY	= 0x6000	|pte&USE_MASK = written to
P_ACCESS_CHECK	= 0x6000	|AND mask
NO_ACCESS	= 0

|2 Mbyte physical address space
MAX_PHYS_MEM	= 0x200000

|Page table entry masks
PG_PROT		= 0x00008000
PG_STAT		= 0x00006000
PG_ACC		= 0x00004000
PG_V		= 0x00002000
PG_M		= 0x00006000
PG_FOD		= 0x00001000
PG_PFNUM	= 0x000001ff

|processor (mostly) registers
|from sys/hardware.h

|WARNING:	All these definitions are set up on the assumption
|that they are operating on 16 bit quantities read/written from/to
|the even address specified as the register address.
|It is further assumed that all reads/writes of hardware registers
|will be performed as 16 bit transfers to the even byte address.
|It is believed that other schemes may work, but this is the way
|these definitions are set up.

|68000 status bits
S_TRACE		= 0x8000
S_SUPV		= 0x2000
S_INTMASK	= 0x700
HIGH		= S_SUPV + S_INTMASK	|high priority supervisor mode (spl 7)
LOW		= S_SUPV		|low priority, supervisor mode (spl 0)

|General Control Register - GCR	
|Write only.	Uses most significant byte of 16 bit word

GCR_ADDR	= 0x450000
SYSERR_ENABLE	= 0x8000	|EE	1=enable NMI/BERR
PE_INT_ENABLE	= 0x4000	|PIE	1=enable PE's
PE_SENSE	= 0x2000	|PS	1=write odd parity
ROM_DISABLE	= 0x1000	|RMD	1=ROM disabled at low addr
LED_ADDR	= 0x450000
LED4		= 0x800		|DS4	1=off	top
LED3		= 0x400		|DS3	1=off	top-1
LED1		= 0x200		|DS1	1=off	bottom+1
LED0		= 0x100		|DS0	1=off	bottom
LED_IDLE	= 0xF00		|all LEDs off 
ALLBUTLED	= 0xF000	|mask for all but the LED's


|General Status Register - GSR
|Read only.	Uses most significant byte of 16 bit word

GSR_ADDR	= 0x410000
MEM_NOT_EXIST	= 0x8000	|MNP	0=no memory there
LOG_WRITE	= 0x4000	|LWT	1=read cycle
BUS_GRANT	= 0x2000	|BGNT	0=DMA 1=processor
PAGE_FAULT	= 0x1000	|PGF	0=page fault
BUS_TIMEOUT	= 0x800		|TO	1=no response
PIE_STATE	= 0x400		|PIE	0=PE's are disabled
PARITY_ERR	= 0x200		|PE	1=parity err occurred
USR_IO_FAULT	= 0x100		|UIE	0=user accessed I/O

|Clear Status Register - CSR
|Read/Write.	Uses most significant byte of 16 bit word
|Any access to this register clears the GSR and BSR0, BSR1

CSR_ADDR	= 0x420000

|	Reset control Register - RCR		*/
|	Read/Write.	Uses most significant byte of 16 bit word */
|	Any access to this register is equivalent to pressing RESET */

RCR_ADDR	= 0x460000

|Bus Status Register 0 - BSR0
|Read only.	Uses least significant byte of 16 bit word
|Latched at the same time as the GSR, also cleared by CSR

BSR0_ADDR	= 0x430000
MMU_ERR		= 0x8000	| 0=mmu error either write
				| violation or page fault
NOT_DGNT	= 0x4000	|DGNT	0=bus grant to disk
NOT_FCGNT	= 0x2000	|FCGNT 0=bus grant to fast comm
NOT_XGNT	= 0x1000	|XGNT	0=bus grant to expansion
LOWER_DATA_STROBE=0x100		| from 68010
A21_A16_MASK	= 0x3f		|mask of A21 to A16

|Bus Status Register 1 - BSR1
|Read only.	Uses all of 16 bit word
|Latched at the same time as the GSR, also cleared by CSR

BSR1_ADDR	= 0x440000
A15_A00_MASK	= 0xffff	|mask of A15 to A0
UPPER_DATA_STROBE=0x1		| from 68010

|to change from 1/2Mb kernel protection space to 1Mb (0-1/2 && 3 1/2 - 4)
HI_K_ENAB_ADDR	= 0xC40018
HI_K_DISAB_ADDR	= 0xC4001C

|	Hardware Register Definitions

INIT_GCR	= ROM_DISABLE+PE_SENSE+LED0+LED1+LED3+LED4	|inital value of GCR

|	ourgcr must be written to whenever the real GCR is written to.
#ifdef KERNEL
		.globl	ourgcr
#endif

|	address in vector table of a pointer to the CDT.
pCDT = 0x3F8		|software leaves pointer in penultimate int vector

|	CDT signature long word
SIG1 = 0x45504A52

|		Format - to be used by crash in analyzing dump
|
|			0000 - 003F:	machine registers
|			0040 - 0041:	GSR
|			0042		set to zero
|			0043 - 0045:	BSR
|			0046 - 0845	memory map registers
|			0846 - 08C5	CDT

|	Displacements from the start of a crash dump plus SAVEAREA.
SAVEAREA	= 0x0000
SVREGS	= 0x0000
SVGSR	= 0x0040
SVBSR	= 0x0042
SVMAP	= 0x0046
SVCDT	= 0x0846

|		Format of the CDT (128 bytes)
|		signature		4 bytes
|		lbolt			4 bytes
|		time of day		4 bytes
|		reason			1 byte
|		(0 = panic, 1 = reset, 2 = poweron)
|		boot media		1 byte
|		(2 = fd, 1 = syq, 0 = hd)
|		panic string		114 bytes
CdtSig		= 0x00
CdtLbolt	= 0x04
CdtTOD		= 0x08
CdtReason	= 0x0C
CdtMedia	= 0x0D
CdtPanic	= 0x0E
SZPANIC		= 114
SZCDT		= 128

|	Disk types.
HD	= 0		|Winchester
SY	= 1		|syquest
FD	= 2		|Floppy

|	Reasons
PANIC	= 0
RESET	= 1
POWERON	= 2
REBOOT	= 3

|	copy of VHBMAGIC from gdisk.h
VHBMAGIC	= 0x55515651

|	Address the loader is loaded at
LOADADDR	= 0x70000
BOOTCDT		= LOADADDR-SZCDT

#endif hardware_m
