/*	Convergent Technologies - System V - Jul 1983	*/
/*	"@(#)i8274.h	1.6"	*/

#ifndef i8274_h
#define i8274_h
/*
 *	Definitions for the I8274.
 */

/*
 *	defines for WR0
 */
#define REG_SELECT	0x07		/* A mask for the field that selects
					   which register */
#define B35MASK		0x38		/* mask for bits 3-5	*/
/*	values for bits 3-5 - Command bits	*/
#define NULL_CTL	0x00		/* null code	*/
#define SEND_ABORT	0x08		/* send abort (sdlc)	*/
#define RST_EX_INT	0x10		/* reset ext/status interrupts	*/
#define RST_CHNL	0x18		/* channel reset	*/
#define ENAB_INT	0x20		/* enable interrupt on next Rx char */
#define RST_TX_PEND	0x28		/* reset Tx int/DMA pending	*/
#define ERR_RESET	0x30		/* error reset	*/
#define END_OF_INT	0x38		/* end of interrupt	*/

#define CRC_RST_CODE	0xc0		/* mask for CRC reset code	*/
/*	values for bits 6-7 - CRC reset code	*/
#define NULL_CRC	0x00		/* null code	*/
#define RST_RX_CRC	0x40		/* reset RX CRC checker	*/
#define RST_TX_CRC	0x80		/* reset TX CRC generator	*/
#define RST_TX_URUN	0xc0		/* reset TX underrun/EOM latch	*/

/*
 *	defines for WR1
 */
#define EXT_INTENAB	0x01		/* external/status interrupt enable */
#define TX_INTENAB	0x02		/* TX interrupt/DMA enable	*/
#define VEC_TYPE	0x04		/* status affects vector 1=variable
						0=fixed	*/
#define RX_INT_MD	0x18		/* mask for RX interrupt mode	*/
/*	values for bits 3-4 - RX interrupt mode	*/
#define RX_INTDISAB	0x00		/* 0= RX interrupts/DMA disable	*/
#define RX_INT_FIRST	0x08		/* 1= RX interrupt on 1'st char only
						or special condition	*/
#define RX_INT_ALLPE	0x10		/* 2= interrupt on all RX chars or
						special condition (inc PE) */
#define RX_INTALL	0x18		/* 3= interrupt on all RX chars or
						special condition (not PE) */

#define WAIT_RX_TX	0x20		/* 1=wait on RX, 0=wait on TX	*/
#define MBZ		0x40		/* must be zero	*/
#define WAIT_ENAB	0x80		/* 1=wait enabled 0=wait disabled */

/*
 *	defines for WR2 (channel A)
 */
#define SYS_CONFIG	0x03		/* system configuration	*/
/*	values for bits 0-1 - system configuration	*/
#define INTA_INTB	0x00		/* channels A+B both interrupt	*/
#define DMAA_INTB	0x01		/* channel A uses DMA,
						channel B interrupts	*/
#define DMAA_DMAB	0x02		/* channels A+B both use DMA	*/
#define ILL_CODE	0x03		/* illegal code	*/

#define CH_PRIORITY	0x04		/* relative priorities:
					  0=RXA, TXA, RXB, TXB, EXTA, EXTB (low)
					  1=RXA, RXB, TXA, TXB, EXTA, EXTB (low)
					 */
#define INT_CODE	0x18		/* interrupt code	*/
/*	values for bits 3-4 - system configuration	*/
#define VEC_85_1	0x00		/* vectored 8085 mode 1	*/
#define VEC_85_2	0x08		/* vectored 8085 mode 2	*/
#define VEC_86_88	0x10		/* vectored 8086/8088	*/
#define VEC_ILL		0x18		/* illegal mode		*/

#define VECTORED	0x20		/* 1=vectored 0=non vectored	*/
#define MBZ2		0x40		/* must be zero		*/
#define PIN_10		0x80		/* 0=RTS 1=SYNDET	*/

/*
 *	defines for WR2 (channel B)
 */
#define INT_TYPE	0x07		/* interrupt type: (set by 8274)
						0=channel B TX
						0=channel B EXT/status
						0=channel B RX
						0=channel B special RX
						0=channel A TX
						0=channel A EXT/status
						0=channel A RX
						0=channel A special RX
					 */
#define VEC_BASE	0xf8		/* vector base # for this chip */

/*
 *	defines for WR3
 */
#define RX_ENAB		0x01		/* RX enable	*/
#define SYNC_CH_INH	0x02		/* SYNC char load inhibit	*/
#define ADDR_SRCH_MD	0x04		/* address search mode (SDLC)	*/
#define RX_CRC_ENAB	0x08		/* RX CRC enable	*/
#define ENT_HUNT_MD	0x10		/* enter hunt mode	*/
#define AUTO_ENAB	0x20		/* auto enable		*/
#define RX_SIZE		0xc0		/* RX character size mask	*/
/*	values for bits 6-7 - RX character size	*/
#define RX5		0x00		/* 0= 5 bits per char	*/
#define RX7		0x40		/* 1= 7 bits per char	*/
#define RX6		0x80		/* 2= 6 bits per char	*/
#define RX8		0xc0		/* 3= 8 bits per char	*/

/*
 *	defines for WR4
 */
#define PARITY		0x01		/* 1=enable parity 0=disable parity */
#define PARITYEVEN	0x02		/* 1=even parity   0=odd parity	*/
#define STOP_BITS_MSK	0x0c		/* mask for the stop bits	*/
/*	values for bits 2-3 - stop bits/sync mode	*/
#define ENAB_SYNC	0x00		/* 0= selects synchronous modes	*/
#define STOP1		0x04		/* 1= 1 stop bit (asynch)	*/
#define STOP15		0x08		/* 2= 1.5 stop bits (asynch)	*/
#define STOP2		0x0c		/* 3= 2 stop bits (asynch)	*/

#define SYNC_MD_SEL	0x30		/* sync mode select mask	*/
/*	values for bits 4-5 - SYNC mode select	*/
#define SYNC8		0x00		/* 0= 8 bit sync character	*/
#define SYNC16		0x10		/* 1= 16 bit sync character	*/
#define SDLC_HDLC	0x20		/* 2= SDLC mode (flag sync)	*/
#define EXT_SYNC_MD	0x30		/* 3= external sync mode	*/

#define CLOCK_MD_MSK	0xc0		/* mask for the clock mode	*/
/*	values for bits 6-7 - clock modes	*/
#define X1		0x00		/* 0= x1 clock	*/
#define X16		0x40		/* 1= x16 clock	*/
#define X32		0x80		/* 2= x32 clock	*/
#define X64		0xc0		/* 3= x64 clock	*/

/*
 *	defines for WR5
 */
#define TX_CRC_ENAB	0x01		/* 1= enable TX CRC	*/
#define RTS		0x02		/* RTS pin		*/
#define SDLC_CRC_16	0x04		/* 1=CRC 16 0=CCITT CRC	*/
#define TX_ENABLE	0x08		/* 1=enable transmitter	*/
#define SEND_BREAK	0x10		/* 1= break line 0=normal	*/
#define TX_CHR_LN	0x60		/* TX character length mask	*/
/*	values for bits 5-6 - TX character length	*/
#define TX5		0x00		/* 0= 5 bits per char	*/
#define TX7		0x20		/* 1= 7 bits per char	*/
#define TX6		0x40		/* 2= 6 bits per char	*/
#define TX8		0x60		/* 3= 8 bits per char	*/

#define DTR		0x80		/* DTR pin	*/

/*
 *	defines for WR6
 */
#define SYNC_ADDR	0xff		/* sync/address		*/

/*
 *	defines for WR7
 */
#define SYNC_FLAG	0xff		/* sync/flag		*/

/*
 *	defines for RR0
 */
#define RX_IN		0x01		/* RX character available	*/
#define INT_PEND	0x02		/* interrupt pending (chnl A only) */
#define TX_EMPTY	0x04		/* TX buffer empty	*/
#define CARRIER		0x08		/* carrier detect (CD)	*/
#define SYNC_HUNT	0x10		/* sync/hunt	*/
#define CTS		0x20		/* CTS		*/
#define TX_URUN		0x40		/* TX underrun/EOM	*/
#define BREAK		0x80		/* break/abort	*/

/* RX_IN and FLAGON are used in devconflg */
#define FLAGON	BREAK

/*
 *	defines for RR1
 */
#define ALL_SENT	0x01		/* all sent	*/
#define RESIDUE_CODES	0x0e		/* mask for residue codes	*/
/*	values for bits 1-3 - residue codes	*/
#define RC28		0x00		/* 0= 2(prev) 8(2'nd prev)	*/
#define RC06		0x02		/* 1= 0(prev) 6(2'nd prev)	*/
#define RC04		0x04		/* 2= 0(prev) 4(2'nd prev)	*/
#define RC08		0x06		/* 3= 0(prev) 8(2'nd prev)	*/
#define RC03		0x08		/* 4= 0(prev) 3(2'nd prev)	*/
#define RC07		0x0a		/* 5= 0(prev) 7(2'nd prev)	*/
#define RC05		0x0c		/* 6= 0(prev) 5(2'nd prev)	*/
#define RC18		0x0e		/* 7= 1(prev) 8(2'nd prev)	*/

#define PAR_ERR		0x10		/* parity error	*/
#define RX_ORUN		0x20		/* RX overrun error	*/
#define CRC_FRAME	0x40		/* CRC/framing error	*/
#define END_OF_FRAME	0x80		/* end of frame	*/

/*
 *	defines for RR2
 */
#define INT_VEC		0xff		/* pending interrupt vector	*/

/*
 *	structure containing device addresses and registers
 *	The first part of this structure is accessed by assembly code
 *	in ml/i8274.s. The following entries must not be changed without
 *	changing tx8274. txcnt, txptr, cmdad, datad, cmdadA.
 */
struct device {
	int txcnt;		/* count of characters in transmit buffer */
	char *txptr;			/* pointer to transmit character */
	ushort	*cmdad, *datad;		/* address for command and data */
	ushort *cmdadA;			/* address of A port for this chip */
	char	wr2,wr3,wr4,wr1;	/* chip registers */
	char	wr5;			/* chip registers */
	char	bprt;			/* =0 if B port else A port */
	ushort clkpsel;		/* timer port selection code for this port */
	ushort	*clkcnt;		/* address for 8253 count, this port */
	ushort	*clkcmd;		/* address for 8253 command,this port */
	ushort cflag;		/* last known hardware configuration */
};

#define HARDBITS 01777		/* mask to determine hardware chip changes */
/*	data associated with the low level RS-232 input routine in ml/i8274.s */
struct serbuf {
	char minr;		/* minor device number for this character */
	char data;		/* received data character */
	ushort mindev;
};

extern unsigned int serbuf[];
extern unsigned int *inptr;	/* address of next char to put in buffer */
extern unsigned int *outptr;	/* address of next char to take from buffer */

extern int serbufcnt;		/* count of characters in buffer */
extern int serbufful;		/* max characters that can be put in buffer */
extern int serhiwater;		/*hi water mark, when serbufcnt exceeds -xoff */
extern int serlowater;	/*low water mark, when serbufcnt falls below -xon */
extern char serinprogress;		/* =1 means C serrint is running */

extern uint serxoff;			/* XOFF sent by us */
extern uint serixon;			/* XON to be sent */
extern uint serinxoff;			/* XOFF blocking TX */
extern uint serrqstxoff;		/* XOFF requested */
extern uint sertxblkd;			/* output blocked */
extern uint sercd;			/* CD state for all lines */
extern uint sercts;			/* CTS state for all lines */

extern unsigned int *eserbuf;		/* first address past end of serbuf */
extern short ser_ports[];		/* preserves extended control bits */

#endif i8274_h
