|	Convergent Technologies - System V - Jul 1983
|	"@(#)iohw.m	1.8"

#ifndef iohw_m
#define iohw_m
|MINIFRAME HARDWARE DEFINITION - peripherals
|	68010 ASSEMBLY INCLUDE FILE
|	(see also hardware.h for processor)
|
|	FILE NAME: iohw.m
|

|8253 interval timer
|Control is Read only.	Uses least significant byte of 16 bit word
|Counters are Read/Write. Uses least significant byte of 16 bit word

CNTL_WD		= 0xC00006
CNT_S		= 0xC00000
CNT_F		= 0xC00002
CNT_TICKS	= 0xC00004
|SC bits of control word bits 6-7
SEL_FC_TIM	= 0x00		|SC select fast com timer
SEL_PERIODIC	= 0x40		|SC select periodic interrupt
SEL_TICK_CNT	= 0x80		|SC select counter of ticks
|counts
HZ_60_MSB	= 0x05		|MSB of 60HZ count
HZ_60_LSB	= 0x00		|LSB of 60HZ count
|RL bits of control word bits 4-5
RW2BYTE		= 0x30		|RL bits= LSB then MSB
RL_LATCH	= 0x00		|RL latch state of timer
MODE0		= 0x0
MODE		= 0x2
MODE2		= 0x4		|for periodic interrupt
MODE3		= 0x6		|for counting ticks

|	value to use in writing to io control registers to trigger actions.
ACTIVATE	= 0

|RS-422 Bus interface registers - 2652A
|Uses the least significant byte of 16 bit word

A_RDSR_LSB_ADDR		= 0xC10000	|RO
A_RDSR_MSB_ADDR		= 0xC10002	|RO
A_TDSR_LSB_ADDR		= 0xC10004	|R/W
A_TDSR_MSB_ADDR		= 0xC10006	|R/W
A_LSB_PCSAR_ADDR	= 0xC10008	|R/W
A_MSB_PCSAR_ADDR	= 0xC1000A	|R/W
A_PCR_LSB_ADDR		= 0xC1000C	|R/W
A_PCR_MSB_ADDR		= 0xC1000E	|R/W
A_RX_ENAB_ADDR		= 0xC10020	|CTRL
A_RX_DISAB_ADDR		= 0xC10022	|CTRL
A_DMA_ENAB_ADDR		= 0xC10024	|CTRL
A_DMA_DISAB_ADDR	= 0xC10026	|CTRL
A_SCLK_SEL_ADDR		= 0xC10028	|CTRL
A_FCLK_SEL_ADDR		= 0xC1002A	|CTRL
A_TX_ENAB_ADDR		= 0xC1002C	|CTRL
A_TX_DISAB_ADDR		= 0xC1002E	|CTRL
A_TXOP_ENAB_ADDR	= 0xC10030	|CTRL
A_RXIP_DISAB_ADDR	= 0xC10032	|CTRL
A_RESET_ADDR		= 0xC10034	|CTRL

|RS-422 DMA registers - 2652A
|Uses full 16 bit word

A_DMA_COUNT_ADDR	= 0xC20000	|R/W
A_DMA_LADDR_ADDR	= 0xC20002	|WO
A_SET_MEMDEV_ADDR	= 0xC20006	|CTRL
A_SET_DEVMEM_ADDR	= 0xC20008	|CTRL

|RS-232 Ports A + B Registers  - 8274
|Uses the least significant byte of 16 bit word

A_DATA_ADDR		= 0xC30000	|R/W
B_DATA_ADDR		= 0xC30002	|R/W
A_CMND_ADDR		= 0xC30004	|WO
B_CMND_ADDR		= 0xC30006	|WO
AB_EX_CTRL_ADDR		= 0xC30008	|R/W
AB_RESET		= 0xC3000A	|WO
|bits in the extended control register on writing
EX_STDA			= 0x08		|1=secondary TX chnl A
EX_STDB			= 0x04		|1=secondary TX chnl B
|the internal/external selection: 0=internal, 1=external
EX_SELA			= 0x02		|select int/ext clk chnl A
EX_SELB			= 0x01		|select int/ext clk chnl B
|status bits in the extended control register on reading
EX_RIA			= 0x80		|0=RI chnl A
EX_DSRA			= 0x40		|0=DSR chnl A
EX_SRDA			= 0x20		|0=SRD chnl A
EX_RIB			= 0x10		|0=RI chnl B
EX_DSRB			= 0x08		|0=DSR chnl B
EX_SRDB			= 0x04		|0=SRD chnl B
EX_FCC			= 0x02		|fast com carrier 2652A
EX_FDP			= 0x01		|=0 floppy present

|8253 timer for 8274 channel A + B
|Control is Read only.	Uses least significant byte of 16 bit word
|Counters are Read/Write. Uses least significant byte of 16 bit word

AB_CNTL_WD		= 0xC40006
A_BAUD_ADDR		= 0xC40000
B_BAUD_ADDR		= 0xC40002
|SC bits of control word bits 6-7
SEL_A_BAUD		= 0x00		|SC select A baud rate
SEL_B_BAUD		= 0x40		|SC select B baud rate

|Parallel Line Printer Registers
|Uses the least significant byte of 16 bit word

LP_DATA_ADDR		= 0xC50000	|R/W
LP_INT_ENAB_ADDR	= 0xC50002	|WO
LP_INT_DISAB_ADDR	= 0xC50004	|WO
|bits in the status register on reading
LP_BUF_FULL		= 0x02		|buffer is full
LP_NOT_PRSNT		= 0x04		|lp not present
LP_OUT_PAPER		= 0x08		|out of paper
LP_SELECTED		= 0x10		|selected
LP_BUSY			= 0x20		|busy

|DISK Bus interface registers
|Uses the least significant byte of 16 bit word

HD_TRI_ADDR		= 0xC60000
HD_ERROR_FLAGS		= 0xC60002
HD_SECTOR		= 0xC60004
HD_SECNUM		= 0xC60006
HD_CYL_LOW		= 0xC60008
HD_CYL_HIGH		= 0xC6000A
HD_SDH			= 0xC6000C
HD_STAT_CMD		= 0xC6000E
FD_STAT_CMD		= 0xC60010
FD_TRACK_REG		= 0xC60012
FD_SECTOR		= 0xC60014
FD_DATA_REG		= 0xC60016
FD_ON_RESET		= 0xC60020
FD_OF_RESET		= 0xC60022
HD_ON_RESET		= 0xC60024
HD_OF_RESET		= 0xC60026
FD_ON_MOTOR		= 0xC60028
FD_OF_MOTOR		= 0xC6002A
HD_DMA_ENABLE		= 0xC6002C
FD_DMA_ENABLE		= 0xC6002E
DSK_DMA_DISABLE		= 0xC60030
FD_SINGLE_DENSITY	= 0xC60032
FD_DOUBLE_DENSITY	= 0xC60034
BIU_RESET		= 0xC60036

|DISK DMA registers - WD1010 & WD2797
|Uses full 16 bit word

D_DMA_COUNT_ADDR	= 0xC80000	|R/W
D_DMA_LADDR_ADDR	= 0xC80002	|WO
D_SET_MEMDEV_ADDR	= 0xC80006	|CTRL
D_SET_DEVMEM_ADDR	= 0xC80008	|CTRL

|RS-232 Ports C + D Registers  - 8274
|Uses the least significant byte of 16 bit word

C_DATA_ADDR		= 0xC70000	|R/W
D_DATA_ADDR		= 0xC70002	|R/W
C_CMND_ADDR		= 0xC70004	|WO
D_CMND_ADDR		= 0xC70006	|WO
CD_EX_CTRL_ADDR		= 0xC70008	|R/W
CD_RESET		= 0xC7000A	|WO

|RS-232 Ports E + F Registers  - 8274
|Uses the least significant byte of 16 bit word

E_DATA_ADDR		= 0xC71000	|R/W
F_DATA_ADDR		= 0xC71002	|R/W
E_CMND_ADDR		= 0xC71004	|WO
F_CMND_ADDR		= 0xC71006	|WO
EF_EX_CTRL_ADDR		= 0xC71008	|R/W
EF_RESET		= 0xC7100A	|WO

|RS-232 Ports G + H Registers  - 8274
|Uses the least significant byte of 16 bit word

G_DATA_ADDR		= 0xC72000	|R/W
H_DATA_ADDR		= 0xC72002	|R/W
G_CMND_ADDR		= 0xC72004	|WO
H_CMND_ADDR		= 0xC72006	|WO
GH_EX_CTRL_ADDR		= 0xC72008	|R/W
GH_RESET		= 0xC7200A	|WO

|RS-232 Ports I + J Registers  - 8274
|Uses the least significant byte of 16 bit word

I_DATA_ADDR		= 0xC73000	|R/W
J_DATA_ADDR		= 0xC73002	|R/W
I_CMND_ADDR		= 0xC73004	|WO
J_CMND_ADDR		= 0xC73006	|WO
IJ_EX_CTRL_ADDR		= 0xC73008	|R/W
IJ_RESET		= 0xC7300A	|WO

|8253 timer for 8274 channel C + D + E
|Control is Read only.	Uses least significant byte of 16 bit word
|Counters are Read/Write. Uses least significant byte of 16 bit word

CD_CNTL_WD		= 0xC74006
C_BAUD_ADDR		= 0xC74000
D_BAUD_ADDR		= 0xC74002
E_BAUD_ADDR		= 0xC74004
|SC bits of control word bits 6-7
SEL_C_BAUD		= 0x00		|SC select C baud rate
SEL_D_BAUD		= 0x40		|SC select D baud rate
SEL_E_BAUD		= 0x80		|SC select E baud rate

|8253 timer for 8274 channel F + G + H
|Control is Read only.	Uses least significant byte of 16 bit word
|Counters are Read/Write. Uses least significant byte of 16 bit word

GH_CNTL_WD		= 0xC75006
G_BAUD_ADDR		= 0xC75000
H_BAUD_ADDR		= 0xC75002
F_BAUD_ADDR		= 0xC75004
|SC bits of control word bits 6-7
SEL_G_BAUD		= 0x00		|SC select G baud rate
SEL_H_BAUD		= 0x40		|SC select H baud rate
SEL_F_BAUD		= 0x80		|SC select F baud rate

|8253 timer for 8274 channel I + J
|Control is Read only.	Uses least significant byte of 16 bit word
|Counters are Read/Write. Uses least significant byte of 16 bit word

IJ_CNTL_WD		= 0xC76006
I_BAUD_ADDR		= 0xC76000
J_BAUD_ADDR		= 0xC76002
|SC bits of control word bits 6-7
SEL_I_BAUD		= 0x00		| SC select I baud rate 
SEL_J_BAUD		= 0x40		| SC select J baud rate 

|	8259A - on-board, controls 2652A (4 interrupts), 8253(0), 1010, 2797

A0_8259_ADDR	=	0xC90000
A1_8259_ADDR	=	0xC90002

|	RadioFrame RS-232 Ports C + D Registers  - 8274
|	Uses the least significant byte of 16 bit word

RC_DATA_ADDR		= 0xC30018	| R/W
RD_DATA_ADDR		= 0xC3001A	| R/W
RC_CMND_ADDR		= 0xC3001C	| WO
RD_CMND_ADDR		= 0xC3001E	| WO
RCD_EX_CTRL_ADDR	= 0xC3000C	| R/W
RCD_RESET		= 0xC3000A	| WO


|	RadioFrame 8253 timer for 8274 channel C + D + E
|	Control is Read only.	Uses least significant byte of 16 bit word
|	Counters are Read/Write. Uses least significant byte of 16 bit word

RCD_CNTL_WD		= 0xC40016
RC_BAUD_ADDR		= 0xC40010
RD_BAUD_ADDR		= 0xC40012
RFIDENT			= 0xC40014

|RS-232 Ports K + L Registers  - 8274
|Uses the least significant byte of 16 bit word

K_DATA_ADDR		= 0xCF0000	|R/W
L_DATA_ADDR		= 0xCF0002	|R/W
K_CMND_ADDR		= 0xCF0004	|WO
L_CMND_ADDR		= 0xCF0006	|WO
KL_EX_CTRL_ADDR		= 0xCF0008	|R/W
KL_RESET		= 0xCF000A	|WO

|RS-232 Ports M + N Registers  - 8274
|Uses the least significant byte of 16 bit word

M_DATA_ADDR		= 0xCF1000	|R/W
N_DATA_ADDR		= 0xCF1002	|R/W
M_CMND_ADDR		= 0xCF1004	|WO
N_CMND_ADDR		= 0xCF1006	|WO
MN_EX_CTRL_ADDR		= 0xCF1008	|R/W
MN_RESET		= 0xCF100A	|WO

|RS-232 Ports O + P Registers  - 8274
|Uses the least significant byte of 16 bit word

O_DATA_ADDR		= 0xCF2000	|R/W
P_DATA_ADDR		= 0xCF2002	|R/W
O_CMND_ADDR		= 0xCF2004	|WO
P_CMND_ADDR		= 0xCF2006	|WO
OP_EX_CTRL_ADDR		= 0xCF2008	|R/W
OP_RESET		= 0xCF200A	|WO

|RS-232 Ports Q + R Registers  - 8274
|Uses the least significant byte of 16 bit word

Q_DATA_ADDR		= 0xCF3000	|R/W
R_DATA_ADDR		= 0xCF3002	|R/W
Q_CMND_ADDR		= 0xCF3004	|WO
R_CMND_ADDR		= 0xCF3006	|WO
QR_EX_CTRL_ADDR		= 0xCF3008	|R/W
QR_RESET		= 0xCF300A	|WO

|8253 timer for 8274 channel K
|Control is Read only. Uses least significant byte of 16 bit word
|Counter are Read/Write. Uses least significant byte of 16 bit word
|Uses IJ_CNTL_WD as control word register

K_BAUD_ADDR		= 0xC76004
|SC bits of control word bits 6-7

SEL_K_BAUD		= 0x80		|SC select K baud rate

|8253 timer for 8274 channel L + M + N
|Control is Read only.	Uses least significant byte of 16 bit word
|Counters are Read/Write. Uses least significant byte of 16 bit word

LMN_CNTL_WD		= 0xCF4006
L_BAUD_ADDR		= 0xCF4000
M_BAUD_ADDR		= 0xCF4002
N_BAUD_ADDR		= 0xCF4004
|SC bits of control word bits 6-7
SEL_L_BAUD		= 0x00		|SC select L baud rate
SEL_M_BAUD		= 0x40		|SC select M baud rate
SEL_N_BAUD		= 0x80		|SC select N baud rate

|8253 timer for 8274 channel O + P + Q
|Control is Read only.	Uses least significant byte of 16 bit word
|Counters are Read/Write. Uses least significant byte of 16 bit word

OPQ_CNTL_WD		= 0xCF5006
O_BAUD_ADDR		= 0xCF5000
P_BAUD_ADDR		= 0xCF5002
Q_BAUD_ADDR		= 0xCF5004
|SC bits of control word bits 6-7
SEL_O_BAUD		= 0x00		|SC select O baud rate
SEL_P_BAUD		= 0x40		|SC select P baud rate
SEL_Q_BAUD		= 0x80		|SC select Q baud rate

|8253 timer for 8274 channel R
|Control is Read only.	Uses least significant byte of 16 bit word
|Counters are Read/Write. Uses least significant byte of 16 bit word

R_CNTL_WD		= 0xCF6006
R_BAUD_ADDR		= 0xCF6000
|SC bits of control word bits 6-7
SEL_R_BAUD		= 0x00		| SC select R baud rate 

#endif iohw_m
