/*	Convergent Technologies - System V - May 1983	*/
/*	"@(#)proc.h	1.4"	*/

#ifndef proc_h
#define proc_h

#include <sys/types.h>
#include <sys/text.h>
#include <sys/param.h>
#include <sys/shm.h>

/*
 * One structure allocated per active process. It contains all data needed
 * about the process while the process may be swapped out.
 * Other per process data (user.h) is swapped with the process.
 */

struct	proc {
	struct	proc *p_link;	/* linked list of running processes */
	int	p_flag;
	char	p_stat;
	char	p_pri;		/* priority, negative is high */
	char	p_time;		/* resident time for scheduling */
	char	p_cpu;		/* cpu usage for scheduling */
	char	p_nice;		/* nice for cpu usage */
	char	p_szpt;		/* 0 - 1 page user tbl, 1 - 2 page user tbl */
	char	p_usrpri;	/* user-priority based on p_cpu and p_nice */
	char	p_slptime;	/* time since last block */
	ushort	p_uid;		/* real user id */
	ushort	p_suid;		/* set (effective) user id */
	short	p_pgrp;		/* name of process group leader */
	short	p_pid;		/* unique process id */
	short	p_ppid;		/* process id of parent */
	ushort	p_addr[2];	/* physical page no of u-area */
	struct	proc *p_pptr;	/* pointer to process structure of parent */
	swblk_t	p_swaddr;	/* disk address of u area when swapped */
	size_t	p_tsize;	/* size of text (clicks)(used by exec/swapin) */
	size_t	p_ssize;	/* size of stack(clicks)(used by exec/swapin) */
	size_t	p_dsize;	/* size of data space (clicks) */
	size_t	p_tpage;	/* no of pages(rounded to segment) of text */
	size_t	p_dpage;	/* no of pages(rounded to segment) of data */
	size_t	p_spage;	/* no of pages(rounded to segment) of stack */
	size_t 	p_rssize; 	/* current resident set size in clicks */
	size_t	p_maxrss;	/* copy of u.u_limit[MAXRSS] */
	size_t	p_swrss;	/* resident set size before last swap */
	long	p_sig;		/* signals pending to this process */
	union {
		caddr_t	p_cad;	/* event process is awaiting */
		int	p_int;
	} p_unw;
#define	p_wchan	p_unw.p_cad
#define	p_arg	p_unw.p_int
	struct text *p_textp;	/* pointer to text structure */
	struct	proc *p_xlink;	/* linked list of procs sharing same text */
	int	p_clktim;	/* time to alarm clock signal */
	struct shmpt_ds	*p_smbeg;	/* beginning pte entry for shared memory */
	short	p_ndx;		/* proc index for memall (because of vfork) */
	short	p_poip;		/* count of page outs in progress */
	ushort	p_dieevkey;	/* for notify on process death */
};

#ifdef KERNEL
extern struct proc proc[];	/* the proc table itself */
#endif

/* stat codes */
#define	SSLEEP	1		/* awaiting an event */
#define	SWAIT	2		/* (abandoned state) */
#define	SRUN	3		/* running */
#define	SIDL	4		/* intermediate state in process creation */
#define	SZOMB	5		/* intermediate state in process termination */
#define	SSTOP	6		/* process being traced */
#define	SXBRK	7		/* process being xswapped */
#define	SXSTK	8		/* process being xswapped */
#define	SXTXT	9		/* process being xswapped */

/* flag codes */
#define	SLOAD	0x000001	/* in core */
#define	SSYS	0x000002	/* swapper or pager process */
#define	SLOCK	0x000004	/* process being swapped out */
#define	SSWAP	0x000008	/* save area flag */
#define	STRC	0x000010	/* process is being traced */
#define	SWTED	0x000020	/* another tracing flag */
#define SULOCK	0x000040	/* prevent a user process to be swapped out */
#define	SPAGE	0x000080	/* process in page wait state */
#define	SKEEP	0x000100	/* another flag to prevent swap out */
#define	SWEXIT	0x000400	/* working on exiting */
#define	SPHYSIO	0x000800	/* doing physical i/o (bio.c) */
#define	SPAGI	0x008000	/* init data space on demand, from inode */
#define	STIMO	0x040000	/* timing out during sleep */
#define	SDETACH	0x080000	/* detached inherited by init */
#define	SOWEUPC	0x200000	/* owe process an addupc() call at next ast */

/*	fork types - parameter to newproc	*/
#define KFORK	0	/* original kernel call of newproc */
#define OFORK	1	/* original sys1 call of newproc */

/*
 * parallel proc structure
 * to replace part with times
 * to be passed to parent process
 * in ZOMBIE state.
 */
#ifndef NPROC
struct	xproc {
	struct	proc *xp_link;	/* linked list of running processes */
	int	xp_flag;
	char	xp_stat;
	char	xp_pri;		/* priority, negative is high */
	char	xp_time;	/* resident time for scheduling */
	char	xp_cpu;		/* cpu usage for scheduling */
	char	xp_nice;	/* nice for cpu usage */
	char	xp_szpt;
	char	xp_usrpri;
	char	xp_slptime;
	ushort	xp_uid;		/* real user id */
	ushort	xp_suid;	/* set (effective) user id */
	short	xp_pgrp;	/* name of process group leader */
	short	xp_pid;		/* unique process id */
	short	xp_ppid;	/* process id of parent */
	ushort  xp_addr[2];
	struct	proc *xp_pptr;	/* pointer to process structure of parent */
	short	xp_xstat;	/* Exit status for wait */
	time_t	xp_utime;	/* user time, this proc */
	time_t	xp_stime;	/* system time, this proc */
};
#endif
#endif
