/*	Convergent Technologies - System V - Jan 1985	*/
/*	"@(#)socket.h	1.1"	*/

/*	socket.h	6.1	83/07/29	*/

/*
 * Definitions related to sockets: types, address families, options.
 */

/*
 * Types
 */
#define	SOCK_STREAM	1		/* stream socket */
#define	SOCK_DGRAM	2		/* datagram socket */
#define	SOCK_RAW	3		/* raw-protocol interface */
#define	SOCK_RDM	4		/* reliably-delivered message */
#define	SOCK_SEQPACKET	5		/* sequenced packet stream */

/*
 * Option flags per-socket.
 */
#define	SO_DEBUG	0x01		/* turn on debugging info recording */
#define	SO_ACCEPTCONN	0x02		/* socket has had listen() */
#define	SO_REUSEADDR	0x04		/* allow local address reuse */
#define	SO_KEEPALIVE	0x08		/* keep connections alive */
#define	SO_DONTROUTE	0x10		/* just use interface addresses */
				/* 0x20 was SO_NEWFDONCONN */
#define	SO_USELOOPBACK	0x40		/* bypass hardware when possible */
#define	SO_LINGER	0x80		/* linger on close if data present */
#define	SO_DONTLINGER	(~SO_LINGER)	/* ~SO_LINGER */

/*
 * Address families.
 */
#define	AF_UNSPEC	0		/* unspecified */
#define	AF_UNIX		1		/* local to host (pipes, portals) */
#define	AF_INET		2		/* internetwork: UDP, TCP, etc. */
#define	AF_IMPLINK	3		/* arpanet imp addresses */
#define	AF_PUP		4		/* pup protocols: e.g. BSP */
#define	AF_CHAOS	5		/* mit CHAOS protocols */
#define	AF_NS		6		/* XEROX NS protocols */
#define	AF_NBS		7		/* nbs protocols */
#define	AF_ECMA		8		/* european computer manufacturers */
#define	AF_DATAKIT	9		/* datakit protocols */
#define	AF_CCITT	10		/* CCITT protocols, X.25 etc */
#define	AF_SNA		11		/* IBM SNA */

#define	AF_MAX		12

/*
 * Structure used by kernel to store most
 * addresses.
 */
struct sockaddr {
	unsigned short	sa_family;		/* address family */
	char	sa_data[14];		/* up to 14 bytes of direct address */
};

/*
 * Structure used by kernel to pass protocol
 * information in raw sockets.
 */
struct sockproto {
	unsigned short	sp_family;		/* address family */
	unsigned short	sp_protocol;		/* protocol */
};

/*
 * Protocol families, same as address families for now.
 */
#define	PF_UNSPEC	AF_UNSPEC
#define	PF_UNIX		AF_UNIX
#define	PF_INET		AF_INET
#define	PF_IMPLINK	AF_IMPLINK
#define	PF_PUP		AF_PUP
#define	PF_CHAOS	AF_CHAOS
#define	PF_NS		AF_NS
#define	PF_NBS		AF_NBS
#define	PF_ECMA		AF_ECMA
#define	PF_DATAKIT	AF_DATAKIT
#define	PF_CCITT	AF_CCITT
#define	PF_SNA		AF_SNA

#define	PF_MAX		12

/*
 * Level number for (get/set)sockopt() to apply to socket itself.
 */
#define	SOL_SOCKET	0xffff		/* options for socket level */

/*
 * Maximum queue length specifiable by listen.
 */
#define	SOMAXCONN	5

/*
 * Message header for recvmsg and sendmsg calls.
 */
struct msghdr {
	caddr_t	msg_name;		/* optional address */
	int	msg_nmlen;		/* size of address */
	int	msg_base;		/* base address of data */
	int	msg_len;		/* size of data */
	caddr_t	msg_accrights;		/* access rights sent/received */
	int	msg_lenaccrights;
};

#define	MSG_OOB		0x1		/* process out-of-band data */
#define	MSG_PEEK	0x2		/* peek at incoming message */
#define	MSG_DONTROUTE	0x4		/* send without using routing tables */

#define	MSG_MAXIOVLEN	16

/*
 *	Socket ioctl commands
 *
 */

#define	SIOC	('S'<<8)
#define SIOCSHIWAT	(SIOC|1)		/* set high watermark */
#define SIOCGHIWAT	(SIOC|2)		/* get high watermark */
#define SIOCSLOWAT	(SIOC|3)		/* set low watermark */
#define SIOCGLOWAT	(SIOC|4)		/* get low watermark */
#define SIOCATMARK	(SIOC|5)		/* at oob mark? */
#define SIOCSPGRP	(SIOC|6)		/* set process group */
#define SIOCGPGRP	(SIOC|7)		/* get process group */

#define RSIOC 		('R'<<8)		/* special routing entry */
#define	SIOCADDRT	(RSIOC|9)		/* add route */
#define	SIOCDELRT	(RSIOC|10)		/* delete route */

#define ISIOC		('I'<<8)		/* special interface entry */
#define	SIOCSIFADDR	(ISIOC|11)		/* set ifnet address */
#define	SIOCGIFADDR	(ISIOC|12)		/* get ifnet address */
#define	SIOCSIFDSTADDR	(ISIOC|13)		/* set p-p address */
#define	SIOCGIFDSTADDR	(ISIOC|14)		/* get p-p address */
#define	SIOCSIFFLAGS	(ISIOC|15)		/* set ifnet flags */
#define	SIOCGIFFLAGS	(ISIOC|16)		/* get ifnet flags */
#define	SIOCGIFCONF	(ISIOC|17)		/* get ifnet list */

/*
 *	utility definitions.
 */

#define MIN(x,y) ((x) < (y) ? (x) : (y))
