/*	Convergent Technologies - System V - May 1983	*/
/*	"@(#)vmmac.h	1.5"	*/

#ifndef vmmac_h
#define vmmac_h

#include <sys/param.h>
#include <sys/pte.h>
extern ushort Maxumem;	/* max user click # */

/*
 * Virtual memory related conversion macros
 */

/* Virtual page numbers to text|data|stack segment page numbers and back */
#define	vtotp(p, v)	((int)((v) - SYSPAGE))
#define	vtodp(p, v)	((int)((v) - ((p)->p_tpage) - SYSPAGE))
#define	vtosp(p, v)	((int)(((Maxumem)-1) - (v)))
#define	tptov(p, i)	((unsigned)((i) + SYSPAGE))
#define	dptov(p, i)	((unsigned)((i) + ((p)->p_tpage) + SYSPAGE))
#define	sptov(p, i)	((unsigned)(((Maxumem)-1) - (i)))

/* Tell whether virtual page numbers are in text|data|stack segment */
#define	isatsv(p, v)	(((v) - SYSPAGE) < (p)->p_tsize)
#define	isadsv(p, v)	(((v) - SYSPAGE) >= ((p)->p_tpage) && \
		((v) - SYSPAGE - ((p)->p_tpage) < (p)->p_dsize))
#define	isassv(p, v)	((v) >= ((Maxumem) - (p)->p_ssize))

/* Tell whether adjusted virtual page numbers are in text|data|stack segment */
/* Adjusted virtual page number = virtual page number - SYSPAGE */

#define validaddr(p, i) ((i < p->p_tsize) || \
			((i - (p->p_tpage) >= 0) && \
			(i - (p->p_tpage) < p->p_dsize)) || \
			((i < (Maxumem-SYSPAGE)) && \
			(i >= ((Maxumem-SYSPAGE)-p->p_ssize))))

/* Tell whether pte's are text|data|stack */
#define	isaspte(p, pte)		((int)(pte - (struct mpte *) VPTE_BASE) >= \
		((p)->p_tsize + (p)->p_dsize))
#define	isatpte(p, pte)		((int)(pte - (struct mpte *) VPTE_BASE) < \
		((p)->p_tsize))
#define	isadpte(p, pte)		(((int)(pte - (struct mpte *) VPTE_BASE) < \
		((p)->p_tsize + (p)->p_dsize)) && !isatpte(p, pte))

/* Text|data|stack pte's to segment page numbers and back */
#define	ptetotp(p, pte)		((int)(pte - (struct mpte *) VPTE_BASE))
#define	ptetodp(p, pte)		((int)(pte - (struct mpte *) VPTE_BASE) \
		- (p)->p_tsize)
#define	ptetosp(p, pte)		(((p)->p_tsize + (p)->p_dsize + (p)->p_ssize -1) \
				- (int)(pte - (struct mpte *) VPTE_BASE))

#define	tptopte(p, i)		((struct mpte *)(((i)<<2) + VPTE_BASE))
#define	dptopte(p, i)		((struct mpte *) \
		((((i) + ((p)->p_tsize))<<2) + VPTE_BASE))
#define	sptopte(p, i) 		((struct mpte *) \
		(((((p)->p_tsize + (p)->p_dsize + (p)->p_ssize -1) - (i)) << 2) + VPTE_BASE))

#define ctopt(x)	(x)

/* given size in clicks, how many pages of U are needed to map it */
#define szupage(sz)	(((sz) > PTE_BANK0) ? UPAGES + 1 : UPAGES)

/* Average new into old with aging factor time */
#define	ave(smooth, cnt, time) \
	smooth = ((time - 1) * (smooth) + (cnt)) / (time)

#endif vmmac_h
