	NAME	COMINT
	INCLUDE	PAGESIZE.INC
	TITLE	.COMINT COMmunications INTerrupt handler
	PAGE
CODE 	SEGMENT PUBLIC BYTE
	ASSUME	CS:CODE,DS:DATA

	EXTRN	RINGIN:NEAR		; Circular buffer handlers
	EXTRN	RINGOUT:NEAR		;
	EXTRN	RINGMT:NEAR		;
	EXTRN	RINGROOM:NEAR		;

IVEC	SEGMENT	AT 0			; Interrupt vector location
	ASSUME	ES:IVEC			; For COM1:
	ORG	0CH*4			; Vector C
IVEC0	DW	0			;
IVEC1	DW	0			;
IVEC	ENDS				;

DATA 	SEGMENT PUBLIC BYTE

INRING	LABEL	WORD
IRS	EQU	30			; Input ring size constant
	DW	0			; Input pointer
	DW	0			; Output pointer
	DW	IRS			; Ring size
	DB	IRS DUP(-1)		; Data area

OUTRING	LABEL	WORD			; 
ORS	EQU	30			;
	DW	0			;
	DW	0			;
	DW	ORS			;
	DB	ORS DUP(-1)		;

	PUBLIC	COMMODE			; Mode setup here
COMMODE	DB	COMMW8+COMM1S+COMMNP	; 8 bit, 1 stop, no parity default
 COMMW5	EQU	0			; Word length selections
 COMMW6	EQU	1			;
 COMMW7	EQU	2			;
 COMMW8	EQU	3			;
 COMM1S	EQU	0			; Stop bits
 COMM2S	EQU	4			;
 COMMNP	EQU	0			; Parity on/off
 COMMPE	EQU	8			;
 COMMOP	EQU	0			; Odd parity
 COMMEP	EQU	16			;

	PUBLIC	COMBAUD			; Baud rate here
COMBAUD	DW	CMB1200			; 1200 baud default
 CMB110	EQU	0900H			; Rate selections
 CMB300 EQU	0180H			;
 CMB1200 EQU	 060H			;
 CMB2400 EQU	 030H			;
 CMB4800 EQU	 018H			; Not reccomended for E78 use!
 CMB9600 EQU	 00CH			; Not reccomended for E78 use!

	PUBLIC	COMSFLG			; 
COMSFLG	DB	0			; Set 1 to disable XON/XOFF control
TXRUN	DB	1			; Set to zero when transmitter is off
HOLDING	DB	0			; Set to 1 when forced XOFF out

OCOVEC	DD	0			; Old interrupt service vector

OCMODE	DB	0			; Old value preservatives
OCBAUD	DW	0			;
OCIIEN	DB	0			;
OCMODM	DB	0			;
OICTLM	DB	0			;

DATA	ENDS
	PAGE
	PUBLIC	COMINIT			; Initialize com interrupts
COMINIT	PROC	NEAR			;

	CLI
	PUSH	ES			; 
	MOV	AX,IVEC			; IVEC starts at COM1: reserved vector
	MOV	ES,AX			; ES points into low memory for vectors

	MOV	AX,ES:IVEC0		; Get current service address
	MOV	BX,ES:IVEC1		;
	MOV	WORD PTR OCOVEC[0],AX
	MOV	WORD PTR OCOVEC[2],T	DX,AL			; Low byte out
	INC	DX			;

	IN	AL,DX			; Get high byte
	MOV	BYTE PTR OCBAUD[1],AL	; Save it away

	XCHG	AH,AL			;
	OUT	DX,AL			; High byte out

	POP	DX			; Restore mode register address
	XCHG	AL,BL			; Get normal mode w/o DLAB set
	OUT	DX,AL			;
	
	MOV	DX,03F9H		; COM1: Interrupt enable register
	IN	AL,DX			; Get current state
	MOV	OCIIEN,AL		;

	MOV	AL,11B			; Enable TX/RX data interrupts
	OUT	DX,AL			;

	IN	AL,021H			; Get current interrupt mask register
	MOV	OICTLM,AL		; Save the previous mask
	AND	AL,11101111B		; Enable (Unmask) RS-232 interrupt
	OUT	021H,AL			;

	MOV	DX,03FCH		; Modem control register COM1:
	IN	AL,DX			;
	MOV	OCMODM,AL		;
	MOV	AL,1111B		; Turn on RTS/DTS, IRQ4
	OUT	DX,AL			;

	POP	ES			;
	STI

	INT	0CH			;CLEAR ANY PENDING INTS
	RET				; And we're off!

COMINIT	ENDP				;

	PUBLIC	COMKILL			;
COMKILL	PROC	NEAR			; Turn off COM1

	CLI

	MOV	DX,03F9H		; COM1: Interrupt enable register
	MOV	AL,OCIIEN		; No interrupts!
	OUT	DX,AL			; COM card is now off..

	MOV	AH,OICTLM		; Get previous interrupt control mask
	AND	AH,00010000B		; Use only one bit
	IN	AL,021H			; Read 8259 control register
	AND	AL,11101111B		; Set mask to kill COM1: interrupts
	OR	AL,AH			; Pass previous bit through

	OUT	021H,AL			; 8259 Off

	PUSH	ES			; Point to the interrupt vector seg
	MOV	AX,IVEC			;
	MOV	ES,AX			;

	MOV	AX,WORD PTR OCOVEC[0]	; Get previous service value
	MOV	BX,WORD PTR OCOVEC[2]	;
	MOV	ES:IVEC0,AX		; And put it back
	MOV	ES:IVEC1,BX		;

	POP	ES			; Restore ES to whatever it was

	MOV	DX,3FBH			; Main control register
	MOV	AL,OCMODE		;
	OR	AL,10000000B		; Set DLAB
	OUT	DX,AL			;

	PUSH	DX			; Save control register address

	MOV	DX,3F8H			; Baud rate registers
	
	MOV	AL,BYTE PTR OCBAUD[0]	; Get low half
	OUT	DX,AL			;
	INC	DX			;
	MOV	AL,BYTE PTR OCBAUD[1]	;
	OUT	DX,AL			;

	POP	DX	

	MOV	AL,OCMODE		; Restore previous mode
	OUT	DX,AL			;

	STI				; And allow other interrupts

	RET				;

COMKILL	ENDP				;
	PAGE
CSINT	PROC	FAR			; Communications interrupt handler
 
	STI				; Enable other interrupts

	PUSH	DS			;
	PUSH	AX			;
	PUSH	BX			;
	PUSH	CX			;
	PUSH	DI			;
	PUSH	DX			;

	MOV	AX,DATA			; Point to our own data area.
	MOV	DS,AX			;

	MOV	DX,03FAH		; COM1: Interrupt ID register
	IN	AL,DX			;

	TEST	AL,100B			; Test for receiver status bit
	JZ	CSI0			; No transmitter stuff yet.
	CALL	RXCC			; Get a character

	TEST	COMSFLG,2		; Is the user allowing XOFFs
	JNZ	CSI0			; No.

	MOV	DI,OFFSET INRING	; Is an XOFF in order?
	CALL	RINGROOM		; Pop the question.
	CMP	AX,IRS-3*(IRS/4)	; Is the ring more than 3/4 full?
	JGE	CSI0			; No, not yet too full

CSX0:	MOV	AL,19			; ASCII XOFF
	CALL	NEAR PTR PUTCOM		;

	OR	HOLDING,1		; Set hold flag

CSI0:	TEST	AL,010B			; Test for transmitter interrupt
	JZ	CSI1			;
	CALL	TXCC			; Send the next character

CSI1:	POP	DX			;
	POP	DI			;
	POP	CX			;
	POP	BX			;

	MOV	AL,20H			; Non-specific End Of Interrupt
	OUT	020H,AL			; 8259 Command register

	POP	AX			;
	POP	DS			;

	IRET				;
	PAGE
RXCC	PROC	NEAR			; Get a character from COM1 into INRING
	PUSH	AX			;

	MOV	DX,03F8H		; COM1: data register
	IN	AL,DX			;

	MOV	DI,OFFSET INRING	;
	CALL	RINGIN			;

	POP	AX			;
	RET				; No recourse if ring is full....

RXCC	ENDP				;

TXCC	PROC	NEAR			; Send a character out COM1
	PUSH	AX			;

	MOV	DI,OFFSET OUTRING	;
	CALL	RINGOUT			; Try to get a character
	JNC	TXMPT			; Outbound ring empty, turn off TX

	MOV	DX,03F8H		; Data register
	OUT	DX,AL			; Send the character

	POP	AX			;
	RET				;

TXMPT:	MOV	AL,1B			; RX interrupt only
	MOV	DX,03F9H		;
	OUT	DX,AL			; Turn off the transmitter

	MOV	TXRUN,0			; Turn off transmitter flag
	POP	AX			;
	RET				;

TXCC	ENDP				;

CSINT	ENDP				; End of interrupt service
	PAGE
	PUBLIC	COMSTAT			; Status of COM buffers
COMSTAT	PROC	NEAR			; AX returns room in input ring
					; BX returns room in output ring
	PUSH	DI			; C is set it input ring has more
	PUSH	CX			;
	PUSH	DX		BX

	MOV	ES:IVEC0,OFFSET CSINT
	MOV	ES:IVEC1,CODE

	MOV	DX,3FBH			; the baud rate next
	IN	AL,DX			; Get mode
	MOV	OCMODE,AL		; 

	MOV	AL,COMMODE		; Set the bits & parity
	AND	AL,00011111B		; Only the normal bits
	MOV	BL,AL			; Save a copy
	OR	AL,10000000B		; With DLAB since we are going to set
	OUT	DX,AL			; 

	PUSH	DX			; Save address of mode register

	MOV	DX,3F8H			; Low order divisor latch
	IN	AL,DX			; Get low byte
	MOV	BYTE PTR OCBAUD[0],AL	; Save it away

	MOV	AX,COMBAUD		;
	OU	;
					;   than IRS/3 free characters
	MOV	DI,OFFSET OUTRING
	CALL	RINGROOM		;
	MOV	BX,AX			;
	PUSH	BX			;

	MOV	DI,OFFSET INRING
	CALL	RINGROOM		;

	CMP	AX,IRS/3		; Minimum holding area
	JL	COMSFUL			;

	CALL	RINGMT			;
	STC				;
	POP	BX			;
	POP	DX			;
	POP	CX			;
	POP	DI			;
	RET				;

COMSFUL: OR	AX,-1			; Nonzero, carry clear
	POP	BX			;
	POP	DX			;
	POP	CX			;
	POP	DI			;
	RET				; 

COMSTAT ENDP
	PAGE
	PUBLIC	PUTCOM			; Send a character out the com port
PUTCOM	PROC	NEAR			;

	PUSH	DI			;
	PUSH	BX			;
	PUSH	CX			;
	PUSH	DX			;
	PUSH	AX			;

	MOV	DI,OFFSET OUTRING	;

		; Interrupts are off during PUTC0 loop because
		; interrupt level code may be trying to RINGIN
		; an XOFF or an XON character if COMSFLG is
		; not set to 1

PUTC0:	CLI				; Turn off interrupts
	CALL	RINGIN			;
	STI				; Re-enable interrupts
	JNC	PUTC0			; Loop forever if neccessary

	CLI				;

	TEST	TXRUN,1			; Is the transmitter already on?
	JNZ	PUTC1			; Yes, do not turn it on again

	MOV	TXRUN,1			; Turn on the transmitter
	PUSH	DX			;
	MOV	AL,11B			; Enable TX & RX interrupts
	MOV	DX,03F9H		; COM1: interrupt control port
	OUT	DX,AL			;
	POP	DX			;

PUTC1:	STI				; 
	POP	AX			;

	POP	DX			;
	POP	CX			;
	POP	BX			;
	POP	DI			;

	RET				;

PUTCOM	ENDP				;
	PAGE
	PUBLIC	GETCOM			;
GETCOM	PROC	NEAR			;

	PUSH	DI			;
	PUSH	BX			;
	PUSH	CX			;
	PUSH	DX			;

	MOV	DI,OFFSET INRING	;

	TEST	HOLDING,1		; Are we held up temporarily?
	JZ	GETC0			;

	CALL	RINGROOM		; Is there still a reason?
	CMP	AX,IRS-(IRS/4)		; Is the ring more than 3/4 empty?
	JL	GETC0			; No, leave it be

	TEST	COMSFLG,1+2		; Are XONs and flow control enabled?
	JNZ	GETC0			; No. One or both illegal now

	MOV	AL,17			; ASCII XON
	CALL	NEAR PTR PUTCOM		; Send it out

	AND	HOLDING,NOT 1		; Turn off hold flag

GETC0:	CALL	RINGOUT			;
	JNC	GETC0			;

	POP	DX			;
	POP	CX			;
	POP	BX			;
	POP	DI			;

	RET				;

GETCOM	ENDP				;
	PAGE
	PUBLIC	GCSTAT			; Get communication status
GCSTAT	PROC	NEAR			;

	PUSH	DI			;
	MOV	AX,DATA			;
	MOV	DS,AX			;
	MOV	DI,OFFSET INRING	;
	CALL	RINGMT			;
	POP	DI			;

	RET				;

GCSTAT	ENDP				;

CODE ENDS

	END
