	NAME	IRMAFIL
	INCLUDE PUBLICS.EQU
	INCLUDE	PAGESIZE.INC
	TITLE	.IRMAFILE   Program to read the IRMA.RMA user function key file

DOSCALL  EQU	21H
OPENFILE EQU	0FH
CLOSE	 EQU	10H
XADDRESS EQU	1AH		; DISK TRANSFER ADDRESS
RANDREAD EQU	21H		; RANDOM BLOCK READ	
MAXLINES EQU	10
MAXCHAR	 EQU	70

DATA	SEGMENT	PUBLIC BYTE

	EXTRN	FCB1:BYTE,	FILEBF1:BYTE,		SFKBUF:BYTE
	EXTRN	LINECNT:BYTE,	FILE_READ_FLAG:BYTE,	SLVERR:BYTE

IRMANM	DB	0,"IRMA    RMA"


DATA	ENDS

FCB	STRUC

DRIVE		DB	0
FILENAME	DB	'        '
EXT		DB	'   '
CURBLK		DW	0
RECSIZE		DW	0
FILESIZE	DD	0
CREATDAT	DW	0
SYSUSE		DT	0
CURRECNO	DB	0
RELRECNL	DW	0
RELRECNH	DW	0

FCB	ENDS
 
CODE	SEGMENT PUBLIC
	ASSUME CS:CODE,DS:DATA,ES:DATA

	PUBLIC	IRMAFIL

IRMAFIL	PROC	NEAR

	PUSH	AX		; SAVE THE ENTIRE REGISTER SET
	PUSH	BX		;
	PUSH	CX		;
	PUSH	DX		;
	PUSH	SI		;
	PUSH	DI		;
	PUSH	BP		;
	PUSH	ES		;
	PUSH	DS		;

	MOV	AL,FILE_READ_FLAG	; Has the file been read
	OR	AL,AL
	JZ	IRMA1
	JMP	IRMA2

IRMA1:	MOV	FILE_READ_FLAG,0FFH	; Set the file read flag

	MOV	AX,DS		; Point ES to Data segment
	MOV	ES,AX
	MOV	DI,OFFSET FCB1	; Point ES:[DI] to Destination
	MOV	SI,OFFSET IRMANM ; Point DS:[SI] to Source
	MOV	CX,12		; Move 12 bytes
REP	MOVSB			; Move the bytes

	MOV	DI,OFFSET SFKBUF
	XOR	AL,AL		; Zero the skfbuf
	MOV	CX,700		; 700 bytes long
REP	STOSB

	MOV	DX,OFFSET FCB1	; Point DS:[DX] to the FCB
	MOV	AH,OPENFILE	; DOS open file command
	INT	DOSCALL		; invoke DOS
	
	OR	AL,AL		; Set the flags on DOS responce
	JZ	TEST1


IRMA2:	POP	DS		; RESTORE ALL THE REGISTERS
	POP	ES		;
	POP	BP		;
	POP	DI		;
	POP	SI		;
	POP	DX		;
	POP	CX		;
	POP	BX		;
	POP	AX		;

	RET
	
TEST1:	MOV	WORD PTR FCB1.RECSIZE,1

	PUSH	DX		; SAVE THE DX REGISTER

	MOV	AH,XADDRESS
	MOV	DX,OFFSET FILEBF1
	INT	DOSCALL 

	POP	DX		; RESTORE POINTER TO FCB

	XOR	AX,AX
	MOV	WORD PTR FCB1[33],AX
	MOV	WORD PTR FCB1[35],AX
	MOV	BX,AX
	MOV	SI,AX
	MOV	LINECNT,AL

READ:	PUSH	BX
	PUSH	SI
	MOV	AH,RANDREAD	; READ 1 BYTE RECORD FROM FILE
	INT	DOSCALL
	OR	AL,AL
	POP	SI
	POP	BX
	JZ	READ0
	JMP	CLOSEFIL			; Jump if EOF reached or ERROR
READ0:	MOV	AL,FILEBF1
	CMP	AL,13		; Check for <CR>
	JE	READ1
	CMP	AL,10		; Check for <NL>
	JE	READ1
	CMP	AL,'\'		; Check for Special Characters
	JNZ	PUTBUF
	JMP	SPECIAL

PUTBUF:	MOV	SFKBUF[BX+SI],AL	; Put the character into the key buffer
	INC	WORD PTR FCB1[RELRECNL]		; Increment the relative record number in the FCB
	INC	BX
	CMP	BX,MAXCHAR
	JG	END_OF_LINE
	JMP	READ

READ1:	INC	WORD PTR FCB1[RELRECNL]	; Increment the relative record number in the FCB
	PUSH	BX
	PUSH	SI
	MOV	AH,RANDREAD	; READ 1 BYTE RECORD FROM FILE
	INT	DOSCALL
	OR	AL,AL
	POP	SI
	POP	BX
	JNZ	CLOSEFIL			; Jump if EOF reached or ERROR
	MOV	AL,FILEBF1
	CMP	AL,13		; Check for <CR>
	JE	READ1
	CMP	AL,10		; Check for <NL>
	JE	READ1

END_OF_LINE:
	MOV	AL,LINECNT	; Are we at the end of a line
	CMP	AL,9
	JGE	CLOSEFIL	; If yes then jump

	MOV	CX,BX
	XOR	BX,BX		; Zero the character count for the next line
	ADD	SI,70		; Point the line pointer to the next line
	INC	LINECNT		; Point to the next line

	CMP	CX,MAXCHAR
	JG	READ2
	JMP	READ

READ2:	INC	WORD PTR FCB1[RELRECNL]	; Increment the relative record number in the FCB
	PUSH	BX
	PUSH	SI
	MOV	AH,RANDREAD	; READ 1 BYTE RECORD FROM FILE
	INT	DOSCALL
	OR	AL,AL
	POP	SI
	POP	BX
	JNZ	CLOSEFIL			; Jump if EOF reached or ERROR
	MOV	AL,FILEBF1
	CMP	AL,13		; Check for <CR>
	JE	READ3
	CMP	AL,10		; Check for <NL>
	JE	READ3

	JMP	READ2

READ3:	INC	WORD PTR FCB1[RELRECNL]	; Increment the relative record number in the FCB
	PUSH	BX
	PUSH	SI
	MOV	AH,RANDREAD	; READ 1 BYTE RECORD FROM FILE
	INT	DOSCALL
	OR	AL,AL
	POP	SI
	POP	BX
	JNZ	CLOSEFIL			; Jump if EOF reached or ERROR
	MOV	AL,FILEBF1
	CMP	AL,13		; Check for <CR>
	JE	READ3
	CMP	AL,10		; Check for <NL>
	JE	READ3

	JMP	READ0		; Finished eating characters

CLOSEFIL:
	MOV	AH,CLOSE	; Close the file and return to caller
	MOV	DX,OFFSET FCB1
	INT	DOSCALL

	POP	DS		; RESTORE ALL THE REGISTERS
	POP	ES		;
	POP	BP		;
	POP	DI		;
	POP	SI		;
	POP	DX		;
	POP	CX		;
	POP	BX		;
	POP	AX		;

	RET

SPECIAL:
	INC	WORD PTR FCB1[RELRECNL]	; Increment the relative record number in the FCB
	PUSH	BX
	PUSH	SI
	MOV	AH,RANDREAD	; READ 1 BYTE RECORD FROM FILE
	INT	DOSCALL
	OR	AL,AL
	POP	SI
	POP	BX
	JNZ	CLOSEFIL	; Jump if EOF reached or ERROR
	MOV	AL,FILEBF1

	CMP	AL,'\'
	JNE	SPEC0
	JMP	PUTBUF

SPEC0:	CMP	AL,'n'		; Check for the <NL> character
	JNE	SPEC1

	MOV	AL,10		; Put a <NL> character into AL reg
	JMP	PUTBUF

SPEC1:	CMP	AL,'e'		; Check for the <CR> character
	JNE	SPEC2

	MOV	AL,13		; Put a <CR> character into AL reg
	JMP	PUTBUF

SPEC2:	MOV	AL,32		; If not a special character put a space
	JMP	PUTBUF


IRMAFIL	ENDP

CODE	ENDS

	END
