	NAME	KXFER
	TITLE	.KXFER - Transfer keys to slave
	INCLUDE	PAGESIZE.INC
	INCLUDE	SKFLAG.INC
DATA	SEGMENT	PUBLIC BYTE
	ASSUME	DS:DATA
	INCLUDE	PUBLICS.EQU

; 10-21-85	Added the ENABLE/DISABLE Emulator Stuff

	EXTRN	KERING:WORD,	SLVERR:BYTE,	KCODE:WORD,	ECCODE:WORD
	EXTRN	FIRKEY:BYTE,	LASKEY:BYTE,	SCODE:BYTE,	STATUS:BYTE
	EXTRN	TOPSET:BYTE,	ENADIS:BYTE

	IF	SKFLAG
	EXTRN	KC128:WORD, 	KC134:WORD

	PUBLIC	IKALIAS
IKALIAS	LABEL	WORD
	DB	"*",111,"N",134	; DUP
	DB	";",112,"O",134	; FM
	DB	" ",109,  0, 68	; RESET
	DB	 13,110, 13, 28 ; ENTER
	DB	 13, 28, 10, 28	; NEW LINE
	DB	"+", 78, 13, 28 ; ENTER - NUMERIC PAD
	DB	"<", 51,",", 51	; duplicate comma
	DB	">", 52,".", 52	; duplicate dot
	DB	32*4 DUP (0)	; Future patch alias
	DB	0,0,0,0		; End of table marker

	ENDIF
DATA	ENDS

CODE	SEGMENT PUBLIC BYTE
	ASSUME	CS:CODE
	EXTRN	RINGIN:NEAR,	RINGOUT:NEAR,	RINGROOM:NEAR	
	EXTRN	INKEY:NEAR,	SPCKEY:NEAR,	WAITS:NEAR

	PUBLIC	KXFER
KXFER	PROC	NEAR

KX0:	MOV	DX,REG0		; Get current slave status direct
	IN	AL,DX		;

	TEST	AL,LOW M$KYMT	; Is the keyboard buffer empty?
	JZ	KX1		; No, do not put more in

	CALL	KEYCHK		; Try to send a key to the host
	JC	KX0		; Try to send ALL pending keys to host

KX1:	MOV	DI,OFFSET KERING; See if there is enough room in buffer
	CALL	RINGROOM	;
	CMP	AX,8		; 
	JC	KX10		; If not enough room for whole key, skip it.

	CALL	INKEY		; Try to get a key from the keyboard
	CALL	SPCKEY		; Filter out the special keys

	JNC	KX10		; If no key to send, quit

	CALL	KEYPUT		; Place scan codes in key ring
	JMP	SHORT KX0	; Try to empty the ring

KX10:	RET

KXFER	ENDP
	PAGE
	PUBLIC	KEYPUT
KEYPUT	PROC	NEAR

	IF	SKFLAG

	PUSH	SI		; [sk] Scan for possible translate
	MOV	SI,0		; [sk]

ALIAS0:	CMP	IKALIAS[SI],0	; [sk] End of table?
	JZ	ALIAS2 		; [sk] No, alias not needed

	CMP	IKALIAS[SI],AX	; [sk] Do this need translation?
	JNZ	ALIAS1 		; [sk] Not yet, check next alias

	MOV	AX,IKALIAS[SI+2]; [sk] Fetch the new value
	JMP	ALIAS2 		; [sk] and get out of the loop

ALIAS1:	ADD	SI,4		; [sk] point to the next alias value
	JMP	ALIAS0		;

ALIAS2:	POP	SI		; [sk] Restore used register

	ENDIF
	LEA	BX,KCODE	; Assume normal (ASCII) key code
	OR	AL,AL		; Is this an extended code

	IF	SKFLAG

	JZ	KPUM1		; [sk] BX is OK.
      
	CMP	AH,80H		; [sk] Possibly and IRMAkey II code?
	JNAE	KPU0		; [sk]

	LEA	BX,KC128	; [sk]
	CMP	AH,129		; [sk] 128, 129 are the same
	JNAE	KPU0		; [sk]

	LEA	BX,KC134	; [sk] Extended keys
	CMP	AH,134+1		; [sk]
	JNAE	KPU0		; [sk]

	LEA	BX,KCODE	; [sk] It is something else, treat as normal
	JMP	SHORT KPU0	; [sk]

KPUM1:	LEA	BX,ECCODE	; [sk] It is extended BIOS code
	MOV	AL,AH		;

	ELSE

	JNZ	KPU0		; No, BX is OK.
	LEA	BX,ECCODE	; It is extended BIOS code
	MOV	AL,AH		;

	ENDIF

KPU0:	XOR	AH,AH		; Clear high byte
	SHL	AX,1		; 16 bit word offset
	ADD	BX,AX		; Into scan code table

	MOV	CX,2		; Length of scan code table

KPU1:	MOV	DL,BYTE PTR [BX]; Get key scan code
	XOR	DH,DH		; As 16 bit entry

	CMP	DX,0		; Is this a null entry?
	JZ	KPU2		; Yes, skip the process

	SUB	DL,FIRKEY	; Remove keyboard position bias
	MOV	DI,DX		; Make index into scan code table
	MOV	AL,SCODE[DI]	; Get key scan code
	AND	AL,01111111B	; Remove UP/DN bit (7)

	MOV	DI,OFFSET KERING; Point to keyboard scan code buffer
	PUSH	BX		;
	PUSH	CX		;
	CALL	RINGIN		;
	POP	CX		;
	POP	BX		;

KPU2:	INC	BX		; Point to next key to process
	LOOP	KPU1		; Press all the keys in the list

	MOV	CX,2		; Process through the key ups

KPU3:	DEC	BX		; Point to next key code to process
	MOV	DL,BYTE PTR [BX];
	XOR	DH,DH		;

	CMP	DX,0		; Is this a null entry?
	JZ	KPU4		;

	SUB	DL,FIRKEY	; Remove keyboard position bias
	MOV	DI,DX		; Into an index register
	MOV	AL,SCODE[DI]	;

	TEST	AL,10000000B	; Is this key supposed to go up?
	JZ	KPU4		; No, dont do it.

	MOV	DI,OFFSET KERING; Put the key up code into the ring
	PUSH	BX		;
	PUSH	CX		;
	CALL	RINGIN		;
	POP	CX		;
	POP	BX		;

KPU4:	LOOP	KPU3		;

	CMP	TOPSET,0	; Is the screen idle?
	JNE	KUP5		; No, countdown of screen alignment in effect

	MOV	TOPSET,4	; Start a screen alignment countdown

KUP5:	RET			;

KEYPUT	ENDP
	PAGE
	PUBLIC	KEYCHK
KEYCHK	PROC	NEAR
	TEST	STATUS,LOW M$CPOR ; Controller reset anyone?
	JZ	KC0		; Not today.

	MOV	WORD PTR KERING+0,0 ; Clear the input pointer
	MOV	WORD PTR KERING+2,0 ; And the output pointer

KC0:	MOV	DI,OFFSET KERING; Attempt to pull a scan code from buffer
	CALL	RINGOUT		;
	JC	KC1		; Character available, send it

	RET			; Nothing to do, quit early

KC1:	MOV	AH,AL		; Save a copy of the scan code
	
	MOV	DX,REG0		; Set up key send command
	MOV	AL,LOW C$KEYS	;
	OUT	DX,AL		;

	MOV	DX,REG3		; Place the outbound key code
	MOV	AL,AH		;
	OUT	DX,AL		;

	MOV	DX,XSTART	; Start the slave

	TEST	ENADIS, 0FFH	; Ignore Keystroke If DISABLED
	JNZ	KC3
	OUT	DX,AL		;

KC3:	CALL	WAITS		; Wait 'till done

	STC			; Return having processed a key
	RET			; Exit

KEYCHK	ENDP

CODE	ENDS

	END
