	NAME	TIMER
	INCLUDE	PAGESIZE.INC
	TITLE	.TIMER - Accumulate something like system response time
DATA	SEGMENT	PUBLIC BYTE
	ASSUME	DS:DATA
	INCLUDE	PUBLICS.EQU
	EXTRN	TIMEOD:BYTE,	TIMMAX:BYTE,	TICTIM:BYTE
	;	All these variables are really DOUBLE WORD but will be
	;	accessed by BYTE offsets from their respective origins.

	EXTRN	AUXST:BYTE,	LSADDR:WORD,	LPDLY:BYTE
	EXTRN	PCDELY:BYTE,	ATDELY:BYTE,	ATFLAG:BYTE
	EXTRN	MACHINE:BYTE
DATA	ENDS

CODE	SEGMENT	PUBLIC BYTE
	ASSUME	CS:CODE
	EXTRN	PUTCH:NEAR		; Put CX on screen at [DI]
	EXTRN	MACHINE_ID:NEAR

	PUBLIC	BANDEL
; Banner delay.  No Data-segment set AS WELL AS NO at FLAG SET YET !!!!
BANDEL	PROC
	PUSH	DS
	PUSH	ES
	MOV	AX,DATA
	MOV	DS,AX
	MOV	AX,0FFFFH	; Point ES to the correct place
	MOV	ES,AX

	MOV	AL,ES:[0EH]	; Load the Machine ID Code from memory address
	MOV	MACHINE,AL	; Save the ID in RAM

	CALL	MACHINE_ID	; Check for Valid machine type

	CALL	UDELAY
	POP	ES
	POP	DS
	RET
BANDEL	ENDP

	PUBLIC	UDELAY
;  General purpose user wait loop for display of messages.
;  Should be about 2 seconds for all types of PC's.
UDELAY	PROC
	CMP	ATFLAG,0FFH		; Is this the AT that we are running
	JNE	STOL1
	MOV	AH,ATDELY		; Much longer wait for AT like machines
	JMP	STOL2	
STOL1:	MOV	AH,PCDELY		; Shorter wait for PC like machines 
STOL2:	MOV	CX,4000H
STOLL:	LOOP	STOLL			; Wait for the implications to sink
	DEC	AH
	JNZ	STOL2
	RET
UDELAY	ENDP



	PUBLIC	TICKER
TICKER	PROC	FAR			; Interrupt service for clock tick
	STI				; Allow interrupts to nest

	MOV	AX,DATA			; Set up local data segment
	MOV	DS,AX			;

	PUSH	BX			; Get a needed offset register
	PUSH	CX			;     and a counter

	CMP	LPDLY,0			; Are we running?
	JE	LPDL0			; No, stopped at zero

	DEC	LPDLY			; Yes, time it out

LPDL0:	TEST	AUXST,M$CLIK		; Is the clicker enabled?

	JNZ	NOTICK			; Clicker is on, zero the time

	XOR	BX,BX			; Count time that clicker is off
	MOV	CX,4			; Length of time register (8 digits)
					; Carry is clear as a result of XOR
TICK0:	MOV	AL,TIMEOD[BX]		; Get the current low order byte
	ADC	AL,TICTIM[BX]		; Add the fractional seconds
	DAA				; Convert back to BCD if overflows...
	MOV	TIMEOD[BX],AL		; Put the new number in place
	INC	BX			; Point to next word
	LOOP	TICK0			; Continue for all bytes

	JNC	TICK0B			; If no overflow, continue.

	XOR	BX,BX			; Overflow, set to 9999.9999
	MOV	CX,4			;
	MOV	AL,99H			; This is same as a BCD 99.

TICK0A:	MOV	TIMEOD[BX],AL		; 99
	INC	BX			;
	LOOP	TICK0A			;

TICK0B:	XOR	BX,BX			; Reset the pointer registers
	MOV	CX,4			;

TICK1:	MOV	AL,TIMMAX[BX]		; Test for maximum
	SBB	AL,TIMEOD[BX]		; Is this greater than before?
	DAS				; 
	INC	BX			;
	LOOP	TICK1			; Scan all the digits

	JNC	TICKX			; TIMEOD is less or equal to TIMMAX

	XOR	BX,BX			; Move new TIMMAX value in frm TIMEOD
	MOV	CX,4			;

TICK2:	MOV	AL,TIMEOD[BX]		; One byte at a time...
	MOV	TIMMAX[BX],AL		;
	INC	BX			;
	LOOP	TICK2			;

	JMP	TICKX			; Exit the loop

NOTICK:	XOR	BX,BX			; Clear the timer, clicker is on  
	MOV	CX,4			;
	XOR	AL,AL			; A convienient zero

NOT0:	MOV	TIMEOD[BX],AL		; Zero the time one byte each
	INC	BX			;
	LOOP	NOT0			;

TICKX:	POP	CX			; Restore the internal special regs
	POP	BX			;

	IRET				; DS,AX are restored by CLOCK_INT
TICKER	ENDP

	PUBLIC	DISTIM			; Display time at [DI]
DISTIM	PROC	NEAR			;
	MOV	DI,LSADDR		; Get status line address
	ADD	DI,80-(7*2)		; Right hand side
	SHL	DI,1			; As a word offset

	MOV	BX,OFFSET TIMEOD	; Current counter
	CALL	DISPTO			; Display in 'time' format (0000.0)

	MOV	BX,OFFSET TIMMAX	; Max time counter
	CALL	DISPTO			;

	RET
DISTIM	ENDP
	PAGE
DISPTO	PROC	NEAR			; Display time object
	ADD	BX,3			; Point to the top of the item
	MOV	CX,3			; Count of digit pairs

DSP0:	MOV	AL,[BX]			; Get a character
	DEC	BX			; Prepare pointer for next

	CMP	CX,1			; Is this the last digit?
	JNZ	DSP1			; No, do not print the decimal

	PUSH	AX			;

	MOV	CX,(15*256)+'.'		; Bright white dot
	CALL	PUTCH			; Drop one here.

	POP	AX			; Restore the digit
	CALL	PHEXDIG			; Display the one digit

	MOV	CX,(15*256)+' '		; Trailing space
	CALL	PUTCH			;

	RET				; And back to the egg

DSP1:	PUSH	CX			; Do not distroy the counter
	CALL	PHEXAL			; Display AL as a hex pair
	POP	CX			;
	DEC	CX			; One less pair to display
	JMP	DSP0			;

DISPTO	ENDP
	PAGE
	PUBLIC	DTIMRS
DTIMRS	PROC	NEAR			; Reset max timer
	XOR	BX,BX			; Offset into TIMMAX
	MOV	CX,4			; Number of bytes in TIMMAX
	CLI				; Do not allow the clock to tick

	XOR	AL,AL			; A typical zero

DTI0:	MOV	TIMMAX[BX],AL		; In a typical zero's job.
	INC	BX			; Hold that place!
	LOOP	DTI0			;

	XOR	BX,BX			; Reset the current tod
	MOV	CX,4			;

DTI1:	MOV	TIMEOD[BX],AL		; 
	INC	BX			;
	LOOP	DTI1			;

	STI				; Re-enable the interrupts

	RET				; And we're done!
DTIMRS	ENDP
	PAGE
	PUBLIC	PHEXAL
PHEXAL	PROC	NEAR
	PUSH	AX			; Character for later

	MOV	CL,4			; Bring upper digit down
	SHR	AL,CL			;
	CALL	PHEXDIG			; Print one hex digit

	POP	AX			;

PHEXDIG	LABEL	NEAR			; Reentry point.
	AND	AL,0FH			; Only one digit
	CMP	AL,10			; Is this alpha?
	JC	NOALP			; No.

	ADD	AL,7			; Alpha/Num offset
NOALP:	ADD	AL,'0'			; Alpha ASCII
	MOV	CL,AL			; Place the character
	MOV	CH,15			; Bright white attribute

	PUSH	DX			; Be kind, save a register

	CALL	PUTCH			; Put the caracter on the screen

	POP	DX			;

	RET				;

PHEXAL	ENDP

CODE	ENDS

	END
