
	NAME	UPDLIN
	INCLUDE	PAGESIZE.INC
	TITLE	.UPDLIN - Update line BL from slave
;
; UPDLIN - action routine to actually write or update a line on the
; screen display from either the on-board IRMA interface buffer or
; from a screen save memory buffer.
;
; On entry: BL == line number to update
;	    ES == screen segment address
;
; On exit: Nothing useful
; 
; Called by: UPDATE, ?
;
; Routines called: PUTCH, MKATTR, WAITS 
;
; Globals changed: ATRSAVE, PRVATR
;
; Globals accessed: DISLIN, BSADDR, LSADDR, TOPLIN, NBUF, EBCDIC,
;		    MEMTAB.MEMADR
;
; History:
;   Date    Version    By     Comments
; 01/22/85   1.40      jsc	Added changes for IRMAvision
; 02/01/85   1.40      jsc	Optimized parts of routine
;
DATA	SEGMENT	PUBLIC BYTE
	ASSUME	DS:DATA
	INCLUDE	PUBLICS.EQU
	EXTRN	PRVATR:BYTE,	BSADDR:WORD,	LSADDR:WORD,	COLROW:WORD
	EXTRN	ATDSC:BYTE,	EBCDIC:BYTE,	ATRSAV:BYTE,	SLVERR:BYTE
	EXTRN	MEMTAB:WORD,	NBUF:BYTE,	TOPLIN:WORD,	NOATRS:BYTE
	EXTRN	DISLIN:BYTE
DATA	ENDS

CODE	SEGMENT	PUBLIC BYTE
	ASSUME	CS:CODE
	EXTRN	PUTCH:NEAR,	MKATTR:NEAR,	WAITS:NEAR

	PUBLIC	UPDLIN
UPDLIN	PROC	NEAR
	XOR	BH,BH		; Clear high byte of line number
	CMP	BL,DISLIN	; Should be less than DISLIN
	JC	UPD0		;

	RET			; Line number out of range

UPD0:	CMP	BX,1		; Top of screen is special
	JNZ	UPD0A		; Wraps from bottom right

	PUSH	BX		; Save line number
	MOV	BL,DISLIN	; Get number of lines on display and use it
	MOV	DH,ATRSAV[BX]	; to as an index into arrays to get the end
	MOV	CH,PRVATR[BX]	; of screen attribute.  Then put this as the
	POP	BX		; as the beginning of screen attribute.
;				; (i.e. If DISLIN = 25 then...
	MOV	ATRSAV[BX],DH	; ATRSAV[1] = ATRSAV[24+1]
	MOV	PRVATR[BX],CH	; PRVATR[1] = PRVATR[24+1]

UPD0A:	MOV	CH,ATRSAV[BX]	; Copy the raw attribute over
	MOV	ATRSAV[BX+1],CH	;
	MOV	CH,PRVATR[BX]	; Get the attribute from the previous line
	MOV	PRVATR[BX+1],CH	; Set default attribute for next line

	SHL	BX,1		; Make BX word offset into LS & BS tables
	MOV	SI,BSADDR[BX]	; Buffer (Slave) start address
	MOV	DI,LSADDR[BX]	; Line (Screen) start address
	SHL	DI,1		; Screen addresses are word addresses
	SHR	BX,1		; BX is back to normal

	CMP	BL,0		; Is this a status line?
	JZ	NOOFST		; Yes, no TOPLIN offset allowed

	ADD	SI,TOPLIN	; Skew the display down as requested

NOOFST:	MOV	DX,REG0		; Set up intial read
	MOV	AL,C$READ	;
	OUT	DX,AL		;

	MOV	AX,SI		; Get address to read

	INC	DX		; Point to address register
	OUT	DX,AX		; Send the address

	MOV	DX,XSTART	; Kick the slave
	OUT	DX,AL		;

	MOV	BP,XFLAGS	; This will be used for later reference
	MOV	CX,COLROW	; Number of locations to update
	CMP	BL,0		; Is this the STATUS line?
	JNZ	NOTST		; No - jump
	MOV	CX,80		; Yes - always use 80 never use 132

NOTST:	CMP	NBUF,0		; Is there any memory active
	JZ	UPD1		; No, read IRMA
	JMP	UPM		; Yes, update from memory, not IRMA

UPD1:	PUSH	BX		; Save line number
	PUSH	CX		; and counter

	MOV	DX,BP		; Get slave status register address
	MOV	CX,TCONT	; Put a large number in CX for timeout
UPD2:	IN	AL,DX		; Check to see if read command finished
	TEST	AL,M$BUSY	; Is the slave ready?
	JZ	UPD3		; Yes, continue
	DEC	CX		; No, decrement timeout count
	JNZ	UPD2		; Check Status again
UPD3:	CALL	WAITS		; Call for long wait if timeout occurs here

	INC	SI		; Prepare next address
	MOV	DX,REG1		; Set next address
	MOV	AX,SI		;
	OUT	DX,AX		;
	INC	DX		; Point to data & eab registers

;****** convert WORD input to BYTE input for EAGLE 1600 *******************
	IN	AL,DX		; Get  DATA:EAB				***
	MOV	AH,AL		;					***
	INC	DX		;					***
	IN	AL,DX		;					***
;	IN	AX,DX		;					***
;	XCHG	AH,AL		; Make EAB:DATA                     	***
;**************************************************************************

	MOV	DX,XSTART	; Start the next read
	OUT	DX,AL		;

	CALL	MKATTR		; Fix the attributes
				; BH contains character set number...
	MOV	BL,AL		; Get character into pointer variable
	MOV	AL,EBCDIC[BX]	; Get screen code for EBCDIC(?) character
	MOV	CX,AX		; Put characters in place for call
	CALL	PUTCH		; Put the attr/char on the screen

	POP	CX		; Restore counter
	POP	BX		; And line number
	LOOP	UPD1		; One less character to move

	MOV	DX,BP		; Get slave status register address
	MOV	CX,TCONT	; Put a large number in CX for timeout
UPD9:	IN	AL,DX		; Check to see if read command finished
	TEST	AL,M$BUSY	; Is the slave ready?
	JZ	UPDX		; Yes, continue
	DEC	CX		; No, decrement timeout count
	JNZ	UPD9		; Check Status again
	CALL	WAITS		; Call for long wait if timeout occurs here

UPDX:	RET

	PAGE
;
; UPM - section of UPDLIN routine that recalls a previously saved 3270
; screen from a memory buffer specified by the NBUF variable.
;
; Register usage: AX == contains index off of MEMTAB to access correct
;			offset:segment for memory recall buffer
;		  BX == contains the number of the line being updated;
;		        temporarily used for its indexing capability
;		  CX == used as loop counter, initially contains number
;			of chars on display line (COLROW)
;		  SI == address into memory buffer to fetch screen data
;		  DS == (implied usage) contains data segment
;		  ES == contains screen segment; temporarily used to
;			fetch data from memory recall buffer
;
UPM:	SHL	SI,1		; Offsets into memory are words, not bytes
	MOV	AL,NBUF		; Get current memory buffer
	MOV	AH,TYPE MEMTE	; Get size of MEMTE structure
	MUL	AH		; AX = NBUF*(Type MEMTE)

UPM1:	PUSH	BX		; Recall from memory, not IRMA
	PUSH	CX		; This loop is very similar to the loop
	PUSH	AX		; at UPD1, except for the data source
	PUSH	BX

	MOV	BX,AX		; Get index into BX

	PUSH	ES		; Do not disturb screen segment

	LES	BX,MEMTAB.MEMADR[BX]	; Get offset:segment of buffer
	MOV	AX,ES:[BX][SI]		; Contents of buffer

	POP	ES
	POP	BX		; Restore line number

	ADD	SI,2		; Point to next buffer location
	CALL	MKATTR		; Compute the attribute, switches & all
				; Char set number in BH
	MOV	BL,AL		; Convert char from EBCDIC(?) to ASCII(?)
	MOV	AL,EBCDIC[BX]	;
	MOV	CX,AX		; Put character where PUTCH needs it
	CALL	PUTCH		; Deposit the character on the screen

	POP	AX		; Restore index
	POP	CX		; Restore the counter
	POP	BX		; And the line number
	LOOP	UPM1		; Count off the characters
	RET

UPDLIN	ENDP
CODE	ENDS
	END
