	NAME	CACHE
	INCLUDE	PAGESIZE.INC
	TITLE	.CACHE - Screen save cache & managers CACHEIN, CACHEOUT

DATA	SEGMENT	PUBLIC BYTE
	ASSUME	DS:DATA
	INCLUDE	PUBLICS.EQU
	EXTRN	CACPOS:WORD,	CACTYP:WORD,	CAVMOD:BYTE,	CACPAG:BYTE
	EXTRN	CASIZE:WORD,	CACHE:BYTE,	VMODE:BYTE,	MONOFLG:BYTE
	EXTRN	CACSHP:BYTE,	SCRNMOD:BYTE,	PCMODE:BYTE,	SMODE:BYTE
	EXTRN	IBMEGA:BYTE,	PALETTE:BYTE
	EXTRN	CHAR_SEL:BYTE,	EMULSW:BYTE
DATA	ENDS
	PAGE
CODE	SEGMENT	PUBLIC BYTE
	ASSUME	CS:CODE
	EXTRN	VIDEON:NEAR,	VIDEOFF:NEAR,	SVMODE:NEAR,	EGAON:NEAR
	EXTRN	EGAOF:NEAR,

;HISTORY
;DATE	     	VERSION	      PROG.	COMMENTS
; 1/31/86       1.46          KA        Support for EGA mult char sets
;12/01/8=	1.$-		        Support for EGA new modes
;11/21/85	1.450001      CMB/KA	VMODE is only used for the current 
;					video state. SMODE is a temporary
;				        storage for what the mode is to become.
;11/20/85	1.45	      CMB/KA	Added detection of video mode 6
;11-7-85	1.40 	      CSM	Added IRMAvision support

;
; Called only by INIT.ASM 
;
	PUBLIC	CACHEIN
CACHEIN	PROC	NEAR

	MOV	EMULSW,1 ; We are now executing the emulator

	MOV	AH,15		; Get current video state
	INT	10H		;

	MOV	CAVMOD,AL	; Video display mode
	MOV	VMODE,AL	; Mode to use for VIDEON
	MOV	PCMODE,AL	; Save the video mode here as well
	MOV	CACPAG,BH	; Active page

	MOV	CASIZE,26*80    ; Default monochrome screen size (characters)
	CMP	AL,7		; BW 80 MODE
	JZ	CSN		; Normal screen size

	CMP	AL,4		; This is the first graphics mode
	JC	CSN		; It is less (0-3)

CSN:	MOV	AH,3		; Read current cursor position and type
	INT	10H		;

	MOV	CACPOS,DX	; Save current cursor position
	MOV	CACTYP,CX	; System cursor definition

	CALL	VIDEOFF		; Turn off the display

	CMP	IBMEGA,1	; Is this EGA
	JNE	CIN00		; bypass palette info if not

; EGA, so save all palette information
	PUSH	ES
	PUSH	DS
	PUSH	DS
	POP	ES

	XOR	AX,AX
	MOV	DS,AX
	MOV	BX,04A8H	; save_ptr
	LDS	BX,DWORD PTR [BX]	; DS:BX points to the 8 dwords

	CMP	WORD PTR DS:[BX+6],0	; is segment still 0
	JE	CIN000			; jmp if yes, no saving

	LDS	SI,DWORD PTR [BX+4]	; DS:SI points to palette information
	MOV	DI,OFFSET PALETTE
	MOV	CX,17D		; save 17 byte
	REP	MOVSB

CIN000:	POP	DS
	POP	ES


CIN00:	MOV	BL,VMODE
	AND	BL,7FH		; clear the high order bit
	CMP	BL,0DH		; Is this a new EGA mode
	JAE	CINNEW		; Jmp if yes

	MOV	SI,0		; Start with the beginning of the screen
	MOV	CX,CASIZE	; CASIZE 	; Number of words on the screen to save

CIN0:	MOV	BL,ES:[SI]	; Get a character from the screen
	MOV	BH,ES:[SI+1]	; One byte at a time for 8086/PC fans...
	MOV	WORD PTR CACHE[SI],BX
	ADD	SI,2		; Next word
	LOOP	CIN0		;

	JMP	CIN10		; ok, we are done

CINNEW:	PUSH	ES		; save ES

; we are now leaving a new EGA mode, so save some memory

	XOR	AX,AX
	MOV	ES,AX
	TEST	BYTE PTR ES:[487H],60H		; check amount of EGA memory
	JNZ	NOT64K			; jmp if more than 64 K
	JMP	EQ64K			; special processing for 64 K

NOT64K:
; save 4k of bit plane 2 (even paragraphs up to 8k)
; save 2k even addresses from plane 0
; save 2k odd addresses from plane 1

	MOV	AX,0A000H	; setup new base for saving
	MOV	ES,AX
	MOV	DI,0		; Start at the beginning of the save are

; first set read mode 0

	MOV	DX,03CEH
	MOV	AL,5		; mode register
	OUT	DX,AL
	INC	DX
	MOV	AL,0		; read mode 0
	OUT	DX,AL

	MOV	AH,2		; start with bit plane 2
	MOV	DX,03CEH	; graphics 1&2 register
CIN2:	MOV	AL,4		; select read map select reigister
	OUT	DX,AL

	MOV	AL,AH		; get the bit plane
	INC	DX		;
	OUT	DX,AL		; write to the read map select register

	MOV	SI,0		; Start with the beginning of the screen
	MOV	CX,0800H	; loop 2k times

CIN5:	MOV	BL,ES:[SI]	; Get a character from the screen
	MOV	BH,ES:[SI+1]	; One byte at a time for 8086/PC fans...

	CMP	AH,2		; is this plane 2
	JNE	CIN6		; jmp if not
	MOV	WORD PTR CACHE[DI],BX	; save word from plane 2
	ADD	DI,2		; Next word in CACHE
	ADD	SI,2		; next pos on screen

	MOV	BX,SI
	AND	BL,01FH		; Isolate the lower 5 bits
	CMP	BL,10H		; Have we just entered an odd paragraph
	JNE	CIN8		; Jump if not odd
	ADD	SI,10H		; Address next even paragraph ... skip odd ones

	JMP 	SHORT CIN8

CIN6:	CMP	AH,1		; is this plane 1
	JNE	CIN7		; jmp if not
	MOV	BYTE PTR CACHE[DI],BL	; plane 1, odd bytes
	ADD	DI,1		; next pos in CACHE
	ADD	SI,2		; next pos on screen
	JMP	SHORT CIN8
CIN7:	MOV	BYTE PTR CACHE[DI],BL	; plane 0, even bytes
	ADD	DI,1		; next position in CACHE
	ADD	SI,2		; next pos on screen
CIN8:	LOOP	CIN5		;

 	DEC	DX
	DEC	AH		; next bit plane
 	JGE	CIN2		; process planes 2,1,0
	JMP	CIN9		; return, we are done

EQ64K:
; save 4k of bit plane 2-3 ( evry second byte of even paragraphs up to 8k on each plane)
; save 4k sequential from plane 0

	MOV	AX,0A000H	; setup new base for saving
	MOV	ES,AX
	MOV	DI,0		; Start at the beginning of the save are

; first set read mode 0

	MOV	DX,03CEH
	MOV	AL,5		; mode register
	OUT	DX,AL
	INC	DX
	MOV	AL,10H		; read mode 0, odd/even
	OUT	DX,AL

	MOV	AH,2		; start with bit plane 2
	MOV	DX,03CEH	; graphics 1&2 register
CI642:	MOV	AL,4		; select read map select reigister
	OUT	DX,AL

	MOV	AL,AH		; get the bit plane
	INC	DX		;
	OUT	DX,AL		; write to the read map select register

	MOV	SI,0		; Start with the beginning of the screen
	MOV	CX,0800H	; loop 2k times
	CMP	AH,2		; is this plane 2
	JB	CI645		; jmp if not
	ADD	CX,0800H	; loop 4k times if plane 2

CI645:	MOV	BL,ES:[SI]	; Get a character from the screen
	MOV	BH,ES:[SI+1]	; One byte at a time for 8086/PC fans...

	CMP	AH,2		; is this plane 2
	JNE	CI647		; jmp if not
	MOV	BYTE PTR CACHE[DI],BL	; save byte from plane 2
	ADD	DI,1		; Next byte in CACHE
	ADD	SI,2		; next pos on screen

	MOV	BX,SI
	AND	BL,01FH		; Isolate the lower 5 bits
	CMP	BL,10H		; Have we just entered an odd paragraph
	JNE	CI648		; Jump if not odd
	ADD	SI,10H		; Address next even paragraph ... skip odd ones
	MOV	BX,SI
	AND	BX,1FFFH	; have we just entered next 8k boundary
	JNE	CI648		; jmp if not
	ADD	SI,2000H	; jump to next page

	JMP 	SHORT CI648

CI647:	MOV	WORD PTR CACHE[DI],BX	; plane 0
	ADD	DI,2		; next position in CACHE
	ADD	SI,2		; next pos on screen
CI648:	LOOP	CI645		;

 	DEC	DX
	DEC	AH		; next bit plane
	DEC	AH		; do not process plane 1
 	JGE	CI642		; process planes 2 and 0

CIN9:	POP	ES		; restore ES

CIN10:	CALL	VIDEON		; Turn the display back on...

	RET

CACHEIN	ENDP
	PAGE
	PUBLIC	CACHEOUT
CACHEOUT PROC	NEAR

	MOV	SCRNMOD,0	; Reset to normal screen

	OR	PCMODE,80H	; Tell SVMODE we are leaving E78

	MOV	AL,CAVMOD	; Set video mode
	MOV	SMODE,AL	; For VIDEON
	CALL	SVMODE		; WITHOUT FOULING UP COLORS!

	MOV	AH,5		; Current page
	MOV	AL,CACPAG	;
	INT	10H		;

	MOV	AH,1		; Set cursor type

	TEST	CACSHP,255	; Is this an always function?
	JNZ	CDFIX		; Yes, ignore old info.

	MOV	CX,CACTYP	;
	TEST	CX,1110000011100000B ; Check for bogus bits
	JZ	NDFIX		;

CDFIX:	MOV	CX,607H		; Repair the returned cursor type
	CMP	MONOFLG,MF$C	; Is this normal color?
	JZ	NDFIX		; Yes, 607 is Ok. (6,7)

	MOV	CX,0B0CH	; No, monochrome is 11,12

NDFIX:	INT	10H		;

	MOV	AH,2		; Set cursor position
	MOV	BH,CACPAG	;
	MOV	DX,CACPOS	;
	INT	10H		;

	CALL	VIDEOFF		; Turn off the display processor

      	MOV	BL,VMODE
	AND	BL,7FH		; clear the high order bit
	CMP	BL,0DH		; Is this a new EGA mode
	JAE	CUTNEW		; Jmp if yes

	MOV	DI,0		; Start at the beginning
	MOV	CX,CASIZE	; CASIZE	;

CUT0:	MOV	BX,WORD PTR CACHE[DI]
	MOV	ES:[DI],BL	; Low byte for 8086 fans
	MOV	ES:[DI+1],BH	;
	ADD	DI,2		;
	LOOP	CUT0		;

	JMP	CUT10		; ok we are done

; we are now returning to a new EGA mode, so restore memory
CUTNEW:	PUSH	ES		; save ES

	XOR	AX,AX
	MOV	ES,AX
	TEST	BYTE PTR ES:[487H],60H		; check amount of EGA memory
	JNZ	NOT64KU			; jmp if more than 64 K
	JMP	EQ64KU			; special processing for 64 K

NOT64KU:

; restore 4k to bitplane 2
; restore 2k odd to plane 1
; restore 2k even to plane 0
	MOV	AX,0A000H	; setup new base for saving
	MOV	ES,AX
	MOV	SI,0		; Start at the beginning of the save are

; first set write mode 0
	MOV	DX,03CEH
	MOV	AL,5		; mode register
	OUT	DX,AL
	INC	DX
	MOV	AL,0		; write mode 0
	OUT	DX,AL

; now, select the proper plane to write to
	MOV	AH,4		; start with bit plane 2
	MOV	DX,03C4H	; sequencer register
CUT2:	MOV	AL,2		; map mask register
	OUT	DX,AL

	MOV	AL,AH		; get the bit plane
	INC	DX		;
	OUT	DX,AL		; mask off all planes but one

	MOV	DI,0		; Start with the beginning of the screen
	MOV	CX,0800H	; loop 2k times

CUT5:	CMP	AH,4		; is this bit plane 2
	JNE	CUT6		; jmp if not

	MOV	BX,WORD PTR CACHE[SI]
	MOV	ES:[DI],BL	; Low byte for 8086 fans
	MOV	ES:[DI+1],BH	;
	ADD	SI,2		; next word in CACHE
	ADD	DI,2		; next pos on screen
	MOV	BX,DI
	AND	BL,01FH		; Isolate the lower 5 bits                     
	CMP	BL,10H          ; Have we just entered an odd paragraph        
	JNE	CUT8            ; Jump if not odd                              
	ADD	DI,10H          ; Address next even paragraph ... skip odd ones
	JMP	SHORT	CUT8

CUT6:	CMP	AH,2		; is this bit plane 1
	JNE	CUT7		; jmp if not
	MOV	BH,BYTE PTR CACHE[SI]	; get the odd byte for plane 1
	MOV	ES:[DI],BH	; restore the odd byte
	ADD	SI,1		; next byte in CACHE
	ADD	DI,2		; next pos on screen
	JMP	SHORT	CUT8

CUT7:	MOV	BL,BYTE PTR CACHE[SI]	; get an even byte for plane 0
	MOV	ES:[DI],BL	; restore the even byte
	ADD	DI,2		; next pos on screen
	ADD	SI,1		; next byte in CACHE

CUT8:	LOOP	CUT5		;

 	DEC	DX
 	SHR	AH,1		; next plane
 	JNZ	CUT2		; process planes 2,1,0

	JMP	CUT9		; return, we are done

EQ64KU:

; restore 4k to bitplane 2-3
; restore 4k to plane 0
	MOV	AX,0A000H	; setup new base for saving
	MOV	ES,AX
	MOV	SI,0		; Start at the beginning of the save are

; first set write mode 0
	MOV	DX,03CEH
	MOV	AL,5		; mode register
	OUT	DX,AL
	INC	DX
	MOV	AL,10H		; write mode 0, odd/even
	OUT	DX,AL

; now, select the proper plane to write to
	MOV	AH,0CH		; start with bit plane 2-3
	MOV	DX,03C4H	; sequencer register
CU642:	MOV	AL,2		; map mask register
	OUT	DX,AL

	MOV	AL,AH		; get the bit plane
	INC	DX		;
	OUT	DX,AL		; mask off all planes but one

	MOV	DI,0		; Start with the beginning of the screen
	MOV	CX,0800H	; loop 2k times
	CMP	AH,0CH		; Is this bit plane 2-3
	JB	CU645		; Jump if plane 0-1
	ADD	CX,0800H	; loop 4k times

CU645:	CMP	AH,0CH		; is this bit plane 2-3
	JNE	CU647		; jmp if not

	MOV	BL,BYTE PTR CACHE[SI]
	MOV	ES:[DI],BL	; Low byte for 8086 fans
	ADD	SI,1		; next byte in CACHE
	ADD	DI,2		; next pos on screen
	MOV	BX,DI
	AND	BL,01FH		; Isolate the lower 5 bits                     
	CMP	BL,10H          ; Have we just entered an odd paragraph        
	JNE	CU648            ; Jump if not odd
	ADD	DI,10H          ; Address next even paragraph ... skip odd ones
	MOV	BX,DI
	AND	BX,1FFFH	; have we just entered next 8k boundary
	JNE	CU648		; jmp if not
	ADD	DI,2000H	; jump to next page
	JMP	SHORT	CU648

CU647:	MOV	BX,WORD PTR CACHE[SI]	; get a word for plane 0
	MOV	ES:[DI],BL	; Low byte for 8086 fans
	MOV	ES:[DI+1],BH	;
	ADD	DI,2		; next pos on screen
	ADD	SI,2		; next word in CACHE

CU648:	LOOP	CU645		;

 	DEC	DX
 	SHR	AH,1		; next plane
 	SHR	AH,1		; next plane
 	JNZ	CU642		; process planes 2 and 0


; reconfigure the Graphics Controller to default status assumed by BIOS

CUT9:	MOV	DX,03C4H
	MOV	AL,2		; sequencer register
	OUT	DX,AL
	INC	DX
	MOV	AL,0FH 		; enable all four planes
	OUT	DX,AL

	MOV	DX,03CEH
	MOV	AL,8		; bit mask register
	OUT	DX,AL
	INC	DX
	MOV	AL,0FFH		; default bit mask
	OUT	DX,AL

	POP	ES

CUT10:	CALL	VIDEON		; Turn the display back on...

	CMP	IBMEGA,1	; is EGA selected
	JNE	CUT15		; jmp if not

	CMP	CHAR_SEL,0	; was any special char set in use
	JE 	CUT12		; jmp if not

	MOV	BL,CHAR_SEL	; get the saved char set
	MOV	AX,1103H	; set block function
	INT	10H		; restore char set

	MOV	AX,1000H	; set color plane enable to 7 to disable
	MOV	BX,0712H	; attr bit 3 in the color palette
	INT	10H

; EGA, so restore all palette information if not all zero
CUT12:	PUSH	ES
	PUSH	DS
	POP	ES

	MOV	DI,OFFSET PALETTE	; ES:DI points to old palette
	CLD
	MOV	AL,0		; search for non-zero
	MOV	CX,17		; search 17 bytes
	REPE	SCASB
	JE	CUT14 		; jmp if only 0's

	MOV	DX,OFFSET PALETTE	;ES:DX points to old palette inf
	MOV	AH,10H		; set palette registers
	MOV	AL,2		; set all palette registers
	INT	10H

CUT14: 	POP	ES		; restore ES

CUT15:	MOV	EMULSW,0	; We are now leaving the emulator
	RET			;

CACHEOUT ENDP

CODE	ENDS

	END


