	NAME	PRINTSC
	INCLUDE	PAGESIZE.INC
	TITLE	.PRINTSC - Print screen replacement for E78 III
;
; PRINTSC - interrupt service routine to print the current screen on
; printer 0 using the BIOS Printer interrupt (INT 17H).  This routine
; is compatible with, but different from, the IBM PC BIOS Print Screen
; routine.
;
ABSSEG	SEGMENT	AT 0		; Low memory absolute segment
ZERO	LABEL	BYTE		;
ABSSEG	ENDS

SCREEN	SEGMENT AT 0B000H	; Dummy segment
SCREEN	ENDS

DATA	SEGMENT	PUBLIC BYTE	; Tell the Assembler about DATA!
	EXTRN	PRABLE:BYTE	; PC display code to ASCII printable table
	EXTRN	SCRN_SEG:WORD,	COLROW:WORD,	DISLIN:BYTE
	EXTRN	SCANCK:BYTE,	SCRNMOD:BYTE,	CRTBASE:WORD
DATA	ENDS

CODE	SEGMENT	PUBLIC PARA	; Must be PARA since this is a FAR module
	ASSUME	CS:CODE

	PUBLIC	PRINTSC
PRINTSC	PROC	NEAR
	STI			; Run with interrupts on
	PUSH	ES		; Save registers used
	PUSH	DS		;
	PUSH	AX		;
	PUSH	BX		;
	PUSH	CX		;
	PUSH	DX		;

	ASSUME	DS:ABSSEG	;
	MOV	AX,050H		; Print screen control data area
	MOV	DS,AX		;

	CMP	ZERO,1		; See if print already in progress
	JZ	PSCX		; Already working, exit.

	MOV	ZERO,1		; Set in-process bit
	
	PUSH	DS		; Save DS for later
	CALL	PCRLF		; Start on a new line
	ASSUME	DS:DATA, ES:SCREEN
	MOV	AX,DATA		; Establish segment registers
	MOV	DS,AX
	MOV	AX,SCRN_SEG
	MOV	ES,AX
	XOR	SI,SI		; Offset into screen segment
	MOV	BX,OFFSET PRABLE ; Used for XLAT
	MOV	DH,DISLIN	; Number of lines on display
	DEC	DH		; Minus Status line
	
PSC14:	MOV	CX,COLROW	; Number of chars per line
PSC15:	CALL	GETCHAR		; Get a char from ES:[SI]
	XLAT			; Convert to printable char
	PUSH	DX		; Save line count
	XOR	DX,DX		; Indicate printer 0
	XOR	AH,AH		; Char in AL
	INT	17H		; BIOS printer interrupt
	POP	DX		; Restore line count
	TEST	AH,29H		; Test for printer error
	JNZ	ERR10		; Error - jump
	LOOP	PSC15		; Loop for an entire line
	CALL	PCRLF		; Else send <cr><lf>
	DEC	DH		; Decrement line count
	JNZ	PSC14		; If nonzero do next line
	
	ASSUME	DS:ABSSEG
	POP	DS		; Restore previous DS
	MOV	ZERO,0		; Clear in-process flag
	JMP	SHORT PSCX	; Normal exit
	
ERR10:	POP	DS		; Remove from stack
	MOV	ZERO,255	; Indicate error
	
PSCX:	POP	DX		; Restore all registers used
	POP	CX		;
	POP	BX		;
	POP	AX		;
	POP	DS		;
	POP	ES
	IRET			;

PCRLF	PROC	NEAR		; Printer CRLF for PRINTSC
	PUSH	DX		; Save DX
	XOR	DX,DX		; Select printer 0

	XOR	AH,AH		; Character in AL
	MOV	AL,12Q		; LF
	INT	17H		;

	XOR	AH,AH		;
	MOV	AL,15Q		; CR
	INT	17H		;
	POP	DX		; Restore DX
	RET
PCRLF	ENDP
;
; GETCHAR - routine to read a char from the display memory and return it
; to the calling routine.  Checks are made to see if a read can only be
; done during vertical or horizontal retrace.
;
; On entry: ES == segment of screen memory (usually either B000 or B800)
;	    DS == data segment
;	    SI == offset of char to read from screen memory
; 
; On exit:  AL == character read from DS:SI
;	    SI == incremented to point to next char slot in screen memory
;
; Called by: PRINTSC, SAVESC
;
; Routines called: None
;
; Globals accessed: SCRNMOD, SCANCK, CRTBASE
;
; Globals changed: None
;
; Registers used (and not saved): AH
;
; History:
;   Date    Version     By	Comments
; 01/31/85    1.40     JSC	Created routine.
;
	PUBLIC	GETCHAR
GETCHAR	PROC	NEAR
	ASSUME	DS:DATA, ES:SCREEN
	PUSH	CX		; Save registers used
	PUSH	DX
	CMP	SCRNMOD,5	; IRMAvision Mod 5 screen?
	JE	GET132		; Yes, use special read
	CMP	SCANCK,0	; Wait for sync to read?
	JZ	GETCH1		; No, do a fast read
	
	MOV	CX,100		; Timeout constant
	MOV	DX,CRTBASE	; Form Status register address
	ADD	DX,6		; in DX
	MOV	AH,1		; Status reg value used for TEST
	CLI			; Do not interrupt read
G_WAIT_LOW:
	IN	AL,DX		; Get Status
	TEST	AL,AH		; Wait till we exit current retrace period
	LOOPNZ	G_WAIT_LOW	; but, timeout if we are in vertical retrace
G_WAIT_HIGH:
	IN	AL,DX		; Wait till we enter next retrace period
	TEST	AL,AH
	JZ	G_WAIT_HIGH
GETCH1:	MOV	AL,ES:[SI]	; Safe to read char now
GETCX:	STI			; Restore interrupts
	INC	SI		; Point to next char slot
	INC	SI
	POP	DX		; Restore registers
	POP	CX
	RET
	
GET132:	PUSH	SI		; Save index register
	SHR	SI,1		; /2 - word addresses
	TEST	SI,01H		; Determine if read is for odd or even char
	JZ	GETEVEN		; Even read - jump
	ADD	SI,4095		; Add odd read offset for 132 mode
GETEVEN:
	MOV	AL,ES:[SI]	; Read the char
	POP	SI		; Restore index reg
	JMP	SHORT GETCX
	 
GETCHAR	ENDP
	
PRINTSC	ENDP
CODE	ENDS
	END
