	NAME	VIDEO
	INCLUDE	PAGESIZE.INC
	TITLE	.VIDEO - Set video mode etc., SVMODE, VIDEON/OFF, PUTCH

;HISTORY
; DATE		VERSION		PROG.	COMMENTS
; 11-30-84  	  ?		  ?	final pc's added
; 02-07-85	1.40		CSM	Added IRMAvision support
; 02-28-85      1.40 A          KBD     Added compatible unusual video modes
;					& Ericsson PC cursor fix
; 03-26-85	1.41 B		KBD     removed Ericsson extra video fix
; 04-27-85      1.42            KA      Added Hercules support
; 05-01-85	1.42		CMB	Added EGA Switches to replace code patches
;
DATA	SEGMENT	PUBLIC BYTE
	ASSUME	DS:DATA
	INCLUDE	PUBLICS.EQU
	EXTRN	CRTBASE:WORD,	VMODE:BYTE,	MONOFLG:BYTE,	SCANCK:BYTE
	EXTRN	VPARM:BYTE,	CMODES:BYTE,	EAGLE:BYTE,	CTTCUR:WORD
	EXTRN	LPOFS:BYTE,	SIMAGE:WORD,	ALTMOD1:BYTE,	ALTMOD2:BYTE
	EXTRN	ERICCRT:BYTE,	ALTVMD:BYTE,	SAVEMD:BYTE
	EXTRN	ALTM21:BYTE,	ALTM22:BYTE,	ALTEXIT:BYTE,	SCRNMOD:BYTE
	EXTRN	STLINE:WORD,	BUFEND:WORD,	COLROW:WORD,	LSADDR:WORD
	EXTRN	STATLIN:WORD,	CMODES2:BYTE,	DISLIN:BYTE,	BSADDR:WORD
	EXTRN	ALTMOD3:BYTE,	ALTM31:BYTE,	HEPAGE1:BYTE,	HEMOD:BYTE
	EXTRN	HEMOD2:BYTE,	IBMEGA:BYTE,	IBMEGAM:BYTE
DATA	ENDS

CODE	SEGMENT	PUBLIC	BYTE
	ASSUME CS:CODE
BEGIN=	$			; Used for word alignment calculations
				; in later time critical 8086 special code

	PAGE

	; The following chart describes the format for data in AL
	;
	; CB=ColorBoard  CD=ColorDisplay  BW=BlackWhite
	; MB=MonoBoard	MD=MonoDisplay
	; IV=IRMAvision display board (MONO)
	;
	;                              VMODE bits
	; Mode     	Size    7 6 5 4 3 2 1 0  VPRAM[ ] Start
	; CB, CD, BW    40x25	X 0 0 0 0 0 0 0 	0
	; CB, CD,	40x25   X 0 0 0 0 0 0 1 	0
	; CB, CD, BW	80x25	X 0 0 0 0 0 1 0		16
	; CB, CD,   	80x25	X 0 0 0 0 0 1 1		16
	; CB, CD,      320x200 	X 0 0 0 0 1 0 0 	32
	; CB, CD,      320x200 	X 0 0 0 0 1 0 1 	32
	; CB, CD,      640x200 	X 0 0 0 0 1 1 0 	32
	; CB, CD,	XXx26	1 0 0 0 0 X X X  PATCH ABOVE LOCATIONS
	; MB, MD, 	80x25	X 0 0 0 0 1 1 1		48
	; IV, MD, 	80X26	0 0 1 0 0 1 1 1		48 PATCHED
	; IV, MD, 	80X34	0 1 1 0 0 1 1 1		64
	; IV, MD, 	80X45	1 0 1 0 0 1 1 1		80
	; IV, MD,      132X29	1 1 1 0 0 1 1 1	        96

	PAGE
	PUBLIC	SVMODE
SVMODE	PROC	NEAR		; Set video mode AL
	XOR	AH,AH		; Zero AH
	PUSH	AX		; Save AX (contains VMODE in AL)

	CALL	VIDEOFF		;
		
	XOR	BX,BX		; Index to SIMAGE
	XOR	AX,AX		;
	MOV	CX,132*29	; Max Words per image
CICS:	MOV	SIMAGE[BX],AX	; Clear Image Control Screen
	ADD	BX,2		; Words!
	LOOP	CICS		;

	POP	AX
	MOV	STATLIN,26
	MOV	BP,25*80	; Characters per screen (Normal...)
	MOV	STLINE,2000	; Status line beginning
	MOV	VPARM[VPL*0][6],25 ; All three non-graphic modes
	MOV	VPARM[VPL*1][6],25
	MOV	VPARM[VPL*3][6],25 

	CMP	IBMEGA,1	; Is the EGA adapter selected
	JE	SV25		; Jump if so

	TEST	AX,080H		; Is this a 26 line setup request?
	JZ	SV25		;

	MOV	STATLIN,26
	MOV	BP,26*80	; Extra characters per screen
	MOV	STLINE,2000	; Status line beginning = sstart + 1920

	MOV	VPARM[VPL*0][6],26 ; Patch 40*25
	MOV	VPARM[VPL*1][6],26 ;       80*25 color modes only

SV25:	MOV	BX,0		; Point to beginning of video tables

	TEST 	AL,060H		; Is this IRMAvision
	JNZ	SIV		;

	AND	AL,7FH		; Remove 26 line bit

SIV:	MOV	CX,VPL		; Length of video parameter table

	MOV	DISLIN,25	; Set number of text lines displayed

	CMP	AL,2		; Check for modes 0,1
	JNC	M2		;
	JMP	M9

M2:	ADD	BX,CX		; Not 40x25 color
	CMP	AL,4		; Check for modes 2,3
	JNC	M3		;
	JMP	M9

M3:	ADD	BX,CX		; Not 80x25 color
	CMP	AL,7		; Check for modes 4,5,6
	JNC	M4		;
	JMP	M9

M4:	ADD	BX,CX		; Not Graphics
	CMP	AL,8		; Check for mode 7 (STD MONOCHROME)
	JNC	IVSTART
	MOV	STATLIN,25
	JMP	M9

IVSTART:
	MOV	BP,26*80	; 80 BY 26 mono display, IRMAvision only
	MOV	STATLIN,26
	MOV	STLINE,2000	; Status line beginning = sstart + 1920
	MOV	COLROW,80       ; Set columns per row
	MOV	VPARM[VPL*3][4],26 ;  IRMAvision mod 2 only
	MOV	VPARM[VPL*3][5], 0 ;  IRMAvision mod 2 only
	MOV	VPARM[VPL*3][6],26 ;  IRMAvision mod 2 only
	MOV	VPARM[VPL*3][7],26 ;  IRMAvision mod 2 only
	CMP	AL,027H		; Check for IRMAvision mod 2
	JNZ	MOD3?
	JMP	M9

                                ; Not IRMAvision mod 2
MOD3?:	MOV	BP,80*34	; Set for Mod 3 IRMAvision display
	MOV	DISLIN,33	; Set number of text lines displayed
	MOV	STATLIN,34
	MOV	STLINE,2640	; Status line beginning
	MOV	VPARM[VPL*3][4],25 ;Not IRMAvision mod 2, change it back
	MOV	VPARM[VPL*3][5], 6 ;Not IRMAvision mod 2, change it back
	MOV	VPARM[VPL*3][6],25 ;Not IRMAvision mod 2, change it back
	MOV	VPARM[VPL*3][7],25 ;Not IRMAvision mod 2, change it back
	ADD	BX,CX		; Not IV mod 2, so point to mod 3
        CMP	AL,067H		; Check for IRMAvision mod 3
	JZ	M9

				; Not IRMAvision mod 3
	MOV	BP,80*45	; Set for Mod 4 IRMAvision display
	MOV	DISLIN,44	; Set number of text lines displayed
	MOV	STATLIN,45
	MOV	STLINE,3520	; Status line beginning
	ADD	BX,CX		; Not mod 3, so point to mod 4
        CMP	AL,0A7H		; Check for IRMAvision mod 4
	JZ	M9

				; Not IRMAvision mod 4
                        	; Set for Mod 5 IRMAvision display
	MOV	BP,4096   	; Clear all IRMAvision display buffer
	MOV	DISLIN,28	; Set number of text lines displayed
	MOV	STATLIN,29
	MOV	STLINE,3644	; Status line beginning
	MOV	COLROW,132      ; Set columns per row
	ADD	BX,CX		; Not IV mod 4, so point to mod 5
        CMP	AL,0E7H		; Check for IRMAvision mod 5
	JZ	M9

	MOV	BP,25*80	; 80 BY 25 display
	MOV	DISLIN,25	; Set number of text lines displayed
	MOV	STATLIN,25
	MOV	STLINE,2000	; Status line beginning = sstart + 1920
	MOV	COLROW,80       ; Set columns per row
	XOR	BX,BX		; RESET BX
	XOR	AX,AX           ; RESET AX

	RET			; NOT ANY OF ABOVE SO RETURN

M9:	PUSH	AX		; Save display mode (AL)
   	MOV	AX,STLINE
	ADD	AX,80
	MOV	BUFEND,AX    	; BUFEND is always STLINE + 80

	XOR	AH,AH		; Register number being updated

	CALL	CSRCALC		; Calculate CTTCUR cursor control table

	MOV	AL,VMODE
	AND	AL,07		; MASK OFF ALL BUT LOWER 3 BITS
	CMP	AL,7		; Is this a monochrome setup
	JNZ	SKIP		; IF not monochrome skip the following

	PUSH	BX
	PUSH	CX
	PUSH	DX

	MOV	AX,STATLIN
	MOV	CX,AX		; Save a copy in cx
	SUB	AX,1
	MOV	BX,COLROW	; Mov colrow into bx
	MUL	BX		; bx*(ax-1)
	ADD	AX,1		;
	MOV	LSADDR,AX	; LSADDR=(STATLIN-1)*COLROW+1
				; Set PC status line start address
	SUB	CX,1  		; Set loop counter needed below

	XOR	BX,BX
	MOV	BSADDR,0 ; Set IRMA buffer status line location
	MOV	AX,COLROW
STUFF:	MOV	AX,BX
	SHR	AX,1		; Divide AX by 2
	MUL 	COLROW  	; ax = bx/2 * colrow
	ADD	BX,2
	MOV	LSADDR[BX],AX	; Set line start address in PC buffer
	ADD	AX,80		; ax= bx/2 * colrow + 80
	MOV	BSADDR[BX],AX

	LOOP 	STUFF

	POP	DX
	POP	CX
	POP	BX

SKIP:	MOV	AX,0
	MOV	SI,0		; Make an index to VPARMs
	
	CMP	SCRNMOD,0	; Is this IRMAvision?
	JNZ	M10 		; Jump if IRMAvision

	CMP	ALTMOD2,1
	JE	MALTM2		; Olivetti  &  AT&T PC
	CMP	ALTMOD1,1
	JE	MALTM1		; Sperry
	CMP	ALTMOD3,1	; Is there a Hercules Graphics Board selected
	JNE	M10		; Jump if not
	JMP	HEALT		; Jump if Hercules selected

M10:	CMP	IBMEGA,1	; Is the IBM EGA attached
	JNE	M101		; Jump if not attached
	JMP	STANEX

M101:	MOV	DX,CRTBASE	; Get address of CRT controller
	MOV	AL,AH		;
	ADD	DX,11		; Point to address 3xF
	OUT	DX,AL		; Output zero
	SUB	DX,11		; Point to CRT controller again

M11:	MOV	AL,AH
     	OUT	DX,AL		; Select register
	INC	DX		; Point to 6845 data register
	INC	AH		; Get ready for next register
	MOV	AL,VPARM[BX][SI]; Get parameter
	OUT	DX,AL		;
	INC	SI		; Point to next parameter
	DEC	DX 		; Point to 6845 index register
	LOOP	M11		; And continue init.

	PUSH	BX
	MOV	DX,CRTBASE	; Get address of CRT controller
	ADD	DX,11		; Point to address 3xF
	MOV	BL,SCRNMOD
	XOR	BH,BH
	MOV 	AL,CMODES2[BX]	; Get value for CRT port 2, for this mod
	OUT	DX,AL		; Output value to 3xF (CRT port 2)
	POP	BX
	JMP	STANEX

MALTM2:	MOV	DX,CRTBASE	; Olivetti & AT&T PC
	MOV	AL,ALTM21[SI]
	OUT	DX,AL		; Select register
	INC	DX		; Point to data register
	MOV	AL,ALTM22[SI]	; Get parameter
	OUT	DX,AL		;
	INC	SI		; Point to next parameter
	LOOP	MALTM2		; And continue init.

	CALL	SAVEALT		; Fix for unusual video mode restoration.
	JMP	STANEX

MALTM1:	CMP	ALTEXIT,0	; see if init in progress,  SPERRY PC
	JE	MALTR4		; yes
; Exit in progress
	MOV	AL,VMODE	; Get original mode
	AND	AL,0FH		;mask off 26 bit indicator
	CMP	AL,0BH
	JE	MALTR8
	CALL	MSPLO		;force original
	JMP	STANEX
MALTR8:	CALL	MSPHI		;on exit, force hi
	JMP	STANEX

; init
MALTR4:	CALL	MSPHI		;set hi
	MOV	AL,VMODE
	AND	AL,87H
	JNE	MALTR5		; 
	JMP	STANEX		; 
MALTR5:				; 
; 26 LINES support
	MOV	DX,CRTBASE	; Get address of CRT controller
	MOV	AL,6		;
	OUT	DX,AL		; Select register
	INC	DX		; Point to data register
	MOV	AL,1AH		; 26 LINES
	OUT	DX,AL		;
	JMP	STANEX		; 

; Additions for Hercules 
HEALT:	CMP	ALTEXIT,0	; are we exiting E78
	JE	HEALT0		; jmp if not

	MOV	AL,HEMOD2	; always switch back when exiting E78
	JMP	SHORT HEALT4	; do the switching

HEALT0:	CALL	HESUB		; find out what mode we are in
	MOV	HEMOD2,AL	; save it

	MOV	AL,020H		; always switch to text mode on entry

HEALT4:	MOV	DX,CRTBASE
	ADD	DX,4
	MOV	SI,0
	MOV	BX,0720H
	CMP	AL,020H		; are we switching to text mode
	JE	HEALT5		; jmp if yes
	MOV	BX,0
	MOV	SI,12
HEALT5:	MOV 	HEMOD,AL	; save video mode
	OUT	DX,AL		; set text/graphics and turn off display
	SUB	DX,4
	PUSH	BX
	MOV	CX,12
HEALT6:	MOV	AL,AH
	OUT	DX,AL
	INC	DX
	INC	AH
	MOV	AL,ALTM31[SI]
	OUT	DX,AL
	INC	SI
	DEC	DX
	LOOP	HEALT6

	MOV	AX,0B000H
	CLD
	MOV	ES,AX
	XOR	DI,DI
	POP	AX
	MOV	CX,02000
	REP	STOSW

 	MOV	AL,HEMOD
 	ADD	DX,4

	CMP	AL,020H		; are we switching to text mode
	JE	HEALT8 		; jmp if yes
	CMP	HEPAGE1,1	; do we want page 1
	JNE	HEALT8		; jmp if not
	MOV	HEPAGE1,0
	OR	AL,080H		; set page 1
HEALT8:	OR	AL,08H		; turn display on
	OUT	DX,AL
 	SUB	DX,4
	POP	AX
 	RET
; end of additions for Hercules 


STANEX:	POP	AX		; Restore mode to AL
	AND	AX,07H		; Mask off everything except lower 3 bits
	MOV	AH,AL		; Make a spare copy.
	PUSH	AX		;

	MOV	DI,0		; Beginning of screen

	CMP	AH,4		; Check for graphics or B&W mode
	JC	M12		; Jump if color character mode
	
	CMP	AH,7		; Is this B&W?
	JNZ	M14		; Jump if not monochrome

	PUSH	AX
	PUSH	DX

	MOV	AL,1
	MOV	DX,CRTBASE	; Get address of CRT controller
	ADD	DX,4		; Point to I/O address 3X8
	OUT	DX,AL 		; Turn screen off while it settles

	POP	DX
	POP	AX

M12:	MOV	CX,BP		; Number of characters on card
	
	MOV	AX,720H		; Fill with normal video spaces

M13A:	STOSB			; Low byte
	XCHG	AH,AL		;
	STOSB			; High byte
	XCHG	AH,AL		;
	LOOP	M13A		; End of this EAGLE patch


	PUSH	AX
	PUSH	CX

	MOV	CX,-1   	; Good number to wait
WAIT:	XOR	AX,AX		; Takes a little time
	LOOP	WAIT		; Wait for screen to settle down


	POP	CX
	POP	AX

M14:	POP	AX		;
	PUSH	BX		;

	MOV	BL,AL		; Make a pointer into modes table
	XOR	BH,BH		;

	MOV	DX,CRTBASE	; Point to the mode register
	ADD	DX,4		;

	CMP	IBMEGA,1	; Is the IBM EGA selected
	JNE	M15		; Jump if NO

	MOV	AH,0		; Use INT 10 rather than direct programming 
	INT	10H		;   of the video registers

	JMP	M151		; Skip over Output instruction

M15:	MOV	AL,CMODES[BX]	; Get current mode
	OUT	DX,AL		;

M151:	POP	BX		; Restore pointer to current VPARM
	MOV	AL,VPARM.VTOTAL[BX]
	CMP	AL,VPARM.VDISP[BX]
	JNAE	M16		; Bogus screen length request

	MOV	AL,VPARM.VDISP[BX]

M16:	RET

SVMODE	ENDP

HESUB	PROC	NEAR
; find out what mode we are leaving, text or graphics
; return in AL
	XOR	AL,AL
	MOV	DX,03BAH
HESUB1:	IN	AL,DX
	TEST	AL,080H
	JZ	HESUB1

HESUB2:	IN	AL,DX
	TEST	AL,080H
	JNZ	HESUB2

	XOR	AL,AL
	MOV	DX,03BBH
	OUT	DX,AL
	MOV	DX,03B9H
	OUT	DX,AL

	MOV	AL,16
	MOV	DX,03B4H
	OUT	DX,AL
	INC	DX
	IN	AL,DX
	MOV	BH,AL

	MOV	AL,17
	DEC	DX
	OUT	DX,AL
	INC	DX
	IN	AL,DX
	MOV	BL,AL

	MOV	AL,020H		; text mode
	CMP	BX,(80*25+45*87)/2
	JB	HESUB3		; jmp if text mode
	MOV	AL,002H		; graphics mode
HESUB3:	RET
HESUB	ENDP


; Fix for PC compatibles that use unusual video modes for graphics.
SAVEALT	PROC
	CMP	ALTVMD,1
	JNE	SAVMEXT
; On entry, save vmode. On exit, restore vmode.
	CMP	ALTEXIT,0	; see if EXIT in progress
	JNE	ALTV04		; yes
; Entry.
	MOV	AH,0FH
	INT	10H		; Get current video mode
	MOV	SAVEMD,AL
	RET
ALTV04:	MOV	AH,00H
	MOV	AL,SAVEMD
	INT	10H		; Set back to current video mode
SAVMEXT: RET
SAVEALT	ENDP


MSPHI	PROC
	MOV	AX,1601H
	INT	10H
	MOV	AX,1500h
	INT	10H
	MOV	AX,0BH
	INT	10H
	RET
MSPHI	ENDP

MSPLO	PROC
	MOV	AX,1600H
	INT	10H
	MOV	AX,1500H
	INT	10H
	MOV	AL,VMODE
	AND	AL,7FH		; Original mode, mask out 26 bit
	MOV	AH,00
	INT	10H
	RET
MSPLO	ENDP


	PAGE
CSRCALC	PROC	NEAR		; Calculate CTTCUR table from VPARM[bx]
	PUSH	AX		; Save the mode et al
	PUSH	DX		;

	CMP	IBMEGAM,1
	JNE	CSRCL1

	MOV	AL,13		; Count of raster lines per cell
	JMP	CSRCL15

CSRCL1:	MOV	AL,VPARM.RASTER[BX] ; Get count of raster lines per cell

CSRCL15:
	CMP	ALTMOD1,1
	JNE	CSRCL2
	CMP	ALTEXIT,0
	JNE	CSRCL2
	MOV	AL,0EH
CSRCL2:	MOV	DL,AL		; Save a copy
	MOV	AH,AL		; Make a copy
	DEC	AH		; One raster line up the screen
	MOV	CTTCUR[0],AX	; Standard underscore cursor

	XOR	AH,AH		; Calculate top line
	MOV	CTTCUR[4],AX	; Full block cursor (Alt cursor)

	SHR	AL,1		; Calculate middle of character cell
 	MOV	CTTCUR[2],AX	; Upper half block (Blinking cursor)

	MOV	AH,AL		; Get middle of cell
	MOV	AL,DL		; Get bottom of cell
	MOV	CTTCUR[6],AX	; Lower half block (Alt Blinking cursor)

	CMP	ERICCRT,1
	JNE	CSREXT
; Ericsson PC cursor fix
	PUSH	BX
	PUSH	CX
	MOV	CX,4
	MOV	BX,OFFSET CTTCUR
CERIC:	MOV	AX,[BX]
	OR	AX,8080H	; Set top bit on to disable cursor recalculate.
	MOV	[BX],AX
	INC	BX
	INC	BX
	LOOP	CERIC
	POP	CX
	POP	BX

; Inhibited cursors (CTTCUR[8-14]) are preinitialized to non-display cursor
; in PUBLICS.

CSREXT:	POP	DX		; Restore used registers
	POP	AX		;
	RET			; And back to the video modes!

CSRCALC	ENDP
	PAGE
	PUBLIC	VIDEOFF
VIDEOFF	PROC	NEAR

	CMP	IBMEGA,1	; Is IBM EGA attached
	JNE	VOFF1

	RET			; Yes then return

VOFF1:	MOV	DX,CRTBASE
	ADD	DX,4		; Point to options register

	MOV	BL,VMODE	; Current video mode
	AND	BL,07H		; Mask off all execpt lower 3 bits
	XOR	BH,BH		; 16 Bit offset 
	
	MOV	AL,CMODES[BX]	; Get crt control mode

 	CMP	ALTMOD3,1	; 
 	JNE	VIDOF1          ; 
	CALL	HESUB		;  get mode
	JMP	SHORT VIDOF2	; 

VIDOF1:	CMP	ALTMOD1,1
	JNE	VIDOF2
	MOV	AL,29H

VIDOF2:	AND	AL,VDOOFF	; Mask out video enable bit
	OUT	DX,AL		;
	RET

VIDEOFF	ENDP

	PUBLIC	VIDEON
VIDEON	PROC	NEAR

	CMP	IBMEGA,1	; Is IBM EGA attached
	JNE	VON1

	RET			; Yes then return

VON1:	MOV	DX,CRTBASE
	ADD	DX,4		

	MOV	BL,VMODE	; Get current video mode
	AND	BL,7H		; Remove all execpt lower 3 bits
	XOR	BH,BH		;

	MOV	AL,CMODES[BX]	; Correct active setting for MODE

 	CMP	ALTMOD3,1	; 
 	JNE	VIDON3		; 
	CALL	HESUB   	;  get mode
	CMP	AL,020H		;  are we switching to text mode
	JE	VIDON2 		;  jmp if yes
	CMP	HEPAGE1,1	;  do we want page 1
	JNE	VIDON2		;  jmp if not
	MOV	HEPAGE1,0       ; 
	OR	AL,080H		;  set page 1
VIDON2:	OR	AL,08H		;  turn on display
	JMP	SHORT VIDON4	; 

VIDON3:	CMP	ALTMOD1,1
	JNE	VIDON4
	MOV	AL,29H
VIDON4:	OUT	DX,AL	
	RET
VIDEON	ENDP

	PAGE
PUTTOC	EQU	100		; Sync timeout constant, ~ 500 uS

	PUBLIC	PUTCH
PUTCH	PROC	NEAR		; Put CHAR/ATTR CX at SCREEN[DI]
	CMP	CX,SIMAGE[DI]	; Is the character already there?
	JNZ	REAL		; No, this is really neccessary.

	ADD	DI,2		; Point to the next place
	RET			; And get out quickly

REAL:	MOV	SIMAGE[DI],CX	; Update the screen image

	CMP	SCRNMOD,5 	; Is this mod 5?
	JZ	PUT132		; If yes, jump

	PUSH	BX		; Make room
	MOV	BX,CX		;

	CMP	EAGLE,0		; See if this is 8086/PC type widget
	JNZ	PUEGL		; Yes, special byte access version req'd

	CMP	SCANCK,0	; Is this a fast monochrome display?
	JZ	PUT10		; Yes, skip the SYNCH stuff

	MOV	DX,CRTBASE	; Get address of CRT control card
	ADD	DX,6		; Point to scan status register

	MOV	AH,1		; A fast constant for TEST in synch loops
	MOV	CX,PUTTOC	; Small timeout constant

	CLI			; Do not disturb

PUT0:	IN	AL,DX		; Get synch status
	TEST	AL,AH		; 
	LOOPNZ	PUT0		; Wait for synch to go low

PUT1:	IN	AL,DX		; 
	TEST	AL,AH		;
	JZ	PUT1		; Wait for synch to go high again

PUT10:	XCHG	AX,BX		; Get AX from CX very fast
	STOSW			; Onto the screen in a hurry

	STI			; Allow interrupts again

	POP	BX		;
	RET			;

PUT132:	TEST	DI,02H    	; Determine odd or even characters
	JNZ	ODD

EVEN:	PUSH	DI
	MOV 	AX,CX		; Get AX from CX

	SHR	DI,1		; Divide address in DI by 2

	STOSW
	STI			; Allow Interrupts again

	POP	DI		; Restore DI

	ADD	DI,2		; Point to next address

	RET

ODD: 	PUSH	DI
	MOV 	AX,CX		; Get AX from CX


	SHR	DI,1		; Divide address in DI by 2
	ADD	DI,4095		; Add 4095 for odd location on screen

	STOSW
	STI			; Allow Interrupts again

	POP	DI		; Restore DI

	ADD	DI,2		; Point to next address

	RET




				; Special code for EAGLE 1600 and similar
				; 8086 PC look similars which cannot do
				; WORD accesses to devices on I/O channel
				; ALWAYS wait for HSYNC before update!

PUEGL:	MOV	DX,CRTBASE	; Get address of CRT control card
	ADD	DX,6		; Point to scan status register

	MOV	AH,1		; A fast constant for TEST in synch loops
	MOV	CX,PUTTOC	; Small time constant

	PUSH	BX		; Save the character's attribute for next

	CMP	SCANCK,0	; Is fast write permitted?
	JZ	EUT10		; Yes, no scan check req'd.

	CLI			; Do not disturb

EUT0:	IN	AL,DX		; Get synch status
	TEST	AL,AH		; 
	LOOPNZ	EUT0		; Wait for synch to go low

EUT1:	IN	AL,DX		; 
	TEST	AL,AH		;
	JZ	EUT1		; Wait for synch to go high again

EUT10:	XCHG	AX,BX		; Get AX from CX very fast
	STOSB			; Onto the screen in a hurry LOW BYTE

	STI			; Allow interrupts again

	POP	BX		; Restore character & attribute
	XCHG	BL,BH		; Put attribute in low place

	CMP	SCANCK,0	; See if fast write is permitted
	JZ	FUT10		; Yes, permission granted, skip SYNC

	MOV	AH,1		; Horizontal synch flag in quick place
	MOV	CX,PUTTOC	; Same small time constant

	CLI			; Do not disturb

FUT0:	IN	AL,DX		; Get synch status
	TEST	AL,AH		; 
	LOOPNZ	FUT0		; Wait for synch to go low

FUT1:	IN	AL,DX		; 
	TEST	AL,AH		;
	JZ	FUT1		; Wait for synch to go high again

FUT10:	XCHG	AX,CX		; Get AX from CX very fast
	STOSB			; Onto the screen in a hurry LOW BYTE

	STI			; Allow interrupts again

	POP	BX		;
	RET			;

PUTCH	ENDP
	PAGE
	PUBLIC	LPENCHK		; Check light pen status
LPENCHK	PROC	NEAR		; Set carry if light pen detect
	MOV	DX,CRTBASE	; Test LPEN status
	ADD	DX,6		; Point to status register
	IN	AL,DX		; Get the status

	TEST	AL,4		; Light pen pick bit (AND CLEAR CARRY!)
	JNZ	LPXRS		; Light pen exit w/ reset

	TEST	AL,2		; Scan trigger bit (AND CLEAR CARRY!)
	JZ	LPX		; Light pen exit general since no reset needed

	MOV	DX,CRTBASE	; Select CRT controller LPEN address
	MOV	AH,16		; High byte
	MOV	AL,AH		;

	OUT	DX,AL		; Select
	INC	DX		;
	IN	AL,DX		; Fetch
	MOV	CH,AL		; Save

	INC	AH		; Low byte
	DEC	DX		; Point back to address register
	MOV	AL,AH		;

	OUT	DX,AL		; Select
	INC	DX		;
	IN	AL,DX		; Fetch
	MOV	CL,AL		; Save	CX contains LPEN scan address

	MOV	BL,VMODE	; Get current video mode
	AND	BL,07H		; Remove all execpt lower 3 bits
	XOR	BH,BH		; Make complete byte offset
	
	SUB	CL,LPOFS[BX]	; Remove lightpen offset
	SBB	CH,0		; Borrow if neccessary from high byte

	STC			; Set success flag

LPXRS:	PUSHF			; Reset the LPEN trigger
	MOV	DX,CRTBASE	;
	ADD	DX,7		;
	OUT	DX,AL		; Output anything to satisfy the beast.
	POPF			;

LPX:	RET			; Back.

LPENCHK	ENDP

CODE	ENDS

	END
