/*
 * Library NMAPI, Module NM_NODE.H
 *
 * Copyright (C) 1992 All Rights Reserved, by
 * Digital Equipment Corporation, Maynard, Mass.
 *
 * IDENT HISTORY:
 *
 *  28-OCt-1992 CLB     Created separate Node header from NM_API.H
 *  02-Nov-1992 CLB     Changed WORD to short, etc;.
 *  18-Nov-1992 CLB     Due to size, break out load file to PWLOAD.DAT
 *  15-Dec-1992 CLB     Update osi address structure in pw_addr_rec
 *                      Change tcp_addr to unsigned long
 *  23-Jan-1993 CLB     Removed software ID
 */

#ifndef NM_NODE_H
#define NM_NODE_H

#define PWNODE_FNAME    "PWNODE.DAT"
#define PWLOAD_FNAME    "PWLOAD.DAT"

/*******************************/
/*  Local node file            */
/*******************************/

/*
 *  Node name record - variable length (4 bytes + 6-256 byte name)
 *      Phase IV DECnet     1-6 bytes
 *      OSI                 1-256 bytes
 *      TCP/IP              1-256 bytes
 */
#define MAX_NODENAME_SIZE   255

typedef struct pw_name_rec
{
    unsigned short flags;   /*  0x0100 - Version 1 name record */
    short  maxlen;          /*  Max name that can use this string */
    short  len;	            /*  strlen(nodename)+1  */
    unsigned char name[MAX_NODENAME_SIZE+1];
} PW_NAME_REC;

/* Node record types */
#define DNET_ADDR	0x0001
#define TCP_ADDR	0x0002
#define OSI_ADDR	0x0004
#define ETHER_ADDR	0x0008
#define PW_SERVER       0x0010
#define PW_MSNET        0x0020
#define PW_LAT          0x0040

#define NM_DNET_AREA    0xFC00     /* area is high order 6 bits */
#define NM_DNET_NODE    0x03FF     /* node number is low order 10 bits */

/************************************************************************/
/*  Node Address record - 48 bytes                                      */
/*      sorted in ascending order by name (use pname to get name string */
/************************************************************************/
typedef struct pw_addr_rec
{
    unsigned short flags;   /* 0x0001 - DECnet */
                            /* 0x0002 - TCP/IP */
                            /* 0x0004 - OSI */
                            /* 0x0008 - Ethernet */
                            /* 0x0010 - Server name */
                            /* 0x0020 - MSNET */
                            /* 0x8000 - DELETED RECORD */
    unsigned short dnet_addr;      /* DECnet address */
    unsigned char ether_addr[ETHER_ADDR_SIZE];  /* Non-DECnet (Terminal servers, etc) */
    unsigned long tcp_addr;      /* TCP/IP address */
    struct
    {
        short len;
        unsigned char addr[OSI_ADDR_SIZE];      /* OSI address */
    }osi;
    long pname;     /* Offset to node name string in node string area */
    long pacc;      /* Offset to outgoing access rec in access area */
                    /*  -1L = no access info */
    long pload;     /* Offset into load/dump file */
                    /*  -1L = no load/dump info */
} PW_ADDR_REC;

/****************************************/
/*  Outgoing access record - 122 bytes  */
/****************************************/
typedef struct pw_acc_rec
{
    unsigned short flags;           /* 0x0100 - Version 1 access record */
    unsigned char user[ACCESS_SIZE+1];
    unsigned char account[ACCESS_SIZE+1];
    unsigned char password[ACCESS_SIZE+1];
} PW_ACC_REC;

/***********************************************/
/*  Entry in LOAD/DUMP database - PWLOAD.DAT  */
/***********************************************/
#define PASSWORD_SIZE   16
#define DNET_FSIZE      255

typedef struct pw_load_rec
{
    unsigned short  flags;                    /* 0x0100- Version 1 load record */
    unsigned char service_pass[PASSWORD_SIZE+1]; /* 111 Service password */
    unsigned char service_dev;              /* 112 Line controller of target */
    unsigned char sysload[DNET_FSIZE+1];    /* 120 System load file */
    unsigned char secload[DNET_FSIZE+1];    /* 121 Secondary load file */
    unsigned char terload[DNET_FSIZE+1];    /* 122 Tertiary load file */
    unsigned char mgmtfile[DNET_FSIZE+1];   /* 123 Management file */
    unsigned char scriptfile[DNET_FSIZE+1]; /* 123 Script file */
    unsigned char diagfile[DNET_FSIZE+1];   /* 123 Diagnostic file */
    unsigned char dumpfile[DNET_FSIZE+1];   /* 130 Dump file */
    unsigned char host_name[DNET_NAME_SIZE+1];
    unsigned short  host_addr;                /* 140 Host node address */
} PW_LOAD_REC;

#endif  /* NM_NODE_H */
