//---------------------------------------------------------------------------
//
//    DIGITAL hereby grants any authorized developer using the PATHWORKS SDK 
//    ("Developer"), a royalty-free, non-exclusive license to use any of 
//    DIGITAL's source code supplied with the PATHWORKS SDK to create binaries 
//    which the developer may then copy and merge with the developers software 
//    for distribution to its customers.  DIGITAL is not liable for any 
//    damages caused by any errors in the source code provided with the SDK.
//
//---------------------------------------------------------------------------

#include <conio.h>
#include <stdio.h>
#include <stdlib.h>

#define WIN32_LEAN_AND_MEAN TRUE
    /* kick out conflicts between winsock.h & iocb.h */
    /* Could use #define _WINSOCKAPI_ instead.  */
#include <windows.h>
#include <winerror.h>  // WIN32 defined errors
#include <errno.h>

#include "iocb_32.h"

VOID   dnp32(VOID);          /* subroutine for making DNP calls */
VOID   dscb32(VOID);         /* subroutine for making DNP DSCB calls */
VOID   lat32(VOID);          /* subroutine for making LAT calls */
HANDLE spawn_thread(VOID);   /* start a second thread */
VOID   cleanup(VOID);        /* cancel second thread */

void main(argc,argv)
int argc;
char *argv[];
{
    DWORD rc;
    HANDLE hthread;
    SYSTEM_INFO si;
    LPSYSTEM_INFO lpsi = &si;
    
    printf("WIN32 IOCB Interface Sample Tester V1.0.006\n\n");
    Sleep(1000);
    
    rc = GetVersion();
    printf("    Win32 Version: %u.%u, Win32 Platform: %Xh\n",
                LOBYTE(LOWORD(rc)),HIBYTE(LOWORD(rc)),HIWORD(rc));
    GetSystemInfo(lpsi);
    printf("    Min Win32 Address: %Xh, Max Win32 Address: %Xh\n\n",
                si.lpMinimumApplicationAddress,
                si.lpMaximumApplicationAddress);
    Sleep(1000);
    
    if (rc = IocbInstallCheck(DECnet_Check))
        printf("DECnet Install Check failed, error: %u\n",rc);
    else
    {
        printf("DECnet is Installed.\n");
        dnp32();
        dscb32();
    }
    printf("\n");
    Sleep(2500); 
    
    if (rc = IocbInstallCheck(LAT_Check))
        printf("LAT Install Check failed, error: %u\n",rc);
    else
    {
        printf("LAT is Installed.\n");
        lat32();
    }
    Sleep(2000);
    
    if (!(hthread = spawn_thread()))  // Start up a 2nd thread to test events
        exit(1);
    Sleep(3000);   // Sleep 3 seconds
    printf("               Hit any key to terminate network I/O wait\n");
    printf("               or send DTS command to this node.\n");
    while(!_kbhit())
    {
        if (GetExitCodeThread(hthread,&rc) && rc != STILL_ACTIVE)
            break;
        Sleep(250);
    }
    cleanup();  // for events
    exit(0);
}

/* 
   This program can terminate in one of two ways:
   1) DTS.EXE attempts to connect to this node for a test which
      is immediately disconnected because we are not DTR.
   2) User hits any key to terminate wait for DTS request.
   
   The purpose of the ACCEPT/DISCONNECT IOCB functions in event32.c
   is to demonstrate and validate the working of Win32 Events for a
   Win32 application.
*/
