2!		PROGRAM		: FLINT.BAS
5!		VERSION		: V10.1
6!		EDIT		: A
7!		EDIT DATE	: 10-MAY-91
10	EXTEND
11	! &
	&
	&
	!		  C O P Y R I G H T &
	&
	&
  !		      Copyright (C) 1976, 1991 by &
  !	        Digital Equipment Corporation, Maynard, Mass. &
  !	&
  !	&
  !	This software is furnished under a license and may be used and &
  !	copied  only  in accordance with the terms of such license and &
  !	with the  inclusion  of  the  above  copyright  notice.   This &
  !	software  or  any  other copies thereof may not be provided or &
  !	otherwise made available to any other person.  No title to and &
  !	ownership of the software is hereby transferred. &
  !	&
  !	The information in this software is subject to change  without &
  !	notice  and should not be construed as a commitment by Digital &
  !	Equipment Corporation. &
  !	&
  !	DIGITAL assumes no responsibility for the use  or  reliability &
  !	of its software on equipment that is not supplied by DIGITAL. &
  !	&
  !******************************************************************* &
	&

20	! &
	&
	&
	!	M O D I F I C A T I O N    H I S T O R Y &
	&
	&

21	! VER/ED	EDIT DATE	REASON &
	! &
	&

100	! &
	&
	&
	!	G E N E R A L    D E S C R I P T I O N &
	&
	&

110!	FLINT ENABLES THE USER TO GET DIRECTORIES OF &
   !	IBM FLOPPIES, TRANSFER IBM DATA SETS TO RSTS DISK &
   !	FILES AND TRANSFER RSTS DISK FILES TO IBM &
   !	DATA SETS.
300	! &
	&
	&
	!	I / O    C H A N N E L S &
	&
	&

301!	CHANNEL #		USED FOR &
   !
310!	    1			KB INPUT &
   ! 	    2			DIRECTORY OUTPUT &

400	! &
	&
	&
	!	V A R I A B L E    D E F I N I T I O N S &
	&
	&

401!	VARIABLE NAME		USED FOR &
   !
410!	ASCEBC$			ASCII TO EBCDIC TABLE &
   !	E$,E%,E0$		ERROR VARIABLES &
   !	EBCASC$			EBCDIC TO ASCII TABLE
420!	L$(0%)			LABEL ID (HDR1) &
   !	L$(1%)			DATA SET NAME (1-8 CHAR.) &
   !	L$(2%)			BLOCK/RECORD LENGTH (1-128) &
   !	L$(3%)			BEGINNING OF EXTENT (BOE) &
   !	L$(4%)			END OF EXTENT (EOE) &
   !	L$(5%)			BYPASS INDICATOR &
   !	L$(6%)			MULTI-VOLUME INDICATOR &
   !	L$(7%)			VOLUME SEQUENCE # &
   !	L$(8%)			END OF DATA (EOD) &

800	! &
	&
	&
	!	S U B R O U T I N E S / F U N C T I O N S &
	!	      D E S C R I P T I O N S &
	&
	&

801!	SUBROUTINE/FUNCTION		USE &
   !
810!	LINE 10010		SET UP EBCDIC TO ASCII CONVERSION TABLE &
   !	LINE 10100		SET UP ASCII TO EBCDIC CONVERSION TABLE &
   !	LINE 10400		CHECK FOR BAD FLOPPY TRACKS &
   !	LINE 10450		TRANSLATE FLOPPY HEADER INFO &
   !	LINE 10560		UPDATE HEADER INFO &
   !	LINE 10610		PRINT DIRECTORY INFO &
   !	LINE 10650		FIND ROOM FOR DATA SET &
   !	LINE 13000		ERROR PRINTING
830!	FNASC.EBC$		TRANSLATE ASCII STRING TO EBCDIC &
   !	FNC%			SEE IF USER WANTS TO CONTINUE &
   !	FNEBC.ASC$		TRANSLATE EBCDIC STRING TO ASCII &
   !	FNE5$			GET ERROR MESSAGE TEXT &
   !	FNI$			VERIFY INPUT (FLOPPY) SPEC(S) &
   !	FNO%			VERIFY OUTPUT (RSTS) SPEC &
   !	FNS0$			USED WITH TABLE SET UP &
   !	FNS2%			SEARCH FOR A DSN &
   !	FNT$			USED WITH TABLE SET UP &
   !	FNT%			CONVERT TT0SS &
   !	FNU$			FLAG UNEXPECTED ERROR TO RECORD # &
   !	FNT2$			CONVERT RECORD # TO TT0SS &
   !	FNY%			GET YES OR NO RESONSE &

900	! &
	&
	&
	!	D I M E N S I O N    S T A T E M E N T S &
	&
	&

905	DIM B$(1%) &
		! USED FOR SAVING BAD TRACKS &

910	DIM S%(30%) &
		! USED FOR TEMPORARY STORAGE & ACCOUNTING INFO &

920	DIM L$(8%),D$(26%) &
		! L$()	USED FOR DIRECTORY INFO &
		! D$()	USED BY FNFOPN FUNCTION &
	&
	&

999	! &
	&
	&
	!	M A I N    C O D I N G &
	&
	&

1000	ON ERROR GOTO 19000 &
	\ PRINT IF CCPOS(0%)<>0% &
		! SET UP STANDARD ERROR TRAP;RETURN KB TO LEFT MARGIN &

1010	I$="V10.1-A" &
		! SET UP V/E &

1020	PRINT "FLINT	"+I$+CHR$(9%)+FNE5$(0%) IF E0%=0% &
		! SET UP SYSTEM HEADER &
		! PRINT IF RUN ENTRY OR CCL WITHOUT SPECIFIC COMMAND &

1030	PROJ%=SWAP%(CVT$%(MID(SYS(CHR$(6%)+CHR$(14%)+STRING$(6%,0%)+CHR$(1%)) &
	,7%,2%))) &
	\ PROJ%=SWAP%(PROJ%) AND 255% &
	\ OPEN "KB:FLINT.CMD" AS FILE 1% &
	\ CRLF$=CHR$(13%)+CHR$(10%) &
	\ GOTO 1050 IF E0%=1% &
		! SAVE PROJ #, OPEN KB FOR MESSAGES &
		! SET UP CARRIAGE RETURN - LINE FEED STRING &
		! SKIP PROMPT IF NECESSARY &

1040	C0%=1% &
	\ DSN$="" &
	\ T$="#" &
	\ GOSUB 14000 &
		! PRINT PROMPT (NO ?), GET COMMAND &

1050	C0%,E%=0% &
	\ C0$=C$ &
	\ C0$=RIGHT(C0$,2%) IF ASCII(C0$)=47% &
	\ RESTORE &
	\ READ I$ UNTIL I$="*COMMANDS" &
		! CLEAR ERROR FLAG &
		! STRIP OFF /,SAVING ORIGINAL COMMAND IN CASE OF ILLEGALITY &
		! INIT READING &

1060	READ I$,I% &
	\ GOTO 1080 IF I$="" &
	\ GOTO 1060 IF LEFT(I$,3%)<>LEFT(C0$,3%) &
	\ GOTO 1080 IF LEFT(I$,LEN(C0$))<>C0$ &
	\ ON I% GOTO 2500,3000,5000,6000 &
		!     DIR, TOI, TOR, ZER, &
		!		     ERA &
		! &
		! &
		! MINIMUM MATCH IS 3 CHAR AND THE REST, IF ANY, MUST BE LEGAL &

1070	GOTO 1040 IF E0%=0% &
	\ GOTO 32767 &
		! CONTINUE IF RUN OR CCL WITHOUT COMMAND &
		! OTHERWISE, EXIT &

1080	E%=512%+64% &
	\ E$=C$ &
	\ GOSUB 13000 &
	\ GOTO 1070 &
		! ILLEGAL COMMAND &

1090	DATA	"*COMMANDS"
1100	DATA	DIRECTORY,1,	TOIBM,2,	TORSTS,3, &
		ZERO,4,	ERASE,4,	"",0 &

2500	! &
	&
	&
	!	D I R E C T O R Y    L I S T I N G &
	&
	&

2510	T$="Output to" &
	\ GOSUB 14000 &
	\ RETRY%,DIR.CH%=1% &
	\ GOTO 2530 IF C$="" &
		! SET RETRY FLAG, OUTPUT FILE # &
		! GET OUTPUT SPEC (NULL=KB:) &

2520	IF FNO%(C$)=0% THEN &
		2660 &
	ELSE	ON ERROR GOTO 2650 &
	\	DIR.CH%=2% &
	\	OPEN C$ FOR OUTPUT AS FILE DIR.CH% &
		! CHECK OUTPUT SPEC FOR ILLEGALITIES OPEN FILE. &

2530	T$="Directory of" &
	\ GOSUB 14000 &
	\ RETRY%=2% &
	\ DSN.ALW%=-1% &
	\ UNIT.STR$=FNI$(C$) &
	\ GOTO 2660 IF E%>0% &
		! GET INPUT SPEC, RESET RETRY FLAG AND DATA SET NAME &
		! ILLEGAL FLAG. &
		! VERIFY SPEC - DSN ILLEGAL &
		! GOTO ERROR ROUTINE IF NECESSARY &

2540	ON ERROR GOTO 2650 &
	\ FOR I0%=1% STEP 1% UNTIL I0%>LEN(UNIT.STR$) &
	\	I2$="DX"+MID(UNIT.STR$,I0%,1%)+":" &
	\	DS.CNT%=0% &
	\	OPEN I2$ AS FILE 4%,RECORDSIZE 128%+1%+32767%, MODE 16384% &
	\	GET #4%, RECORD 4% &
	\	GOSUB 10410 &
	\	GOTO 2660 IF E%>0% &
	\	FOR DSL%=7% TO 25% &
	\		GET #4%,RECORD DSL% &
	\		GOSUB 10450 &
	\		GOSUB 10540
2590		NEXT DSL% &
	\	S$="s" &
	\	S$="" IF DS.CNT%=1% &
	\	PRINT #DIR.CH%,CRLF$;"Total of";DS.CNT%;"Data Set";S$; &
		" on ";I2$;CRLF$ &
		! GET NEXT SPEC. &
		! SET DATA SET COUNTER. &
		! ACCESS FLOPPY. &
		! LET THE USER KNOW IF THERE ARE ANY BAD TRACKS. &
		! ONLY ERROR (FATAL) IS NO 'ERMAP' FIELD. &
		! PLOW THROUGH 19 DATA SETS, LISTING ONLY NON-DELETED ONES. &
		! PRINT THE TOTALS FOR THIS FLOPPY. &

2610	NEXT I0% &
		! DO THE ABOVE FOR ALL FLOPPIES &

2620	PRINT #DIR.CH% FOR I%=1% TO 3% &
	\ CLOSE 2%,3%,4% &
	\ M$=SYS(CHR$(6%)+CHR$(-21%)+CHR$(0%)) &
		! CLOSE FILES, RECOVER PRIVILEGES &

2630	ON ERROR GOTO 19000 &
		! RESET ERROR TRAP &

2640	GOTO 1070 &
		! CONTINUE &

2650	RESUME 2590 IF ERR=50% &
	\ E%=ERR &
	\ E$=I2$ &
	\ E$=C$ IF ERL<2530% &
	\ E%=E%+512% IF ERL=2520% &
	\ RESUME 2660 &
		! CATCH DATA FORMAT ERRORS (50) IF A 'GET' ENCOUNTERS A &
		! DELETED DATA MARK. &
		! A RETRY IS PERMITTED ON AN OUTPUT OPEN ERROR AS WELL &
		! AS INPUT SPECIFICATION ERRORS. &

2660	GOSUB 13000 &
	\ IF E%>0% THEN 2620 &
		ELSE ON RETRY% GOTO 2500,2530 &
		! PRINT ERROR MSG, EXIT IF NON-RECOVERABLE/RETRIABLE &
		! ELSE REPEAT PROPER ? &
	&

3000	! &
	&
	&
	!	R S T S    T O    I B M &
	&
	&

3010	VOL%,IBM.WR%,DSN.ALW%=0% &
	\ LGCL.PTR%,RETRY%=1% &
	\ T$="Output to" &
		! CLEAR VOLUME COUNTER; &
		! SET DSN ALLOWED/FORBIDDEN FLAG TO "ALLOWED"; &
		! CLEAR IBM RECORDS WRITTEN COUNTER; &
		! SET RETRY POINTER; &
		! SET RSTS LOGICAL RECORD POINTER TO INDICATE THE &
		! BEGINNING OF A PHYSICAL RECORD. &

3020	GOSUB 14050 &
	\ UNIT.STR$=FNI$(C$) &
	\ GOTO 3290 IF E%>0% &
	\ IF VOL%=0% THEN &
		DSN$="RSTS    " IF DSN$="" &
	\	DSN$=DSN$+" " UNTIL LEN(DSN$)=8% &
		! VERIFY OUTPUT SPEC &
		! SET UP DEFAULT DSN OF LENGTH 8. &
	&

3030	FOR O0%=1% TO LEN(UNIT.STR$) &
	\	ON ERROR GOTO 3280 &
	\	I2$="DX"+MID(UNIT.STR$,O0%,1%)+":" &
	\	GOTO 3280 IF FNFOPN%(I2$) &
	\	ON ERROR GOTO 3280 &
	\	GET #4%, RECORD 4% &
	\	GOSUB 10410 &
	\	GOTO 3290 IF E%>0% &
	\	GOTO 3240 IF FNC%("CONTINUE")=0% IF BAD.TRKS%>0% &
	\	GOTO 3120 IF VOL%>0% &
		! ACCESS THE NEXT OUTPUT FLOPPY. &
		! CHECK THE INDEX TRACK FOR BAD TRACKS - IF THERE ARE ANY, &
		! ALLOW THE USER TO CONTINUE OR GET OUT. &
		! IF WE'RE PAST THE 1ST VOLUME, SKIP THE TRANSLATE ?. &

3060		T$="Translate from ASCII to EBCDIC <Yes>" &
	\	GOSUB 14000 &
	\	TRANS%=FNY%(C$,"Y") &
	\	GOTO 3060 IF TRANS%<0% &
		! SEE IF TRANSLATION IS DESIRED - RESPONSE MUST BE &
		! YES, NO OR NULL &

3080		MVI$=" " &
	\	RETRY%=2% &
	\	T$="Input from" &
	\	GOSUB 14000 &
	\	GOTO 3080 IF C$="" &
	\	GOTO 3290 IF FNO%(C$)=0% &
	\	ON ERROR GOTO 3280 &
	\	OPEN C$ FOR INPUT AS FILE 2% &
		! SET THE FLOPPY CONTINUATION VOLUME FLAG &
		! SET THE RETRY FLAG &
		! GET AND VERIFY THE FILE SPEC AND TRY TO OPEN THE FILE &

3090		T$="Record Length <128>" &
	\	GOSUB 14000 &
	\	ON ERROR GOTO 3270 &
	\	IF C$="" THEN &
			IBM.RCD.LGT%=128% &
		ELSE	IBM.RCD.LGT%=VAL(C$) &
	\		GOTO 3090 IF IBM.RCD.LGT%<1% OR IBM.RCD.LGT%>128% &
		! GET BRL &
		! REPEAT ? IF ILLEGAL RESPONSE OR VAL() ERROR. &

3100		BLK.FCT%=512%/IBM.RCD.LGT% &
	\	PRINT CRLF$;"1 RSTS Record =";BLK.FCT%;"IBM Records" &
	\	RSTS.RD%=1% &
	\	R$=NUM1$(IBM.RCD.LGT%) &
	\	R$="0"+R$ UNTIL LEN(R$)=3% &
		! GET/PRINT THE BLOCKING FACTOR. &
		! SET RSTS RECORD COUNTER (RSTS.RD%). &
		! GET 3-CHAR RECORD LENGTH FOR LATER. &

3120		GOSUB 10570 &
	\	GOTO 3290 IF E%>0% &
	\	BOE%=FNT%(L$(3%)) &
	\	EOE%=FNT%(L$(4%)) &
	\	J%=BOE% &
	\	ON ERROR GOTO 3300 &
	\	WHILE J%<=(EOE%+1%) &
	\		GET #2%,RECORD RSTS.RD% &
	\		GOTO 3210 IF J%=(EOE%+1%) &
	\		FOR RSTS.LGCL.TRN%=LGCL.PTR% TO BLK.FCT% &
	\			FIELD #2%, &
				(RSTS.LGCL.TRN%-1%)*IBM.RCD.LGT% AS D0$, &
				IBM.RCD.LGT% AS INP$ &
	\			INP$=FNASC.EBC$(INP$) IF TRANS%=1% &
	\			FLP.INP$=INP$ &
	\			IO%=1% AND (J%<(EOE%-26%) AND J%>(BOE%+26%)) &
	\			GOTO 3300 IF FNFLPWT%(J%,IO%) &
	\			ON ERROR GOTO 3300 &
	\			J%=J%+1% &
	\			IBM.WR%=IBM.WR%+1% &
	\			GOTO 3205 IF J%=(EOE%+1%) &
					UNLESS RSTS.LGCL.TRN%=BLK.FCT% &
	\		NEXT RSTS.LGCL.TRN% &
	\	LGCL.PTR%=1% &
	\	RSTS.RD%=RSTS.RD%+1% &
	\	NEXT &
		! TRY TO FIND A SPOT FOR THE DATA SET. &
		! FIND ALLOWABLE FLOPPY RECORD RANGE - WILL TRANSFER &
		! RECORDS UNTIL WE HIT THE FIRST RECORD NUMBER PAST &
		! THE EOE. &
		! &
		! GET A RSTS RECORD, WHICH MUST BE DIVIDED/DUMPED &
		! INTO BLK.FCT IBM RECORDS - NOTE THIS IS DONE BEFORE &
		! RECORD # CHECK IN CASE WE HIT THE EOF ON THE RSTS FILE. &
		! &
		! LGCL.PTR% INDICATES IF WE HAD TO DIVIDE ACROSS VOLUMES &
		! (IF >1, WE HIT THE END OF A FLOPPY BEFORE TRANSFERRING &
		! ALL OF THE LOGICAL RECORDS; RESET TO 1 AFTER &
		! COMPLETE PHYSICAL RECORD TRANSFER0. &
		! &
		! KEEP TRACK OF RECORDS READ/WRITTEN: &
		!	RSTS.RD%-1%	RSTS RECORDS READ (AND TOTALLY &
		!			TAKEN CARE OF) &
		!	IBM.WR%		IBM RECORDS WRITTEN &

3180		GOSUB 10480 &
	\	S$="" &
	\	S$="s" IF VOL%>1% &
	\	PRINT CRLF$;"Exchange Completed";CRLF$; &
		DSN$;" Resides on";VOL%;"Diskette";S$;CRLF$; &
		RSTS.RD%-1%;" RSTS Records Read";CRLF$; &
		IBM.WR%;" IBM Records Written" &
	\	GOTO 3240 &
		! GIVE THE USER SOME STATS. &
		! TRANSFER COMPLETE - GET OUT. &

3205		LGCL.PTR%=RSTS.LGCL.TRN%+1% &
		! WE'VE FILLED A FLOPPY BUT HAVE MORE DATA. &
		! POINT TO THE NEXT UNTRANSFERRED LOGICAL RSTS RECORD. &

3210		MVI$="C" &
	\	GOSUB 10480 &
	\	MVI$="L" &
	\	CLOSE 3%,4% &
	\ NEXT O0% &
	\ DSN.ALW%=-1% &
	\ RETRY%=3% &
	\ T$="Volume #"+NUM$(VOL%+1%) &
	\ GOTO 3020 &
		! UPDATE APPROPRIATE HEADERS. &
		! IF ALL SPECIFIED OUTPUT VOLUMES HAVE BEEN EXHAUSTED. &
		! GET MORE OUTPUT SPECS, PROHIBITTING A NEW DATA SET NAME. &

3240	ON ERROR GOTO 19000 &
		! RESET ERROR TRAP &

3250	CLOSE 2%,3%,4% &
	\ M$=SYS(CHR$(6%)+CHR$(-21%)+CHR$(0%)) &
	\ GOTO 1070 &
		! REGAIN PRIVILEGES,CONTINUE &

3270	RESUME 3090 &
		! TRAP VAL() ERROR &

3280	E%=ERR &
	\ E%=E%+512% IF E%=5% AND ERL=3080% &
	\ RESUME 3290 &
		! CATCH ALL ERRORS, FLAG OPEN ERROR &

3290	GOSUB 13000 &
	\ IF E%>0% THEN &
		3240 &
	ELSE	ON RETRY% GOTO 3000,3080,3020 &
		! PRINT ERROR &
		! REPEAT PROPER ? IF POSSIBLE: &
		! 1. ERROR ON VERY FIRST OUTPUT STRING &
		! 2. RSTS FILE SPEC ERROR &
		! 3. ERROR ON OUTPUT STRING &

3300	RESUME 3180 IF ERR=11% AND ERL=3120% &
	\ E%=ERR &
	\ PRINT "?Transfer Aborted" IF ERR=14% AND &
				(ERL=16300% OR ERL=16210% OR ERL=16220) &
	\ RESUME 3240 &

5000	! &
	&
	&
	!	I B M    T O    R S T S &
	&
	&

5010	ON ERROR GOTO 19000 &
	\ RETRY%=1% &
	\ T$="Output to" &
	\ GOSUB 14000 &
	\ GOTO 5010 IF C$="" &
	\ NH%=INSTR(1%,C$,"/NH") &
	\ GOTO 5010 IF NH%<LEN(C$)-2% IF NH% &
	\ C$=LEFT(C$,NH%-1%) IF NH% &
	\ GOTO 5310 IF FNO%(C$)=0% &
	\ ON ERROR GOTO 5300 &
	\ OPEN C$ FOR OUTPUT AS FILE 2% &
		! ASSURE THAT ERROR TRAP IS PROPERLY SET. &
		! SET RETRY FLAG. &
		! VERIFY OUTPUT SPEC, OPEN FILE &

5030	T$="Translate from EBCDIC to ASCII <Yes>" &
	\ GOSUB 14000 &
	\ TRANS%=FNY%(C$,"Y") &
	\ GOTO 5030 IF TRANS%<0% &
		! ONLY LEGAL RESPONSES ARE Y[E[S]],N[O] OR NULL(=Y) &
		!            TRANS%=          1       0       1 &

5040	RETRY%=2% &
	\ DSN.ALW%,VOL%,VOL.SEQ.CHK%,RSTS.LGCL.WR%,IBM.RD%=0% &
	\ RSTS.WR%=1% &
	\ T$="Input from" &
		! SET RETRY FLAG, &
		! SET DSN FLAG, VOLUME COUNTER, VOLUME SEQUENCE &
		! CHECKING FLAG, INPUT (FLOPPY) RECORDS READ FLAG, &
		! OUTPUT (RSTS DISK) RECORDS WRITTEN FLAG &
		! AND LOGICAL RECORDS (INCLUDING HEADER) FLAG &

5050	GOSUB 14050 &
	\ UNIT.STR$=FNI$(C$) &
	\ GOTO 5310 IF E%>0% &
	\ FOR I0%=1% TO LEN(UNIT.STR$) &
	\	I2$="DX"+MID(UNIT.STR$,I0%,1%)+":" &
	\	PRINT CRLF$;I2$ &
	\	ON ERROR GOTO 5290 &
	\	CLOSE 3%,4% &
	\	GOTO 5290 IF FNFOPN%(I2$) &
	\	ON ERROR GOTO 5290 &
	\	GET #4%, RECORD 4% &
	\	GOSUB 10410 &
	\	GOTO 5310 IF E%>0% &
	\	GOTO 5320 IF FNS2%=0% &
	\	IF L$(3%)=L$(8%) THEN &
			E%=213% &
	\		GOTO 5310 &
		! GET AND VERIFY THE INPUT SPEC(S). &
		! FOR EACH OUTPUT DEVICE: &
		!	LET THE USER KNOW WHICH FLOPPY WE'LL BE &
		!	WORKING ON NEXT. &
		!	SET ERROR TRAP AND TRY TO ACCESS THE FLOPPY. &
		!	CHECK THE INDEX TRACK FOR BAD TRACKS. &
		!	FATAL ERROR IF NO 'ERMAP' FIELD. &
		!	ASSURE THAT THE DESIRED DSN'S ON THE FLOPPY. &
		!	IF BOE=EOD THEN &
		!		FILE HAS LENGTH 0, DON'T TRANSFER &
	&

5110		IF VOL%=0% AND LEN(UNIT.STR$)=1% AND L$(6%)="C" THEN &
			E%=512%+77% &
	\		GOSUB 13000 &
	\		GOTO 5280 IF FNC%("CONTINUE")=0% &
		!	IF 1ST AND ONLY FLOPPY IS MARKED AS A &
		!	CONTINUATION FLOPPY, THEN LET HIM GET OUT &
		!	OR CONTINUE. &

5120		VOL.SEQ.CHK%=-1% IF VOL%=0% AND L$(7%)<>"  " &
	\	IF VOL.SEQ.CHK%=-1% AND (VAL(L$(7%))<>(VOL%+1%)) THEN &
			E%=512%+87% &
	\		GOSUB 13000 &
	\		GOTO 5230 &
		!	TEST 1ST VOLUME TO SEE IF VOLUME SEQUENCE &
		!	CHECKING SHOULD BE PERFORMED. &
		!	IF SO, CHECK ALL VOLUMES &

5130		BRL%=VAL(L$(2%)) &
	\	IF VOL%>0% AND BRL%<>ORIG.BRL% THEN &
			E%=209% &
	\		GOTO 5310 &
		!	GET BLOCK/RECORD LENGTH OF THIS FLOPPY. &
		!	IF NOT THE 1ST FLOPPY AND THE BRL IS &
		!	INCONSISTENT IT'S A FATAL ERROR. &

5140		GOTO 5160 IF VOL%>0% &
	\	ORIG.BRL%=BRL% &
	\	BLK.FCT%=512%/ORIG.BRL% &
	\	PRINT BLK.FCT%;ORIG.BRL%; &
			"Character IBM Records = 1 RSTS Record" &
	\	LGCL.RCDS%=1% &
	\	LGCL.RCDS%=LGCL.RCDS%+1% UNTIL LGCL.RCDS%*ORIG.BRL%>5% &
	\	LGCL.RCDS%=0% IF NH% &
		!	IF THIS IS THE VERY 1ST FLOPPY: &
		!	SAVE MASTER BRL &
		!	DETERMINE/PRINT BLOCKING FACTOR &
		!	ALLOW ROOM FOR THE HEADER RECORD(S) &

5150		FIELD #2%,512% AS D0$ &
	\	LSET D0$="" &
		!	CLEAR OUT BUFFER &

5160		BOE%=FNT%(L$(3%)) &
	\	EOD%=FNT%(L$(8%))-1% &
		!	SAVE BOE AND EOD-1 &
		!	EOD IS NEXT UNUSED SECTOR &
		!	HENCE THE EOD-1 &
	&

5170		FOR I3%=BOE% TO EOD% &
	\		GOTO 5290 IF FNFLPRD%(I3%) &
	\		ON ERROR GOTO 5290 &
	\		IBM.RD%=IBM.RD%+1% &
	\		FLP.OUT$=LEFT(FLP.OUT$,ORIG.BRL%) &
	\		FIELD #2%,LGCL.RCDS%*ORIG.BRL% AS D0$,ORIG.BRL% AS OUT$ &
	\		FLP.OUT$=FNEBC.ASC$(FLP.OUT$) IF TRANS%=1% &
	\		LSET OUT$=FLP.OUT$ &
	\		LGCL.RCDS%=LGCL.RCDS%+1% &
	\		IF LGCL.RCDS%=BLK.FCT% THEN &
				PUT #2%,RECORD RSTS.WR% &
	\			RSTS.LGCL.WR%=RSTS.LGCL.WR%+BLK.FCT% &
	\			LGCL.RCDS%=0% &
	\			RSTS.WR%=RSTS.WR%+1% &
	\			FIELD #2%,512% AS D0$ &
	\			LSET D0$=""
5200		NEXT I3% &
	\	VOL%=VOL%+1% &
	\	DSN.ALW%=-1% &
	\	GOTO 5240 IF INSTR(1%," L",L$(6%))<>0% &
		!	FOR ALL IBM RECORDS: &
		!	GET A RECORD, UP IBM RECORD COUNTER, FIELD RECORD &
		!	FIELD RSTS RECORD, TRANSLATE TO ASCII IF &
		!	NECESSARY, UP LOGICAL RECORD COUNTER &
		!	IF THE PROPER # OF RECORDS HAVE BEEN FIELDED: &
		!	DUMP THE RECORD, UP THE TOTAL # OF LOGICAL &
		!	RSTS RECORDS WRITTEN, CLEAR THE LOGICAL &
		!	RECORD COUNTER, UP THE RSTS PHYSICAL RECORD &
		!	COUNTER (WANT TO KEEP TRACK OF EXACTLY &
		!	WHERE WE ARE) &
		! &
		!	BUMP VOLUME COUNTER &
		!	PROHIBIT DSN'S IN CASE MORE SPECS NEEDED &
		!	SEE IF LAST VOLUME IN SERIES (MVI=BLANK OR L) &
		!	IF NOT, GET MORE INPUT DEVICES IF NECESSARY &

5220	NEXT I0% &
		!	GO THRU ALL SUPPLIED INPUT FLOPPIES &

5230	T$="Next Input Device" IF VOL%>0% &
	\ GOTO 5050 &
		! GET ANOTHER SPEC &
		! 'NEXT' IF NOT WORKING ON 1ST FLOPPY &

5240	NO.IN.LST.BLK%=BLK.FCT% &
	\ IF LGCL.RCDS%=0% THEN &
		RSTS.WR%=RSTS.WR%-1% &
	ELSE	PUT #2%, RECORD RSTS.WR% &
	\	NO.IN.LST.BLK%=LGCL.RCDS% &
	\	RSTS.LGCL.WR%=RSTS.LGCL.WR%+LGCL.RCDS% &
		! HAVE (MAYBE) A COMPLETED TRANSFER. &
		! TENTATIVELY SET THE # OF LOGICAL RECORDS IN THE &
		! LAST PHYSICAL RECORD TO THE 'PROPER' # (MAXIMUM). &
		! IF NO LEFTOVER RECORDS REMAIN THEN &
		!	DECREMENT RSTS RECORD COUNT (WHICH POINTS TO THE &
		!	NEXT RECORD TO BE WRITTEN) &
		! ELSE 'EXTRA' RECORDS REMAIN, SO &
		!	RESET THIS # TO 'EXTRA', &
		!	DUMP THE LAST RECORD &
		!	UP TOTAL # OF LOGICAL RECORDS OUTPUT BY 'EXTRA'. &
	&

5250	GET #2%,RECORD 1% &
	\ FIELD #2%, 6% AS H$ &
	\ LSET H$=CVT%$(RSTS.WR%)+CVT%$(NO.IN.LST.BLK%)+CVT%$(ORIG.BRL%) &
	\ PUT #2%, RECORD 1% UNLESS NH% &
	\ PRINT CRLF$;"Exchange Completed";CRLF$; &
	IBM.RD%;"IBM Records Read";CRLF$; &
	RSTS.LGCL.WR%;"Logical ("; &
	RSTS.WR%;"Physical ) RSTS Records Written";CRLF$;CRLF$ &
		! STICK IN HEADER: LAST PHYSICAL RECORD, # OF LOGICAL RECORDS &
		! IN LAST PHYSICAL RECORD, RECORD LENGTH. &
		! GIVE THE USER SOME STATS. &

5280	CLOSE 2%,3%,4% &
	\ M$=SYS(CHR$(6%)+CHR$(-21%)+CHR$(0%)) &
	\ ON ERROR GOTO 19000 &
	\ GOTO 1070 &
		! CLOSE FILES, REGAIN PRIVILEGES &
		! RESET ERROR TRAP, CONTINUE &

5290	RESUME 5200 IF ERR=50% &
	\ E%=ERR &
	\ RESUME 5310 &
		! TRAP ERRORS &

5300	E%=512%+ERR &
	\ RESUME 5310 &
		! TRAP OUTPUT OPEN ERROR &

5310	GOSUB 13000 UNLESS E%=14% &
	\ PRINT "?Transfer Aborted" IF ERR=14% AND &
				(ERL=16300% OR ERL=16210% OR ERL=16220) &
	\ IF E%>0% THEN 5280 &
		ELSE ON RETRY% GOTO 5010,5040 &
		! PRINT ERROR MSG - RETRY IF POSSIBLE &

5320	E1%=E% &
	\ GOSUB 13000 &
	\ GOTO 5280 IF E1%<>(512%+75%) &
	\ GOTO 5230 &
		! ONLY 'DSN NOT FOUND' IS NOT FATAL &
	&

6000	! &
	&
	&
	&
	!	Z E R O    A    F L O P P Y &

6010	ONERROR GOTO 19000 &
	\ RETRY%=2% &
	\ DSN.ALW%=-1% &
	\ E%=0% &
	\ T$=I$+" which diskette" &
	\ GOSUB 14000 &
	\ GOTO 6010 IF C$="" &
	\ UNIT.STR$=FNI$(C$) &
	\ GOTO 6010 IF E% &
	\ I2$="DX"+UNIT.STR$+":" &
		! FIND OUT WHICH FLOPPY TO ZERO &
		! PUT ANSWER -->I2$ &

6020	T$="Really "+I$+" "+I2$+" <No> " &
	\ GOSUB 14000 &
	\ T%=FNY%(C$,"N") &
	\ GOTO 6020 IF T%<0% &
	\ PRINT I$+" aborted" UNLESS T% &
	\ GOTO 1070 UNLESS T% &
	\ T1%=FNFOPN%(I2$) &
	\ T1%=FNZERO%(I2$) &
	\ CLOSE 2%,3%,4% &
	\ ONERROR GOTO 19000 &
	\ GOTO 1070 &
		! GIVE USER A CHANCE TO RECONSIDER. &
		! LET USER KNOW WHAT WE HAVE DONE. &
		! GO BACK FOR MORE. &
	&

10000	! &
	&
	&
	!	S U B R O U T I N E S &
	&

10010	!	E B C D I C    T O    A S C I I &
	&
	&
	! THIS SUBROUTINE SETS UP AN EBCDIC TO ASCII CONVERSION TABLE. &
	! CHARACTERS WITHOUT A CORRESPONDING ASCII CHARACTER ARE &
	! CONVERTED TO A SPACE. &
	! TO HAVE SUCH NON-MAPPING CHARACTERS CONVERTED TO SOMETHING &
	! ELSE,CHANGE THE FIRST LINE TO SET V$=DESIRED DEFAULT CHARACTER &

10015	V$=" " &
	\ V%=ASCII(V$) &
	! SET UP DEFAULT CONVERSION CHARACTER &
	! TO BE A SPACE &

10020	S$=FNT$(0%,3%)+V$+CHR$(9%)+V$+CHR$(127%)+FNS0$(3%) &
	! NUL,SOH,STX,ETX,,HT,,DEL,,, &

10030	S0$=FNS0$(2%) &
	\ S$=S$+FNT$(11%,19%)+S0$+CHR$(8%)+V$+CHR$(24%)+CHR$(25%)+S0$+ &
	     FNT$(28%,31%) &
	! VT,FF,CR,SO,SI,DLE,DC1,DC2,DC3,,,BS,,CAN,EM,,, &
	! FS,GS,RS,US &

10040	S0$=FNS0$(5%) &
	\ S$=S$+S0$+CHR$(10%)+CHR$(23%)+CHR$(27%)+S0$+FNT$(5%,7%) &
	! ,,,,,LF,ETB,ESC,,,,,,ENQ,ACK,BEL &

10050	S0$=FNS0$(4%) &
	\ S$=S$+FNS0$(2%)+CHR$(22%)+S0$+CHR$(4%)+S0$+CHR$(20%)+ &
	     CHR$(21%)+V$+CHR$(26%) &
	! ,,SYN,,,,,EOT,,,,DC4, &
	! NAK,,SUB &

10060	S0$=FNS0$(9%) &
	\ S$=S$+CHR$(32%)+S0$+"[.<(+]&"+S0$+"!$*);^-/"+FNS0$(8%)+ &
	     CHR$(124%)+",%_>?"+S0$+CHR$(96%)+":#@'="+'" ' &
	! SPACE PLUS CHARACTERS SHOWN &

10070	S0$=FNS0$(7%) &
	\ S$=S$+"abcdefghi"+S0$+"jklmnopqr"+S0$+"~stuvwxyz"+FNS0$(22%) &
	! SMALL LETTERS AND TILDE &

10080	S0$=FNS0$(6%) &
	\ S$=S$+"{ABCDEFGHI"+S0$+"}JKLMNOPQR"+S0$+"\ STUVWXYZ"+S0$+ &
	  "0123456789"+S0$ &
	! CAPS,NUMERICS,\, AND LEFT AND RIGHT SQUIGGLE BRACKETS &

10090	EATBL%=-1% &
	\ EBCASC$=S$ &
	! SET TABLE INITIALIZED FLAG, SAVE TABLE &

10095	RETURN &
	&
	&

10100	! &
	&
	&
	!	A S C I I    T O    E B C D I C &
	&
	&
	! THIS SUBROUTINE SETS UP AN ASCII TO EBCDIC CONVERSION	TABLE. &

10120	S$=FNT$(0%,3%)+"7-./"+CHR$(22%)+CHR$(5%)+"%"+FNT$(11%,19%) &
	! NUL,SOH,STX,ETX,EOT,ENQ,ACK,BEL,BS, &
	! HT,LF,VT,FF,CR,SO,SI,DLE,DC1,DC2,DC3 &

10130	S$=S$+"<=2&"+CHR$(24%)+CHR$(25%)+"?'"+FNT$(28%,31%) &
	! DC4,NAK,SYN,ETB,CAN,EM,SUB,ESC,FS,GS.RS.US &

10140	S$=S$+"@Z"+CHR$(127%)+"{[lP}M]\Nk`Ka"+FNT$(240%,249%)+ &
	   "z^L~no"+CHR$(124%) &
	! SPACE EXCLAMATION POINT "#$%&'()*+,-./0123456789 &
	! :;<=>?@ &

10160	S$=S$+FNT$(193%,201%)+FNT$(209%,217%)+FNT$(226%,233%) &
	! A-Z &

10170	S$=S$+"J"+CHR$(224%)+"O_my"+ &
	   FNT$(129%,137%)+FNT$(145%,153%)+FNT$(162%,169%) &
	\ S$=S$+CHR$(192%)+"j"+CHR$(208%)+CHR$(161%)+CHR$(7%) &
	! [\]^_@ &
	! SMALL LETTERS &
	! [\]^ AND DEL &

10180	AETBL%=-1% &
	\ ASCEBC$=S$ &
	! SET TABLE INITIALIZED FLAG, SAVE TABLE &

10190	RETURN &
	&
	&

10400	! &
	&
	&
	!	E X T R A C T    &    T R A N S L A T E &
	!	H E A D E R    I N F O &
	&
	&

10410	FIELD #4%, 13% AS E1$ &
	\ E1$=FNEBC.ASC$(E1$) &
	\ IF LEFT(E1$,5%)<>"ERMAP" THEN &
		E%=201% &
	\	RETURN &
		! ILLEGAL FLOPPY IF THIS FIELD DOESN'T CONTAIN 'ERMAP' &

10420	BAD.TRKS%=0% &
	\ B$(0%),B$(1%)="" &
	\ RETURN IF MID(E1$,9%,1%)=" " &
	\ BAD.TRKS%=1% &
	\ B$(0%)=MID(E1$,7%,2%) &
	\ IF MID(E1$,13%,1%)="0" THEN &
		BAD.TRKS%=2% &
	\	B$(1%)=MID(E1$,11%,2%) &
		! IF THERE ARE ANY BAD TRACKS, SAVE THEM &
		! THIS IS FOR LATER USE &

10430	S$="" &
	\ S$="s" IF BAD.TRKS%=2% &
	\ PRINT I2$;" Contains";BAD.TRKS%;" Bad Track";S$;CRLF$ &
		! PRINT INFORMATIONAL MESSAGE &

10440	RETURN &
	&

10450	FIELD #4%, 4% AS L$(0%), 1% AS D0$, 8% AS L$(1%), 11% AS D0$, &
	3% AS L$(2%), 1% AS D0$, 5% AS L$(3%), 1% AS D0$, 5% AS L$(4%), &
	1% AS D0$, 1% AS L$(5%), 3% AS D0$, 1% AS L$(6%), 2% AS L$(7%), &
	27% AS D0$, 5% AS L$(8%) &
		! FIELD A HEADER RECORD. &

10460	L$(I%)=FNEBC.ASC$(L$(I%)) FOR I%=0% TO 8% &
	\ DS.CNT%=DS.CNT%+1% &
		! TRANSLATE FIELDS AND UP COUNTER &

10470	RETURN &

10480	BD.TRK%=FNFLPWT%(0%,-1%) &
	\ VOL%=VOL%+1% &
	\ IF MVI$=" " THEN &
		VSN$="  " &
	ELSE	VSN$=RIGHT(NUM1$(100%+VOL%),2%) &
		! INCREMENT THE VOLUME #. &
		! IF THIS IS THE 1 AND ONLY VOLUME (THE CONTINUATION &
		! FIELD IS BLANK) THEN &
		!	BLANK OUT VOLUME SEQUENCE FIELD &
		! ELSE	SET UP VOLUME SEQUENCE # STRING. &

10490	FIELD #4%,80% AS D0$,48% AS D1$ &
	\ H$="HDR1 "+DSN$+SPACE$(11%)+R$+" "+FNT2$(BOE%)+" "+FNT2$(J%-1%) &
	+SPACE$(5%)+MVI$+VSN$+SPACE$(27%)+FNT2$(J%)+" " &
	\ LSET D0$=FNASC.EBC$(H$) &
	\ LSET D1$=STRING$(48%,0%) &
	\ PUT #4%, RECORD DSL1% &
		! UPDATE THE HEADER FOR THIS DATA SET &

10500	IF DSL1%=25% THEN &
		10520 &
	ELSE	ON ERROR GOTO 10530 &
	\	GET #4%,RECORD DSL1%+1% &
		! SEE IF NEXT DATA SET IS MARKED AS DELETED &

10510	ON ERROR GOTO 19000 &
		! RESET ERROR TRAP IN CASE IT WAS CHANGED &

10520	RETURN &

10530	FIELD #4%,4% AS L$(0%),24% AS D0$,5% AS L$(3%) &
	\ RESUME 10510 IF FNEBC.ASC$(L$(0%))<>"DDR1" &
		       OR FNEBC.ASC$(L$(3%))<>"74001" &
	\ LSET L$(3%)=FNASC.EBC$(FNT2$(J%)) &
	\ PUT #4%,RECORD DSL1%+1%+16384% &
	\ RESUME 10510 &
		! VERY NEXT DATA SET WAS MARKED AS DELETED &
		! IF IT IS A 'INITIALIZED FLOPPY DELETED DATA SET' &
		! THEN UPDATE THE BOE, ELSE DON'T TOUCH IT AND GET OUT &
	&
	&

10540	IF DS.CNT%=1% THEN &
		PRINT #DIR.CH% FOR I%=1% TO 3% &
	\	PRINT #DIR.CH%,T$;" ";I2$;CRLF$;"DSN";TAB(11%);"BRL"; &
		TAB(18%);"BOE";TAB(26%);"EOE";TAB(34%);"EOD";TAB(42%); &
		"BI MVI VSN";CRLF$ &
		! &
		!	L I S T    D I R E C T O R Y &
		! &
		! PRINT HEADER FIRST TIME &

10550	PRINT #DIR.CH%,L$(1%);TAB(11%);L$(2%);TAB(17%); &
	L$(3%);TAB(25%);L$(4%);TAB(33%); &
	L$(8%);TAB(42%);L$(5%);TAB(46%);L$(6%);TAB(49%);L$(7%) &
		! PRINT DATA SET STATISTICS INFO. &

10560	RETURN &
	&
	&

10570	ON ERROR GOTO 10610 &
	\ FOR DSL1%=7% TO 25% &
	\	GET #4%,RECORD DSL1% &
	\	GOSUB 10450 &
	\	RETURN IF L$(3%)=L$(8%) AND L$(4%)="73026"
10580	NEXT DSL1% &
		! TRY TO FIND A PLACE FOR THE DATA SET. &
		! ON NEW FLOPPIES, 1ST DATA SET IS MARKED AS NON-DELETED &
		! BUT HAS LENGTH ZERO AND SHOULD BE USED IF ALL FIELDS ARE &
		! IN THEIR 'INITIALIZED' STATE. &
		! VERIFY THAT: LABEL ID='HDR1', EOE=73026 AND BOE=EOD=01001 &
		! IF ANY OF THESE DON'T MATCH, (CHANGED BY SOMEONE?) &
		! KEEP LOOKING. &

10590	E%=217% &
		! CAN'T FIND A SPOT FOR THE DATA SET. &

10600	RETURN &

10610	RESUME 10620 IF ERR=50% &
	\ E%=ERR &
	\ RESUME 10600 &
		! ONLY ERROR SHOULD BE DDM (50) &

10620	GOSUB 10450 &
	\ GOTO 10600 IF L$(4%)="73026" &
		AND L$(8%)="74001" &
		AND L$(3%)<L$(4%) &
		AND L$(0%)="DDR1" &
	\ GOTO 10580 &
		! HAVEN'T USED VERY 1ST DATA SET - TRY TO USE 'DELETED' &
		! DATA SET, SHOULD HAVE: &
		! LABEL ID='DDR1', EOD=74001, EOE=73026 AND BOE<EOE &
	&

13000	! &
	&
	&
	!	E R R O R    P R I N T I N G &
	&
	&

13010	E0$="" &
	\ E$="Transfer Aborted" IF E%>200% AND E%<300% &
	\ IF E%=201% THEN &
		E0$="?Track 00 does not contain ERMAP field" &
	ELSE	IF E%=205% THEN &
		E0$="?Data Set LABEL ID must be HDR1" &
	ELSE	IF E%=209% THEN &
		E0$="?Data set RECORD LENGTH inconsistent "+NUM1$(BRL%) &
	ELSE	IF E%=213% THEN &
		E0$="?BOE = EOD" &
	ELSE	IF E%=217% THEN &
		E0$="?No room for Data Set" &
	ELSE	IF E%=300% THEN &
		E0$=DSN$+" is not intended for processing" &
	ELSE	IF E%=512%+64% THEN &
		E0$="Illegal command" &
	ELSE	IF E%=512%+66% THEN &
		E0$="Illegal Data Set Name" &
	ELSE	IF E%=512%+68% THEN &
		E0$="Data Set Name too long" &
	ELSE	IF E%=512%+70% THEN &
		E0$="Logical device name not assigned" &
	ELSE	IF E%=512%+75% THEN &
		E0$="Data set not found" &
	ELSE	IF E%=512%+77% THEN &
		E0$=DSN$+" Resides on more than 1 diskette" &
	ELSE	IF E%=512%+85% THEN &
		E0$="Output device must be disk" &
	ELSE	IF E%=512%+87% THEN &
		E0$="Volume #"+L$(7%)+" cannot follow Volume # "+ &
		NUM1$(VOL%) &
	ELSE	IF E%=512%+89% THEN &
		E0$=DSN$+" is the 1st Data Set on "+I2$ &
		! GET FLINT SPECIFIC MESSAGES. &

13150	E0$=FNE5$(E%) IF E0$="" &
	\ E0$=E0$+" - "+E$ IF E$<>"" &
	\ PRINT SYS(CHR$(0%))+E0$ &
	\ IF E%>512% THEN &
		E$="" &
	\	E%=0% &
		! GET MESSAGE IF NON-FLINT SPECIFIC. &
		! TACK ON FLINT MSG IF ANY AND PRINT. &
		! CLEAR FLAGS IF EXPECTED/RETRIABLE ERROR. &
		! &
		! NOTE*** UNEXPECTED ERROR MESSAGES WILL BE PRECEDED WITH &
		! '?' OR '%'. &

13210	RETURN &
	&
	&

14000	! &
	&
	&
	!	G E T    C O M M A N D    L I N E &
	&
	&

14020	PRINT T$; &
	\ INPUT LINE #C0%,C$ &
	\ C$=CVT$$(C$,2%+4%+8%+16%+32%+64%+128%+256%) &
	\ RETURN &
	! GET NORMAL COMMAND LINE. &
	! THIS IS USED FOR EVERYTHING BUT FLOPPY INPUT SPECS &

14050	PRINT T$; &
	\ INPUT LINE #C0%,C$ &
	\ C$=CVT$$(C$,4%+256%) &
	! GET COMMAND &
	! DISCARD EXCESS CHARACTERS &
	! DON'T ALTER CHAR. INSIDE QUOTES &
	! &
	! NOTE** REST OF TRIMMIMG WILL BE DONE IN FNI$ &
	! THIS IS NECESSARY BECAUSE DATA SET NAMES &
	! MAY CONTAIN ANY CHARACTER &

14070	RETURN &
	&

15000	! &
	&
	&
	!	F U N C T I O N S &
	&
	&

15010	DEF* FNASC.EBC$(I$) &
	! FUNCTION	FNASC.EBC$	TRANSLATE ASCII STRING I$ TO EBCDIC &

15030	GOSUB 10100 UNLESS AETBL%<>0% &
	\ FNASC.EBC$=XLATE(I$,ASCEBC$) &
	! SET UP TRANSLATION TABLE IF DOESN'T ALREADY EXIST &
	! TRANSLATE ASCII STRING TO EBCDIC &

15050	FNEND &
	&

15070	DEF* FNC%(T1$) &
	! FUNCTION	FNC%	SEE IF USER WANTS TO RETRY/CONTINUE &
	! PARAMETER	T1$	'CONTINUE' OR 'RETRY' &
	! RETURNS:	FNC%	0=NO,  1=YES &

15080	ON ERROR GOTO 19000 &
	\ T$="Do You Wish to "+T1$+"<NO>" &
	\ GOSUB 14000 &
	\ FNC%=0% &
	\ FNC%=1% IF FNY%(C$,"N")=1% &
	! ASK ?, DEFAULT TO NO &

15110	FNEND &
	&

15130	DEF* FNEBC.ASC$(I$) &
	! FUNCTION	FNEBC.ASC$	TRANSLATE EBCDIC STRING I$ TO ASCII &

15150	GOSUB 10010 UNLESS EATBL%<>0% &
	\ FNEBC.ASC$=XLATE(I$,EBCASC$) &
	! SET UP TRANSLATION TABLE IF DOESN'T ALREADY EXIST &
	! TRANSLATE EBCDIC STRING TO ASCII &

15170	FNEND &
	&

15190	DEF* FNE5$(E5%)=CVT$$(RIGHT(SYS(CHR$(6%)+CHR$(9%)+ &
		CHR$(E5% AND 63%)),E5%/512%+3%),4%) &
	! GET ERROR MSG ASSOCIATED WITH (E5% AND 63%) &
	&

15210	DEF* FNI$(I$) &
	! FUNCTION:	FNI$	VERIFY INPUT STRING &
	! PARAMETER:	I$	INPUT STRING - MUTIPLE SPECS MUST &
	!			BE SEPARATED BY COMMAS. &
	! 			VALID FORMS: &
	!			DXN:	N=0-7 &
	!			N	EQUIVALENT TO DXN: &
	!			NULL 	EQUIVALENT TO DX0: &
	! GLOBAL VAR.	DSN$	DATA SET NAME IF SPECIFIED ELSE NULL &
	! AFFECTED &
	! &
	! RETURNS:	FNI$	STRING OF LEGAL DEVICE UNIT #'S &
	!			(IGNORED IF E% (ERROR) IS SET) &
	! &
	! ERRORS: &
	! ALL RESULT FROM ILLEGAL FLOPPY SPEC AND WILL CAUSE ERROR &
	! MESSAGE TO BE OUTPUT AND ? TO BE RE-ASKED. &
	!	E%		MESSAGE/CAUSE &
	!	512+6		NOT A VALID DEVICE (MUST BE FLOPPY) &
	!	512+66		ILLEGAL DATA SET NAME (DSN ILLEGAL &
	!			WITH DIRECTORY REQUEST OR WITH >1ST &
	!			FLOPPY SPEC. &
	!	512+68		DSN TOO LONG (>8 CHAR) &
	!	512+70		LOGICAL DEVICE NAME NOT ASSIGNED &

15250	ON ERROR GOTO 15450 &
	\ K$="" &
	\ J%=1% &
	\ I$=I$+"," &
	! SET ERROR TRAP FOR THIS FUNCTION &
	! SET UP STRING TO SAVE LEGAL SPECS &
	! SET UP POINTER &
	! TACK ON ',' TO AVOID MISSING NULL SPEC (=DX0:) &

15270	WHILE J%<=LEN(I$) &
	\	I%=INSTR(J%,I$,",") &
	\	I2$=MID(I$,J%,I%-J%) &
	\	I1%=INSTR(1%,I2$,":") &
	\	C0$=RIGHT(I2$,I1%+1%) IF I1%>0% &
	\	I2$=CVT$$(I2$,2%+8%+16%+32%+64%+128%) &
	\	I2$="0" IF I2$="" &
	\	I2$="DX"+I2$+":" IF VAL(I2$)<8% IF LEN(I2$)=1% &
	\	I1%=INSTR(1%,I2$,":") &
	\	IF I1%=0% THEN &
			E%=512%+6% &
		ELSE	IF I1%<>LEN(I2$) THEN &
				IF DSN.ALW%<0% THEN &
					E%=512%+66% &
				ELSE	DSN$=C0$ &
	\				E%=512%+68% IF LEN(DSN$)>8% &
	! GET THE NEXT PART OF THE INPUT SPEC. &
	! NULL=0, 0-7=DXN: &
	! PINPOINT DEVICE AND DSN (ERROR IF NO ':') &
	! ERROR IF DSN NOT PERMITTED OR TOO LONG. &
	! MUST TEST DSN SEPARATELY AS NEED NOT BE IN &
	! 'RSTS' FORMAT - ONLY LIMITATION IS 1-8 CHAR. &

15320		GOTO 15470 IF E%>0% &
	! GET OUT IF THERE WAS ALREADY AN ERROR &
	&

15330		CHANGE SYS(CHR$(6%)+CHR$(-10%)+LEFT(I2$,I1%)) TO S% &
	\	IF S%(29%)+SWAP%(S%(30%))<0% THEN &
			E%=512%+70% &
		ELSE	IF S%(23%)<>68% OR S%(24%)<>88% &
			OR S%(26%)<>255% THEN &
				E%=512%+6% &
			ELSE	K$=K$+NUM1$(S%(25%)) &
	! DO SCAN ON DEVICE PART OF SPEC ONLY. &
	! CHECK FOR LOGICAL NAME ASSIGNMENT. &
	! MUST HAVE EQUIVALENT OF DXN: - ELSE ERROR &

15370		GOTO 15470 IF E%>0% &
	\	J%=I%+1% &
	\	DSN.ALW%=-1% &
	! GOTO ERROR ROUTINE IF NECESSARY &
	! BUMP PTR AND SET DSN (NOW) PROHIBITED FLAG &

15390	NEXT &
	! CHECK EACH SPECIFICATION &

15410	FNI$=K$ &
	! SET FUNCTION &

15420	ON ERROR GOTO 19000 &
	! RESET ERROR TRAP &

15430	FNEND &
	!	ERROR ROUTINE FOLLOWS &
	! &

15450	RESUME 15470 IF ERL=15270% &
	\ E$=FNU$ &
	\ RESUME 15410 &
	! ONLY EXPECTED ERROR IS VAL() &

15470	E$=I2$ &
	\ E$=LEFT(I2$,I1%)+"<"+DSN$+">" IF E%=512%+66% OR (E%=512%+68%) &
	\ GOTO 15410 &
	! HAD AN ERROR &
	! IF IT WAS A DATA SET ERROR THEN &
	! ENCLOSE THE DSN TO CLARIFY ERROR &
	&

15500	DEF* FNO%(O$) &
	! FUNCTION:	FN0%	VERIFY OUTPUT SPEC (DISK) &
	! PARAMETER:	O$	OUTPUT SPEC &
	! RETURNS:	FN0%	0 =FAILURE &
	!			-1=SUCCESS &
	! ERRORS: &
	! ALL RESULT FROM ILLEGAL SPEC AND WILL CAUSE ERROR &
	! MESSAGE TO BE OUTPUT AND ? TO BE RE-ASKED. &
	!	E%		MESSAGE/CAUSE &
	!	512+2		ILLEGAL FILENAME &
	!	512+10		PROTECTION VIOLATION (MUST BE &
	!			PRIVILEGED TO CROSS ACCOUNTS) &
	! 	512+70		LOGICAL DEVICE NAME NOT ASSIGNED &
	!	512+85		OUTPUT DEVICE MUST BE DISK &

15520	ON ERROR GOTO 15640 &
	\ FNO%=0% &
	\ S$=SYS(CHR$(6%)+CHR$(-21%)+CHR$(-1%)) &
	\ CHANGE SYS(CHR$(6%)+CHR$(-10%)+O$) TO S% &
	\ IF PROJ%<>1% AND (S%(5%)+S%(6%)<>0%) THEN &
		E%=10% &
	ELSE	IF (S%(27%)+SWAP%(S%(28%)))<0% THEN &
			E%=2% &
		ELSE	Z0%=S%(29%)+SWAP%(S%(30%)) &
	\		IF Z0%<0% THEN &
				E%=70% &
			ELSE	E%=85% IF (Z0% AND 4096%)<>0% AND &
				(STATUS AND 255%)<>0% &
	! SET ERROR TRAP AND FUNCTION. &
	! DROP PRIVILEGES, DO SCAN. &
	! CHECK FILENAME, EXTENSION,PPN FOR ? AND *. &
	! CHECK FOR LOGICAL DEVICE ASSIGNED. &
	! MAKE SURE ITS DISK IF DEVICE SPECIFIED &

15580	IF E%=0% THEN &
		FNO%=-1% &
	ELSE	E%=E%+512% &
	\	E$=O$ &
	! SUCCESS=-1% &
	! IF FAILURE, SET ERROR CODE FOR RETRY &

15600	ON ERROR GOTO 19000 &
	! RESET ERROR TRAP &

15620	FNEND &
	&

15640	E%=ERR &
	\ RESUME 15580 &
	! CATCH ERROR ON SYS(), CONTINUE &
	&

15660	DEF* FNS0$(Z0%)=STRING$(Z0%,V%) &
	&

15680	DEF* FNS2%
15700	ON ERROR GOTO 15880 &
	\ FNS2%=0% &
	\ DS.CNT%=0% &
	! SET ERROR TRAP, FUNCTION &
	! AND FOUND NON-DELETED DATA SET FLAG &

15720	FOR DSL%=7% TO 25% &
	\	GET #4%,RECORD DSL% &
	\	GOSUB 10450 &
	\	IF DSN$="" AND DS.CNT%=1% THEN &
			DSN$=L$(1%) &
	\		E%=512%+89% &
	\		GOSUB 13000 &
	! GET A DSN - IF NOT LOOKING FOR A PARTICULAR DSN, &
	! GRAB 1ST ONE OFF 1ST DX AND SAVE FOR POSSIBLE &
	! LATER MATCHES - MUST STILL CHECK LABEL ID &
	! AND BYPASS INDICATOR &

15760		IF DSN$=L$(1%) THEN &
			GOTO 15820 IF L$(5%)=" " AND L$(0%)="HDR1" &
	\		GOTO 15900 IF L$(0%)<>"HDR1" &
	\		E%=300% &
	\		GOSUB 13000 &
	\		GOTO 15840 IF FNC%("CONTINUE")=0% &
	\		E%=0% &
	\		GOTO 15820 &
	! IF WE HAVE A MATCH: &
	!	JUMP OUT IF LEGAL LABEL AND INTENDED FOR &
	!	PROCESSING. &
	! &
	!	DO NOT PROCESS IF ILLEGAL LABEL ID &
	! 	OTHERWISE, SEE IF USER WANTS TO CONTINUE &
	!	EVEN THO DATA SET IS NOT INTENDED FOR PROCESSING. &

15780	NEXT DSL% &
	! TRY ALL DATA SET LABELS &

15800	E%=512%+75% &
	\ E$=I2$+DSN$ &
	\ GOTO 15840 &
	! CAN'T FIND DATA SET &

15820	FNS2%=-1% &
	! FOUND DSN &

15840	ON ERROR GOTO 19000 &
	! RESET ERROR TRAP &

15860	FNEND &
	&

15880	RESUME 15780 IF ERR=50% &
	\ E$=FNU$ &
	\ RESUME 15840 &
	! ONLY EXPECTED ERROR IS DELETED DATA MARK (50) &

15900	E%=205% &
	\ E$=L$(0%) &
	\ GOTO 15840 &
	! IBM DATA SET LABEL ID MUST BE 'HDR1' &
	! IF NOT, IT'S FATAL &
	&

15920	DEF* FNT$(S1%,S2%)
15940	S1$="" &
	\ S1$=S1$+CHR$(N%) FOR N%=S1% TO S2% &
	\ FNT$=S1$
15960	FNEND &
	&

15980	DEF* FNT%(T3$)= &
		VAL(RIGHT(T3$,4%))+(26%*VAL(LEFT(T3$,2%)))-1% &
	! CONVERT TT0SS TO RECORD # &

16000	DEF* FNT2$(R2%)=RIGHT(NUM1$(100%+(R2%/26%)),2%)+"0"+ &
		RIGHT(NUM1$(100%+(R2%-(R2%/26%)*26%+1%)),2%) &
	! CONVERT RECORD # TO TT0SS BY GETTING TRACK AND SECTOR. &
	&
	&

16010	DEF* FNU$ &
	! FUNCTION	FNU$	SAVE UNEXPECTED ERRORS
16012	E%=ERR &
	\ FNU$="Unexpected Error at Line "+NUM1$(ERL) &
	! SAVE # AND LINE &

16015	FNEND &

16020	DEF* FNY%(Y$,Y1$) &
	! FUNCTION	FNY%	VERIFY Y[E[S]],N[O] OR NULL RESPONSE &
	! PARAMETERS	Y$	USER RESPONSE &
	!		Y1$	DEFAULT, NULL IF NONE ALLOWED &
	! RETURNS		-1= ILLEGAL RESPONSE &
	!			0 = NO &
	!			1 = YES &

16060	Y%=-1% &
	\ IF Y$="" AND Y1$<>"" THEN &
		Z0$=Y1$ &
	\	GOTO 16100 &
	! IF NULL & DEFAULT ALLOWED THEN SET UP &

16080	Z0$="YES" &
	\ Z0$="NO" IF ASCII(Y$)=78% &
	\ GOTO 16120 IF LEFT(Z0$,LEN(Y$))<>Y$ &
	! VERIFY YES OR NO &

16100	Y%=ASCII(Z0$) AND 1% &
	! SET FLAG &

16120	FNY%=Y% &
	! SET FUNCTION &

16140	FNEND &
	&
	&

16200	DEF* FNFLPRD%(SECTR.NUM%) &
	\ FNFLPRD%=0% &
	\ REQ.TRK%=SECTR.NUM%/26% &
	\ GOTO 16240 IF CUR.TRK%=REQ.TRK% &
	\ FNFLPRD%=FNFLPWT%(SECTR.NUM%,-1%) IF TRK.DRTY% &
	\ ONERROR GOTO 16270 &
	&

16210	DEL.MRK1%,DEL.MRK2%=0% &
	\ INTRLV%=-1% &
	\ GET #3%,RECORD (REQ.TRK%-1%)*26% +32767%+1%+8192% &
	\ CUR.TRK%=REQ.TRK% &
	\ GOTO 16240 &
	! GET TRACK IN BLOCK MODE. &
	! SKIP OVER SECTOR MODE GET. &

16220	INTRLV%=0% &
	\ FOR I%=0% TO 25% &
	\ GET #4%,RECORD I%+REQ.TRK%*26%+8192%
16230	LSET D$(I%)=D$(26%) &
	\ NEXT I% &
	\ CUR.TRK%=REQ.TRK% &
	! GET ALL SECTORS IN SECTOR MODE. &

16240	SECTR%=SECTR.NUM% &
	\ SECTR%=SECTR%+(CUR.TRK%-1%)*20% IF INTRLV% &
	\ SECTR%=SECTR%-(SECTR%/26%)*26% &
	\	FLP.OUT$=D$(SECTR%) &
	\	IF INTRLV%=0% THEN &
		FNFLPRD%=-1% IF	DEL.MRK1% AND 2%^SECTR% IF SECTR%<16% &
	\	FNFLPRD%=-1% IF	DEL.MRK2% AND 2%^(SECTR%-16%) IF SECTR%>15% &

16250	ON ERROR GOTO 19000 &
	\ FNEND &
	! GO HOME. &

16270	RESUME 16220 IF ERL=16210 AND ERR=50 &
	\ IF ERL=16220 AND ERR=50 THEN &
		DEL.MRK1%=DEL.MRK1% OR 2%^I% IF I%<16% &
	\	DEL.MRK2%=DEL.MRK2% OR 2%^(I%-16%) IF I%>15% &
	\	RESUME 16230 &
	! TRY TO READ IN SECTOR MODE IF FAIL IN BLOCK MODE &
	! MARK THE SECTOR AS DELETED AND TRY NEXT SECTOR IF DELETED DATA. &

16290	PRINT RIGHT(SYS(CHR$(6%)+CHR$(9%)+CHR$(ERR)),3%) &
	\ FNFLPRD%=-1% &
	\ RESUME 16250 &

16300	DEF* FNFLPWT%(SECTR.NUM%,IO%) &
	\ FNFLPWT%=0% &
	\ ONERROR GOTO 16340 &
	\ REQ.TRK%=SECTR.NUM%/26% &
	\ GOTO 16320 UNLESS IO%=-1% IF CUR.TRK%=REQ.TRK% &
	\ GOTO 16310 UNLESS TRK.DRTY% &
	\ IF INTRLV% THEN &
		PUT #3%,RECORD (CUR.TRK%-1%)*26% +32767%+1%+8192% &
		ELSE &
		INTRLV%=0% &
		\ FOR I%=0% TO 25% &
		\ DEL.DATA%=0% &
		\ DEL.DATA%=16384% IF	(DEL.MRK1% AND 2%^I% AND I%<16%) OR &
					(DEL.MRK2% AND 2%^(I%-16%) AND I%>15%) &
	\ LSET D$(26%)=D$(I%) &
	\ PUT #4%,RECORD I%+(CUR.TRK%-1%)*26%+8192%+DEL.DATA% &
	\ NEXT I% &

16310	TRK.DRTY%=0% &
	\ GOTO 16330 IF IO%=-1% &
	\ DEL.MRK1%,DEL.MRK2%=0% &
	\ INTRLV%=1% &
	\ GOTO 16320 IF IO%=1% &
	\ GOTO 16340 IF FNFLPRD%(SECTR.NUM%) UNLESS IO%=1% &
	\ ONERROR GOTO 16340 &

16320	CUR.TRK%=REQ.TRK% &
	\ SECTR%=SECTR.NUM% &
	\ SECTR%=SECTR%+(CUR.TRK%-1%)*20% IF INTRLV% &
	\ SECTR%=SECTR%-(SECTR%/26%)*26% &
	\	LSET D$(SECTR%)=FLP.INP$ &
	\	IF INTRLV%=0% AND IO%>=0% THEN &
		    DEL.MRK1%=DEL.MRK1% AND NOT 2%^SECTR% IF SECTR%<16% &
	\	    DEL.MRK2%=DEL.MRK2% AND NOT 2%^(SECTR%-16%) IF SECTR%>15% &

16330	TRK.DRTY%=-1% IF IO%>=0% &
	\ FNEND &
	! MARK THE IN CORE TRACK AS DIRTY IF WE WROTE ON IT. &
	! GO HOME. &

16340	PRINT RIGHT(SYS(CHR$(6%)+CHR$(9%)+CHR$(ERR)),3%) &
	\ FNFLPWT%=-1% &
	\ RESUME 16330 &

16400	DEF* FNFOPN%(DEV$) &
	\ ON ERROR GOTO 16420 &
	\ FNFOPN%=-1% &
	\ CUR.TRK%=-1% &
	\ TRK.DRTY%=0% &
	\ OPEN DEV$ AS FILE 4%, RECORDSIZE 128%+1%+32767%,MODE 16384% &
	\ OPEN DEV$ AS FILE 3%, RECORDSIZE (128%*26%)+1%+32767% ,MODE 16384% &
	\ FIELD #3%, &
	128% AS D$(0%) , 128% AS D$(2%), &
	128% AS D$(4%) , 128% AS D$(6%), &
	128% AS D$(8%) , 128% AS D$(10%), &
	128% AS D$(12%), 128% AS D$(14%), &
	128% AS D$(16%), 128% AS D$(18%), &
	128% AS D$(20%), 128% AS D$(22%), &
	128% AS D$(24%), 128% AS D$(1%), &
	128% AS D$(3%) , 128% AS D$(5%), &
	128% AS D$(7%) , 128% AS D$(9%), &
	128% AS D$(11%), 128% AS D$(13%), &
	128% AS D$(15%), 128% AS D$(17%), &
	128% AS D$(19%), 128% AS D$(21%), &
	128% AS D$(23%), 128% AS D$(25%) &
	\ FIELD #4%, 128% AS D$(26%) &
	\ FNFOPN%=0% &

16410	FNEND
16420	RESUME 16410 &

16500	DEF* FNZERO%(I2$) &
	\ ON ERROR GOTO 16520 &
	\ LSET D$(26%),D$(25%)=STRING$(80%,64%)+STRING$(48%,0%) &
	\ PUT #4%,RECORD I%+8192% FOR I%=0% TO 8% &
		! MOST SECTORS ARE HALF BLANK HALF NULL SO INITIALLY SET &
		!	UP THE BUFFER THAT WAY AND PUT INTO SECTORS 0-8 &
	\ FIELD #4%,5% AS ERRMAP$ &
	\ LSET D$(26%)=D$(25%) &
	\ LSET ERRMAP$=FNASC.EBC$("ERMAP") &
	\ PUT #4%,RECORD 4%+8192% &
		! SECTOR 5 (RECORD 4) HAS BYTES 0-4 = ERMAP (EBCIDC) &
	\ FIELD #4%,10% AS VLL$,69% AS V$,1% AS V$ &
	\ LSET D$(26%)=D$(25%) &
	\ LSET VLL$=FNASC.EBC$("VOL1      ") &
	\ LSET V$=FNASC.EBC$("W") &
	\ PUT #4%,RECORD 6%+8192% &
		! SECTOR 7 (RECORD 6) HAS BYTES 0-3 = VOL1 &
		!			  BYTES 5-10= BLANK &
		!			  BYTE  80  = W &
	\ LSET D$(26%)=D$(25%) &
	\ FIELD #4%,4% AS HDR1$, &
		1% AS DSI$,4% AS DSI$,2% AS DSIN$, &
		13% AS BL$,3% AS BL$, &
		1% AS BOE$,5% AS BOE$, &
		1% AS EOE$,5% AS EOE$, &
		35% AS EOD$,5% AS EOD$ &
	\ LSET HDR1$	=FNASC.EBC$("HDR1") &
	\ LSET DSI$	=FNASC.EBC$("DATA") &
	\ LSET BL$	=FNASC.EBC$("080") &
	\ LSET BOE$	=FNASC.EBC$("01001") &
	\ LSET EOE$	=FNASC.EBC$("73026") &
	\ LSET EOD$	=BOE$ &
	\ PUT #4%,RECORD 7%+8192% &
		! SECTOR 8 (RECORD 7) IS THE FIRST DIRECTORY ENTRY &
		! 		HDR1=HDR1 &
		!		DSN =DATA &
		!		BLN = 080 &
		!		BOE = 01001 &
		!		EOE = 73026 &
		!		EOD = 01001 &
	\ LSET HDR1$	=FNASC.EBC$("DDR1") &
	\ LSET BOE$	=FNASC.EBC$("74001") &
	\ LSET EOD$	=BOE$ &
	\ LSET D$(25%)=D$(26%) &
		! SECTOR 9 - 25 ARE THE SAME AS 8 EXCEPT FOR THE FOLLOWING. &
		!		HDR1=DDR1 &
		!		BOE = 74001 &
		!		EOD = 74001 &
		!		DSN = DATAnn	nn=sector # &
		!		ALL SECTOR ARE WRITTEN WITH DELETED DATA MARKS &
	\ FOR I%=8% TO 25% &
	\	LSET D$(26%)=D$(25%) &
	\	T%=0% &
	\	T%=1% IF I%+1%>9% AND I%+1%<20% &
	\	T%=2% IF I%+1%>19% &
	\	I1%=I%+1% &
	\	I1%=I1%-10% WHILE I1%>9% &
	\	LSET DSIN$=FNASC.EBC$(CHR$(T%+48%)+CHR$(I1%+48%)) &
	\	PUT #4%,RECORD I%+8192%+16384% &
	\ NEXT I% &
	\ IF LEFT(C0$,3%)=LEFT("ERASE",3%) THEN &
		FLP.INP$=STRING$(128%,229%) &
	\	CUR.TRK%=-1% &
	\	TRK.DRTY%=0% &
	\	GOTO 16520 IF FNFLPWT%(T0%,1%) FOR T0%=26% TO 2001% &
	\	GOTO 16520 IF FNFLPWT%(1000%,1%) &
		! IF USER ASKED TO BE ERASED THEN ZAP BLANKS INTO SECTORS &
		!	27-2002 &
	&

16510	FNEND &

16520	PRINT "?Transfer Aborted" IF (ERR=14% AND &
			(ERL=16210% OR ERL=16220% OR ERL=16300%)) OR ERL=16500 &
	\ RESUME 16510 &
	&
	&

19000	! &
	&
	&
	!	E R R O R    H A N D L I N G &
	&
	&

19010	RESUME 32767 IF ERR=11% &
	\ E$=FNU$ &
	\ GOSUB 13000 &
	\ RESUME 32767 &
		! TRAP CONTROL/Z, ALL UNEXPECTED ERRORS &

30000	! &
	&
	&
	!	C C L    E N T R Y &
	&
	&

30010	ON ERROR GOTO 19000 &
	\ E0%=1% &
	\ C$=CVT$$(SYS(CHR$(7%)),4%+8%+16%+32%+128%+256%) &
	\ FOR J%=5% TO 1% STEP -1% &
	\	IF LEFT(C$,J%)=LEFT("FLINT",J%) THEN &
			C$=RIGHT(C$,J%+1%) &
	\		E0%=0% IF C$="" &
	\		GOTO 1000
30020	NEXT J% &
	\ PRINT "?FLINT - Unrecognized CCL Command - ";C$ &
		! SET FLAG TO INDICATE CCL ENTRY. &
		! GET CORE COMMON STRING AND STRIP OFF 'FLINT'. &
		! TREAT LIKE RUN ENTRY IF NO OPTION WAS SPECIFIED. &
		! ISSUE AN ERROR IF 'FLINT', OR PART THEREOF, DOES &
		! NOT APPEAR IN THE STRING. &
		! &
		! **NOTE** LACK OF SEPARATOR CAN LEAD TO ILLEGAL COMMAND, &
		! E.G. FLINTOI[B[M]] MUST BE FLIN/TOI[B[M]]. &

32767	END
