! BLDPBS.COM -- Build the RSTS Print/Batch Services (PBS) package

$ _SET NOON
$  P1 = F$EDIT(P1,32)

$! Assign (user) logicals
$ _DEASSIGN/USER/ALL
$ _ASSIGN/USER/REPLACE	D:[170,0]	CMN
$ _ASSIGN/USER/REPLACE	D:[1,1]		LB
$ _ASSIGN/USER/REPLACE	D:[1,2]		LIB
$ _ASSIGN/USER/REPLACE	D:[170,58]	LST
$ _ASSIGN/USER/REPLACE	D:[170,58]	SYSTEM
$
$! Set default protection code
$ _SET PROT=40/DEFAULT

$! Delete any intermediate files
$ _RUN LIB:PIP
SYSTEM:*.BAK/DE:NOWARN
$ _EOD

$ _ON ERROR THEN _EXIT 4	! Fatal thing if PBS build goes awry
$ _IF F$INSTR(1,P1,"NOMAC") .NE. 0 THEN _GOTO OBJ
$! Assemble Macro Library PBSMAC
$ _RUN LIB:MAC
,LST:PBSMAC/-SP/CR=SYSTEM:PBSMAC
$ _EOD

$! Cref the PBSMAC listing
$ _RUN SYSTEM:BCRF
LST:PBSMAC.LST/-SP
$ _EOD

$! Create the PBSMAC Macro library
$ _RUN LIB:LBR
SYSTEM:PBSMAC.MLB/CR:100.:0.:30.:MAC
SYSTEM:PBSMAC.MLB=SYSTEM:PBSMAC.MAC
$ _EOD

$  OBJ:
$ _IF F$INSTR(1,P1,"NOOBJ") .NE. 0 THEN _GOTO MAIN
$! Assemble PBSLIB object library modules
$ _RUN LIB:MAC
SYSTEM:NUM,LST:NUM/-SP/CR=SYSTEM:NUM
SYSTEM:BLDPPN,LST:BLDPPN/-SP/CR=SYSTEM:BLDPPN
SYSTEM:CLRFQX,LST:CLRFQX/-SP/CR=SYSTEM:CLRFQX
SYSTEM:PRINT,LST:PRINT/-SP/CR=SYSTEM:PRINT
SYSTEM:CVT,LST:CVT/-SP/CR=SYSTEM:CVT
SYSTEM:R502A,LST:R502A/-SP/CR=SYSTEM:R502A
SYSTEM:UNFSS,LST:UNFSS/-SP/CR=SYSTEM:UNFSS
SYSTEM:GETLIN,LST:GETLIN/-SP/CR=SYSTEM:GETLIN
SYSTEM:SAVREG,LST:SAVREG/-SP/CR=SYSTEM:SAVREG
SYSTEM:PROMPT,LST:PROMPT/-SP/CR=SYSTEM:PROMPT
SYSTEM:SETPRV,LST:SETPRV/-SP/CR=SYSTEM:SETPRV
SYSTEM:CHKPRV,LST:CHKPRV/-SP/CR=SYSTEM:CHKPRV
SYSTEM:MUTEXC,LST:MUTEXC/-SP/CR=SYSTEM:MUTEXC
$ _EOD

$! Cref the listings of PBSLIB
$ _RUN SYSTEM:BCRF
LST:NUM.LST/-SP
LST:BLDPPN.LST/-SP
LST:CLRFQX.LST/-SP
LST:PRINT.LST/-SP
LST:CVT.LST/-SP
LST:R502A.LST/-SP
LST:UNFSS.LST/-SP
LST:GETLIN.LST/-SP
LST:SAVREG.LST/-SP
LST:PROMPT.LST/-SP
LST:SETPRV.LST/-SP
LST:CHKPRV.LST/-SP
LST:MUTEXC.LST/-SP
$ _EOD

$! Create the PBSLIB object library
$ _RUN LIB:LBR
SYSTEM:PBSLIB/CR=SYSTEM:NUM
SYSTEM:PBSLIB=SYSTEM:BLDPPN
SYSTEM:PBSLIB=SYSTEM:CLRFQX
SYSTEM:PBSLIB=SYSTEM:PRINT
SYSTEM:PBSLIB=SYSTEM:CVT
SYSTEM:PBSLIB=SYSTEM:R502A
SYSTEM:PBSLIB=SYSTEM:UNFSS
SYSTEM:PBSLIB=SYSTEM:GETLIN
SYSTEM:PBSLIB=SYSTEM:SAVREG
SYSTEM:PBSLIB=SYSTEM:PROMPT
SYSTEM:PBSLIB=SYSTEM:SETPRV
SYSTEM:PBSLIB=SYSTEM:CHKPRV
SYSTEM:PBSLIB=SYSTEM:MUTEXC
$ _EOD

$! Cleanup PBSLIB library operation
$ _RUN LIB:PIP
SYSTEM:PBSLIB.OLB<40>/MO:64=SYSTEM:PBSLIB.OLB
SYSTEM:NUM.OBJ/DE
SYSTEM:BLDPPN.OBJ/DE
SYSTEM:CLRFQX.OBJ/DE
SYSTEM:PRINT.OBJ/DE
SYSTEM:CVT.OBJ/DE
SYSTEM:R502A.OBJ/DE
SYSTEM:UNFSS.OBJ/DE
SYSTEM:GETLIN.OBJ/DE
SYSTEM:SAVREG.OBJ/DE
SYSTEM:PROMPT.OBJ/DE
SYSTEM:SETPRV.OBJ/DE
SYSTEM:CHKPRV.OBJ/DE
SYSTEM:MUTEXC.OBJ/DE
$ _EOD

$  MAIN:
$ _IF F$INSTR(1,P1,"NOMAIN") .NE. 0 THEN _GOTO TKB
$! Assemble all components of PBS
$ _RUN LIB:MAC
SYSTEM:SKED,LST:SKED/-SP/CR=SYSTEM:SKED
SYSTEM:SKDINI,LST:SKDINI/-SP/CR=SYSTEM:SKDINI
SYSTEM:SKDPMD,LST:SKDPMD/-SP/CR=SYSTEM:SKDPMD
SYSTEM:SKDJOB,LST:SKDJOB/-SP/CR=SYSTEM:SKDJOB
SYSTEM:RMSORG,LST:RMSORG/-SP/CR=SYSTEM:RMSORG
SYSTEM:RMSOPN,LST:RMSOPN/-SP/CR=SYSTEM:RMSOPN
SYSTEM:RMSCLS,LST:RMSCLS/-SP/CR=SYSTEM:RMSCLS
SYSTEM:RMSGET,LST:RMSGET/-SP/CR=SYSTEM:RMSGET
SYSTEM:XMIT,LST:XMIT/-SP/CR=SYSTEM:XMIT
SYSTEM:PRTSER,LST:PRTSER/-SP/CR=SYSTEM:PRTSER
SYSTEM:BATSER,LST:BATSER/-SP/CR=SYSTEM:BATSER
SYSTEM:QMAN,LST:QMAN/-SP/CR=SYSTEM:QMAN
SYSTEM:QMINIT,LST:QMINIT/-SP/CR=SYSTEM:QMINIT
SYSTEM:QMCMD,LST:QMCMD/-SP/CR=SYSTEM:QMCMD
SYSTEM:QMURP,LST:QMURP/-SP/CR=SYSTEM:QMURP
SYSTEM:QMUTIL,LST:QMUTIL/-SP/CR=SYSTEM:QMUTIL
SYSTEM:SNDOMS,LST:SNDOMS/-SP/CR=SYSTEM:SNDOMS
SYSTEM:MSGSER,LST:MSGSER/-SP=SYSTEM:MSGSER
SYSTEM:GETTXT,LST:GETTXT/-SP/CR=SYSTEM:GETTXT
SYSTEM:CHRGEN,LST:CHRGEN/-SP/CR=SYSTEM:CHRGEN
SYSTEM:CHARS,LST:CHARS/-SP=SYSTEM:CHARS
$ _EOD

$! Cref the listings of PBS
$ _RUN SYSTEM:BCRF
LST:SKED.LST/-SP
LST:SKDINI.LST/-SP
LST:SKDPMD.LST/-SP
LST:SKDJOB.LST/-SP
LST:RMSORG.LST/-SP
LST:RMSOPN.LST/-SP
LST:RMSCLS.LST/-SP
LST:RMSGET.LST/-SP
LST:XMIT.LST/-SP
LST:PRTSER.LST/-SP
LST:BATSER.LST/-SP
LST:QMAN.LST/-SP
LST:QMINIT.LST/-SP
LST:QMCMD.LST/-SP
LST:QMURP.LST/-SP
LST:QMUTIL.LST/-SP
LST:SNDOMS.LST/-SP
LST:GETTXT.LST/-SP
LST:CHRGEN.LST/-SP
;CHARS is too big to Cref !!!!
$ _EOD

$  TKB:
$ _IF F$INSTR(1,P1,"NOTKB") .NE. 0 THEN _GOTO END
$! Task Build the RMS resident library version of PBS
$ _RUN LIB:TKB
@SYSTEM:PBS

$! Task Build the RMS disk library (overlaid) version of PBS
$ _RUN LIB:TKB
@SYSTEM:PBSOVR

$! Task Build the debugger version of PBS
$ _RUN LIB:TKB
@SYSTEM:PBSDBG

$! Cref the taskbuild maps
$ _RUN SYSTEM:BCRF
LST:PBS.MAP
LST:PBSOVR.MAP
LST:PBSDBG.MAP
$ _EOD

$!  Build PBS error file PBSERR.ERR
$ _BASIC/BPLUS
RUN SYSTEM:PBSERR.BAS
SYSTEM:PBSERR.TXT
SYSTEM:PBSERR.ERR
$ _EOD
$ _SET JOB/KEYBOARD=DCL

$  END:
$! PBS build complete
$ _EXIT
