$ ! OMSBLD.COM
$ ! Build the V10.0 Operator/Message Services (OMS) Package

$ ! Parameters:
$ !	P1	= OMSMGR parameter list (NOMGR,DBG,NOMAC,NOB2S,NOTKB)
$ !	P2	= OMSTSK parameter list (NOTSK,DBG,NOMAC,NOB2S,NOTKB)
$ !	P3	= OMSSUB parameter list (NOSUB)
$ !	P4	= Alternate account to use for private build

$ ! Init error handling
$  STATUS = "in error"
$  EXIT_STATUS = 2
$ _ON ERROR THEN _GOTO END

$ ! Defaults for parameters
$ ! Ensure parameters are uppercase
$  P1 = F$EDIT(P1,32)
$  P2 = F$EDIT(P2,32)
$  P3 = F$EDIT(P3,32)

$ ! Assign user logicals
$ _DEASSIGN/ALL
$ _ASSIGN D:[1,1] LB
$ _IF P4 .nes. "" THEN GOTO PRIVATE_BUILD
$ _ASSIGN D:[170,106] SYSTEM
$ _ASSIGN D:[170,106] LST
$ _GOTO SYSTEM_LOGICALS

$PRIVATE_BUILD:
$ ! Assign user specified logicals
$ _ASSIGN 'P4' SYSTEM				! Allow a different source acct
$ _ASSIGN 'P4' LST				! Allow a different list acct

$SYSTEM_LOGICALS:
$ ! Assign system logicals
$ _IF F$PARSE("LIB:",,"STATUS") .EQ. 0 THEN _ASSIGN/SYSTEM/NOREP D:[1,2]    LIB
$ _IF F$PARSE("CMN:",,"STATUS") .EQ. 0 THEN _ASSIGN/SYSTEM/NOREP D:[170,0]  CMN
$ _IF F$PARSE("CUI:",,"STATUS") .EQ. 0 THEN _ASSIGN/SYSTEM/NOREP D:[170,19] CUI

$ ! Set default protection code
$ _SET PROTECTION/DEFAULT 40

$ ! Define BASIC command
$  BASIC = "BASIC/NOWAR/NOFLA/CHA/LIS=LST:/CRO:NOKEY"
$ _IF F$INSTR(1,P3,"NOSUB") .NE. 0 THEN _GOTO BLDMGR
$ _IF P3 .EQS. "" THEN P3 = "FORMAT,SYSIO,GETDAT"

$GETDAT:
$ _IF F$INSTR(1,P3,"GETDAT") .EQ. 0 THEN _GOTO SYSIO
$ _CCL MAC SYSTEM:GETDAT,SYSTEM:GETDAT/CR/-SP=SYSTEM:GETDAT
$ _RUN LIB:CRF
LST:GETDAT.LST

$SYSIO:
$ _IF F$INSTR(1,P3,"SYSIO") .EQ. 0 THEN _GOTO FORMAT
$ _CCL MAC SYSTEM:SYSIO,SYSTEM:SYSIO/CR/-SP=SYSTEM:SYSIO
$ _RUN LIB:CRF
LST:SYSIO.LST

$FORMAT:
$ _IF F$INSTR(1,P3,"FORMAT") .EQ. 0 THEN _GOTO BLDMGR
$  BASIC SYSTEM:FORMAT/OBJECT=SYSTEM:

$BLDMGR:
$ _IF F$INSTR(1,P1,"NOMGR") .NE. 0 THEN _GOTO BLDOMS
$ _IF P1 .EQS. "" -
   THEN P1 = "OMSMGR,SHOOMS,SHOREQ,MGRREQ,MGRREP,MGRRCV," -
	+ "MGRSND,STPOMS,SETOMS,PRIVED,STROMS,VMSCMD"

$ ! Build the command interpreter OMSMGR.TSK
$ _ON ERROR THEN _GOTO MGREND

$ _IF F$INSTR(1,P1,"NOMAC") .NE. 0 THEN _GOTO MGRB2S

$ ! Assemble .MAC files
$ _CCL MAC SYSTEM:OMSCUI,LST:OMSCUI/CR/-SP=SYSTEM:OMSCUI
$ _CCL MAC SYSTEM:OMSKEY,LST:OMSKEY/CR/-SP=SYSTEM:OMSKEY
$ _CCL MAC SYSTEM:OMSSUB,LST:OMSSUB/CR/-SP=SYSTEM:OMSSUB
$ _CCL MAC SYSTEM:GETREQ,LST:GETREQ/CR/-SP=SYSTEM:GETREQ

$ ! CREF the .LST files
$ _RUN LIB:CRF
LST:OMSCUI.LST
LST:OMSKEY.LST
LST:OMSSUB.LST
LST:GETREQ.LST

$MGRB2S:
$ _IF F$INSTR(1,P1,"NOB2S") .NE. 0 THEN _GOTO MGRTKB
$ _IF F$INSTR(1,P1,"NOBP2") .NE. 0 THEN _GOTO MGRTKB

$ ! Compile .BP2 files
$  VAR = 2					! Variant for OMSMGR
$  BLDTYP = "/NOLIN"				! Don't save line #'s
$ _IF F$INSTR(1,P1,"DBG") .NE. 0 THEN VAR = VAR .or. 1
$ _IF F$INSTR(1,P1,"DBG") .NE. 0 THEN BLDTYP = "/DEB/LIN/LIS=LST:"
$ _IF F$INSTR(1,P1,"PRIVED") .EQ. 0 THEN _GOTO MGRRCV
$  BASIC'BLDTYP'/VAR='VAR' SYSTEM:PRIVED/OBJ=SYSTEM:

$MGRRCV:
$ _IF F$INSTR(1,P1,"MGRRCV") .EQ. 0 THEN _GOTO MGRSND
$  BASIC'BLDTYP'/VAR='VAR' SYSTEM:MGRRCV/OBJ=SYSTEM:

$MGRSND:
$ _IF F$INSTR(1,P1,"MGRSND") .EQ. 0 THEN _GOTO VMSCMD
$  BASIC'BLDTYP'/VAR='VAR' SYSTEM:MGRSND/OBJ=SYSTEM:

$VMSCMD:
$ _IF F$INSTR(1,P1,"VMSCMD") .EQ. 0 THEN _GOTO STPOMS
$  BASIC'BLDTYP'/VAR='VAR' SYSTEM:VMSCMD/OBJ=SYSTEM:

$STPOMS:
$ _IF F$INSTR(1,P1,"STPOMS") .EQ. 0 THEN _GOTO SETOMS
$  BASIC'BLDTYP'/VAR='VAR' SYSTEM:STPOMS/OBJ=SYSTEM:

$SETOMS:
$ _IF F$INSTR(1,P1,"SETOMS") .EQ. 0 THEN _GOTO OMSMGR
$  BASIC'BLDTYP'/VAR='VAR' SYSTEM:SETOMS/OBJ=SYSTEM:

$OMSMGR:
$ _IF F$INSTR(1,P1,"OMSMGR") .EQ. 0 THEN _GOTO SHOOMS
$  BASIC/VAR='VAR' SYSTEM:OMSMGR/OBJ=SYSTEM:/LINE	!Need /LINE

$SHOOMS:
$ _IF F$INSTR(1,P1,"SHOOMS") .EQ. 0 THEN _GOTO SHOREQ
$  BASIC'BLDTYP'/VAR='VAR' SYSTEM:SHOOMS/OBJ=SYSTEM:

$SHOREQ:
$ _IF F$INSTR(1,P1,"SHOREQ") .EQ. 0 THEN _GOTO MGRREQ
$  BASIC'BLDTYP'/VAR='VAR' SYSTEM:SHOREQ/OBJ=SYSTEM:

$MGRREQ:
$ _IF F$INSTR(1,P1,"MGRREQ") .EQ. 0 THEN _GOTO MGRREP
$  BASIC'BLDTYP'/VAR='VAR' SYSTEM:MGRREQ/OBJ=SYSTEM:

$MGRREP:
$ _IF F$INSTR(1,P1,"MGRREP") .EQ. 0 THEN _GOTO STROMS
$  BASIC'BLDTYP'/VAR='VAR' SYSTEM:MGRREP/OBJ=SYSTEM:

$STROMS:
$ _IF F$INSTR(1,P1,"STROMS") .EQ. 0 THEN _GOTO MGRTKB
$  BASIC'BLDTYP'/VAR='VAR' SYSTEM:STROMS/OBJ=SYSTEM:

$MGRTKB:
$ _IF F$INSTR(1,P1,"NOTKB") .NE. 0 THEN _GOTO MGR_OK
$ ! Task-build OMSMGR
$ _RUN LIB:TKB
@SYSTEM:OMSMGR

$ ! CREF the .MAP files
$ _RUN LIB:CRF
LST:OMSMGR.MAP

$ ! Set the .TSK file to be privileged
$ _SET PROTECTION=232 SYSTEM:OMSMGR.TSK

$MGR_OK:
$ ! Show success status
$  STATUS = "successfully"

$ ! Broadcast completion status and exit
$MGREND:
$  EXIT_STATUS = $SEVERITY
$  MSG = "OMSMGR build completed ''STATUS'"
$ _IF F$ACCESS() .EQS. "BATCH" THEN _BROADCAST/NOHEADER [] "''MSG'"
$ _WRITE 0 MSG

$BLDOMS:
$ _IF F$INSTR(1,P2,"NOTSK") .NE. 0 THEN _GOTO EXIT
$ _IF P2 .EQS. "" -
   THEN P2 = "OMS,OMSINI,OMSREP,BRDCST,SLEEPR,SNDCFM"
$  P2 = P2 + ","	! Add "," in case "OMS" is at end of text

$ ! Build the main OMS program OMS.TSK
$  STATUS = "in error"
$ _ON ERROR THEN _GOTO OMSEND

$ _IF F$INSTR(1,P2,"NOMAC") .NE. 0 THEN _GOTO OMSB2S

$ ! Assemble .MAC files
$ _CCL MAC SYSTEM:RECV,LST:RECV/CR/-SP=SYSTEM:RECV
$ _CCL MAC SYSTEM:PUTREQ,LST:PUTREQ/CR/-SP=SYSTEM:PUTREQ
$ _CCL MAC SYSTEM:ORPARS,LST:ORPARS/CR/-SP=SYSTEM:ORPARS

$ ! CREF the .LST file
$ _RUN LIB:CRF
LST:RECV.LST
LST:PUTREQ.LST
LST:ORPARS.LST

$OMSB2S:
$ _IF F$INSTR(1,P2,"NOB2S") .NE. 0 THEN _GOTO OMSTKB
$ _IF F$INSTR(1,P2,"NOBP2") .NE. 0 THEN _GOTO OMSTKB

$ ! Compile .BP2 files
$  VAR = 4					! Variant for OMS
$  ! VAR = 5					! Variant for OMS
$  BLDTYP = "/NOLIN"
$ _IF F$INSTR(1,P2,"DBG") .NE. 0 THEN VAR = VAR .or. 1
$ _IF F$INSTR(1,P2,"DBG") .NE. 0 THEN BLDTYP = "/DEB/LIN/LIS=LST:"

$OMSINI:
$ _IF F$INSTR(1,P2,"OMSINI") .EQ. 0 THEN _GOTO OMSREP
$  BASIC'BLDTYP'/VAR='VAR' SYSTEM:OMSINI/OBJ=SYSTEM:

$OMSREP:
$ _IF F$INSTR(1,P2,"OMSREP") .EQ. 0 THEN _GOTO BRDCST
$  BASIC'BLDTYP'/VAR='VAR' SYSTEM:OMSREP/OBJ=SYSTEM:

$BRDCST:
$ _IF F$INSTR(1,P2,"BRDCST") .EQ. 0 THEN _GOTO SLEEPR
$  BASIC'BLDTYP'/VAR='VAR' SYSTEM:BRDCST/OBJ=SYSTEM:

$SLEEPR:
$ _IF F$INSTR(1,P2,"SLEEPR") .EQ. 0 THEN _GOTO SNDCFM
$  BASIC'BLDTYP'/VAR='VAR' SYSTEM:SLEEPR/OBJ=SYSTEM:

$SNDCFM:
$ _IF F$INSTR(1,P2,"SNDCFM") .EQ. 0 THEN _GOTO OMS
$  BASIC'BLDTYP'/VAR='VAR' SYSTEM:SNDCFM/OBJ=SYSTEM:

$OMS:
$  ! "OMS," is used here to distinguish it from OMSREP and OMSINI
$ _IF F$INSTR(1,P2,"OMS,") .EQ. 0 THEN _GOTO OMSTKB
$  BASIC'BLDTYP'/VAR='VAR'/LINE SYSTEM:OMS/OBJ=SYSTEM:		!Need /LINE

$OMSTKB:
$ _IF F$INSTR(1,P2,"NOTKB") .NE. 0 THEN _GOTO OMS_OK

$ ! Task-build OMS.TSK
$ _RUN LIB:TKB
@SYSTEM:OMS

$ ! CREF the .MAP files
$ _RUN LIB:CRF
LST:OMS.MAP

$OMS_OK:
$ ! Show success status
$  STATUS = "successfully"

$ ! Broadcast completion status and exit
$OMSEND:
$  EXIT_STATUS = $SEVERITY
$  MSG = "OMSTSK build completed ''STATUS'"
$ _IF F$ACCESS() .EQS. "BATCH" THEN _BROADCAST/NOHEADER [] "''MSG'"
$ _WRITE 0 MSG
$ _GOTO EXIT

$ ! Broadcast completion status and exit
$END:
$  MSG = "OMSBLD command file completed ''STATUS'"
$ _IF F$ACCESS() .EQS. "BATCH" THEN _BROADCAST/NOHEADER [] "''MSG'"
$ _WRITE 0 MSG
$EXIT:
$ _EXIT EXIT_STATUS
