/*

	dgr.h

	Definitions for x35 esqape sequence generation

	Jan Tjernberg

	1984-06-06

	1984-06-19	Definitions for abc806, by LM.

*/

#define	_PI_	3.141592653589793	/* This is pi */

#ifdef ESCGR
extern int _elen;
extern char * _ep;
extern char *egen();

extern double sin(),cos();

#define	grline(x,y,pnr,cnr)	_ep=egen(4,'d',x,y,pnr,cnr);\
				write(1,_ep,_elen)

#define grpos(x,y)		_ep=egen(2,'m',x,y);\
				write(1,_ep,_elen)
#define grdot(x,y,op,cnr)	_ep=egen(4,'p',x,y,op,cnr);\
				write(1,_ep,_elen)

#define grfill(x,y,pnr,cnr)	_ep=egen(4,'f',x,y,pnr,cnr);\
				write(1,_ep,_elen)

#define grpaint(x,y,pnr,cnr)	_ep=egen(4,'F',x,y,pnr,cnr);\
				write(1,_ep,_elen)

#define grcseg(x,y,len,pnr,cnr)	_ep=egen(5,'a',x,y,len,pnr,cnr);\
				write(1,_ep,_elen)

#define	grfg(index,colour)	_ep=egen(3,'C',1,index,colour);\
				write(1,_ep,_elen)

#define	grfgship()		_ep=egen(1,'C',4);\
				write(1,_ep,_elen)

#define	grarc(x,y,r,fi,theta,p,c) _ARC((x),(y),(r),(fi),(theta),(p),(c));

#define	grwidth(width)		_ep=egen(2,'C',3,width);\
				write(1,_ep,_elen)

#define	grpict(draw,show)	_ep=egen(3,'C',2,draw,show);\
				write(1,_ep,_elen)

#define	grfgctl(fgctl)		_ep=egen(2,'C',5,fgctl);\
				write(1,_ep,_elen)

#define	grpattern(pnr,m1,m2,shft,op)	_ep=egen(5,'R',pnr,m1,m2,shft,op);\
					write(1,_ep,_elen)

#endif
