/*
 *	Machine dependent parameters
 */

#define	XC_CPUTYPE		(XC_68K|XC_BSWAP)
#define	TEXTPAD		2	/* Extra bytes for instruction pre-fetch */

#define	PAGESIZE	0x0800		/* Size in bytes of one page */
#define	PAGESHIFT	11		/* Log (base 2) PAGESIZE */
#define	SEGSIZE		0x8000		/* Size in bytes of one segment */
#define	SEGSHIFT	15		/* Log (base 2) SEGSIZE */
#define	PAGESPERSEG	16		/* Number of pages per segment */
#ifdef	DS90M10
#define	SYSINFO	"ABCenix","",VERSION,RELEASE,0,0,0,0,0,"M68010"
#define	SEGSPERCONTEXT	64		/* Number of segments per context */
#define	NPAGEBLK	62		/* Number of page blocks */
#define	SZPLTAB		4096		/* Size of page list table */
#endif
#ifdef	DS60M10
#define	SYSINFO	"D60nix","",VERSION,RELEASE,0,0,0,0,0,"M68010"
#define	SEGSPERCONTEXT	128		/* Number of segments per context. */
#define	NPAGEBLK	128		/* Number of page blocks. */
#define	SZPLTAB		2048		/* Size of page list table. */
#endif
#ifdef	X35
#define	SYSINFO	"ABCenix","",VERSION,RELEASE,0,0,0,0,0,"M68008"
#define	SEGSPERCONTEXT	32		/* Number of segments per context */
#define	NPAGEBLK	64		/* Number of page blocks */
#define	SZPLTAB		512		/* Size of page list table */
#define	IOPPHY	(laddr_t)0x1fe000	/* Physical address of io pages */
#define	IOPSIZE		0x2000		/* Size of io page */
#define	SIOPLAD	(laddr_t)0x7e000	/* Logical address of io page in system */
#define	NGRAPHSEG	4
#define	GRAPHSEG	(0x40000 >> 15)
#define	IOBPAGENO	UPAGENO+6
#define	IOBPAGEA	(IOBPAGENO << PAGESHIFT)
#endif

#define	UPAGENO		242		/* Logical number of upage */
#define	UPAGEA		(UPAGENO << PAGESHIFT)
					/* Virtual address of UPAGE */

/*	Logical address and size when mapping io page and grafic to user */
#define	UGRAFLAD (laddr_t)0x40000	/* Logical address of grafic memory */
#define	UGRAFSIZ	0x20000		/* Size of grafic memory */
#define	UIOSLAD	(laddr_t)0x78000	/* Logical address of io seg. for user*/
#define	UIOSSIZ		0x8000		/* Size of io segment */
#define	UIOPLAD	(laddr_t)0x7e000	/* Logical address for io page for user */
#define	UIOBLAD	(laddr_t)0x7c000	/* Logical address for io buffer for user */

/*	Pages to bytes ( 2k pages */
#define	ptob(x) ((x)<<PAGESHIFT)

/*	Bytes to pages ( 2k pages */
#define	btop(x) (((unsigned) (x) + (PAGESIZE-1)) >> PAGESHIFT)

/*	Bytes to page number ( 2k pages ) */
#define	btopn(x) (((unsigned) (x) ) >> PAGESHIFT)

/*	Address (long) to page (int) */
#define	atopn(x) ((int)( ((long) (x) ) >> PAGESHIFT ))

/*  Address (32 bit ) to offset in page ( get bits 0-11 ) */
#define	atoo(x)	((int) ((x) & (PAGESIZE-1)))

/*	Pages to segments */
#define	ptoseg(x) (((x) + 15) >> (SEGSHIFT-PAGESHIFT))

/*	Page register to long address */
#define	ptol(x) ((long)((int)(x) & 0x01fff) << PAGESHIFT)

/* Text address used at U-page swap */
#define TEXTBASE	((laddr_t) 0)
#define	INVDSTADR(dst,tst,tsz)	(((int) (dst) & (SEGSIZE-1)) != 0 || \
				btopn(dst) < (btop(tsz) + btopn(tst)))
#define	USERSTACK	((laddr_t) (PAGESIZE*PAGESPERSEG*SEGSPERCONTEXT))
/* Check for invalid load start address */
#define	INVLSTADR(x)	(((int) (x) & (SEGSIZE-1)) != 0)
#define INITSADR	u.u_core.c_ar0[UPC] = exdata.x_entry & ~01

#define	SMODE		0x2000		/* System mode bit */
#define	USERMODE(sr)	(((sr) & SMODE) != SMODE)

#define	INTPRI		0x0700
#define	USERPRI(sr)	(((sr) & INTPRI) == 0)

#define	NSAVEREG	17		/* Number of registers to save */
#define	NREGPAR		0		/* Number of parameters in register */

#define	NBPW	sizeof(int)	/* Number of bytes in an interegr */
#define	INTBOUND 2		/* Boundary on which integer must start */

#define	SSIZE	1024		/* Initiale stack size */
#define	SINCR	2048		/* Stack increment in bytes */
#define	USIZE	1		/* Size of user block is one page */
#define	UBYTES	ptob(USIZE)	/* Number of bytes from &u to end of upage */

#define	ARGBSIZE	512	/* Size of argument buffer (inside u-page) */

#define	DHZ	50		/* Ticks/second of the clock */

/*
 *	Definitions for blocks
 */
#define	BSIZE	512		/* Size of block in bytes */
#define	BMASK	0777		/* BSIZE - 1 */
#define	BSHIFT	9		/* LOG2(BSIZE) */

#define	CBSIZE	12		/* Number of chars in clist block */
#define	CROUND	0x0f		/* Clist rounding:sizeof(int *)+CBSIZE-1 */

/*
 * 	Device definitions
 */

/* Major part of device */
#define	major(x)	(int)(((unsigned)(x)>>8) & 0x1f)
/* Minor part of device */
#define	minor(x)	(int)((x)&0377)
/* Convert major and minor to device number */
#define	makedev(x,y)	(dev_t)((x)<<8 | (y))
