
/* 
 * Request sent from A-side to B-side
 * 	*/
struct omsg {
	char om_thdr ;		/* Transport level header byte	*/
	unsigned char om_chnum ;		/* Channel id	*/
	unsigned char om_fc ;		/* Remote function code	*/
	unsigned char om_fd ;		/* Remote file descriptor	*/
	long om_bc ;		/* Byte count	*/
	long om_bsize ;		/* Buffer size	*/
	long om_upar ;		/* User par or random address	*/
	long om_nph,om_npl ;	/* Network wide requester id	*/
	union	{
		struct {
			short omun_uid, omun_gid ;
			char omun_mytwist ;
			char omun_debug ;
		} omu_norm ;
		struct {
			unsigned long omus_m[2] ;
		} omu_spec ;
	} om_u ;
} ;
#define	TWNORM	"4c5lss"
#define	TWSPEC	"4c7l"

/* 
 * Reply sent from B-side to A-side upon request complete
 * 	*/
struct imsg {
	char im_thdr ;		/* Transport level header	*/
	unsigned char im_chnum ;		/* channel id 	*/
	unsigned char	im_1,im_2 ;		/* spare */
	long im_kpar ;		/* Open privileges, append address	*/
	long im_rpar ;		/* Return parameter	*/
} ;
#define	TWREPLY	"4cll"

/* Direction bits in chnum call	*/
#define DATAOUT	1
#define	DATATWIST	0x20	/* Data should be twisted on b side
				 * also selects special format of
				 * om_u	*/
#define	DATAIN		0x40
#define DATARND		0x80	/* Random address in request	*/
#define	CHMSK		0x1f	/* Channel number mask	*/

/* Error values from B-side to A-side	*/
#define	Erabuf	(-900)		/* Cannot allocate buffer	*/
#define	Eseq	(-901)		/* Sequence error	*/
#define Ebcnt	(-902)		/* Request overflows buffer	*/

/* Special function codes used only over the net	*/
#define F_uxlate	253	/* Uid info translation	*/
#define	F_stat		254	/* Stat request with translation */
#define	F_symstat	255	/* Stat - symbolic version	*/
/*
 *	Symbolic stat stuff.
 */
#define	NIO_SYMSTAT	('n'<<8 | 100)
#define	SY_IDLEN	20

#define	Devxlate	"/tmp/rdevxlate"
#define	Defuname	"netxqt"
#define	Defgname	"other"

struct symstat	{
	unsigned short	sy_dev ;
	unsigned short	sy_ino ;	/* Not twisted to match dir entry */
	unsigned short	sy_mode ;
	unsigned short	sy_nlink ;
	unsigned short	sy_rdev ;
	unsigned short	sy_1 ;		/* Pad to make align 4 */
	long	sy_size ;
	long	sy_atime ;
	long	sy_mtime ;
	long	sy_ctime ;
	char	sy_sysname[SY_IDLEN] ;
	char	sy_uname[SY_IDLEN] ;
	char	sy_gname[SY_IDLEN] ;
} ;
#define	TWSYST	"s2c4s4l"
