/*  bm# 0000003654
/*  typ C
/*  ver 68k.paged
/*  mod steel
*/ 
/*
 *	SCCSID(@(#)VIA.h	1.1);
 */



/*
 * Copyright (C) Microsoft Corporation, 1982
 *
 *  	nsw may 1984 
 *	- created to conform to the 3.0 standard
 *	  formerly part of systm.h
 */

/*
 * Instrumentation
 *
 *      The following cells are used by
 *              iostat.c
 *              systat.c
 *              disk device drivers (optional)
 *
 *      This instrumentation is very rudimentary and inflexible.
 *      It currently allows the monitoring of up to 3 independent units:
 *      there needs to be magic code in the device drivers to divvy up
 *      those three into three different disks devices, three units
 *      of one kind, or whatever.
 *
 *      Whenever each unit is busy, its corresponding bit (01, 02, or 04)
 *      is set in dk_busy.  The driver also should accumulate the
 *      number of transfers performed in dk_numb[unit], and
 *      the number of words transfered in dk_wds[unit].
 *
 *      clock.c increments one cell in dk_time[] depending upon which
 *      of the three units are active (8 possibilities) and upon
 *      whether we're in user or system mode, niced or idle (4 choices)
 *
 *      The structure of dk_time is:
 *
 *      {  long usermode[8],            /* in user mode
 *         long usernice[8],            /* in user mode, nice priority
 *         long sysmode [8],            /* in system mode
 *         long sysidle [8]; }          /* in the idle loop
 *
 *      Programs like systat and iostat can sum these numbers and
 *      extract both disk performance data and the amount of time spent
 *      with the cpu assigned to user, nice, or system, as well as
 *      idle time.  Note that dk_time[24+0] counts system totally idle
 *      time, dk_time[24+1] to dk_time[24+7] count "wasted" time:
 *      time where the cpu was idle waiting for I/O to complete.
 */
short   dk_busy;
long    dk_time[32];
long    dk_numb[3];
long    dk_wds[3];
long    tk_nin;
long    tk_nout;


/************************************************************************
*
*  L001 - clock definitions to allow machdep.c to set/reset the clock
*
************************************************************************/

#define	VIA	((char *) 0xfd9000)
#define	ORB_IRB	0x01	/* Offsets for various things on chip */
#define	ORA_IRA	0x03
#define DDRB	0x05
#define	DDRA	0x07
#define T1C_L	0x09
#define T1C_H	0x0B
#define T1L_L	0x0D
#define T1L_H	0x0F
#define T2L_L	0x11
#define T2C_L	T2L_L
#define T2C_H	0x13
#define SHIFT_R	0x15
#define	ACR	0x17
#define PCR	0x19
#define IFR	0x1B
#define IER	0x1D
#define ORA	0x1F

#define CLOCK_INTREQ()	(VIA[IFR] & 0x80)
