/*
 *	Machine dependent parameters
 */

#define	TEXTPAD		2	/* Extra bytes for instruction pre-fetch */

#define	PAGESIZE	0x0800		/* Size in bytes of one page */
#define	PAGESHIFT	11		/* Log (base 2) PAGESIZE */
#define	SEGSIZE		0x8000		/* Size in bytes of one segment */
#define	SEGSHIFT	15		/* Log (base 2) SEGSIZE */
#define	PAGESPERSEG	16		/* Number of pages per segment */
#ifdef	M68010
#define	SEGSPERCONTEXT	64		/* Number of segments per context */
#else
#define	SEGSPERCONTEXT	32		/* Number of segments per context */
#endif

#define	UPAGENO		242		/* Logical number of upage */
#define	UPAGEA		(UPAGENO << PAGESHIFT)
					/* Virtual address of UPAGE */

/*	Pages to bytes ( 2k pages */
#define	ptob(x) ((x)<<PAGESHIFT)

/*	Bytes to pages ( 2k pages */
#define	btop(x) (((unsigned) (x) + (PAGESIZE-1)) >> PAGESHIFT)

/*	Bytes to page number ( 2k pages ) */
#define	btopn(x) (((unsigned) (x) ) >> PAGESHIFT)

/*	Address (long) to page (int) */
#define	atopn(x) ((int)( ((long) (x) ) >> PAGESHIFT ))

/*  Address (32 bit ) to offset in page ( get bits 0-11 ) */
#define	atoo(x)	((int) ( (x) & 0x07ff))

/*	Pages to segments */
#define	ptoseg(x) (((x) + 15) >> (SEGSHIFT-PAGESHIFT))

/*	Page register to long address */
#define	ptol(x) ((long)((int)(x) & 0x01fff) << PAGESHIFT)

#define	TEXTSTART	((laddr_t) 0x8000)
#define	DATASTART(ts,sep)	((laddr_t) ptob(((btop(ts))+16+15) & ~15))
#define	USERSTACK	((laddr_t) (PAGESIZE*PAGESPERSEG*SEGSPERCONTEXT))

#define	SMODE		0x2000		/* System mode bit */
#define	USERMODE(sr)	(((sr) & SMODE) != SMODE)

#define	INTPRI		0x0700
#define	USERPRI(sr)	(((sr) & INTPRI) == 0)

#define	NBPW	sizeof(int)	/* Number of bytes in an interegr */
#define	INTBOUND 2		/* Boundary on which integer must start */

#define	UBASE	UPAGEA		/* Abs address of user block is top page */
#define	SSIZE	2048		/* Initiale stack size */
#define	SINCR	2048		/* Stack increment in bytes */
#define	USIZE	1		/* Size of user block is one page */
#define	UBYTES	ptob(USIZE)	/* Number of bytes from &u to end of upage */

#define	NOFILE	20		/* Max open files per process */

#define	ARGBSIZE	512	/* Size of argument buffer (inside u-page) */

#define	DHZ	50		/* Ticks/second of the clock */
#define	HZ	50		/* Same as DHZ */

/*
 *	Definitions for blocks
 */
#define	BSIZE	512		/* Size of block in bytes */
#define	BMASK	0777		/* BSIZE - 1 */
#define	BSHIFT	9		/* LOG2(BSIZE) */

#define	CBSIZE	12		/* Number of chars in clist block */
#define	CROUND	0x0f		/* Clist rounding:sizeof(int *)+CBSIZE-1 */

#define	BLKDMSK	8192

#define	mstob(x)	((x) << PAGESHIFT)
#define	mltoa(x)	((char *)mstob(x))

#include "types.h"
