;    ******************************************************
;    ******************************************************
;    ******************************************************



;                            *******  
;                            HEX.COM
;                            *******  


;                        Version:    1.00a

;                  First Written:    O5/25/88

;                  Last Modified:    12/15/89



;	STAMP:
                      VERS	EQU	'1'
                      MODIF	EQU	'00'
                      CHANG	EQU	'b'

                      MONTH	EQU	'12'
                      DAY	EQU	'15'
                      YEAR	EQU	'89'



;          ACCEPTS A KEYSTROKE INPUT FROM THE CONSOLE
;        AND OUTPUTS THE CORRESPONDING HEXADECIMAL VALUE



;                           ******
;                           SAMPLE
;                           DIALOG:
;                           ******



;	A>HEX
;
;	ASCII-TO-HEXADECIMAL TRANSLATOR
;	   (CARRIAGE-RETURN TO EXIT)
;
;            =>       B        = 42
;            =>       ?        = 3F
;            => CNTRL-C (ETX)  = 03
;            => CNTRL-M (CR)   = 0D
;                 *** EXIT ***
;
;	A>



;    ******************************************************
;    ******************************************************



;                          *********
;                          CONSTANTS:
;                          *********



;                        CP/M  SYSTEM:
;                        ----  ------


TPA	EQU	0100H
ALOAD	EQU	TPA
ABDOS	EQU	0E306H
ABIOS	EQU	0F200H
WBOOT	EQU	0F203H
BDOS	EQU	0005H
BREAK	EQU	''


;                        CHARACTER  I/O:
;                        ---------  ---


BOOT	EQU	0
INP	EQU	1
OUTP	EQU	2
LIST	EQU	5
DINP	EQU	6
PRSTR	EQU	9
XMSG	EQU	'$'
RDBUF	EQU	10
CSTAT	EQU	11


;                           UTILITY:
;                           -------


ZERO	EQU	0
OFF	EQU	ZERO
ON	EQU	0FFFFH
XCASE	EQU	ZERO


;                            ASCII:
;                            -----


NUL	EQU	00H
BEL	EQU	07H
BS	EQU	08H
LF	EQU	0AH
CR	EQU	0DH
SPACE	EQU	20H
FFEED	EQU	0CH
RUB	EQU	7FH
QMARK	EQU	'?'
HUH	EQU	QMARK
CNTRL	EQU	'^'


;                           PROGRAM:
;                           -------


LOAD	EQU	TPA

STACK	EQU	20H



;    ******************************************************
;    ******************************************************



;                           *********
;                           PROCEDURE:
;                           *********



	ORG	LOAD


ENTRY	JMP	START


;                            STAMP:
;                            -----


NAME	DB	'HEX.COM      '

VERNO	DB	' VERSION:  '
	DB	VERS,'.'
	DB	MODIF AND 0FFH
	DB	(MODIF SHR 8) AND 0FFH
	DB	CHANG

DATE	DB	' DATE:  '
	DB	MONTH AND 0FFH
	DB	(MONTH SHR 8) AND 0FFH,'/'
	DB	DAY AND 0FFH
	DB	(DAY SHR 8) AND 0FFH,'/'
	DB	YEAR AND 0FFH
	DB	(YEAR SHR 8) AND 0FFH
	DB	'   '


START	LXI	SP,SPNTR

	LXI	D,HELLO
	CALL	PRINF

MAIN	LXI	D,MSG1
	CALL	PRINF

MAIN1	CALL	GETCH
	STA	INPUT

	CPI	80H
	JM	MAIN2
	CALL	QUIZ
	CALL	BEEP
	CALL	WAIT1
	CALL	BKSPC
	JMP	MAIN1

MAIN2	CPI	CR
	JZ	EXIT

MAIN3	CPI	7FH
	JNZ	MAIN4
	LXI	D,TLAST
	CALL	PRINF
	LXI	D,MSG2
	CALL	PRINF
	JMP	MAIN8

MAIN4	CPI	SPACE+1
	JM	MAIN5
	LXI	D,MSG3
	CALL	PRINF
	CALL	ECHO
	LXI	D,MSG4
	CALL	PRINF
	JMP	MAIN8

MAIN5	LXI	H,NDTBL
	LXI	D,14

MAIN6	CPI	0
	JZ	MAIN7
	DAD	D
	DCR	A
	JMP	MAIN6

MAIN7	MOV	D,H
	MOV	E,L
	CALL	PRINF
	LXI	D,MSG2
	CALL	PRINF
	
MAIN8	LDA	INPUT
	CALL	UPHEX
	CALL	PUTCH
	LDA	INPUT
	CALL	LOHEX
	CALL	PUTCH

	CALL	CRLF
	JMP	MAIN

EXIT	CALL	QUIT



;    ******************************************************
;    ******************************************************



;                      *****************
;                      NON-DISPLAY TABLE:
;                      *****************



NDTBL	DB	'CNTRL-@ (NUL)',XMSG
	DB	'CNTRL-A (SOH)',XMSG
	DB	'CNTRL-B (STX)',XMSG
	DB	'CNTRL-C (ETX)',XMSG
	DB	'CNTRL-D (EOT)',XMSG
	DB	'CNTRL-E (ENQ)',XMSG
	DB	'CNTRL-F (ACK)',XMSG
	DB	'CNTRL-G (BEL)',XMSG
	DB	'CNTRL-H (BS) ',XMSG
	DB	'CNTRL-I (HT) ',XMSG
	DB	'CNTRL-J (LF) ',XMSG
	DB	'CNTRL-K (VT) ',XMSG
	DB	'CNTRL-L (FF) ',XMSG
	DB	'CNTRL-M (CR) ',XMSG
	DB	'CNTRL-N (SO) ',XMSG
	DB	'CNTRL-O (SI) ',XMSG
	DB	'CNTRL-P (DLE)',XMSG
	DB	'CNTRL-Q (DC1)',XMSG
	DB	'CNTRL-R (DC2)',XMSG
	DB	'CNTRL-S (DC3)',XMSG
	DB	'CNTRL-T (DC4)',XMSG
	DB	'CNTRL-U (NAK)',XMSG
	DB	'CNTRL-V (SYN)',XMSG
	DB	'CNTRL-W (ETB)',XMSG
	DB	'CNTRL-X (CAN)',XMSG
	DB	'CNTRL-Y (EM) ',XMSG
	DB	'CNTRL-Z (SUB)',XMSG
	DB	'CNTRL-[ (ESC)',XMSG
	DB	'CNTRL-\ (FS) ',XMSG
	DB	'CNTRL-] (GS) ',XMSG
	DB	'CNTRL-^ (RS) ',XMSG
	DB	'CNTRL-_ (US) ',XMSG
	DB	'  ( SPACE )  ',XMSG
TLAST	DB	'RUBOUT  (DEL)',XMSG



;                           ********
;                           MESSAGES:
;                           ********



HELLO	DB	LF,'ASCII-TO-HEXADECIMAL TRANSLATOR',CR,LF
	DB	'   (CARRIAGE-RETURN TO EXIT)',CR,LF,LF,XMSG


MSG1	DB	'     => ',XMSG

MSG2	DB	'  = ',XMSG

MSG3	DB	'      ',XMSG

MSG4	DB	'        = ',XMSG


BYE	DB	'CNTRL-M (CR)   = 0D',CR,LF,LF
	DB	'          *** EXIT ***',CR,LF,XMSG



;    ******************************************************
;    ******************************************************



;                         ***********
;                         SUBROUTINES:
;                         ***********



;                     CP/M  CHARACTER  I/O:
;                     ----  ---------  ---


QUIT	LXI	D,BYE
	CALL	PRINF
	MVI	C,BOOT
	JMP	BDOS

FETCH	PUSH	B
	PUSH	D
	PUSH	H
	MVI	C,INP
	CALL	BDOS
	POP	H
	POP	D
	POP	B
	RET

GETCH	PUSH	B
	PUSH	D
	PUSH	H

GETC1	MVI	C,DINP
	MVI	E,0FFH
	CALL	BDOS
	CPI	0
	JZ	GETC1

	POP	H
	POP	D
	POP	B
	RET

UPCAS   CPI	'a'
	RM
	CPI	'z'+1
	RP
	ANI	0DFH
        RET

LOCAS   CPI	'A'
	RM
	CPI	'Z'+1
	RP
	ORI	20H
        RET

PUTCH	
ECHO    CALL	RSAVE
	MOV	E,A
	MVI	C,OUTP
	CALL	BDOS
	CALL	RREST
	RET

PRINT	CALL	RSAVE
	MOV	E,A
	MVI	C,LIST
	CALL	BDOS
	CALL	RREST
	RET
 
PRINF	CALL	RSAVE
	MVI	C,PRSTR
	CALL	BDOS
	CALL	RREST
	RET

RSAVE	XTHL
	PUSH	A
	PUSH	B
	PUSH	D
	PUSH	H
	RET

RREST	POP	H
	POP	D
	POP	B
	POP	A
	XTHL
	RET


;                  SCREEN / PRINTER  UTILITY:
;                  ------   -------  -------


CRLF	MVI	A,CR
	CALL	PUTCH
	MVI	A,LF
	CALL	PUTCH
	RET

CRET	MVI	A,CR
	CALL	PUTCH
	RET

LFEED	MVI	A,LF
	CALL	PUTCH
	RET

BKSPC	MVI	A,BS
	CALL	PUTCH
	MVI	A,SPACE
	CALL	PUTCH
	MVI	A,BS
	CALL	PUTCH
	RET

QUIZ	MVI	A,HUH
	CALL	PUTCH
	RET

BEEP	MVI	A,BEL
	CALL	PUTCH
	RET

SPC1	MVI	A,SPACE
	CALL	PUTCH
	RET

SPC3	MVI	B,3
	CALL	SSPC
	RET

SPC5	MVI	B,5
	CALL	SSPC
	RET

SPC10	MVI	B,10
	CALL	SSPC
	RET

SSPC	CALL	PUTCH
	DCR	B
	JNZ	SSPC
	RET

WAIT1	PUSH	A			;	1-SECOND DELAY
	PUSH	B
	PUSH	H
	MVI	A,ZERO
	MVI	B,3
	LXI	H,ZERO

WTA	DCX	H
	CMP	H
	JNZ	WTA

WTB	CMP	L
	JNZ	WTA

	DCR	B
	JNZ	WTA
	POP	H
	POP	B
	POP	A
	RET

CASE	XTHL				;	GENERALIZED CASE
	MOV	B,A			;	     SWITCH
	MVI	C,1

CAS1	MOV	A,M			;	SEE "ASCII.ASM"
	CPI	XCASE			;	FOR DETAILS OF
	JZ	CAS4			;	     USAGE
	CMP	B
	JZ	CAS2
	INX	H
	INR	C
	JMP	CAS1

CAS2	MVI	A,0

CAS3	INX	H
	CMP	M
	JNZ	CAS3

CAS4	INX	H
	MOV	A,B
	XTHL
	RET


;                     HEXADECIMAL  UTILITY:
;                     -----------  -------


UPHEX	RAR
	RAR
	RAR
	RAR
	CALL	LOHEX
	RET

LOHEX	ANI	0FH
	ORI	30H
	CPI	'9'+1
	RM
	ADI	07H
	RET



;    ******************************************************
;    ******************************************************



;                             ***
;                             RAM:
;                             ***



RAM	ORG	(($ AND 0FFF0H)+10H)


INPUT	DS	1



;   ******************************************************
;   ******************************************************



;                             *****
;                             STACK:
;                             *****



	ORG	(($ AND 0FFF0H)+10H)


	DS	STACK-1

SPNTR

LAST	DS	1



;    ******************************************************
;    ******************************************************



;                         ***********
;                           ASSEMBLY
;                         TERMINATION:
;                         ***********



PSIZE	EQU	LAST-ENTRY



;    ******************************************************
;    ******************************************************
;    ******************************************************



	END	ENTRY


