                             .XLIST


                      .INSERT  SWITCHES.DEF


                              .LIST

;    **************************************************
;    **************************************************
;    **************************************************



;                       DEBUGGING SWITCH:
;                       --------- ------

	                 DEBUG  ==  ON  ; SHORTEN LISTING


;                       LISTING OPTIONS:
;                       ------- -------

	              DEFINITIONS  ==  OFF
	              MACROS       ==  OFF
                      MESSAGES     ==  OFF
	              LIBRARY      ==  OFF
	              SYMBOLS      ==  OFF

                             .XLIST


;                      ASSEMBLY CONTROLS:
;                      -------- --------

                              .PABS

                              .PHEX

                              .LADDR

                              .RADIX  16

                   .IFE  SYMBOLS - OFF, .XSYM



                              .LIST

;    **************************************************
;    **************************************************



                              .LCTL

;                            ********
	.TITLE              "LION.COM"
;                            ********

                              .XCTL


;                       Version:    1.00

;                 First Written:    05/04/90

;                 Last Modified:    05/04/90


                  .IFE  DEBUG - ON, .XLIST


;                          **********
;                          LABEL DATA:
;                          **********



                      VERSION	=       '1'
                      MODIF	=	'00'
                      CHANGE	=	' '

                      MONTH	=     	'05'
                      DAY	=	'04'
                      YEAR	=	'90'



;                            *******
;                            HISTORY:
;                            *******



;	05/04/90:  Written to get the Lion Oil source
;                  code off the "Exorciser" disks.
;		   One-shot program only.

                              .PAGE
                  .SBTTL  "SYMBOLIC CONSTANTS"

;    **************************************************
;    **************************************************



;                           *********
;                            SYMBOLIC
;                           CONSTANTS:
;                           *********



                       .INSERT  CPM.DEF


                       .INSERT  ASCII.DEF


                       .INSERT  SWITCHES.DEF


                 .IFE  DEFINITIONS - ON,  .LIST


;                      MAPPING CONSTANTS:
;                      ------- ---------


		LOAD.POINT	==	TPA

		STACK.SIZE	==	20 ; (words)


;                  SPECIAL PROGRAM CONSTANTS:
;                  ------- ------- ---------


	SRC.DRIVE            ==         03H
	SRC.TRACK            ==         0DH
	SRC.SECTOR           ==         07H
	SRC.COUNT            ==         0169H

	DST.DRIVE            ==         03H

	BIOS                 ==         0B600H

                           .RADIX   10

	SELDSK               ==         BIOS +  9 * 3
	SETTRK               ==         BIOS + 10 * 3
	SETSEC               ==         BIOS + 11 * 3
	SETDMA               ==         BIOS + 12 * 3
	READ                 ==         BIOS + 13 * 3


;                       GENERAL UTILITY:
;                       ------- -------


		BYTE.SIZE	==	1  ; bytes

		WORD.SIZE	==	2  ; bytes


                              .LIST
                              .PAGE
                    .SBTTL  "ROOT PROCEDURE"

;    **************************************************
;    **************************************************



;                          *********
;                          PROCEDURE:
;                          *********



		       .LOC   LOAD.POINT


			     FIRST:

                          JMP	START


                    .IFE  DEBUG - ON, .XLIST


;                            LABEL:
;                            -----


..NAME:
		.ASCII	'    LION.COM'
		.BYTE	END.MESSAGE

VERS.NUMBER:
		.ASCII	'Version:  '
		.BYTE	VERSION
		.BYTE	'.'
		.BYTE	MODIF / 100H
		.BYTE	MODIF @ 100H
		.BYTE	CHANGE
		.BYTE	END.MESSAGE

..DATE:
		.ASCII	'Date:  '
		.BYTE	MONTH / 100H
		.BYTE	MONTH @ 100H
		.BYTE	'/'
		.BYTE	DAY / 100H
		.BYTE	DAY @ 100H
		.BYTE	'/'
		.BYTE	YEAR / 100H
		.BYTE	YEAR @ 100H
		.BYTE	END.MESSAGE


                              .LIST


INTERLEAVE.TABLE:

	.BYTE	1, 10, 19, 2, 11, 20, 3, 12, 21, 4, 13, 22, 5
	.BYTE	14, 23, 6, 15, 24, 7, 16, 25, 8, 17, 26, 9, 18

COUNT:
	.WORD	SRC.COUNT

SOURCE:
	.BYTE	SRC.DRIVE
	.BYTE	SRC.TRACK
	.BYTE	SRC.SECTOR

			DRIVE   =  0
			TRACK   =  1
			SECTOR  =  2

FCB:
	.BYTE	DST.DRIVE
	.ASCII	'LIONOIL M68'
	.BYTE   0,0,0,0
	.BYTE	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	.BYTE   0,0,0,0

BUFFER.128:
	.BLKB	128


START:
	LXI	SP, TOP.STACK

MAIN:
	LXI	D, HELLO
	CALL	FLASH
	CALL	SPC5
	LXI	D, VERS.NUMBER
	CALL	FLASH
	CALL	CRLF
	CALL	LFEED

	LXI	X, SOURCE

OPEN.OUTPUT.FILE:

	MVI	C, 19
	LXI	D, FCB		; ERASE
	CALL	SYSTEM

	MVI	C, 22
	LXI	D, FCB		; CREATE
	CALL	SYSTEM

RAN.READ:

	LXI	H, COUNT
	MOV	A, M
	INX	H
	ORA	M
	JZ	CLOSE.FILE

	MOV	C, DRIVE(X)
	CALL	SELDSK

	MVI	B, ZERO
	MOV	C, TRACK(X)
	CALL	SETTRK

	LXI	H, INTERLEAVE.TABLE
	MVI	D, ZERO
	MOV	E, SECTOR(X)
	DCR	E
	DAD	D

	MOV	C, M
	MVI	B, ZERO
	CALL	SETSEC

	LXI	B, BUFFER.128
	CALL	SETDMA

	CALL	READ

	MOV	A, SECTOR(X)
	INR	A
	CPI	27
	JC	..SKIP

	INR	TRACK(X)
	MVI	A, 1

..SKIP:

	MOV	SECTOR(X), A
	LHLD	COUNT
	DCX	H
	SHLD	COUNT

SEQ.WRITE:

	MVI	C, 26
	LXI	D, BUFFER.128
	CALL	SYSTEM

	MVI	C, 21
	LXI	D, FCB
	CALL	SYSTEM

	JMP	RAN.READ

CLOSE.FILE:

	LXI	D, FCB
	MVI	C, 16
	CALL	SYSTEM

NORM.EXIT:

	LXI	D, GOODBYE
	CALL	FLASH

	MVI	C, WARM.BOOT
	CALL	SYSTEM

                           .RADIX   16
                  .IFE  MESSAGES - OFF,  .XLIST
                    .IFE  DEBUG - OFF,  .LIST
                              .PAGE
                       .SBTTL  "MESSAGES"

;    **************************************************
;    **************************************************



;                           ********
;                           MESSAGES:
;                           ********



HELLO:
	.BYTE	LF, LF
	.ASCII	'     LION OIL SOURCE FILE RETRIEVE'
	.BYTE	END.MESSAGE

GOODBYE:
	.ASCII  '     FILE COPIED'
	.BYTE	CR, LF, LF
	.ASCII	'     EXIT TO CP/M'
	.BYTE	CR, LF, LF
	.BYTE	END.MESSAGE
                              .PAGE
            .SBTTL  "PROGRAM FUNCTIONS & SUBROUTINES"

;    **************************************************
;    **************************************************



;                          ***********
;                          SUBROUTINES:
;                          ***********



;                           LIBRARY:
;                           -------


                      .INSERT  SAVES.LIB


                      .INSERT  CONSOLE.LIB



;   ***************************************************
;   ***************************************************



;                            *****
;                            STACK:
;                            *****



		    .LOC  ( . + 0F ) & 0FFF0


		   .BLKW	STACK.SIZE


			   TOP.STACK:



;    **************************************************
;    **************************************************



;                         ***********
;                           ASSEMBLY
;                         TERMINATION:
;                         ***********


                              .LIST


                              LAST:


                SIZE.PROGRAM   ==   LAST - FIRST



;    **************************************************
;    **************************************************
;    **************************************************



                          .END	FIRST

