;     SEARCHES MEMORY
;     FROM 0000H THROUGH FFFFH
;     FOR A STRING WHICH MATCHES
;     THE CONSTANT STRING  AT
;     ADDRESS 'STRNG'.
;
;
;   NO LONGER VALID!****       SAMPLE DIALOGUE:
;
;     A>ZDTI MSEARCH.HEX
;     -IFILENAME.TYP
;     -R
;     -GLOAD,BREAK
;     ADDRESS #1
;     ADDRESS #2
;         .
;         .
;     END OF MEMORY
;     *BREAK
;     -




TPA    EQU     0100H                   ;  CP/M  PARAMETERS
BDADR  EQU     0D600H

LOAD   EQU     TPA
PRLNG  EQU     200H                    ;  PROGRAM LENGTH
STRAD  EQU     BDADR-PRLNG

START  EQU     TPA+3                   ;  SEARCH LIMITS
STOP   EQU     STRAD-1

STACK  EQU     20H

;                             CONSTANTS:

BDOS   EQU     0005H

RETRN  EQU     00H
PRCHR  EQU     02H
PRSTR  EQU     09H
TERM   EQU     '$'
ASC9   EQU     '9'
CR     EQU     0DH
LF     EQU     0AH





       ORG     LOAD

       JMP     ENTRY




STRNG  ;                ORG     STRAD

       DB      02H                          ;  CHARACTER COUNT
       DB      18H,50H                      ;  SEARCH PATTERN




ENTRY  LXI     SP,SPNTR

       MVI     C,PRSTR
       LXI     D,MSG1
       CALL    BDOS
       LXI     H,START
       MOV     A,H
       CALL    SEND
       MOV     A,L
       CALL    SEND
       MVI     C,PRSTR
       LXI     D,MSG2
       CALL    BDOS
       LXI     H,STOP
       MOV     A,H
       CALL    SEND
       MOV     A,L
       CALL    SEND
       MVI     C,PRSTR
       LXI     D,MSG3
       CALL    BDOS

   
       LXI     H,START



SRCH   LXI     D,STRNG+1
       CALL    EQUAL
       JZ      MATCH

CONT   INX     H
       CALL    FINIS
       JNZ     SRCH

EXIT   LXI     D,MSG4
       MVI     C,PRSTR
       CALL    BDOS

       MVI     C,RETRN
       CALL    BDOS




MATCH  PUSH    H
       LXI     D,STRNG
       XCHG
       MOV     B,M
       INX     H
       XCHG

GOON   MOV     A,B
       CPI     0
       JZ      FOUND
       CALL    EQUAL
       JZ      GOON1
       POP     H
       JMP     CONT

GOON1  INX     H
       INX     D
       DCR     B
       JMP     GOON

FOUND  POP     H

       MOV     A,H                          ; DISCRIMINATE AGAINST
       CPI     ((STRNG+1)/256)              ; THE REFERENCE VALUE
       JNZ     FOUN1                        ; AT 'STRNG'
       MOV     A,L
       CPI     ((STRNG+1) AND 00FFH)

FOUN1  CNZ     PRTHL
       JMP     CONT




;                             SUBROUTINES:


EQUAL  MOV     A,M
       XCHG
       CMP     M
       XCHG
       RET


FINIS  MOV     A,H
       CPI     ((STOP+1)/256)
       RNZ
       MOV     A,L
       CPI     ((STOP+1) AND 00FFH)
       RET


PRTHL  PUSH    A
       PUSH    B
       PUSH    D
       PUSH    H

       PUSH    H
       MVI     C,PRSTR
       LXI     D,SPACE
       CALL    BDOS
       POP     H

       MOV     A,H
       CALL    SEND
       MOV     A,L
       CALL    SEND
       CALL    CRLF

       POP     H
       POP     D
       POP     B
       POP     A

       RET


SEND   PUSH    A
       ANI     0F0H
       RRC     
       RRC
       RRC
       RRC
       CALL    BCD
       CALL    OUTCH
       POP     A
       ANI     00FH
       CALL    BCD
       CALL    OUTCH
       RET


CRLF   MVI     A,CR
       CALL    OUTCH
       MVI     A,LF
       CALL    OUTCH
       RET


OUTCH  PUSH    A
       PUSH    B
       PUSH    D
       PUSH    H
  
       MOV     E,A
       MVI     C,PRCHR
       CALL    BDOS

       POP     H
       POP     D
       POP     B
       POP     A

       RET


BCD    ORI     030H
       CPI     ASC9
       RM
       RZ
       ADI     07H
       RET




;                             PROGRAM  MESSAGES:


MSG1   DB      LF,'SEARCHING FROM ',TERM

MSG2   DB      ' TO ',TERM

MSG3   DB      ':',CR,LF,TERM


MSG4   DB      'END OF USER MEMORY',CR,LF,TERM

SPACE  DB      '       ',TERM



       ORG     ($ AND 0FFF0H)+10H

       DS      STACK

SPNTR

PREND



       END     LOAD
