
                  .TITLE   "WANG.COM"



;    ****  THIS VERSION ONLY FOR THE MASTER  ****
;                       ----


;	     FILTER FOR THE WANG #2231W-1
;	     LINE PRINTER:    FILTERS OUT
;	     1 LINE-FEED AFTER AN INITIAL
;		   CR/LF SEQUENCE
;	       TO ELIMINATE INADVERTENT
;	      	   DOUBLE-SPACING.

;	      THE PRINTER PRINTS BY LINES
;	 WHENEVER A CARRIAGE-RETURN IS RECEIVED,
;	 AND AUTOMATICALLY ADVANCES TO NEXT LINE.
;	  BUT CR's ARE IGNORED IF PRINTER IS AT
;	   THE MARGIN (NO PRINTABLE CHARACTERS 
;	     RECEIVED SINCE THE LAST CR).
;	   HOWEVER, IT REACTS TO ALL LINE-FEED
;	   CHARACTERS INSTANTLY, REGARDLESS OF
;	            WHEN RECEIVED.

;	     IF IT WERE DESIRABLE TO PRODUCE
;	 SPLIT-LINE EFFECT OF A CHARACTER PRINTER
;	   IT WOULD BE NECESSARY TO MAINTAIN AN
;	    ADDITIONAL COUNTER FOR PRINTABLES.
;	  THEN WHEN AN LF WAS RECEIVED, YOU WOULD:

;	    (1) INSERT A CR IN THE PRINT STREAM
;	    (2) REGAIN CONTROL!!!
;	    (3) SEND THE LF
;	    (4) SEND THE APPROPRIATE # OF SPACES, AND
;	    (5) RESUME THE NORMAL PRINT STREAM.

;       WANG LOCATES ITSELF 100h BYTES BELOW THE CCP
;         THEN FIDDLES WITH THE BDOS JUMP AT 0006h
;            TO PROTECT ITSELF FROM OVERLAY
;                      ( I HOPE )

;            DIVERTS OUTPUT FROM THE MASTER'S
;            SPOOL INTERRUPT SERVICE ROUTINE
;                 TO PARALLEL PORT 2
;              AND FILTERS IT FOR THE WANG

;           VERSIONS 3.00 AND EARLIER FAILED
;       TO DETECT THEIR OWN PRESENCE, AND SO FAILED
;            TO REFRESH THEMSELVES PROPERLY
;            WHEN THE PROGRAM IS RE-EXECUTED.
;          VERSION 4.00 CORRECTED THIS MISTAKE.

;        VERSION 5.00 (4/26/90) PROVIDED AN ASSEMBLY
;         OPTION TO ACCOMMODATE RELEASE 7.0 MASTER

;          VERSION 6.00 (9/16/90) PROVIDES AN "off"
;         OPTION IN LIEU OF THE OLD "unwang" COMMAND
;             ALSO IMPROVED  BY CHECKING USER #
;             TO POSITIVELY IDENTIFY THE MASTER

;            VERSION 6.00b (10/13/90) REPAIRS A BUG
;              INTRODUCED AT LINE #268 ON 9/16/90 
;        IN THE COURSE OF "CLEANING UP" THE SOURCE CODE
;                - NOT DISCOVERED UNTIL LATER



;			LISTING CONTROLS:


                            .PABS
                            .PHEX
                            .XSYM

                            .RADIX	16
                            .LADDR



;                      VERSION SELECTOR:


         RELEASE.70   =\   '
			Enter 0  for Release 7.0
		      	      1  for Release 6.2

				   Version'



;			   CONSTANTS:


		   BDOS           ==    00005
                   USER.NO        ==    00047


                     .IFE   RELEASE.70,    [

LOAD		==	09C00	; 256 Bytes Below CCP
TRUE.BDOS	==	0A606
WARM.BOOT	==	0B677
SPOOL.OUT	==	0D676
                                          ] [
LOAD		==	09E00
TRUE.BDOS	==	0A706
WARM.BOOT	==	0B774
SPOOL.OUT	==	0D6D8
                                           ]

CRET		==	0D
LFEED		==	0A
HOME		==	0C
BEEP		==	07
SPACE		==	20
NULL		==	00
ZERO		==	00
CLEAR		==	00
SET		==	0FF



                         .LOC   0100


BEGIN:

                         JMP   START


PROG.ID:

	.ASCII	'     WANG.COM'

	.ASCII	'Version:   6.00b'

	.ASCII	'Date:   10/13/90'


START:

;                         SIGN-ON:

 	LXI	D, ID
	MVI	C, 9
	CALL	BDOS

;            MAKE SURE THAT THIS IS THE MASTER
;              IF NOT, GET OUT IMMEDIATELY:

	LDA	USER.NO
	CPI	00
	JRZ	OK

	LXI	D, WARNING
	MVI	C, 9
	CALL	BDOS

	JMP	EXIT

;                       ON or OFF?

OK:

	LXI	H, 5DH
	LXI	D, NO.PARAMETER
	CALL	COMPARE
	JRZ	ENABLE

	LXI	H, 5Dh
	LXI	D, OFF.PARAMETER
	CALL	COMPARE
	JRZ	DISABLE

	LXI	D, HUH
	MVI	C, 9
	CALL	BDOS

	JMPR	EXIT

NO.PARAMETER:

	.ASCII	' '
	.BYTE	0

OFF.PARAMETER:

	.ASCII	'OFF '
	.BYTE	0

;                    DISABLE THE PATCH:

DISABLE:

	LXI	H, TRUE.BDOS
	SHLD	0006
	SHLD	WARM.BOOT
	LXI	H, 02D3
	SHLD	SPOOL.OUT
	LXI	H, 00DB
	SHLD	SPOOL.OUT + 2

	LXI	D, OFF.MESSAGE
	MVI	C, 9
	CALL	BDOS

	JMPR	EXIT

ENABLE:

	LHLD	0006
	PUSH	H

;              IF PATCH IS ALREADY INSTALLED
;              REFRESH IT, IN CASE "UNDRLINE"
;                     HAS BEEN RUN:

	LXI	D, LOAD + 6
	XRA	A
	DSBC	D
	POP	H
	JRZ	CONTINUE

;                    PATCH IS NOT INSTALLED
;              ABORT UNLESS BDOS IS RECOGNIZABLE:

	LXI	D, TRUE.BDOS
	XRA	A
	DSBC	D
	JRZ	CONTINUE

	LXI	D, WRONG.VERSION
	MVI	C, 9
	CALL	BDOS

	JMPR	EXIT

CONTINUE:

	LXI	D, FIRST
	LXI	H, LOAD
	MVI	C, LAST - FIRST
	CALL	MOVE

;                     FIX WARM BOOT CODE
;                 SO THAT BDOS JUMP AT 0006h
;                 IS REFRESHED WITH INDIRECT
;                   JUMP THROUGH THE PATCH
;                 SO THAT APPLICATIONS THINK 
;                 THE BDOS IS ABOUT 2K LOWER
;                   THAN IT REALLY IS, AND
;                    DON'T TRY TO OVERLAY
;                      THE PATCH AREA:

	LXI	H, LOAD + 6
	SHLD	WARM.BOOT
	SHLD	0006

;                  THEN INSTALL THE JUMP OUT
;                   OF THE SPOOL INTERRUPT
;                      SERVICE ROUTINE
;                    TO THE PATCH ENTRY:

	MVI	A, 0C3
	STA	SPOOL.OUT
	LXI	H, LOAD + ( PATCH - FIRST )
	SHLD	SPOOL.OUT + 1

	LXI	D, ON.MESSAGE
	MVI	C, 9
	CALL	BDOS

EXIT:

;               RETURN CONTROL TO SYSTEM:

	RET



;                          MESSAGES:
;                          --------


ID:

	.BYTE	CRET, LFEED
	.ASCII	'          '
	.ASCII	'                  ** WANG.COM **'
	.BYTE	CRET, LFEED, LFEED
	.ASCII	'          '

                                .IFE   RELEASE.70,             [

	.ASCII	'         Version  6.00a   for Release 7.0'
                                                              ] [
	.ASCII	'         Version  6.00a   for Release 6.2'
                                                               ]

	.BYTE	CRET, LFEED, LFEED

	.BYTE	'$'


ON.MESSAGE:

	.ASCII	'          '
	.ASCII	'       Set Spool Filter For The Wang Printer'
	.BYTE	CRET, LFEED, LFEED

	.BYTE	'$'


OFF.MESSAGE:

	.ASCII	'          '
	.ASCII	'                Spool Filter Reset'
	.BYTE	CRET, LFEED, LFEED

	.BYTE	'$'


WARNING:

	.BYTE	BEEP
	.ASCII	'          '
	.ASCII	'***  THIS PROGRAM EXECUTES ON THE MASTER ONLY  ***'
	.BYTE	CRET, LFEED, LFEED

	.BYTE	'$'


WRONG.VERSION:

	.BYTE	BEEP
	.ASCII	'          '
	.ASCII	'           ***  WRONG HiNET VERSION  ***'
	.BYTE	CRET, LFEED, LFEED

	.BYTE	'$'


HUH:

	.BYTE	BEEP
	.ASCII	'          '
	.ASCII	'                       HUH?'
	.BYTE	CRET, LFEED, LFEED

	.BYTE	'$'



;                        SUBROUTINES:
;                        -----------


                   .LOC	(. + 000F) & 0FFF0


MOVE:

	XCHG
	MOV	A, M
	XCHG
	MOV	M, A
	INX	D
	INX	H
	DCR	C
	MOV	A, C
	ORA	A
	JRNZ	MOVE

	RET


COMPARE:

	XCHG
	MOV	A, M
	INX	H
	CPI	0
	JRZ	END.COMPARE

	XCHG
	CMP	M
	JRNZ	END.COMPARE
	INX	H
	JMPR	COMPARE

END.COMPARE:

	RET



;                      CORPUS DE PATCH:
;                      ------ -- -----


                   .LOC	(. + 000F) & 0FFF0


FIRST:

;                   MIMICS BDOS ALIGNMENT:

	.BYTE	ZERO, ZERO, ZERO
	.BYTE	ZERO, ZERO, ZERO

;                    BDOS  CONTROL POINT
;                  JUMPS TO THE TRUE BDOS:

FAKE.BDOS:

	JMP	TRUE.BDOS


;                ACTUAL ENTRY POINT TO PATCH:


PATCH:

	PUSH	X
	PUSH	PSW
	PUSH	B

	LXI	X, LOAD + ( FLAGS - FIRST )

	ANI	7F	; STRIP "UNDERSCORE" BIT WHICH
	MOV	C, A	;   PIP & WORDSTAR  TRANSMIT!

CRTEST:

	CPI	CRET
	JRNZ	LFTEST

	MOV	A, MARGFLG(X)
	CPI	SET
	JRZ	SEND

	MVI	MARGFLG(X), SET
	MVI	INHIBFLG(X), SET
	JMPR	SEND

LFTEST:

	CPI	LFEED
	JRNZ	VISIBLE

	MOV	A, INHIBFLG(X)
	CPI	CLEAR
	JRZ	SEND

	MVI	INHIBFLG(X), CLEAR
	MVI	C, NULL
	JMPR	SEND

VISIBLE:

	CPI	SPACE
	JRC	SEND

	MVI	MARGFLG(X), CLEAR

SEND:

	MOV	A, C

	OUT	02
	IN	00

	POP	B
	POP	PSW
	POP	X

	RET


;                          FLAGS:


FLAGS:

MARGIN:
	.BYTE	SET

BLOCK:
	.BYTE	CLEAR


;                  INDEX REGISTER OFFSETS:


MARGFLG		=	MARGIN - FLAGS
INHIBFLG	=	BLOCK  - FLAGS


;                     END OF PROGRAM:
;                     --- -- -------

LAST:

                       .END   BEGIN

