version	==	1
revision==	0
        .pabs
	.phex
	.title	'Print the date and time. (Set by settime & updated by BIOS).'
	.sbttl	'TIME'
	.loc	100h
	lxi	sp,stack	;stack at end of prog.
;----------
; Get the date from 44h,45h, & 46h
; and print out in months (J-F),days
; (1-31), and year (00-99).	D.Stein 09/05/80
;
month	=	44h
day	=	45h
year	=	46h
;
prtdate:
;print the date message
	lxi	H,datmsg
	call	prtmsg
;out the month,day and year (XXX-DD-YY)
	lxi	H,month
	mov	A,M	;1-12 in A
	lxi	H,Janmsg
	cpi	1	;January?
	jz	prmnth
	lxi	H,Febmsg
	cpi	2	;February?
	jz	prmnth
	lxi	H,Marmsg
	cpi	3	;March?
	jz	prmnth
	lxi	H,Aprmsg
	cpi	4	;April?
	jz	prmnth
	lxi	H,Maymsg
	cpi	5	;May?
	jz	prmnth
	lxi	H,Junmsg
	cpi	6	;June?
	jz	prmnth
	lxi	H,Julmsg
	cpi	7	;July?
	jz	prmnth
	lxi	H,Augmsg
	cpi	8	;August?
	jz	prmnth
	lxi	H,Sepmsg
	cpi	9	;September?
	jz	prmnth
	lxi	H,Octmsg
	cpi	10	;October?
	jz	prmnth
	lxi	H,Novmsg
	cpi	11	;November?
	jz	prmnth
	lxi	H,Decmsg
	cpi	12	;December?
	jz	prmnth
;error trap
	lxi	H,XXXmsg
prmnth:	call	prtmsg
;
prtday:	lxi	H,day
	mov	A,M
	call	cvtbcd
	;is leading 0 necessary?
	cpi	10
	jp	aa2
	push	PSW
	mvi	A,'0'	; out a leading 0
	call	CONOUT
	pop	PSW
	;
aa2:	call	prtbyt	; out the day
	mvi	A,'-'
	call	CONOUT	;
;
	lxi	H,year
	mov	A,M
	cpi	10	; leading 0 necessary?
	jp	aa3
	push	PSW
	mvi	A,'0'
	call	CONOUT
	pop	PSW	; leading 0 printed
aa3:	call	cvtbcd
	call	prtbyt	; date is all out.
;space down
	lxi	H,crlf
	call	prtmsg
;----------
; Print the real time (in hours and minutes and seconds)
; as represented by these bytes:
seconds	=	41h
minutes	=	42h
hours	=	43h
WBOOT	=	0
;----------
; Print the time on the DSC/3 or DSC/4.
; This program is used in conjunction with the TIMERopt
; option of the BIOS on the DSC/3 and DSC/4.
; The BIOS maintains the time in locations 40h-43h.
;
; Print the time message
	lxi	H,timmsg
	call	prtmsg
; Print the hours
	lxi	H,hours
	mov	A,M	;get hours in A
	call	cvtbcd
	;is leading 0 necessary?
	cpi	10
	jp	bb1
	push	PSW
	mvi	A,'0'
	call	CONOUT
	pop	PSW
	;
bb1:	call	prtbyt
	mvi	A,':'
	call	CONOUT	
;
; Print the minutes
prtmin:	lxi	H,minutes
	mov	A,M	;get minutes in A
	call	cvtbcd
	;is leading 0 necessary?
	cpi	10
	jp	bb2
	push	PSW
	mvi	A,'0'
	call	CONOUT
	pop	PSW
	;
bb2:	call	prtbyt
	mvi	A,':'
	call	CONOUT
;
; Print the seconds
prtsec:	lxi	H,seconds
	mov	A,M
	call	cvtbcd
	;is leading 0 necessary?
	cpi	10
	jp	bb3
	push	PSW
	mvi	A,'0'
	call	CONOUT
	pop	PSW
	;
bb3:	call	prtbyt
	jmp	WBOOT	; finished
;----------
; Print a message on the console
;  Regs in:   HL = address of string (ended by null)
;  Regs out:  none
;  Destroyed: A, HL
prtmsg:
	mov	A,M
	ora	A
	rz
	call	CONOUT
	inx	H
	jmpr	prtmsg
;----------
; Print a byte on the console
;  Regs in:   A = byte to be printed
;  Regs out:  none
;  Destroyed: A
prtbyt:
	push	PSW
	rrc
	rrc
	rrc
	rrc
	ani	0Fh	; don't print leading zeros
	jrz	..1
	call	prtnbl
..1:	pop	PSW
prtnbl:	ani	0Fh
	adi	'0'
	cpi	'9'+1
	jrc	CONOUT
	adi	'A'-('9'+1)
	jmpr	CONOUT
;----------
; Convert binary to BCD
;  Regs in:   A = byte to be converted
;  Regs out:  A = byte, in BCD format
;  Destroyed: B
cvtbcd:
	ora	A
	rz
	mov	B,A
	xra	A
..1:	inr	A
	daa
	djnz	..1
	ret
;----------
; Print a character on the console
;  Regs in:   A = character to be printed
;  Regs out:  none
;  Destroyed: C
CONOUT:
	mov	C,A
	lxi	D,09h
	lixd	WBOOT+1
	dadx	D
	pcix
;----------
; Messages
datmsg:	.asciz	'Date  '
timmsg: .asciz	'Time  '
crlf:	.asciz	[0Dh][0Ah]
janmsg:	.asciz	'Jan-'
febmsg:	.asciz	'Feb-'
marmsg:	.asciz	'Mar-'
aprmsg:	.asciz	'Apr-'
maymsg:	.asciz	'May-'
junmsg:	.asciz	'Jun-'
julmsg:	.asciz	'Jul-'
augmsg:	.asciz	'Aug-'
sepmsg:	.asciz	'Sep-'
octmsg:	.asciz	'Oct-'
novmsg:	.asciz	'Nov-'
decmsg:	.asciz	'Dec-'
XXXmsg:	.asciz	'XXX-'
	.blkb	30
stack:
.end
