.title	"Send a pattern on HiNet"
	.sbttl	"SENDPAT"
;
        .phex
	.pabs
	.loc	100h
	lxi	sp,stack ;stack at end of program
;---------------
; First determine if we have a master or user station.
;
	mvi	A,1	;turn off RTC interrupt
	out	33h
        lxi	h,crlf	;space one line
	call 	prtmsg
	lxi	h,massta 	 
	call    prtmsg	;print a message
        call	CONIN
	cpi	'N'	;is this the station
	jrz	station	;yes? do the station
;-------------
;The operator is on the master terminal
;
	lxi	H,mastmsg
	call	prtmsg	   ;print the start messaage
..loop: lxi	H,patern   ;the constant to be sent
	lxi	B,1        ;byte length 
	mvi	E,$halfms  ;maximum time for send
	lda	0A3h       ;user number
	call    SENDNET
	in      STROBE
	mvi	A,45h	   ;sync the network clock
	out	31h
	mvi	A,2
	out	31h
	jmpr    ..loop     ;do it forever
;---------------
;otherwise, we have a station
;
STATION:
;
	lxi	H,usrmsg
	call	prtmsg	   ;print the start messaage
..loop:	lxi	H,patern  ;the constant to be rec
	lxi	B,1       ;byte length
	lxi     D,$1sec   ;maximum time for rec  
	lda	0A3h      ;user number
	call	RECNET
	bit 	7,A
	jrz	..loop
	in      STROBE
	jmpr    ..loop    
.page
;----------------
; Print a message on the console
;
;  Regs in:   HL = address of string (ended by null)
;  Regs out:  none
;  Destroyed: A, HL
prtmsg:
	mov	A,M
	ora	A
	rz
	call	conslout
	inx	H
	jmpr	prtmsg
;---------------
; Print a character on the console
;  Regs in:   A = character to be printed
conslout:
	push	H
	push	D
	push	B
	mvi	C,2
	mov	E,A
	call	BDOS	; print using BDOS
	pop	B
	pop	D
	pop	H
	ret
;---------
; get character from console (using BDOS) then
; convert lower to upper case.
; Abort on CTRL-C, restart on ESC
CONIN:
	mvi	C,1	; command 1
	call	BDOS	; read a char
	cpi	ctrlC
	jz	0	; abort if ctrlC
	cpi	1Bh
	jrz	..DDT	; jump into DDT if ESC
	call	CVTluc	; convert to upper case
	ret		; and return
..DDT:	rst	6	
;-------------------
; CVTLUC:  used to convert lower case on the CRT
;	   to upper case  
;
CVTluc:	cpi	'a'	; convert upper to lower case
	jm	..up
	cpi	'z'+1
	jp	..up	
	sui	'a'-'A'
..up:	ret
.page
;---------------
; Transmit a block on the network
;  Regs in:   HL = block address
;   	      BC = byte count
;	      E  = delay time before transmitting
;	      A  = user number
;  Regs out:  none
;  Destroyed: A, BC, DE, HL
SENDNET: 
	inr	E	; delay so that receiver has
..delay:dcr	E	; time to prepare for message
	jrnz	..delay	
	mov	D,A	; save user number
	shld	DMANSadr; store block address
	dcx	B	; DMA chip wants real size - 1
	sbcd	DMANSsize
	mov	A,C
	ora	B
	jrz	..send1
;
; Send more than one byte
	push	D
	lhld	1
	lxi	D,DMAvect
	dad	D
        lxi	D,DMATdone; setup the DMA vector
	mov	M,E
	inx	H
	mov	M,D	;store the DMA vector
	pop	D
	mvi	A,1	; multiplex SIO1B to DMA
	out	PIOAD
	lxi	H,DMANSprog; program the DMA chip
	lxi	B,DMAN$<8+DMA
	outir
	lxi	H,SENDprog
	lxi	B,SEND$<8+SIO1BC
	outir
	mvi	B,9	; force min 3 leading flags
	djnz	.
	mov	A,D
	di
	out	SIO1BD	; send user number
	mvi	A,87h	; enable the DMA chip
	out	DMA
	mvi	A,11010000b; reset underrun/EOM status
	out	SIO1BC
	jmpr	..fin
.page
;
; Send one byte (DMA chip isn't needed)
..send1:
	lxi	H,SENDprog
	lxi	B,SEND$<8+SIO1BC
	outir
	mvi	B,9	; force min 3 leading flags
	djnz	.
	lbcd	DMANSadr
	ldax	B
	mov	E,A	; get message byte
	mvi	C,SIO1BD
	di
	outp	D	; send userno
	mvi	A,11010000b; reset underrun/EOM status
	out	SIO1BC	; reset underrun status
..3:	in	SIO1BC
	bit	2,A	; wait for transmitter empty
	jrz	..3
	outp	E	; send message byte
;
; Handle the end of the transmission
..fin:	ei
..4:	in	SIO1BC	; wait for transmit underrun
	bit	6,A
	jrz	..4
..5:	in	SIO1BC	; wait for CRC complete
	bit	2,A
	jrz	..5
	mvi	B,10h	; force min 3 closing flags
	djnz	.
	mvi	A,18h
	out	SIO1BC	; reset the SIO chip
	ret
;----------
; Receive a block from the network
;  Regs in:   HL = block address
;	      BC = maximum byte count
;	      DE = timeout count
;	      A  = user number
;  Regs out:  A  = error status
;		   bit 7 = end of frame (0 if time-out)
;		   bit 6 = CRC error
;		   bit 5 = receiver overrun
;  Destroyed: A, BC, DE, HL
RECNET:
	push	D	; save the timeout count
	call	RECbegin; program the SIO chip
	pop	D	; get the timeout count back
	ei		; make sure SIO can interrupt
	lxi	H,RECstat; point to receiver status
	mvi	M,1	; tell REClast to not ack polls
; Wait for block received from network cable
..wait:	mvi	B,8	; inner loop count
..loop:	mov	A,M	; check receiver status
	bit	4,A
	rnz		; return if block received
	djnz	..loop
	dcx	D	; decrement timeout count
	mov	A,E
	ora	D
	jrnz	..wait	; fall through if timeout
	call	REClast	; pretend we received a block
	sub	A	; return "timeout" status
	ret
; Program the SIO chip to receive a block
RECbegin:
	sta	RECadr	; station address
	shld	DMANRadr; DMA address
	dcx	B	
	sbcd	DMANRsize; DMA length = real length-1
	mov	A,C
	ora	B
	jrz	..prog
; Receive more than one byte
	lhld	1
	lxi	D,DMAvect
	dad	D
        lxi	D,DMARdone; setup the DMA vector
	mov	M,E
	inx	H
	mov	M,D	;store the DMA vector
	mvi	A,1	; multiplex SIO1B to DMA
	out	PIOAD
	lxi	H,DMANRprog; program the DMA chip
	lxi	B,DMAN$<8+DMA
	outir
.page
..prog:	lhld	1
	lxi	D,SIO1vect+4
	dad	D
        lxi	D,RECfirst; setup the DMA vector
	mov	M,E
	inx	H
	mov	M,D	  ;store the DMA vector
	lhld	1
	lxi	D,SIO1vect+6
	dad	D
        lxi	D,REClast ;setup the DMA vector
	mov	M,E
	inx	H
	mov	M,D	  ;store the DMA vector
	lxi	H,RECprog; program the SIO chip
	lxi	B,REC$<8+SIO1BC
	outir
	ei		; make sure interrupts enabled
	ret
;---------------
; Receive status and count, and temp storage for regs
RECstat:.byte	0FFh	; receiver status
REC.SP:	.word	0
REC.HL:	.word	0
	.byte	76h,76h,76h,76h,76h,76h,76h,76h
	.byte	76h,76h,76h,76h,76h,76h,76h,76h
	.byte	76h,76h,76h,76h,76h,76h,76h,76h
RECstck:
;---------------
; SDLC receive interrupt on first char
RECfirst:
	push	PSW
	in	SIO1BD	; flush user number
	lda	DMANRsize; if len = 0, don't use DMA
	ora	A
	jrnz	..DMA
	nop
	in	SIO1BD	; get message byte
	shld	REC.HL
	lhld	DMANRadr; get buffer address
	mov	M,A	; put message into buffer
	lhld	REC.HL
	in	SIO1BD	; flush first CRC byte
	jmpr	..ret
..DMA:	mvi	A,87h	; enable DMA
	out	DMA
..ret:	pop	PSW
	ei
	reti
.page
; SDLC receive interrupt on last char
REClast:
	ei 
	sspd	REC.SP
	lxi	SP,RECstck
	push	H
	push	D
	push	B
	push	PSW
	lda	DMANRsize; check whether DMA was used
	ora	A
	jrz	..fin
	mvi	A,0C3h	; deprogram the DMA chip
	out	DMA
..fin:	in	SIO1BD	; throw away second CRC byte
	lda	RECstat
	mov 	B,A
	mvi	A,1	; get receive status
	out	SIO1BC
	in	SIO1BC
	ani	11100000b; mask out relevant bits
	set	4,A
	sta	RECstat
	mvi	A,18h
	out	SIO1BC	; reset the SIO1B chip
..ret:	pop	PSW
	pop	B
	pop	D
	pop	H
	lspd	REC.SP
	reti
;----------
; DMA transmit complete interrupt
DMATdone:
	push	PSW
	mvi	A,0C3h	; reset the DMA chip
	out	DMA
	pop	PSW
        ei
        ret 
.page
;---------------
; DMA receive complete interrupt
DMARdone:
	push	PSW
	push	D
	shld	REC.HL
	mvi	A,0C3h	; reset the DMA chip
	out	DMA
	mvi	A,21h	; now interrupt on every char
	out	SIO1BC
	mvi	A,11110100b
	out	SIO1BC
	lhld	1
	lxi	D,SIO1vect+4
	dad	D
        lxi	D,RECflush; setup the DMA vector
	mov	M,E
	inx	H
	mov	M,D	  ;store the DMA vector
	lhld	REC.HL
	pop	D
	pop	PSW
	ei
	ret
;---------------
; SDLC receive interrupt on every char
RECflush:
	push	PSW
	in	SIO1BD	; flush this char away
	pop	PSW
	ei
	reti
;---------------
; SIO commands
SENDprog:
	.byte	    00011000b ; channel reset
	.byte	  3,00100000b ; auto enables
	.byte	14h,00100000b ; SDLC mode
	.byte	11h,11000100b ; no interrupts
	.byte	  5,11101011b ; transmitter enable
	.byte	    10000000b ; reset CRC generator
SEND$	==	.-SENDprog
.page
RECprog:
	.byte	    00011000b ; channel reset
	.byte	  2,SIO1vect+3; interrupt vector
	.byte	  4,00100000b ; SDLC mode
	.byte	15h,10000000b ; transmit disable
	.byte	  3,11111100b ; receiver info
	.byte	6
RECadr:	.byte	0	      ; user number
	.byte	  7,01111110b ; flag byte
	.byte	11h,11101100b ; interrupt on first byte
	.byte	23h
RECable:.byte	    11111101b ; enable receiver
REC$	==	.-RECprog
;---------------
; DMA commands
DMANSprog:
	.byte	0C3h	; master reset		     2D
	.byte	0C7h	; reset port A		     2D
	.byte	0CBh	; reset port B		     2D
	.byte	79h	; write
DMANSadr:.word	0	; filled by SENDNET or RECstart
DMANSsiz:.word	0	; filled by SENDNET or RECstart
	.byte	14h	; port A inc, memory	     1B
	.byt	28	 por  fixed I/	     1B
	.byte	95h	; byte mode		     2B
	.byte	SIO1BD	; port B
	.byte	12h	; interrupt at end of block
	.byte	DMAvect+3; interrupt vector
	.byte	92h	; stop at end of block
	.byte	0CFh	; load starting address      2C
	.byte	5	; write
	.byte	0CFh	; load starting address	     1A
	.byte	0ABh	; enable interrupts	     2D
DMAN$	==	.-DMANSprog
;
DMANRprog:
	.byte	0C3h	; master reset		     2D
	.byte	0C7h	; reset port A		     2D
	.byte	0CBh	; reset port B		     2D
	.byte	7Dh	; read
DMANRadr:.word	0	; filled by SENDNET or RECstart
DMANRsiz:.word	0	; filled by SENDNET or RECstart
	.byte	14h	; port A inc, memory	     1B
	.byt	28	 por  fixed I/	     1B
	.byte	95h	; byte mode		     2B
	.byte	SIO1BD	; port B
	.byte	12h	; interrupt at end of block
	.byte	DMAvect+3; interrupt vector
	.byte	92h	; stop at end of block
	.byte	0CFh	; load starting address      2C
	.byte	1	; read
	.byte	0CFh	; load starting address	     1A
	.byte	0ABh	; enable interrupts	     2D
.page
;
; Constants
;
PIOAD	==	08h
DMA	==	38h

SIO1BC	==      2Bh    ;SIO-1 channel B, cntrl
SIO1BD	==	29h    ;SIO-1 channel B, data
SIO1vect==	3Dh    ;SIO-1 interrupt vectrs
DMAvect	==	55h    ;DMA interrupt vector
$halfms	==	50h    ;1/2 ms delay in SENDNET
$1sec   ==      4000h  ;1 sec delay in RECNET
BDOS    ==	5      ;BDOS entry point 
ctrlc   ==      03h
CR	==	0Dh
lf   	==	0Ah
patern: .byte 	0A3h
STROBE  ==	0
;
massta: .ascii 	[cr][lf]'Are we the master station? '
	.asciz 		'(Y or N)'
mastmsg:.ascii  [cr][lf] [cr][lf] 'This program will '
	.asciz		'send A3 until you reset.'
usrmsg: .ascii  [cr][lf] [cr][lf] 'This program will '
	.asciz		'receive A3 until you reset.'
crlf:   .asciz	[cr][lf]
;
	.blkb	30
stack:
	.end

