.title	"Boot network diagnostic program"
	.iden slavetest
;----------
; Test the DMS 3B station
;
version ==	1
revision==	2
patc	=	'C'
;
        .phex
	.pabs
	.loc	9000h
	lxi	sp,stack ;stack at end of program
;---------------
; First determine if we have a master or user station.
;
START:
..again:
	CALL	CHEKCON	   ;check for user commands
	lxi	H,lopmsg
	call    prtmsg	   ;print the loop message
        call	prtloop    ;print the loop count
	lxi	B,0400h
	call	cntRS
	cpi	'/'
	jrz	..again
	lbcd    loopcntr   
	inx     B	   ;add one to loop counter for
	sbcd	loopcntr   ;summary and store it 
	jmpr    ..again
.sbttl "SUBROUTINES"
;           -------------
;            SUBROUTINES
;           -------------
;---------------
; subroutine prtloop: print the loop count 
;
; reg in:  HL
; reg out: None
; reg destroyed: None
prtloop:
        lhld	loopcntr;counts the loops completed
	jmp	prthex
;--------------
; subroutine: count the HiNet STATION receive and
;	      send for the HiNet tests
cntRS:
;
..loop: 
	mvi	A,0	  ;bit to be changed up
	call	upbit	  ;when receive starts
       	lxi	H,SRbuff  ;receive send buffer
	lxi	B,0400h
	lxi     D,$1sec   ;maximum time for rec  
	mvi	A,1	  ;user number
	call	RECNET
	bit	7,A
	jrnz    ..1       ;don't print error message
	mvi	A,2	  ;bit to be changed
	call 	upbit	  ;to be changed up
        mvi     A,'T'     ;for time out
	call    conslout  ;HiNet times out
	lbcd	errcntr
	inx	B	  ;add 1 to the error counter
	sbcd	errcntr	  ;and store it
	mvi	A,2	  ;bit to be changed down when
	call	downbit	  ;timeout processing is done
	jmpr    ..loop    ;don't send without receive
..1:    bit	6,A
	jrz	..2
	mvi	A,'C'
	call    conslout
	lbcd	errcntr
	inx	B	  ;add 1 to the error counter
	sbcd	errcntr	  ;and store it
	mvi	A,0	  ;bit to be changed down
	call	downbit	  ;when the receive is done
	mvi	A,1	  ;bit to be changed up
	call	upbit	  ;when sene begins
..2:    lxi	H,SRbuff  ;receive send buffer 
	lxi	B,400h
	mvi	E,$halfms ;maximum time for send
	mvi	A,1	  ;user number
	call	SENDNET
	mvi	A,1	  ;bit to be changed down
	call	downbit	  ;when send finishes
	mvi	A,inittim ;the # of timeouts allowed
	sta	timcntr	  ;stored in the counter
	lbcd    usrcntr 
	dcx     B   	  ;decrement the user counter
	sbcd    usrcntr   ;store the counter
	mov     A,C        
	ora     B
	jnz     ..loop    ;no, send and receive again
	lbcd    tstloop   ;re-initialize the counter,
	sbcd    usrcntr   ;store it and return
	mvi     A,'.'     ;print a period for
	call    conslout  ;each test loop 
	lda     dotcntr
	dcr     A	  ;load, decrement and 
	sta     dotcntr   ;store dot counter
	cpi     0	  ;have we done 3 loops?
	jnz     ..loop	  ;no, do another loop
	mvi     A,3       ;yes,
	sta     dotcntr   ;re-initialize dot counter
..exit:	ret		  ;and return to main program
;---------------
; Subroutine usrreinit: Reinitialize the user counters
; Reg in:
; Reg out: A
; Destroyed: None
;
usrreinit:
   	lbcd	tstloop	 ;number of loops
	sbcd	usrcntr  ;to user counter
	mvi     A,3   
	sta     dotcntr  ;re-initialize dot counter
        mvi	A,inittim;the # of timeouts allowed
	sta	timcntr  ;reinit the time counter
	mvi	A,'/'	 ;test character
	ret
;----------------
; Print a message on the console
;
;  Regs in:   HL = address of string (ended by null)
;  Regs out:  none
;  Destroyed: A, HL
prtmsg:
	mov	A,M
	ora	A
	rz
	call	conslout
	inx	H
	jmpr	prtmsg
;---------------
; Print a character on the console
;  Regs in:   A = character to be printed
conslout:
	mov	C,A
outchr:	in	SIO1AC
	ani	1<TXRDY
	jrz	outchr
	mov	A,C
	out	SIO1AD
	ret

prthex:			;prints h,l
	mov	A,H
	call	prtbyt
	mov	A,L
;---------------
; Print a byte on the console
;  (Do print leading zeros)
;  Regs in:   A = byte to be printed
;  Regs out:  none
;  Destroyed: A
prtbyt:
	push	PSW
	rrc
	rrc
	rrc
	rrc
	ani	0Fh	
	call	prtnbl
	pop	PSW
prtnbl:	ani	0Fh
	adi	'0'
	cpi	'9'+1
	jrc	conslout
	adi	'A'-('9'+1)
	jmpr	conslout
;-------------------
;  Subroutine chekcon:  Check the console for a
;			character
;  Reg in: A
;  Reg out: None
;  Destroyed: A
Chekcon:
	in	SIO1AC
	ani	1<RXRDY
	rz
	in	SIO1AD
..Scmd: 		;summary command
	lxi	H,cntrmsg
	call    prtmsg	;print the error message
	lhld	errcntr ;counts the errors detected
	call	prthex
	lxi	H,loopmsg
	call    prtmsg	;print the loop message
        lhld	loopcntr;counts the loops completed
	jmp	prthex	
;---------------
; Wait for a cr to be typed
;
.sbttl "NET ROUTINES"
;---------------
; Transmit a block on the network
;  Regs in:   HL = block address
;   	      BC = byte count
;	      E  = delay time before transmitting
;	      A  = user number
;  Regs out:  none
;  Destroyed: A, BC, DE, HL
SENDNET: 
	inr	E	; delay so that receiver has
..delay:dcr	E	; time to prepare for message
	jrnz	..delay	
	mov	D,A	; save user number
	shld	DMANSadr; store block address
	dcx	B	; DMA chip wants real size - 1
	sbcd	DMANSsize
	mov	A,C
	ora	B
	jrz	..send1
;
; Send more than one byte
	push	D
	lhld	1
	lxi	D,DMAvect
	dad	D
        lxi	D,DMATdone; setup the DMA vector
	mov	M,E
	inx	H
	mov	M,D	;store the DMA vector
	pop	D
	mvi	A,1	; multiplex SIO1B to DMA
	out	PIOAD
	lxi	H,DMANSprog; program the DMA chip
	lxi	B,DMAN$<8+DMA
	outir
	lxi	H,SENDprog
	lxi	B,SEND$<8+SIO1BC
	outir
	mvi	B,9	; force min 3 leading flags
	djnz	.
	mov	A,D
	di
	out	SIO1BD	; send user number
	mvi	A,87h	; enable the DMA chip
	out	DMA
	mvi	A,11010000b; reset underrun/EOM status
	out	SIO1BC
	jmpr	..fin
;
; Send one byte (DMA chip isn't needed)
..send1:
	lxi	H,SENDprog
	lxi	B,SEND$<8+SIO1BC
	outir
	mvi	B,9	; force min 3 leading flags
	djnz	.
	lbcd	DMANSadr
	ldax	B
	mov	E,A	; get message byte
	mvi	C,SIO1BD
	di
	outp	D	; send userno
	mvi	A,11010000b; reset underrun/EOM status
	out	SIO1BC	; reset underrun status
..3:	in	SIO1BC
	bit	2,A	; wait for transmitter empty
	jrz	..3
	outp	E	; send message byte
;
; Handle the end of the transmission
..fin:	ei
..4:	in	SIO1BC	; wait for transmit underrun
	bit	6,A
	jrz	..4
..5:	in	SIO1BC	; wait for CRC complete
	bit	2,A
	jrz	..5
	mvi	B,10h	; force min 3 closing flags
	djnz	.
	mvi	A,18h
	out	SIO1BC	; reset the SIO chip
	ret
;----------
; Receive a block from the network
;  Regs in:   HL = block address
;	      BC = maximum byte count
;	      DE = timeout count
;	      A  = user number
;  Regs out:  A  = error status
;		   bit 7 = end of frame (0 if time-out)
;		   bit 6 = CRC error
;		   bit 5 = receiver overrun
;  Destroyed: A, BC, DE, HL
RECNET:
	push	D	; save the timeout count
	call	RECbegin; program the SIO chip
	pop	D	; get the timeout count back
	ei		; make sure SIO can interrupt
	lxi	H,RECstat; point to receiver status
	mvi	M,1	; tell REClast to not ack polls
; Wait for block received from network cable
..wait:	mvi	B,8	; inner loop count
..loop:	mov	A,M	; check receiver status
	bit	4,A
	rnz		; return if block received
	djnz	..loop
	dcx	D	; decrement timeout count
	mov	A,E
	ora	D
	jrnz	..wait	; fall through if timeout
	call	REClast	; pretend we received a block
	sub	A	; return "timeout" status
	ret
; Program the SIO chip to receive a block
RECbegin:
	sta	RECadr	; station address
	shld	DMANRadr; DMA address
	dcx	B	
	sbcd	DMANRsize; DMA length = real length-1
	mov	A,C
	ora	B
	jrz	..prog
; Receive more than one byte
	lhld	1
	lxi	D,DMAvect
	dad	D
        lxi	D,DMARdone; setup the DMA vector
	mov	M,E
	inx	H
	mov	M,D	;store the DMA vector
	mvi	A,1	; multiplex SIO1B to DMA
	out	PIOAD
	lxi	H,DMANRprog; program the DMA chip
	lxi	B,DMAN$<8+DMA
	outir
..prog:	lhld	1
	lxi	D,SIO1vect+4
	dad	D
        lxi	D,RECfirst; setup the DMA vector
	mov	M,E
	inx	H
	mov	M,D	  ;store the DMA vector
	lhld	1
	lxi	D,SIO1vect+6
	dad	D
        lxi	D,REClast ;setup the DMA vector
	mov	M,E
	inx	H
	mov	M,D	  ;store the DMA vector
	lxi	H,RECprog; program the SIO chip
	lxi	B,REC$<8+SIO1BC
	outir
	ei		; make sure interrupts enabled
	ret
;---------------
; Receive status and count, and temp storage for regs
RECstat:.byte	0FFh	; receiver status
REC.SP:	.word	0
REC.HL:	.word	0
	.byte	76h,76h,76h,76h,76h,76h,76h,76h
	.byte	76h,76h,76h,76h,76h,76h,76h,76h
	.byte	76h,76h,76h,76h,76h,76h,76h,76h
RECstck:
;---------------
; SDLC receive interrupt on first char
RECfirst:
	push	PSW
	in	SIO1BD	; flush user number
	lda	DMANRsize; if len = 0, don't use DMA
	ora	A
	jrnz	..DMA
	nop
	in	SIO1BD	; get message byte
	shld	REC.HL
	lhld	DMANRadr; get buffer address
	mov	M,A	; put message into buffer
	lhld	REC.HL
	in	SIO1BD	; flush first CRC byte
	jmpr	..ret
..DMA:	mvi	A,87h	; enable DMA
	out	DMA
..ret:	pop	PSW
	ei
	reti
; SDLC receive interrupt on last char
REClast:
	ei 
	sspd	REC.SP
	lxi	SP,RECstck
	push	H
	push	D
	push	B
	push	PSW
	lda	DMANRsize; check whether DMA was used
	ora	A
	jrz	..fin
	mvi	A,0C3h	; deprogram the DMA chip
	out	DMA
..fin:	in	SIO1BD	; throw away second CRC byte
	lda	RECstat
	mov 	B,A
	mvi	A,1	; get receive status
	out	SIO1BC
	in	SIO1BC
	ani	11100000b; mask out relevant bits
	set	4,A
	sta	RECstat
	mvi	A,18h
	out	SIO1BC	; reset the SIO1B chip
..ret:	pop	PSW
	pop	B
	pop	D
	pop	H
	lspd	REC.SP
	reti
;----------
; DMA transmit complete interrupt
DMATdone:
	push	PSW
	mvi	A,0C3h	; reset the DMA chip
	out	DMA
	pop	PSW
        ei
        ret 
;---------------
; DMA receive complete interrupt
DMARdone:
	push	PSW
	push	D
	shld	REC.HL
	mvi	A,0C3h	; reset the DMA chip
	out	DMA
	mvi	A,21h	; now interrupt on every char
	out	SIO1BC
	mvi	A,11110100b
	out	SIO1BC
	lhld	1
	lxi	D,SIO1vect+4
	dad	D
        lxi	D,RECflush; setup the DMA vector
	mov	M,E
	inx	H
	mov	M,D	  ;store the DMA vector
	lhld	REC.HL
	pop	D
	pop	PSW
	ei
	ret
;---------------
; SDLC receive interrupt on every char
RECflush:
	push	PSW
	in	SIO1BD	; flush this char away
	pop	PSW
	ei
	reti
;---------------
; SIO commands
SENDprog:
	.byte	    00011000b ; channel reset
	.byte	  3,00100000b ; auto enables
	.byte	14h,00100000b ; SDLC mode
	.byte	11h,11000100b ; no interrupts
	.byte	  5,11101011b ; transmitter enable
	.byte	    10000000b ; reset CRC generator
SEND$	==	.-SENDprog
RECprog:
	.byte	    00011000b ; channel reset
	.byte	  2,SIO1vect+3; interrupt vector
	.byte	  4,00100000b ; SDLC mode
	.byte	15h,10000000b ; transmit disable
	.byte	  3,11111100b ; receiver info
	.byte	6
RECadr:	.byte	0	      ; user number
	.byte	  7,01111110b ; flag byte
	.byte	11h,11101100b ; interrupt on first byte
	.byte	23h
RECable:.byte	    11111101b ; enable receiver
REC$	==	.-RECprog
;---------------
; DMA commands
DMANSprog:
	.byte	0C3h	; master reset		     2D
	.byte	0C7h	; reset port A		     2D
	.byte	0CBh	; reset port B		     2D
	.byte	79h	; write
DMANSadr:.word	0	; filled by SENDNET or RECstart
DMANSsiz:.word	0	; filled by SENDNET or RECstart
	.byte	14h	; port A inc, memory	     1B
	.byt	28	 por  fixed I/	     1B
	.byte	95h	; byte mode		     2B
	.byte	SIO1BD	; port B
	.byte	12h	; interrupt at end of block
	.byte	DMAvect+3; interrupt vector
	.byte	92h	; stop at end of block
	.byte	0CFh	; load starting address      2C
	.byte	5	; write
	.byte	0CFh	; load starting address	     1A
	.byte	0ABh	; enable interrupts	     2D
DMAN$	==	.-DMANSprog
;
DMANRprog:
	.byte	0C3h	; master reset		     2D
	.byte	0C7h	; reset port A		     2D
	.byte	0CBh	; reset port B		     2D
	.byte	7Dh	; read
DMANRadr:.word	0	; filled by SENDNET or RECstart
DMANRsiz:.word	0	; filled by SENDNET or RECstart
	.byte	14h	; port A inc, memory	     1B
	.byt	28	 por  fixed I/	     1B
	.byte	95h	; byte mode		     2B
	.byte	SIO1BD	; port B
	.byte	12h	; interrupt at end of block
	.byte	DMAvect+3; interrupt vector
	.byte	92h	; stop at end of block
	.byte	0CFh	; load starting address      2C
	.byte	1	; read
	.byte	0CFh	; load starting address	     1A
	.byte	0ABh	; enable interrupts	     2D
;------------------
; The following routines are designed for flagging
; various bits on the second parallel port. This
; allows the technicians to obtain data without
; having to consult the CRT.
;
; bit 0 - set high during net receives, otherwise low.
; bit 1 - set high during net sends, otherwise low.
; bit 2 - set high after a network timeout (receive).
; bit 3 - unused	
; bit 4 - unused
; bit 5 - unused
; bit 6 - unused
; bit 7 - unused
;
; to set a bit high use the following code:
; 	mvi	A,2 (or other bit number)
;	call	upbit
;
; to set a bit low use the following code:
; 	mvi	A,2 (or other bit number
;	call	downbit
;
;----------------
; Upbit and Downbit
; Regs  in: A=bit number to be raised or lowered.
; Regs out: none	
; Destroyed: none
; Set/Reset the bit number received in A (0-7) on PP2.
;
;A= bit number to raise
upbit:	push	PSW
	push	B	  ; save users regs
	ora	A 	  ; is bit number 0 to be on?
	mov	B,A	  ; save bit number as counter
	mvi	A,1	  ; start off with 0th bit set
	jrz	..upbyte  ; jump around computation
			  ; if its only bit 0, because
			  ; the 0th bit was just set.
..loop: rlc
	djnz	..loop	  ; rotate to proper bit setting
..upbyte:
	mov	B,A	  ; bit pattern is in B
	lda	PP2byt	  ; old bit pattern in A
	ora	B	  ; turn on our bit
	jmp	SENDbyt
;
;A= bit number to lower
downbit:
        push	PSW
	push	B	  ; save users regs
	ora	A 	  ; is it bit 0?
	mov	B,A	  ; save bit number as counter
	mvi	A,1	  ; start off with 0th bit set
	jrz	..downbyt ; jump around computation
			  ; if its only bit 0, because
			  ; the 0th bit is already set.
..loop: rlc
	djnz	..loop	  ; rotate to proper bit setting
..downbyt:
	cma		  ; flip bits and move
	mov	B,A	  ; bit pattern into B
	lda	PP2byt	  ; old bit pattern in A
	ana	B	  ; turn off our bit

;----------
SENDbyt:
	sta	PP2byt	  ; save the new bit pattern
	out	Pport2	  ; output the pattern
	pop	B
	pop	PSW	  ; restore users regs
	ret		  ; and return.
;---------------
;constants
;
DMA	==      38h    ;DMA chip
PIOAD	==      08h    ;PIO channel A, data
SIO1BC	==      2Bh    ;SIO-1 channel B, cntrl
SIO1BD	==	29h    ;SIO-1 channel B, data
SIO1AC	==	2ah
SIO1AD	==	28h
RXRDY	==	01h
TXRDY	==	04h
SRbuff	==	2000h
RECbuff	==	3000h
SIO1vect==	3Dh    ;SIO-1 interrupt vectrs
DMAvect	==	55h    ;DMA interrupt vector
$halfms	==	50h    ;1/2 ms delay in SENDNET
$1sec   ==      4000h  ;1 sec delay in RECNET
ctrlc   ==      03h
CR	==	0Dh
lf   	==	0Ah
blank	==	20h    ;used to clear CP/M's conbuf
;
; The following constants determine the length of the 
; data transmitted for the HiNet test.
;
;  
; The number of sends and receives per loop is counted
; by initlp(initialize loops).  To change the receive-
; sends per loop, simply modify the number in initlp.
;
initlp  ==   20 ;initializes all loop counters
tstloop:.word initlp ;test for loops done
usrcntr:.word initlp ;user send rec counter	
dotcntr:.byte      3 ;outer loop for user send
loopcntr:.word	   0 ;count the send rec loops
errcntr: .word     0 ;count the send rec errors
timcntr: .byte inittim ;timeout counter
inittim ==        10 ;initialize the time counter
;
Pport2	==        02 ;Parallel port 2 address
PP2byt:	.byte	  00h;This byte is what will be
		     ;sent out of port 2.
.sbttl "CRT INFO"
; All CRT user info is located here
;
lopmsg: .asciz  [cr][lf]'loop '
loopmsg:.asciz  [cr][lf]'loops: '
cntrmsg:.asciz  [cr][lf]'err: '
;
.sbttl "STACK"
	.byte   76h,76h,76h,76h,76h,76h,76h,76h,76h,76h
	.byte   76h,76h,76h,76h,76h,76h,76h,76h,76h,76h
	.byte   76h,76h,76h,76h,76h,76h,76h,76h,76h,76h
	.byte   76h,76h,76h,76h,76h,76h,76h,76h,76h,76h
	.byte   76h,76h,76h,76h,76h,76h,76h,76h,76h,76h
	.byte   76h,76h,76h,76h,76h,76h,76h,76h,76h,76h
	.byte   76h,76h,76h,76h,76h,76h,76h,76h,76h,76h
	.byte   76h,76h,76h,76h,76h,76h,76h,76h,76h,76h
	.byte   76h,76h,76h,76h,76h,76h,76h,76h,76h,76h
	.byte   76h,76h,76h,76h,76h,76h,76h,76h,76h,76h
	.byte   76h,76h,76h,76h,76h,76h,76h,76h,76h,76h
	.byte   76h,76h,76h,76h,76h,76h,76h,76h,76h,76h
stack:
	.end
