/*	Alloc module 6.				#6
    "AL6.C"

    This module conatains Quick menu choices Clear, ReadOnly, ReadWrite,
Ownable, YouOwnIt and Change Passwords (partition).
*/
/*
#define		debug6
*/

#define		dbg6

#define		EXTERNal	0
#include	"alloc.dat"

/*=============================================================================
			HISTORY

date		8 March 1984
person		tpl

ver	0
rev	0
mod	c
patch	18


 ver-rev
+++++++++
   0-0

     mod-patch
    +++++++++++
	c8		29 February 1984	tpl
		.Add functions Ownable, YouOwnIt.
		.Use the force command for Ownable, YouOwnIt, ReadOnly,
		ReadWrite.

	c6		7 February 1984		tpl
		.Start Clear coding.

	   c3		17 January 1984		tpl
		.Take out "if ( debug_mode )" and replace with
		"#ifdef debug" and "#endif" to save space.

	  c1		16 January 1984		tpl
		.Add the code to change password, do the RO/RW change.


	  c		3 January 1984		tpl
		.Update to USERS type constant names.
		.Change to new include scheme.

	  b		September 26, 1983	tpl
		.Put in empty procedures.

	  a		September 23, 1983	tpl
		.Make this module from alloc1/g, alloc2/g, alloc3/f, alloc4/e.


*/

/*page*/
/*=============================================================================
			DEFINES
*/

#define		NnetUser	32

/*page*/
/*=============================================================================
			ROUTINES
*/
/*---------------------------------------------------------------------------*/

Clear()
{
  register partition;

    putz("\n\nClear an Ownable partition to Not Owned.\n");

    if ( (partition = GetPartName()) == 0 )
	return( 0 );

/* Make sure partition is ownable and is owned.	*/
/* If owned say who its owned by.	*/

    if ( (alloc_table[ partition ].control & PRTCTMASK) != OWNABLE )
    {
	printz("%c\nPartition %.8s is not an Ownable partition.\n",
					BELL, alloc_table[partition].name);
	Wait_for_Input();
	return;
    }

    if ( !Is_Owned( partition ) )
    {
	printz("%c\nPartition %.8s is not owned.\n",
					BELL, alloc_table[partition].name);
	Wait_for_Input();
	return;
    }

/* else it is owned.	*/
/* Say who owns it.	*/

    printz("\nOwned by %.8s who is user number %d.\n",
			WMparams.wmrec.WMuser, WMparams.wmrec.WMstatus );

/* Set partition to not owned.		*/

    WM_Force( partition, NOTowned );	/* zabort's if net error.	*/

    putz("Clear complete.\n");

    Wait_for_Input();

}/*Clear*/

/*---------------------------------------------------------------------------*/
/*page*/

Only_Read()
{
  register	i, partition;

    putz("\n    Set a partition to Read-Only mode.\n");

/* Get the name of partition to change from user.	*/

    if ( (partition = GetPartName()) == 0 )
	return( 0 );


/*	IGNORE PASSWORD FOR NOW UNTIL NEW SYSTEM PASSWORD SCHEME IS IN PLACE.

    * If partition has a password, ask for it.	*
    if ( alloc_table[ partition ].password[0] != SPACE )
     * then password exists *
	GetPassword( partition ); * zaborts after 3 tries at password fail. *
*/


/* If partition is already read-only, return.	*/
/* If partition is shared, disalow change and return.	*/
/* If partition is currently owned, disallow change, say who owns it, return.*/

    switch( alloc_table[ partition ].control & PRTCTMASK )
    {
	case READONLY:	/* If already Read-Only, return.	*/

		printz("%c\nPartition %.8s is already Read-Only.\n",
					BELL, alloc_table[partition].name );
		Wait_for_Input();
		return;

	case SHARED:  /* If partition is Shared, disallow change and return. */
		NoModeChange( SHARED, partition );
		return;

	case OWNABLE:
		if ( Is_Owned( partition ) )
		{
		    NoModeChange( OWNABLE, partition  );
		    return;
		}
		else	/* Not currently owned so OK to change.	*/
		    break;

	default:	/* anything else is OK.	*/
		break;

    }/* switch on protection mode of partition. */


/* Go ahead with change.	*/
/* First update Alloc Table in memory.	*/

    alloc_table[ partition ].control &= CLEARprotection;
    alloc_table[ partition ].control |= READONLY;

/* Put in list to update write mode table when Save is done.	*/

    i = 0;
    while( (i < index_wm_update) && (i < NallocEntries) )
	if ( wm_Update[ i++ ] == partition )
	{	/* then already in 'to be updated' array.	*/
	    to_be_owned[--i] = FALSE;
	    break;
	}
    if ( i == index_wm_update )	    /* Put into 'to be updated' array.	*/
	wm_Update[ index_wm_update++ ] = partition;

/* Set flag to note that changes have been made.	*/

    changes_made = TRUE;

}/*Only_Read*/

/*---------------------------------------------------------------------------*/
/*page*/

Write_Read()
{
  register i, partition;

    putz("\n    Set a partition to Read/Write mode.\n");

    if ( (partition = GetPartName()) == 0 )
	return( 0 );


/* If partition is already read/write return.	*/
/* If partition is shared, disalow change and return.	*/
/* If partition is currently owned, disallow change, say who owns it, return.*/

    switch( alloc_table[ partition ].control & PRTCTMASK )
    {
	case READWRITE:	/* If already Read/Write  return.	*/

		printz("%c\nPartition %.8s is already Read/Write.\n",
				BELL, alloc_table[partition].name);
		Wait_for_Input();
		return;

	case SHARED:  /* If partition is Shared, disallow change and return. */
		NoModeChange( SHARED, partition  );
		return;

	case OWNABLE:
		if ( Is_Owned( partition ) )
		{
		    NoModeChange( OWNABLE, partition  );
		    return;
		}
		else	/* Not currently owned so OK to change.	*/
		    break;

	default:	/* anything else is OK.	*/
		break;

    }/* switch on protection mode of partition. */


/* Go ahead with change. */
/* First update the Alloc Table in memory.	*/

    alloc_table[ partition ].control &= CLEARprotection;
    alloc_table[ partition ].control |= READWRITE;

/* Put in list to update write mode table when Save is done.	*/

    i = 0;
    while( (i < index_wm_update) && (i < NallocEntries) )
	if ( wm_Update[ i++ ] == partition )
	{	/* then already in 'to be updated' array.	*/
	    to_be_owned[ --i ] = FALSE;
	    break;
	}

    if ( i == index_wm_update )	    /* Put into 'to be updated' array.	*/
	wm_Update[ index_wm_update++ ] = partition;

/* Set flag to note that changes have been made.	*/

    changes_made = TRUE;

}/*Write_Read*/

/*---------------------------------------------------------------------------*/
/*page*/

Ownable()
{
  register i, partition;

    putz("\n    Set a partition to Ownable mode.\n");

    if ( (partition = GetPartName()) == 0 )
	return( 0 );

/* If partition is already Ownable return.	*/
/* If partition is shared, disalow change and return.	*/

    switch( alloc_table[ partition ].control & PRTCTMASK )
    {
	case SHARED:  /* If partition is Shared, disallow change and return. */
		NoModeChange( SHARED, partition  );
		return;

	case OWNABLE:
		printz("%c\nPartition %.8s is already Ownable.\n",
				BELL, alloc_table[partition].name);
		Wait_for_Input();
		return;

	default:	/* anything else is OK.	*/
		break;

    }/* switch on protection mode of partition. */


/* Go ahead with change. */
/* First update the Alloc Table in memory.	*/

    alloc_table[ partition ].control &= CLEARprotection;
    alloc_table[ partition ].control |= OWNABLE;

/* Put in list to update write mode table when Save is done.	*/

    i = 0;
    while( (i < index_wm_update) && (i < NallocEntries) )
	if ( wm_Update[ i++ ] == partition )
	{	/* then already in 'to be updated' array.	*/
	    to_be_owned[ --i ] = FALSE;
	    break;
	}

    if ( i == index_wm_update )	    /* Put into 'to be updated' array.	*/
	wm_Update[ index_wm_update++ ] = partition;

/* Set flag to note that changes have been made.	*/

    changes_made = TRUE;

}/* Ownable */

/*---------------------------------------------------------------------------*/
/*page*/

YouOwnIt()
{
  register	i, partition;

    putz("\n    Set a partition to Owned by You.\n");

    if ( (partition = GetPartName()) == 0 )
	return( 0 );

/* If partition is already Ownable
				then set ownership to user running NetAlloc. */

/* If partition is shared, disalow change and return.	*/
/* If partition is currently owned, disallow change, say who owns it, return.*/

    switch( alloc_table[ partition ].control & PRTCTMASK )
    {
	case SHARED:  /* If partition is Shared, disallow change and return. */
		NoModeChange( SHARED, partition  );
		return;

	case OWNABLE:
		if ( Is_Owned( partition ) )
		{
		    NoModeChange( OWNABLE, partition  );
		    return;
		}

		else	/* Not currently owned so OK to change.		    */
		{	/* No need to update Alloc Table since partition is */
			/*already Ownable.				    */

		    WM_Force( partition, userno() );
		    return;
		}

	default:	/* anything else is OK.	*/
		break;

    }/* switch on protection mode of partition. */

/* Go ahead with change. */
/* First update the Alloc Table in memory.	*/

    alloc_table[ partition ].control &= CLEARprotection;
    alloc_table[ partition ].control |= OWNABLE;

/* Put in list to update write mode table when Save is done.	*/

    i = 0;
    while( (i < index_wm_update) && (i < NallocEntries) )
    {
	if ( wm_Update[ i++ ] == partition )
	{	/* then already in 'to be updated' array.	*/
	    to_be_owned[ --i ] = TRUE;	/* To remember to force to be owned. */
	    break;
	}
    }

    if ( i == index_wm_update )	    /* Put into 'to be updated' array.	*/
    {
	to_be_owned[ i ] = TRUE;	/* To remember to force to be owned. */
	wm_Update[ index_wm_update++ ] = partition;
    }

/* Set flag to note that changes have been made.	*/

    changes_made = TRUE;

}/* YouOwnIt */

/*---------------------------------------------------------------------------*/
/*page*/

Password_Change()
{
  register	i, partition;
  CHAR	*input_string, length;

    putz("\nChange a partition's password.\n");

    if ( (partition = GetPartName()) == 0 )
	return( 0 );
/*
    if ( alloc_table[ partition ].password[0] != SPACE )
     ** then password exists **
	GetPassword( partition ); ** zaborts after 3 tries at password fail. **
*/
    putz("\n    Enter new password.\n");

    input_string = ReadPassword( &length );

    clear( &(alloc_table[ partition ].password[0]), Lpassword, SPACE);
    if ( length != 0 )
	for ( i=0; (i<Lpassword) && (input_string[i] != '\0'); i++)
	    alloc_table[ partition ].password[i] = input_string[i];

    changes_made = TRUE;

}/*Password_Change*/

/*---------------------------------------------------------------------------*/
/*page*/

Query_WM( partition )
  CHAR	partition;
{
/* Query the master about the write mode status of the partition passed. */

    WMparams.wmsend.wmcmd = WMCMD;
    WMparams.wmsend.WMcmd = WMquery;
    WMparams.wmsend.WMvol = cur_volume;
    WMparams.wmsend.WMunit = partition;
    WMparams.wmsend.WMuserno = userno();
    WMparams.wmsend.WMuserno = userno();

/* Add check to see if the partition is assigned to any drives of this user. */
/* If so, use this drive and not 0xff as below.				     */

    WMparams.logdrive = 0xff;

/* Do the net request	*/
    if ( writemode( &WMparams ) == 1 )
    {		/* try twice. */
	if ( writemode( &WMparams ) == 1 )
	{
	    printz("%c\nNet Error.\n", BELL);
	    zabort();
	}
    }
}/* Query_WM */


/*---------------------------------------------------------------------------*/
/*page*/

Is_Owned( partition )
  CHAR partition;
{			/* Return TRUE if partition is currently owned, */
			/* else return FALSE. */
  register status;

    Query_WM( partition );	/* zaborts if failure. */

    switch ( status = WMparams.wmrec.WMstatus )
    {
	case MULTIgrant:
			return TRUE;
	default:
		if ( (status < NnetUsers) && (status >= 0) )
			return TRUE;
		else
		{
			printz("%c\n\
Net Error in 'Is_Owned'.\n\
WMstatus = %x hex.\n", BELL, status );

			zabort();
		}

	case NOTowned:
	case ISreadWrite:
	case ISreadOnly:
	case ISshared:
	case WMerrorGeneric:

			return FALSE ;
    }/*switch*/

}/* Is_Owned */

/*---------------------------------------------------------------------------*/
/*page*/

WM_Force( partition, mode_or_usernum)
  CHAR partition, mode_or_usernum;
{
#ifdef dbg6
    printz("\nWM_Force\n    force partition: %xh to value: %xh\n",
		partition, mode_or_usernum );
#endif

    WMparams.wmsend.wmcmd = WMCMD;
    WMparams.wmsend.WMcmd = WMforce;
    WMparams.wmsend.WMvol = cur_volume;
    WMparams.wmsend.WMunit = partition;
    WMparams.wmsend.WMvalue = mode_or_usernum;
    WMparams.wmsend.WMuserno = userno();

/* Add check to see if the partition is assigned to any drives of this user. */
/* If so, use this drive and not 0xff as below.				     */

    WMparams.logdrive = 0xff;


/* Do the net request	*/
    if ( writemode( &WMparams ) == 1 )
    {		/* try twice. */
	if ( writemode( &WMparams ) == 1 )
	{
	    printz("%c\nNet Error.\n", BELL);
	    zabort();
	}
    }

}/* WM_Force */

/*---------------------------------------------------------------------------*/
/*page*/

NoModeChange( mode, partition )
  register int	mode;
{
    switch( mode )
    {
	case SHARED:  /* If partition is Shared, disallow change and return. */
			printz("%c\n\
Partition %.8s is shared.\n\
You may not change the mode of a shared partition from NetAlloc.\n",
					BELL, alloc_table[partition].name );
			Wait_for_Input();

	case OWNABLE:
			printz("%c\n\
Partition %.8s is owned by %.8s who is user number %d.\n\
You may not change the mode of a partition that is currently owned.\n",
				BELL, alloc_table[partition].name,
				WMparams.wmrec.WMuser,WMparams.wmrec.WMstatus);
			Wait_for_Input();


    }/* switch on mode */

}/* NoModeChange */

/*---------------------------------------------------------------------------*/


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

