
/*		File Copy Module	reading msdos files under cpm80

	"FCMSREAD.C"
*/

/*=============================================================================
			INCLUDE FILES
*/

#include	"filecopy.os"
#include	"c:switch.os"
#include	"fcconst.h"
#include	"fcstruct.h"
#include	"fcdata.h"

/*=============================================================================
			HISTORY
    Last change:       13 March 1984		tpl
ver	0
rev	0
mod	d
patch	1


 mod
-----
  d		7 December 1983		tpl
	.Do error check for zero length file in FileRead.

  c3		November 11, 1983	tpl
	.Last series of patches: passing FCB again, drive -> 1=A, 2=B, 3=C...
	But OS uses (via SelDisk and CurDisk) 0=A, 1=B, 2=C, ...
	.Many variable name changes, cleanups.
	.Arrays of pointers for each drive's descriptors' working.

  c	.New mod on Nov 11. Still debugging after various paramter changes.
	.Passing fcb's now.

  b		November 1, 1983	tpl
	.Tired of patches. November deserves a new mod.

  a		October 25, 1983	tpl
	.begin coding this module.

*/

/*=============================================================================
			CONSTANTS / DEFINITIONS
*/
#define		DIRentrySize	32


/*=============================================================================
			VARIABLES and DATA STRUCTURES
*/
/*page*/
/*=============================================================================
			ROUTINES
*/
/*---------------------------------------------------------------------------*/

int
FileRead (file, buffer, buff_size)
  CHAR	*buffer;		/* Address of buffer to receive data.	*/
  int	buff_size;		/* Size of buffer, i.e. 1024 for 1k.	*/
  int	file;			/* FileOpen return value.		     */
				/* open_fcbs [file] is a pointer to an fcb.*/
/* Return EOF if end of file, i.e. al the file has already been read.
   Return 0 if successfull read.
*/
{
int		cluster_offset, num_records, save_DMA;
int		buff_offset;
CHAR		cur_disk, drive, i;
struct ms_fcb	*curfcb;
struct BPB	*curBPB;

#ifdef debugP
	printf ("Begin FileRead =====================================\n");
#endif

	curfcb = open_fcbs [file];

	if (curfcb->start_cluster == 0)
		return(EOF);	/* Zero length file.	*/

	if (curfcb->cur_cluster == 0xfff)
		return (EOF);	/* End of file set from last read. */

	cur_disk = CurDisk ();
	drive = curfcb->drive - 1;	/* drive -> 0=A, 1=B, 2=C..  */
	SelDisk (drive);
	save_DMA = GetDMA ();
	curBPB = frgn_BPB [drive];

	/* Compute the number of records to read to get buff_size bytes. */
	num_records = buff_size / curBPB->BytesInSector;

#ifdef debug
	printf ("  num_records to read: %xh = %xh / %xh\n",num_records,
		buff_size, curBPB->BytesInSector);
#endif

/* continued next page */
/*page*/

	buff_offset = 0;
#ifdef debug
	printf  ("\tTrack\tSector\tCluster\n");
#endif
	for (i=0; i<num_records; ++i)	{ /* Read the record into buffer. */
		if (frgnRead (drive, buffer + buff_offset,
			curfcb->curBiosTrack,
			curfcb->curBiosSector)) {
			printf (" Fatal error returned from BiosRead call in FileRead\n");
			zabort ();
			}
#ifdef debug
	printf ("\t%04x\t%04x\t%04x\n",
			curfcb->curBiosTrack,
			curfcb->curBiosSector,
			curfcb->cur_cluster);
#endif

	buff_offset += curBPB->BytesInSector;
	++curfcb->cur_record;

	if (curfcb->cur_record == curBPB->SectPerCluster) {
		/* If have read all records in the cluster 	*/
		/* Then get next cluster			*/

 		curfcb->cur_cluster
			= NextCluster (curfcb->cur_cluster, drive);

		if (curfcb->cur_cluster == 0xfff) {
			/* Then end of file. */
			/* Zero fill rest of buffer not needed, at end of cluster. */
			SetDMA (save_DMA);		/* Restore order.	*/
	 		SelDisk (cur_disk);		/* Restore order.	*/
			return (0);			/* Successfull read.	*/

			}/*if EOF*/

		/* Prepare to read next cluster.	*/
		curfcb->cur_record = 0;
		cluster_offset 
			= ((curfcb->cur_cluster - 2) * curBPB->SectPerCluster)
				+ frgnDirInfo [drive]->dataOffset;
		curfcb->curBiosTrack  = cluster_offset / curBPB->SectPerTrack;
		curfcb->curBiosSector = cluster_offset % curBPB->SectPerTrack;
		}/*if end of cluster*/

/* continued next page */
/*page*/

	else
		/* Not end of cluster, so update open_file fcb	*/
		/* for next record read.			*/
		if (++curfcb->curBiosSector == curBPB->SectPerTrack) {
			curfcb->curBiosSector = 0;
			++curfcb->curBiosTrack;
			}

	}/*for num_records*/

	SetDMA (save_DMA);
	SelDisk (cur_disk);

#ifdef debug
	printf ("End FileRead=====================================\n");
#endif

	return (0);	/* Successfull read.	*/

	}/*FileRead*/

/*---------------------------------------------------------------------------*/
/*page*/

int
NextCluster (pres_cluster, drive)
int	pres_cluster;	/* Present cluster.				*/
int	drive;		/* drive number, A = 0, B = 1, C = 2, ....	*/
{
unsigned int	next_cluster;	/* Next cluster in FAT list	*/
				/*  following pres_cluster. 	*/
	/* Return the next cluster in the FAT list given the present cluster.*/

	next_cluster = *(addr_FAT [drive] + pres_cluster + pres_cluster/2);

	if ((pres_cluster % 2) == 0)	/* If even */
		next_cluster &= 0x0fff;
	else	/* odd */
		next_cluster >>= 4;

#ifdef debugP
	printf ("p..NextCluster    pres_cluster: %x   next_cluster: %x   hex\n",
				  pres_cluster,      next_cluster);
#endif

	return (next_cluster);

	}/*NextCluster*/

/*---------------------------------------------------------------------------*/
/*page*/
/*======================================================================*/
/*	MSgetFAT	- read MS-DOS FAT into 'alloc'ed memory,	*/
/*			  set SectPerTrack field in BPB if non DMS disk	*/
/*======================================================================*/
MSgetFAT(drive)
int	drive;		/* Drive to get FAT from. A = 0, B = 1, C = 2, ... */
{

int	sizeFAT, save_DMA, track, sector;
int	offset = 0;
CHAR	i;

#ifdef debugP
	printf ("p..MSgetFAT\n");
#endif

	/* Compute size of FAT.	*/
	sizeFAT = frgn_BPB [drive]->SectPerFAT 
		* frgn_BPB [drive]->BytesInSect;

	/* Allocate space for FAT table on heap. */
	if ((addr_FAT [drive] = alloc(sizeFAT)) == 0) {
		printf ("Allocation error in MSgetFAT for FAT.  size=%x\n",
			sizeFAT);
		zabort ();
		}

#ifdef debug
	printf ("  addr_FAT[%x]: %x hex     sizeFAT: %x hex  %d decimal\n",
		drive, addr_FAT[drive], sizeFAT, sizeFAT);
#endif

	/* GetDMA address and save. */
	save_DMA = GetDMA ();

	track = 0;
	sector = (frgn_BPB [drive]->reserved_sect); /* FAT always resides */
						/* after reserved sectors.   */
	for (i = 0; i < frgn_BPB [drive]->SectPerFAT; ++i) { 
		/* Read in all sectors of the first FAT on the disk.	*/
		frgnRead (drive, addr_FAT [drive] + offset, track, sector);
		offset += frgn_BPB [drive]->BytesInSect;

#ifdef debug
		printf ("    track: %x    sector: %x\n",
			track, sector);
#endif
		if (++sector == frgn_BPB [drive]->SectPerTrack) {
			sector = 0;
			++track;
			}

		}/*for #sects/FAT*/

	/* fill in sectors per track in BPB for non DMS disks */
	switch (*addr_FAT [drive]) {
	case 0xFF :	/* Dual,	8 sect per track */
	case 0xFE :	/* Single,	8 sect per track */
#ifdef debug
		printf ("\tChanging Sect/Track from %d to 8\n",
			frgn_BPB [drive]->SectPerTrack);
#endif
		frgn_BPB [drive]->SectPerTrack = 8;
		break;
	case 0xFD :	/* Dual,	9 sect per track */
	case 0xFC :	/* Single,	9 sect per track */
#ifdef debug
		printf ("\tChanging Sect/Track from %d to 9\n",
			frgn_BPB [drive]->SectPerTrack);
#endif
		frgn_BPB [drive]->SectPerTrack = 9;
		break;
	/* 0xF8 means fixed disk */
	}

	/* Reset DMA address to value saved. */
	SetDMA (save_DMA);

	}/*MSgetFAT*/

/*---------------------------------------------------------------------------*/
/*page*/

int
FileOpen (userFcb)
  CHAR	*userFcb;	/* A pointer to an MSDOS standard fcb.	*/
{
/   Setup passed fcb as 'opened' and keep pointer in open_fcbs array.
   Retur the open_fcbs index (current value of index_open_fcbs)
   a positiv intege. This is t b passe t FileRea an FileWrite for
   identification.
   A returned value of 'FAIL' means file not found.
	No mode allowed. (Like RW or RO.)
*/
  int	cluster_offset, buff_offset;
  CHAR	drive, i;
  struct ms_dir_entry	*dir_entry;
  struct ms_fcb		*fcb;
  struct ms_fcb_ex	*fcb_ex;

#ifdef debugP
	printf ("p..FileOpen	entering\n");
#endif

	if (*userFcb == 0xff)	{ /* Then extended fcb.	*/
		fcb_ex = userFcb;
		fcb = userFcb + 7;
		}
	else {		/* else standard MSDOS fcb.	*/
		fcb = userFcb;
		fcb_ex = NULL;
		}

	if (fcb->drive == 0) {	/* if = 0 use curDisk.		*/
		fcb->drive = drive = CurDisk ();		/* 0=A, 1=B for CPM.	*/
		++fcb->drive;				/* 1=A, 2=B for fcb.	*/
		}
	else
		drive = fcb->drive -1;	/* So 0=A, 1=B, 2=C, ...	*/

#ifdef debug
	printf ("  userFcb: %x    fcb: %x    fcb_ex: %x\n",
		  userFcb,	 fcb,	    fcb_ex);
	printf ("  drive: %x hex    fcb->drive: %x hex\n", drive, fcb->drive);
#endif

	/* Search directory for matching file to passed fcb.	*/
	/* FirstDir does drive reselection.  */
	if ((buff_offset = FirstDir (fcb)) == FAIL)
		return (FAIL);	/* Then not found in directory. */

	dir_entry = frgnDirBuffer + buff_offset; /* buff_offset in units of */
		  /* ms_dir_entry's since frgnDirBuffer is a pointer to one. */
	
	for (++index_open_fcbs, index_open_fcbs %= MAXfcbs; 
		open_fcbs [index_open_fcbs] != NULL;
		++index_open_fcbs, index_open_fcbs %= MAXfcbs)
		;

	/* Setup open_fcbs pointer to the fcb.	*/
	open_fcbs [index_open_fcbs] = fcb;

	/* Overlay found file on fcb template passed to FileOpen.  */
	Toverlay (fcb->name, dir_entry->name, LENname + LENtype);
	fcb->cur_cluster = fcb->start_cluster = dir_entry->start_cluster;
	fcb->cur_record  = 0;
	cluster_offset = ((fcb->cur_cluster - 2)
			* frgn_BPB [drive]->SectPerCluster)
			+ frgnDirInfo [drive]->dataOffset;
	fcb->curBiosTrack = cluster_offset / frgn_BPB [drive]->SectPerTrack;
	fcb->curBiosSector = cluster_offset % frgn_BPB [drive]->SectPerTrack;

#ifdef debug
	printf ("p..FileOpen        exiting\n");
	printf ("  returning 'index_open_fcbs': %x  hex\n", index_open_fcbs);
	ShowOpenFile (index_open_fcbs);
#endif

	return (index_open_fcbs);

	}/*FileOpen*/


/*==============================================================*/
/*	FreeFile	- free up open_fcb used by FileOpen	*/
/*==============================================================*/
FreeFile (file)
int	file;
{
	if (open_fcbs [file] == NULL) {
		printf ("****ERROR in Free File. closing file not opened: %-8.8s.%-3.3s\n",
			open_fcbs [file]->name, open_fcbs [file]->type);
		}
	else
		open_fcbs [file] = NULL;
	} 

/*page*/
/*---------------------------------------------------------------------------*/

ShowOpenFile (file)
  int file;
{
/* Show the fcb pointed to by open_fcbs [file]->	*/
/* Three lines to output.				*/
  CHAR i;

	printf ("ShowOpenFile[%xh]:%-8.8s.%-3.3s\n",
		file, open_fcbs [file]->name, open_fcbs [file]->type);
	printf ("\tstart_cluster: %x hex  %d decimal    drive: %x hex\n",
				open_fcbs [file]->start_cluster,
				open_fcbs [file]->start_cluster,
				open_fcbs [file]->drive);

	printf ("\tcur_cluster   cur_record  curTrack  curSector\n");
	printf ("\t   %4x           %4x        %4x        %4x\n",
	open_fcbs [file]->cur_cluster, open_fcbs [file]->cur_record,
	open_fcbs [file]->curBiosTrack, open_fcbs [file]->curBiosSector);

	}/*ShowOpenFile*/

/*---------------------------------------------------------------------------*/
/* Mike P. has one of these.	*/
Toverlay (d, s, l)   /* destination, source, length paramaters.		     */
  CHAR	*d, *s;	    /* Overlay string *d with *s when *d points to a '?'.    */
  int	l;	    /* overlay 'l' CHARs.	*/
{
    while (l--)
    {
	if (*d == '?')
	    *d = *s;
	++d;
	++s;
    }

}/*Toverlay*/

/*---------------------------------------------------------------------------*/
frgnRead (drive, dma, track, sector)
int	drive;
CHAR	*dma;
int	track, sector;
{
int	i, xlate_sector, convert;
int	t, s;
	
	convert  = frgn_BPB [drive]->BytesInSector / 128;
	track *= convert * frgn_BPB [drive]->SectPerTrack;
	sector *= convert;
	t = (track + sector) / 128;
	s = (track + sector) % 128;
	for (i = 0; i < convert; ++i, dma += 128) {
		SetDMA (dma);
		settrk (t);
		xlate_sector = sectran (s + i, 
			frgn_dph [drive]->translate_table);
		setsect (xlate_sector);
		if (biosread () == 1) return TRUE;
		}
	return FALSE;
	}

/*++++++++++++++++++++++++++++++++ END ++++++++++++++++++++++++++++++++++++++*/

