/*	Install Utility		*/

#define ver 1
#define rev 0
#define mod ' '
#define asm ' '

#include "install.os"
#include "c:switch.os"

#define CR 13
#define LF 10
#define SP ' '
#define forever 1
#define ESC 0x1b

#define p1 &buffer[2]
#define p2 &buffer[5]
#define p3 &buffer[8]
#define p4 &buffer[11]

char	buffer[80];
char	label[5] = "l ";
char	firstgen = TRUE;
char	fnpdefault[20] = "install.txt";
char	subfnpdefault[20] = "$$$.sub";
char	*fnp, *subfnp;
FILE	*fpi;
char	flag[256];
int	eof;
int	saveline;
int	lineno;
char	*list[99];
int	lp = 0;
char	esc[3] = "99";

/*page*/
main( argc, argv)
int argc;
char *argv[];
{
	printf("Install Utility -- version %d.%d%c%c\n", ver,rev,mod,asm);

	if( argc > 1)
		fnp = argv[1];
	else
		fnp = fnpdefault;
	if( argc > 2)
		subfnp = argv[2];
	else
		subfnp = subfnpdefault;

	clear( flag, 256, FALSE);
	openin();
	scantext();
	list[ lp] = NULL;
	if( flag[ '@'] == TRUE )
		submit( subfnp, list);
	return 0;	/* needed for above submit to work consistently */
}
/*=====================================================================*/

scantext()
{
	while( !readin() )
		{switch( *buffer)
			{
			case 'd': 	display( p1); 	break;
			case 'q':	query( p1, p2); break;
			case 'f':	go( p1); 	break;
			case 's':	set( p1); 	break;
			case 'c':	clr( p1); 	break;
			case 'i':	doif( p1, p2, p3); break;
			case 'w':	writeout( p1); 	break;
			case 'r':	doreset();	break;
			default:			break;
			}
		if( eof)
			{return;
			}
		}
}
/*=====================================================================*/
/*page*/
display( s) char *s; { printf( "\n%s",s); }

/*=====================================================================*/
query( y, n)
char *y, *n;
{
char a[20];
	input( a, 20);
	switch( *a)
		{
		case 'Y':	go( y); break;

		case ESC:	go( esc); break;

		default:	go( n); break;
		}
}
/*====================================================================*/
go( l)
char	*l;
{
	saveline = lineno;
	strncpy( &label[2], l, 2);
	while( !readin() && strncmp( buffer, label, 4) );
	if (eof)
		printf( "\n*** Error: EOF while processing line %d\n", 
			saveline);
}
/*====================================================================*/
set( f) char *f; { flag[ *f] = TRUE; }
/*====================================================================*/
clr( f) char *f; { flag[ *f] = FALSE; }
/*====================================================================*/
doif( f, y, n)
char *f, *y, *n;
{
	if( flag[ *f] == TRUE )
		go( y);
	else
		go( n);
}
/*=====================================================================*/
doreset()
{
CHAR	a[3];

	closein();
	input( a, 2);
	DiskReset();
}
/*=====================================================================*/
DiskReset() { bdos( 13, 0); bdos( 13, 0); /* in case first didn't take */}
/*=====================================================================*/
/*page*/
openin()
{
	fpi = fopen( fnp, "r");
	eof = FALSE;
}
/*=====================================================================*/
readin()
{
char	*b;
	lineno++;
	if( fgets( buffer, 80, fpi) == NULL) eof = TRUE;
	if( !eof) {
		for (b = buffer; *b != '\n'; ++b)
			if (*b == '^')
				*b = ESC;
		*b = 0;
		}
	return eof;
}
/*=====================================================================*/
closein()
{
	fclose( fpi);
	eof = TRUE;
}
/*=====================================================================*/
writeout( l)
char	*l;
{
	while( list[ lp] = alloc( strlen( l) + 1) )
		{
		strcpy( list[ lp], l);
		lp++;
		return;
		}
	printf( "\n*** Internal error: out of memory\n");
}
/*=====================================================================*/
CHAR	*input( buff, len)
CHAR	*buff;
int	len;
{
CHAR	c;

	clear( buff, len, ' ');
	while( forever)
		{
		c = getchar();
		if (c == CR || c == LF)
			return *buff;
		if( len) 
			{len--;
			*buff++ = toupper( c);
			}
		}
}

