  .page
  .sbttl	'master polling  (b83mast.asm)'
  .prntx	'made it to master'

; +++++++++++++++++++++++++++++++++++++++++++++++
; +						+
; +	     HiNet Master Routines		+
; +						+
; +	last modified>	13apr84 kgh		+
; +						+
; +++++++++++++++++++++++++++++++++++++++++++++++

;	H I N E T   M A S T E R
;	-----------------------

lenNewDesc	==	05	; len of preRead desc
lenRdReq	==	10	; len of net read req
RecsInBuf	==	08	; records in read buf
Pre128		==	0FFh	;  128 byte preRead
Pre1024 	==	0FEh	; 1024 byte preRead
MaxRec		==	128	; last legal record#
slowPOLL	==	160	; start slow polling
pollSKIP	==	16	; slow poll counter

	; Disk locations of tables searched in login
	; Note that no table crosses a track boundary

SDtrk		==	2	; System Directory trck
SDsec		==	9	;   "        "	 sector 
SDlength	==	24	;   "    " entry length
SDmax		==	128	;   "    " # of entries
UNtrk		==	0	; User Name Table track
UNsec		==	29h	;  "     "    "  sector
UNlength	==	16	;  "     " entry length
UNmax		==	128	;  "     " # of entries
UCtrk		==	0	; User Config Table trk
UCsec		==	39h	;  "     "	"sector
UClength	==	64	;  "     " entry length
UCmax		==	128	;  "     " # of entries
MTtrk		==	1	; Machine Table track
MTsec		==	09h	;    "      "	sector
MTlength	==	12	;    "      " entry len 
MTmax		==	128	;    "      " # of ents
PTtrk		==	1	; Product Type Tble trk
PTsec		==	19h	;    "      "	 " sect
PTlength	==	25	;    "      " entry len
PTmax		==	40	;    "      " # of ents
OStrk		==	1	; OS Table track
OSsec		==	21h	;  "   "   sector
OSlength	==	96	;  "   "   entry length
OSmax		==	128	;  "   "   # of entries

BP2data 	==	MASTbuf+4; patch area for loader
CPM2code	==	11h	; unique code for CP/M 2
		      
WModTrk 	==	1	; WriteModes table track
WModSec 	==	15h	;  "    "     "   sector

	.page
MastUsr:	.byte	numusr-1; user being polled now
DeadUsr:	.byte	numusr	; "dead" user number
BootTime:	.byte	1	; boot broadcast cntr
LogTime:	.byte	1	; login poll counter
NtRdDesc:	.blkb	lenRdReq; temp storage
PreDesc:	.blkb	lenNewDesc
InSequence:	.byte	0ffh	; seq read flag
SeqBufd:	.byte	0	; buffer preRead
AutoRd: 	.byte	0	; preRead op flag

	; Buffers, flags and messages used in login
       
MTbuf:		.blkb	MTlength; mach tab entry buffer 
PTbuf:		.blkb	PTlength; prod table entry buf
SDbuf:		.blkb	SDlength; sys dir entry buffer
SDtarget:	.word	0	; .(file name to find)
OSbuf:		.blkb	OSlength; OS table entry buffer
OSoffset:	.byte	0FFH	; offset into OS table
usernam:	.blkb	UNlength
UNoffset:	.byte	0
UCbuf:		.blkb	UClength

badprod:.asciz	[cr][lf]"bad product# in login: "
badfile:.asciz	[cr][lf]"no sys file: "

MTdefault:	.byte	0 
BP2dir: 	.blkb	16	; directory info
honor:		.byte	0FFh	; login honor status

prevusr:	.byte	numusr-1; start scanning at begin

	; log down count table - change pollSKIP
	; value to alter time till logout occurs.
	; change slowPOLL value to change time to
	; start the slow poll sequence.
	; The table is initialized at cold boot.
slowTBL:
	.BLKB	numusr

.page
MastLoop:
; Save user registers and lock DMA chip
	call	saveUSER
	lxi	SP,MASTstack-6
	call	lockDMA ; reserve the DMA chip
;
; Don't allow parallel port ints while polling
  .ifn	Hard5opt,[
    .ife	SpoolOpt,[
	mvi	A,00000011b
	out	PIOAC
	]		; end ' SpoolOpt '
	]		; end ' not Hard5opt '
	ei		; interrupts OK now
;------------
; Poll each active user (poll bad users each 1/2 sec)
	lda	MASTusr
	ora	A
	jrnz	nxtusr
;
	mvi	A,numusr-1
NxtUsr: 
	sta	MASTusr ; store current user number
	lxi	H,InSequence
	mvi	M,0ffh	; init to read not in sequence
;
; see if it's time for our 1-second functions
	lxi	H,OneSecFlag
	mov	A,M	; see if it's at least 1 sec
	mvi	M,0	; since we last did the "check
	ora	A	; login / send bootstrap"
	jrz	..startpoll
;
; check for somebody wanting to log in
	call	ChkLogin
;
; send the boot phase 1 code for the Z80 stations
	lxi	H,Net1Strap	; HL = .bootcode
	lxi	B,len1strap	; BC = len of boot code
	mvi	E,0		;  E = delay time
	mvi	A,bootusr	;  A = destination
	call	SendNet 	; broadcast
;
; see if the spooler needs more data
	call	ChkSpool
;
; now continue the normal polling sequence
..startPoll:
	call	curUSR	; get current activity counter
	mov	A,M
	ora	A	; don't poll if status = 0
	jz	nxtpoll
;
	cpi	slowPOLL
	jrnc	..poll	; poll every time only till 223
;
	lda	MASTusr
	mov	C,A
	mvi	B,0
	lxi	H,slowTBL
	dad	B	; table loc for logdown count
	dcr	M
	jrnz	nxtpoll ; poll only every 32nd time
;
	mvi	M,pollSKIP	; init table
..poll:
	call	serOFF	; disable serial printer ints
	ei		; ints ok now
	mvi	A,poll	; poll the current user
	mvi	E,0	; no delay
	call	SENDUSR
	call	RECCMD	; wait for a response
	jrnc	ACKed
;
;----------
; Logout this user if countdown = 0
	call	curUSR
..nack:
	dcr	M	; countdown for logout

  .ife	HARDshar,[
	jrnz	nxtpoll
	call	MMclrlock; clear locks (if any)
	call	MMabort  ; abort spool job (if any)

    .ife	WriteModes,[
	lda	MastUsr
	call	ClearUser
	]			; end ' WriteModes '
	]			; end ' HardShare '

	jmpr	nxtpoll
;----------
; Poll was acknowledged with pollack or request
ACKed:	
	call	curUSR
	mvi	M,0FFh	; keep user logged in
	cpi	pollack
	jrz	nxtpoll ; check for poll acknowledge

;----------
; Process HiNet request
	call	savereq ; update entry in WHO table
;
; Parse request
	sui	whoNET
	jrc	..bad
;
	cpi	..lentab
	jrnc	..bad
;
	call	..dispatch
	jmpr	nxtpoll ; ret's to here if no error

..dispatch:
	call	DISPATCH
..table:
	.word	Mwho	; who
	.word	Mread	; read
	.word	Mwrite	; write
	.word	..bad0	; login
	.word	Mstart	; start spool
	.word	Mread1	; read 1K
	.word	Mstop	; stop spool
	.word	Massign ; assign
	.word	Mhog	; hog
	.word	Mlock	; lock
	.word	Munlock ; unlock
	.word	Mclrlock; clear locks
	.word	Mspool	; spool
	.word	Mhdstat ; hard disk status
	.word	Mdattim ; date/time
	.word	Mlogout ; instant logout

  .ife	WriteModes,[
	.word	M.Wr.Mode ; Write Mode request
	]		  ; end ' WriteModes '
  .ifn	WriteModes,[
	.word	..bad0
	]		  ; end ' not WriteModes '
	.word	Mnetinfo  ; Network Information

..lentab=	(.-..table)/2

;----------
; Give local user a shot at processing the request
..bad0: 
	pop	h	  ; balance the stack
..bad:
	lxi	H,MASTcom ; HL = message address
	lda	MASTusr   ; A = user number
	call	LOCALcall ; call user thru jump vector
			  ; initially INTERCEPT
	ora	A	  
	jrz	nxtpoll ; if no error, continue
;
	call	NETerr	; illegal request
;
;----------
; Poll next user, if any remain
NxtPoll:
	call	CkPrtOn ; maybe enable print ints
	lda	InSequence
	ora	a	; check for sequential read
	jrnz	..notSeq
;
; Restore Net request - it was a read
	lxi	h,NtRdDesc
	lxi	d,MastCom
	lxi	b,lenRdReq
	ldir
;
	lda	MastCom
	cpi	ReadNet ; check for 128 byte reads
	lda	MastSec
	jrz	..newRec
;
	adi	RecsInBuf -1	; bump to next 1k blk
..newRec:
	inr	a	; bump to next rec
	cpi	MaxRec+1; check for end of track
	jrc	..setSec
;
	lhld	MastTrk
	inx	h	; bump track
	shld	MastTrk
	mvi	a,1	; reset sector
;
..setSec:
	sta	MastSec
	call	KeepNew 	; save this disk desc
	mvi	a,0ffh
	sta	AutoRd		; this is a preRead
	lxi	h,PreRdBuf
	lda	MastCom 	; last req was either a
	cpi	ReadNet 	; 128 or 1024 byte read
	jrz	..128rd
;
;  Setting HardCom + 4 to 0FFh will force the 8-inch
; HDC to preREAD the next 1k sector after this request
; - this will tend to improve net performance.
;	It awaits the new release of the HDC firmware.

;.ife Hard8opt, [
;	lxi	H,HardCom + 4
;	mvi	M,0FFh
;	]
;
	call	MMrd1		; pre read 1k block

;.ife Hard8opt,  [
;	xra	A		; clear the forced Pre-
;	sta	HARDcom + 4	; Read flag
;	]
;
	lxi	H,AutoRd	; AutoRd = 0 means
	mov	A,M		; read is within unit
	mvi	M,0		; reset flag
	ora	A		; check the flag
	mvi	A,Pre1024	; mark the buffer (1k)
	jrz	..markType
;
	xra	A		; no read was done
	jmpr	..markType
;
..128rd:
	call	MMread		; pre read 128 byte blk
	lxi	H,AutoRd	; AutoRd = 0 means
	mov	A,M		; read is within unit
	mvi	M,0		; reset flag
	ora	A		; check the flag
	mvi	A,Pre128	; mark the buffer (128)
	jrz	..markType
;
	xra	a		; no read was done
..markType:
	sta	SeqBufd ; mark preRead length
	ora	A	; A = in_unit_flag also 0 means 
	jrz	..notseq ; next request can't be seq'l.
;
;      Possibly delay to give user time to be ready for
; another read by the time you poll him - the Hard5
; master will never be too fast to just check this on
; the 8 inch master.
;      This awaits the release of the HDC firmware that
; sets the DidBufRead flag (HardStat + 6).
;
; .ife Hard8opt,[
;	lxi	B,656		; 6.56 msec delay count
;	lda	HardStat+6	; A = FF means the HDC
;	inr	A		; got data from buffer,
;	cz	delay		; so wait for pre-read
;	]

	lda	MastUsr ; and poll this user again
	jmp	NxtUsr
;
..notSeq:
	lda	MASTusr
	dcr	A	; decrement user number
	jnz	nxtusr
;
;---------
; Poll one "dead" user per pass
	lda	deadusr
	dcr	A
	jrnz	..poll
;
	mvi	A,numusr-1
..poll: sta	deadusr
	sta	MASTusr
	call	curUSR
	mov	A,M
	ora	A
	jrnz	..local ; don't poll if active
;
	mvi	A,poll
	mvi	E,0	; no delay
	call	SENDUSR
	call	RECCMD	; get command from net user
	jnc	ACKed	; process request, if any
;
;----------
; See if the local user has anything for us to do
..local:
	sub	A
	sta	MASTusr ; set local user number
	lda	NETcom	; check local user's command
	ora	A
	jrz	clrreq	; jump if nothing to do
;
	lxi	H,NETcom; get local user's command
	lxi	D,MASTcom
	lxi	B,lencom
	ldir
;
	lxi	H,userlist
	call	savereq ; update entry in WHO table
	sui	whoNET
	jrc	..bad
;
	cpi	..lentab
	jrnc	..bad
;
	call	..dispatch
	jmpr	clrreq	; ret here if no error

..dispatch:
	call	DISPATCH
..table:
	.word	..bad0	; who
	.word	Lread	; read
	.word	Lwrite	; write
	.word	Llogin	; login
	.word	Lstart	; start spool
	.word	..bad0	; read 1K
	.word	Lstop	; stop spool
	.word	Lassign ; assign
	.word	..bad0	; hog
	.word	Llock	; lock
	.word	Lunlock ; unlock
	.word	MMclrlock; clear locks
	.word	Lspool	; spool
	.word	Lhdstat ; hard disk volume status
	.word	..bad0	; date/time request
	.word	..bad0	; instant logout

  .ife	WriteModes,[
	.word	L.Wr.Mode ; Write Mode request
	]		  ; end ' WriteModes '
  .ifn	WriteModes,[
	.word	..bad0
	]		  ; end ' not WriteModes '
	.word	Lnetinfo

..lentab=	(.-..table)/2

..bad0: pop	h	; balance stack
..bad:	call	NETerr	; should NEVER come here

clrreq:
	sub	A	; clear local user's request
	sta	NETcom
;----------
; We used to broadcast the bootstrap code here, but as
; of version 2.247 it's been moved to the top of this
; module and is activated by elapsed time rather than
; by the number of polls since the last broadcast.
;
;-------
; Poll mimic and login pseudo users every 1/3 sec
; (if net is lightly loaded; less often on a busy net)

..poll:
	lxi	H,logtime
	dcr	M	; poll if counter = 0
	jrnz	..spool
;
	mvi	M,sendlog
	call	CHKmimic; poll mimic
	call	CHKlogin; check for new logins
;
;-------
; Check spooling
..spool:
	call	CHKspool
;
;-------
; flush the least-recently-used write 
; buffer on Hard5 master only

    .ife	Hard5opt,[
..flush5:
	lda	Hd5busy ; is the drive in use
	ora	a
	jrnz	Rdy2ret ; jump if in use
;
	push	x	; some programs use Ix
	call	LruFlush
	pop	x	; restore Ix
	]		; end ' Hard5opt master '

;-------
; Return control to local user for average 1/120 sec
; (on a lightly-used 8-inch system anyway)
Rdy2ret:
	di		; no ints until user running
	sub	A	; unlock the DMA chip
	sta	lockbyte
MastRet:
	mvi	A,wakeupMAST; delay a bit before
	sta	timeMAST    ; calling MASTER again
	jmpr	retUSER
;
;-------
Intercept:
	mvi	A,0FFh	; come here if local user
	ret		; not intercepting net calls
  .page
  .sbttl	'context switch routines  (b83mast.asm)'
;-----------------------------------------------------
;  C O N T E X T   S W I T C H	 R O U T I N E S
;-----------------------------------------------------
USER.SP:	.word	BURN.SP
MAST.SP:	.word	0
LOCALflag:	.byte	0 ; local user => 0, Mast => 1

;----------
; Save user registers
saveUSER:
	xthl
	sspd	USER.SP
	lxi	SP,MASTstack
	push	D
	push	B
	push	PSW
	lspd	MAST.SP
	mvi	A,0FFh
	sta	LOCALflag
	pchl

;----------
; Restore user registers
retUSER:
	sub	A
	sta	LOCALflag
	sspd	MAST.SP
	in	PIOAD
	ani	80h	; return to user if no INT
	jrz	..ret

..wait:
	in	PIOAD
	ani	80h	; wait until INT released
	jrnz	..wait
;
	lxi	SP,MASTstack-6
	pop	PSW
	pop	B
	pop	D
	lspd	USER.SP
	pop	H
	ei
	jmp	30h	; go to DDT when INT released

..ret:
	lxi	SP,MASTstack-6
	pop	PSW
	pop	B
	pop	D
	lspd	USER.SP
	pop	H
	ei
	ret
  .page
  .sbttl	'login new user  (b83mast.asm)'
;-----------------------------------------------------
; L O G I N   N E W   U S E R
;-----------------------------------------------------

; Poll login user - if answered, then log'er in
CHKlogin:
	lxi	H,LOGcom       ; blank entry first
	lxi	D,LOGcom+1
	lxi	B,(8+6+4+1)-1  ; name,psw,ser,pt
	mvi	M,0
	ldir	

	mvi	A,poll
	mvi	E,0	; no delay
	lxi	B,1
	call	SENDLUSR; poll "login" user
;
	lxi	H,LOGcom
	lxi	B,lencom+5
	lxi	D,$1ms
	sub	A
	call	RECNET	; wait for response
	call	ckRECstat
	jrnc	..ack
;
; Nobody (or everybody!) wants to login
..logerr:	
	mvi	A,lognack
	mvi	E,$halfms
	lxi	B,1
	jmp	SENDLUSR; prospective logins must retry
;
; Check machine, prod type, user name and password
..ack:	
  .ife	HARDshar,[
	lxi	H,MASTnam	; move to safe place
	lxi	D,usernam	; (reads will trash
	lxi	B,14		; this block!)
	ldir

	call	ckmach	; machine doesn't have to be
			; in the Machine Table.
	call	ckprod	; product MUST be in prod!
	jnz	..deny
;
	lxi	H,PTbuf+1 ; Boot Phase 2 MUST exist!
	call	ckSD
	jnz	..deny 
	lxi	H,SDbuf+8 ; in which case, save out its
	lxi	D,BP2dir  ; directory information
	lxi	B,16
	ldir
;
	call	ckusr  ; user HAD BETTER be in Table!
	ora	A
	jrz	..os	; go on & find an OS, else
;
	mvi	A,2	; set honor flag to tell loader
	sta	honor	  ; login-please situation.
	lxi	H,PTbuf+9; Line up login-please name.
	jmpr	..tuff	; Go fake up a load list.

; Now see about finding a BIOS for this individual.
..os:
	call	findos	; 0 fail, 1 ok big, 
			; 2 default, 3 ok small
	lxi	H,honor ; honor flag
	mvi	M,1	; honor flag=1 for default
	cpi	2	; A=2 if default was found
	jrz	..plug
	ora	A	; A=1 or 3 means ok. Set
	mvi	M,0	; honor=0 for req. matched
	jrnz	..plug
	mvi	M,3	; here if A=0, i.e. failure.
			; honor flag=3 for tough luck
	lxi	H,PTbuf+17; "OS menu" file name
..tuff:
	lxi	D,OSbuf+23 ; fake up load list
	lxi	B,8
	ldir
	push	D	; 1st char of next "name"
	pop	H	; make it source
	inx	D	; here is destination
	lxi	B,55	; blank the rest out so we know
	mvi	M,0	; not to search for 'em
	ldir

; Bring in the cold-boot loader (boot phase 2) and
; plug the parameters into it.

..plug:
	call	rloader 	; read the loader
				; (first 1k)
	lxi	H,UCbuf    ; ckusr disk defaults
	lxi	D,BP2data  ; move into MASTbuf
	lxi	B,32
	ldir
	lda	MTbuf+11   ; install the IOBYTE
	stax	D
	inx	D
	lxi	B,32	   ; install the type-ahead 
	ldir
			    
			    ; install the load-list 
	mvi	B,8	    ; may be up to 8 names here
	lxi	H,OSbuf+23  ; start of names
	lxi	D,BP2data+66; start of locations
..lllp: mov	A,M
	ora	A
	jrz	..done	; null name means end of list
	push	B
	push	H
	push	D
	call	ckSD   ; find its vital statistics
	pop	D
	pop	H
	jrz	..fnd
	mvi	A,4	; fatal error honor flag
	sta	honor
	pop	B	; throw out loop counter
	jmpr	..done	; and just quit.

..fnd:	push	H	; entry found, move it
	lxi	H,SDbuf+8; space past name
	lxi	B,16	; move the remaining 16 bytes.
	ldir		; now D is set to go again!
	pop	H	; here's H back
	lxi	B,8	; point it at the next name
	dad	B
	pop	B	    ; get that loop counter
	djnz	..lllp	    ; go until all 8 done
..done: lda	honor	    ; show how well we did
	lxi	H,MTdefault ; set high bit of honor
	add	M	    ; flag if machine is not
	sta	BP2data+65  ; in the Machine Table
	lxi	H,BP2data+194 ; product type spot
	lda	PTbuf
	mov	M,A
			    ; BOOT PHASE 2 set 
	]		; end ' HARDshare '
;
; Find room in the current user list

	lda	prevusr ; start scanning at last login
..look: 
	inr	A
	cpi	numusr
	jrnz	..ok
;
	mvi	A,1	; restart scan at beginning
..ok:	
	push	PSW
	sta	MASTusr
	call	curUSR	; point to userlist entry
	mov	A,M
	ora	A	; if zero, then available
	jrz	..found
;
	pop	PSW
	lxi	H,prevusr
	cmp	M	; see if all entries checked
	jrnz	..look	; jump if not all checked
;
; Deny login if name not found or no room in list
..deny: 
	lxi	H,MTbuf     ; serial number
	lxi	D,LOGser
	lxi	B,4
	ldir
	mvi	A,logdeny
	mvi	E,0
	lxi	B,1+1+7+4	; resp, usr, time, ser
	jmp	SENDLUSR
;
; Put user in table, send user number, time, serial num
..found:
	pop	PSW
	push	H	; save table location
	sta	prevusr ; save current user number
	call	newuser ; put user in table

    .ife	WriteModes,[   ; this user can't have 
	call	ClearUser      ; locked anything yet.
	]		       ; end ' WriteModes '

	lxi	H,ticks
	lxi	D,LOGclk
	lxi	B,7
	ldir		; login time
	lxi	H,MTbuf 
	lxi	B,4
	ldir		; serial number
;
	mvi	A,LOGack
	mvi	E,0
	lxi	B,1+1+7+4	; resp, usr, time, ser
	call	SENDLUSR
;
; Give the user the cold-boot loader
;
	lda	MASTbuf     ; see how many K it will be
	mov	B,A
..send: push	B
	call	sendBP2     ; send present chunk
	call	rloader     ; get the next K
	pop	B
	djnz	..send

	pop	H	    ; user table location
	lda	honor
	cpi	2	; if it's a login-please,
	jrz	..0	; wipe out the user table entry
	cpi	4	; if it's a fatal error, likewise
	rnz		; wipe it on out
..0:	mvi	M,0	; by running timer down to 0
	ret

  .ife	HARDshar,[
;------------------------
; Read 1K of the cold-boot loader into MASTbuf.
; Change the pointers in our local copy of the cold-boot
; loader's directory information so that each time this
; routine is called we get the next 1K.  This routine
; does not check for the end of the file, instead the  
; calling routine refers to the first byte of the cold-
; boot loader to determine how many times to call this
; routine.
;
; Regs in & out: none
; Trashed:	 all

rloader:
				; set up read of loader
	lhld	BP2dir+2	; track
	lda	BP2dir+4	; sector
	call	rdset		; force vol, unit = 0

	lxi	H,MASTbuf	; start at begin of buf
	mvi	B,8		; get 8 sectors (1k)
..rsec: push	B
	push	H
	call	MMread		; read a sector of code
	lda	MASTsec
	inr	A 
	cpi	129		; off end of track?
	jrc	..nsec
	lhld	MASTtrk 	; if so, bump track
	inx	H
	shld	MASTtrk 	; and get sector back
	shld	BP2dir+2
	ani	127		; into range
..nsec: sta	MASTsec 	; fix disk address
	sta	BP2dir+4
	pop	H
	lxi	D,128		; increment DMA address
	dad	D
	pop	B
	djnz	..rsec		; get anither till done
 
	ret
;----------
; Check user table for name and password
; Name table entry saved in username
; Config table entry saved in UCbuf
;  Regs out:   A = 0 if name found
;	       A not 0 if name not found
ckusr: 
;
	sub	A	; read user table from disk 0
	sta	MASTvol ; HD drive 0
	sta	MASTdsk ; unit 0
	sta	UNoffset; start user counter at 0
	lxi	H,UNtrk ; User Name Table track
	shld	MASTtrk
	mvi	A,UNsec ; User Name Table sector
	sta	MASTsec
;
; Search next sector for match with user name
..nsect:
	lxi	H,MASTbuf
	push	H
	call	MMread	; read sector
	pop	H
..nname:
	lxi	D,usernam
	lxi	B,14	; compare 14 chars
	call	match
	jrz	..match 

	lda	UNoffset; keep our counter.
	inr	A
	sta	UNoffset

	lxi	D,UNlength ; move to next
	dad	D
	mov	A,L
	cpi	(MASTbuf+128)&0FFh
	jrnz	..nname
;
; No match found, so search next sector of table
	lda	MASTsec
	cpi	UNsec+(UNlength*UNmax/128)-1 ; maybe end
	rz		; deny login if name not found
;
	inr	A	; this is ok since we know
	sta	MASTsec ; the table is on a trk
	jmpr	..nsect
;
; Save Entry, Get Default Configuration Table
..match:
	lxi	D,usernam  ; move the whole entry in,
	lxi	B,UNlength ; flags and all.
	ldir

	lda	UNoffset; get number of table entry
		; NOTE! the rrc below depends on
		; there being 2 entries per sect
		; change it if we ever decide to
		; make UClength other than 64!
	rrc		; two entries per sector,
	ani	(UClength-1)*UCmax/128 ; 64 sects 
	mvi	B,UCsec
	add	B	; get the starting sector
	sta	MASTsec ; rd sect UCsec..UCsec+63
	lxi	H,UCtrk ; ( the right track) 
	shld	MASTtrk
	sub	A
	sta	MASTvol ; table is on drive 0
	lxi	H,MASTbuf
	push	H
	call	MMread	; get default 
	pop	H
	lda	UNoffset
	ani	1	; check odd or even
	jrz	..even
	lxi	H,MASTbuf+64; move entry 
..even:
	lxi	D,UCbuf
	lxi	B,UClength
	ldir
	sub	A	; A = 0 means name OK
	ret

;------------------
; Find machine in the Machine Table
; Leave relevant entry in MTbuf
; Regs in:  none
; Regs out: none
;	    If success:  MTdefault = 0
;			 MTbuf = matching entry
;	    If failure:  MTdefault = 80h
;			 MTbuf = synthetic entry
;			     made from login req.
; Trashed:  all

ckmach:
	lxi	H,MTtrk  ; where to find machine table
	mvi	A,MTsec
	call	rdset	 ; set up read

	mvi	B,MTmax  ; max entries in mach table
..ent:	push	B
	mvi	B,MTlength ; length of an entry 	  
	lxi	H,MTbuf 			   
	call	getent	; get an entry		   
	lxi	D,LOGprom; try match serial number
	lxi	B,4	; length of serial number  
	call	match						
	pop	B	; restore loop ctr, even stack		 
	jrz	..out	; zero if match is good
	djnz	..ent
 
	lxi	H,LOGprom ; get serial #, product type
	lxi	D,MTbuf   ; as sent by station
	lxi	B,5
	ldir
	push	D	; fill next 7 bytes of MTbuf
	pop	H	; with nulls.  (This means an
	inx	D	; option map of all 0's and
	mvi	M,0	; an IOBYTE of 00.)
	lxi	B,6
	ldir
	mvi	A,80h
..out:	sta	MTdefault
	ret

;------------------
; Check if the product is in the Product Type Table
; Leave relevant entry in PTbuf
; Regs out:  Z if found, NZ if not
ckprod:
	lxi	H,PTtrk
	mvi	A,PTsec
	call	rdset 
	mvi	B,PTmax ; max entries in prod type table
..ent:	push	B
	mvi	B,PTlength ; length of an entry
	lxi	H,PTbuf 		    
	call	getent	; get the entry
	lxi	D,MTbuf+4; try and match product type
	ldax	D
	pop	B	; get back cnt, even stack 
	ora	a	; product# of zero is illegal
	jrz	..bad
;
	cmp	M
	rz		; return if match gives Z
	djnz	..ent	; try again
..bad:
	lxi	H,badprod
	lxi	D,MTbuf+4  
	mvi	B,1
	call	LOGerr
	ori	0FFh	; show failure 
	ret		; return to caller

;------------------
; Find file in the System Directory
; Leave relevant entry in SDbuf
; Regs in:  HL = ptr to file name
; Regs out: Z if found, NZ if not
ckSD:  
	shld	SDtarget
	mov	A,M	 ; if first byte of name is null
	ora	A	 ; then reject, but don't print
	jrz	..bad	 ; name as it's unprintable.
;
	lxi	H,SDtrk  ;where to find sys dir
	mvi	A,SDsec
	call	rdset	 ; set up read

	mvi	B,SDmax    ; max entries in sys dir
..ent:	push	B					 
	mvi	B,SDlength ; length of an entry 	  
	lxi	H,SDbuf 			   
	call	getent	; get an entry		   
	lded	SDtarget; name to match
	lxi	B,8	; length of name
	call	match						
	pop	B	; restore loop ctr, even stack		 
	rz		; zero if match is good
	djnz	..ent
 
	call	pErrMode  ; see if errors are to be 
	jrz	..bad	  ; printed.
	lxi	H,badfile
	call	PRTMSG
	lhld	SDtarget
	mvi	B,8
	call	PRTSTR
..bad:
	ori	0FFh	; show failure
	ret		; return to caller

;----------------------------------------
; Search the bios table for a match with the machine
;  type, option map & OS we want.  Put winning entry in
;  OSbuf, return a code saying how good it is.
; This search depends on the OS Table being organized
;  in increasing size order! If looking for the smallest
;  OS of a given type, we need only find the first one
;  of that type.  In any case we record its number so 
;  that we can go back and get it if we need to.  This
;  may seem cumbersome but is better than having to   
;  keep the whole entry around (96 bytes!).	      
; If the lower nibble of the user's OS specification is
;  0, the lower nibble of the corresponding byte in the
;  OS Table will be ignored (need not match).  The excep-
;  tion is CP/M 2 (code 11h) which will NEVER be sent un-
;  less the user's OS specification is 11h exactly.
;
; Regs in:  none	   
; Regs out:  A = 0 if total failure
;		 1 if exact match was asked for & found
;		 2 if exact match was asked for but
;		      high-TPA OS was found instead
;		 3 if high-TPA was asked for and found
; (i.e. bit 0 means we got exactly what we wanted, bit
;  1 means we got a high-TPA OS.)
; Trashed:  all

findos:  
	lxi	H,OStrk     ; set up to read OS table 
	mvi	A,OSsec
	call	rdset
	mvi	A,0FFh	    ; set up to record first 
	sta	OSoffset    ;  possible match

	mvi	B,OSmax     ; max entries in table
..loop: push	B	    ; outer loop gets entries

	lxi	H,OSbuf     ; where to put entry
	mvi	B,OSlength  ; length of an entry
	call	getent	    ; go get it

	lxi	D,username+14 ; OS the user wants
	ldax	D	    ; we must match the upper
			    ;  nibble.	If the lower
			    ;  nibble in (DE) is not 0
			    ;  we must match it too.
	xra	M	    ; M is the BIOS' OS
	jrz	..osok	    ; exact match wins.
	ani	0F0h
	jrnz	..osno	    ; differs in upper nib.
	ldax	D	    ; differs in lower nib.
	ani	0Fh	    ; if lower nib matters,
	jrnz	..osno	    ;  say no match.
	mvi	A,CPM2code  ; here if lower nib "doesn't
	xra	M	    ; matter", which really says
	jrz	..osno	    ; allow anything but CP/M 2.
			    ; reject CP/M 2 BIOS's.
..osok: 		    ; OS is ok, now see if it
			    ;  can run on the user's
			    ;  machine.
	lda	PTbuf	    ; First byte = product type
	push	H
	inx	H	    ; HL pnts to product map
	call	smapbit     ; Is the bit 0 or 1...
	pop	H	    ; 0 means can't run on that
	jrz	..prno	    ;  machine, so no good.
			    ; If we get here we match on
	lda	OSoffset    ;  OS type and product type
	inr	A	    ; Is this the first time...
	jrnz	..nnew	    ;  No, keep flag as it is.
	pop	B	    ;  Yes, get loop counter,
	push	B	    ;  use it to figure offset
	mvi	A,OSmax     ;  of the current entry.
	sub	B	    ; It's non-negative so now
	sta	OSoffset    ; OSoffset says we got one.

..nnew: lda	username+15 ; Does she want small or good
	bit	0,A	    ; 0 for full-service, 1 if
	mvi	E,3	    ;  options don't matter. 
	jrnz	..bingo     ; E=3 means we got high-TPA 
			    ;  as wanted, so we're done 
			    ; If that isn't what we 
			    ;  wanted, test option map.
	lxi	D,OSbuf+17  ; option map in BIOS table
	lxi	H,MTbuf+5   ; option map in machine tbl 
	lxi	B,6	    ; len to match
	call	match
	mvi	E,1	    ; code 1, exact match w/map
	jrz	..bingo
..osno: 		    ; entry failed on OS type, or
..prno: 		    ; entry failed on product map
	pop	B	    ; pop the outer loop counter
	djnz	..loop
			    ; we dropped out without an
	mvi	E,0	    ; exact match being found.
	lda	OSoffset    ; did we get anything...
	inr	A	    ; 0 if not, 1-128 if so.
	jrz	..ok	    ; nothing at all. Code 0.
	mov	B,A	    ; Something! go back to get
	lxi	H,OStrk     ; it.  Start at beginning
	mvi	A,OSsec     ; of table and go fast-fwd
	call	rdset	    ; until we hit it again.
..ffwd: push	B
	mvi	B,OSlength  ; entry is this long
	lxi	H,OSBUF     ; and goes here.
	call	getent	    ; get it.
	pop	B
	djnz	..ffwd
	mvi	E,2	    ; consolation flag
	jmpr	..ok
..bingo:
	pop	B	    ; align stack
..ok:	mov	A,E	    ; set return code.
	ret

;-----------------------------------
; Search a bit-map for a particular bit.
; Regs in:   A = the number of the bit
;	    HL = ptr to beginning of bit map
;		 (low addr, low-order)
; Regs out:  flag Z or NZ according to bit
; Trashed:   A,B,C,HL
;
smapbit:
	push	PSW
	ani	7	    ; bit shift
	mov	C,A	    ; save it
	pop	PSW
	xra	C
	srlr	A
	srlr	A
	srlr	A	    ; byte shift
	ora	A
	jrz	..bit
	mov	B,A
..inx:	inx	H	    ; move along to byte
	djnz	..inx
..bit:	mov	A,C
	ora	A	    ; see if bit to test is 0	
	mov	B,A	    ; move it to B in case not
	mov	A,M	    ; get the byte to rotate 
	jrz	..test	    ; Z was last set by ora A
..rrc:	rrc
	djnz	..rrc
..test: bit	0,A
	ret
;--------------------------

; Compare two strings.
; Regs in:  HL = ptr to one string
;	    DE = ptr to the other
;	    BC = length to match
; Regs out: A=0,Z if match; A<>0,NZ if not
; Trashed:  B,PSW
match:
	push	H
	push	D
..loop: mov	A,B
	ora	C
	jrz	..out
	ldax	D
	cmp	M
	jrnz	..out
	inx	H
	inx	D
	dcx	B
	jmpr	..loop
..out:	pop	D
	pop	H
	ret
;-------------------------
; set up to read a table via TABLbuf, tgetc
; Regs in:  HL = track
;	     A = sector
rdset:	
	sta	MASTsec ; first sector of table
	shld	MASTtrk ; (only) track of table
	sub	A
	sta	CHRcnt	; no chars available yet!
	sta	MASTvol ; all tables on vol 0
	sta	MASTdsk ; unit 0
	ret
;-------------------------
; get an entry from the currently-open table
; Regs in:  HL = ptr to buffer to read into
;	     B = length to read
; Regs out: none
; Trashed:  all except HL
getent:
	push	H
..chr:	call	tgetc	 ; get a character
	mov	M,A
	inx	H
	djnz	..chr	; get until 12 are gotten
	pop	H
	ret
;-------------------------
; Get a character from the table-buffer.
; Regs in:   A = character.
; Regs out:  none
; Trashed:   A, DE

CHRcnt: .byte	0
TABLbuf:.blkb	128

tgetc:
	push	B
	push	H
;
	lda	CHRcnt
	ora	A
	jrnz	..get
;
	lxi	H,TABLbuf	; so read a bufferful
	call	MMread		; get a sector
	lxi	h,MASTsec	; what we read
	inr	m
 ; NOTICE that this assumes the table
 ; being read lies entirely within one
 ; track.  They all, in fact, do.

	mvi	A,128
..get:
	mov	C,A
	dcr	A
	sta	CHRcnt	; how many will remain
	lxi	H,TABLbuf+128
	mvi	B,0
	ora	A	; clear carry
	dsbc	B	; point H at char
	mov	A,M
	pop	H
	pop	B
	ret

; -------------------------------
; Send 1k of cold-boot loader to newly-logged-in user
; Regs in:  none
; Regs out: none
; Trashed:  all
sendBP2:
	lxi	H,MASTbuf
	lxi	B,len2strap
	lda	MASTnum
	mvi	E,$halfms*2 ; extra delay for DSC/4
	jmp	SENDNET

;--------------------------------
; An important search failed.  Print an error message
; if the mode bit says errors are to be printed.
; Regs in:  HL = .(error message)
;	    DE = .(buffer w/search pattern)
;	     B = length of buffer
; Regs out: none
; Trashed:  all

LOGerr:
	push	H
	call	pErrMode  ; only print if ok
	pop	H
	rz
	push	B	; save buffer byte count
	push	D	; and buffer location
	call	PrtMsg	; put up error message up
	pop	H	; pop buffer loc into HL
	pop	B	; print any relevant bytes
	jmp	PrtBuf	; (e.g. bad serial number)
       ]	       ; end 'HARDshar'
;----------
; Assign the user a position in the user table
;  Regs in:  HL = pointer to available table entry
;	     A	= user number
newuser:
	mvi	M,0FFh	; log 'er
	sta	LOGnum	; give userno to user

	push	H	
	call	MMclear ; clr locks if any
	pop 	H

  .ife	HARDshar,[
	inx	H
	xchg
	lxi	H,usernam
	lxi	B,8
	ldir		; save user name
	lxi	H,secs
	lxi	B,3
	ldir		; save login time
	]		; end ' HARDshare '
	ret
  .page
  .sbttl	'process local user request (b83mast.asm)'
;------------------------------------------------------
; P R O C E S S   L O C A L   U S E R	R E Q U E S T
;------------------------------------------------------
Lread:	
	lhld	NETdma	; read directly into user area
	jmp	MMread 
;
;-------
; entry>	none
; exit> 	none
LWrite:

  .ife	WriteModes,[

	call	SetUpRequest
	mvi	a,WrQuery
	sta	M.Request.Mode	; ask for status
	xra	a
	sta	M.Value.Mode	; - for user 0
	sta	M.User.Mode	; - by user 0
	call	L.Wr.Mode	; get Wr_Mode_Status
	lda	NetDtn		; a = current status
	call	CompareStatus

    .ifn	BiosGrants,[
	jnc	WrongMode	; say write not allowed
	]			; end ' not BiosGrants '

    .ife	BiosGrants,[
	jrc	..doLocal	; our write is allowed
;
	lda	NetDtn		; a = current status
	call	SayRefused	; say write not allowed
	mvi	a,WrGrant
	sta	M.Request.Mode	; ask for ownership
	call	L.Wr.Mode	; get Wr_Mode_Status
	lxi	h,ModeTable	; local disk status tbl
	lded	cpmDsk		;  e = current disk
	mvi	d,0
	dad	d		; hl = .ModeTable(cpm)
	lda	NetCom		;  a = new status
	mov	m,a		; save new status
	call	MstRestoreParams
	jmpr	LWrite		; retry if requested
;
;----------
;	either the user owns this partition
;	   or it is a read/write partition
;	   or it is a HiDos shared partition
;	      and the user is running HiDos (or lying)
..doLocal:			; a = MesAck
	]		; end ' BiosGrants '
	call	MstRestoreParams; moved by CkWriteReq
	]		; end ' WriteModes '

	lhld	MastDma ; write directly from user area
	jmp	MMwrite
;
;----------
  .ife	HARDshar,[
Lassign:
	lxi	H,MASTnam; point to name and password
	call	MMassign
	sbcd	NETassn ; store assignment value
	sded	NETassn+2
	ret

;----------
Llogin: 
	lxi	H,BOOTnam	; get name into the
	lxi	D,usernam	; area used by ckusr
	lxi	B,14		; 8 name + 6 psw
	ldir
	call	ckusr
	sta	NETassn ; A = 0 if ok
	lxi	H,UCbuf  
	lxi	D,DSK0def
	lxi	B,8*4	; move the defaults
	ldir
	inx	D	; now move the
	lxi	B,32	; typeahead stuff
	ldir		; put it down there
	sub	A
	call	curUSR
	jmp	newuser ; enter name in user table

;----------
  .ife	SPOOLopt,[
Lstart: lda	SPLid
	sta	SPL$id
	call	MMstart
	lxi	H,SPL$resp
	lxi	D,RespSpStart
	lxi	B,7
	ldir	; return spool ack,dsk,track,sect,vol
	ret	;  and spool size

;----------
Lstop:	lda	SPLid
	sta	SPL$id
	jmp	MMstop
;
;----------
Lspool:
	call	Lwrite
	jmp	MMspool
;
;----------
Lhdstat:
	lbcd	HSTadr	; Get HD status block addr
	jmp	MMhdstat
	]		; end ' SPOOLopt '

;----------
Llock:
	call	MMlock
	sta	LOCKstat; store status for user
	ret

;----------
Lunlock:
	call	MMunlock
	sta	LOCKstat; store status for user
	ret

	]		; end ' HARDshare '
;
;-------
;	- Called by the local user command parser when
;	the Generic.Mode command is Write_Mode (20h)
;
;  - Normally the status would be returned starting at
;  NetMsg but the master clears NetCom to tell the
;  local user that his command is processed.
;  - Command acknowledgement is returned in NetMsg
;  for consistency with network stations.  
; entry>	none
; exit> 	none

    .ife	WriteModes,[
L.Wr.Mode:
	call	MM.Wr.Mode
	mov	a,m
	sta	NetMsg		; save command ack/deny
	lxi	d,NetCom	; save params
	ldir
	ret
	]	; end ' Write Modes '
;-----------
; Net Info -- Pass pointer to info table if local user
;
Lnetinfo:
	lxi	h,NetInfo
	shld	NETifo	; return in netbuffer
	ret
  .page
  .sbttl	'process remote user request (b83mast.asm)'
;------------------------------------------------------
; P R O C E S S   R E M O T E	U S E R   R E Q U E S T
;------------------------------------------------------

; +++++++++++++++++++++++++++++++++++++++++++++++++++++
; +						      +
; +		- WrMode.asm -			      +
; +						      +
; +++++++++++++++++++++++++++++++++++++++++++++++++++++

; last modified>	06dec1983	joel wittenberg


;	Master Write_Ownership routines
;	------ --------------- --------

  .ife	WriteModes,[
;-------
;	- Called by the remote user command parser when
;	the Generic.Mode command is Write_Mode (20h)
; entry>	none
; exit> 	none
M.Wr.Mode:
	call	MM.Wr.Mode
	mvi	e,0
	lda	MastUsr 	; send data to station
	jmp	SendNet
;
;-------
; entry>	none
; exit> 	hl = .Wr_Mode return data
;		bc = len Wr_Mode return dat
MM.Wr.Mode:
	call	Wr.Status.Fill	; fill name w/0ffh
	call	Exec.Mode.Req	; do Wr_Mode_Request
	sta	Value.WrMode	; return current status
	cpi	MaxUser +1
	cc	Name.Fill	; return owners' name
;
	lxi	h,Ack.Wr.Mode	; hl = .return data
	lxi	b,len.Wr.Status
	ret
;
;-------
;	- default user name field to 0ffh
; entry>	none
; exit> 	none
Wr.Status.Fill:
	lxi	h,Value.WrMode
	mvi	b,len.Wr.Status -1
..fill:
	mvi	m,0ffh
	inx	h
	djnz	..fill
	ret
;
;-------
;	- execute the specific Request.Mode
; entry>	none
; exit> 	a = current Wr.Mode.Value
Exec.Mode.Req:
	lda	M.Request.Mode
	cpi	MaxReq +1	; illegal requests will
	jrnc	BadRequest	; execute <BadRequest>
;
	call	Dispatch	; execute a table entry
..ptable:
	.word	Grant
	.word	Release
	.word	Force
	.word	Query
	.word	Clear
MaxReq	=	((.  -..ptable) /2) -1

;
;-------
;	- fill the user name field with the name of the
;	  user who owns this partition
; entry>	a = valid user#
; exit> 	none
Name.Fill:
	mvi	h,0
	mov	l,a
	dad	h	; *2
	dad	h	; *4
	dad	h	; *8
	dad	h	; *16
	lxi	d,UserList
	dad	d	; hl = .User(activity count)
	inx	h	; hl = .User(name)
	lxi	d,Name.WrMode
	lxi	b,len.Wr.Status -2
	ldir
	ret
;
;-------
;	- return a parameter error indication
; entry>	none
; exit> 	a = GenericErr
BadRequest:
	mvi	a,GenericErr
	ret
;
;-------
;	- return the current unit status and address
; entry>	none
; exit> 	 a = current Wr_Mode_Status
;		hl = .Wr_Mode_Status(Volume,Unit)
Query:
	lda	M.Volume.Mode
	cpi	MaxVol +1	; vols 0 - 3 only
	jrnc	BadRequest
;
	cmc		; clear carry
	rrc
	rrc		; *64 (entries per volume)
	mvi	d,0
	mov	e,a
	lxi	h,WrMode.Table
	dad	d	; hl = .Wr_Mode_Table(volume)
	lda	M.Unit.Mode
	cpi	MaxUnit +1	; units 0 - 63 only
	jrnc	BadRequest
;
	mov	e,a
	dad	d	; hl = .Wr_Mode_Table(vol,unit)
	mov	a,m
	ret
;
;------
;	- unconditionally change a units Write_Mode
; entry>	none
; exit> 	a = new Write_Mode_Value
Force:
	call	Query	; a = current Write_Mode_Value
	cpi	GenericErr
	rz
;
	lda	M.Value.Mode
	mov	m,a	; hl = .WrModeStatus(vol,unit)
	jmpr	ModeUpdate
;
;-------
;	- maybe change a units Write_Mode
; entry>	none
; exit> 	a = current Write_Mode_Value
Grant:
	call	Query	; a = Write_Mode_Value
	cpi	GenericErr
	rz
;
	mov	b,a	; b = Write_Mode_Value

; if Grant request user already has Is_Owned status
; then return Multiple_Grant_Error
	lda	M.Value.Mode
	cmp	b
	mvi	a,MultiGrant
	rz
;
	mov	a,b
	cpi	Not.Owned.Unit
	rnz
;
	lda	M.Value.Mode
	mov	m,a	; hl = .WrModeStatus(vol,unit)
	jmpr	ModeUpdate
;
;-------
;	- maybe return a unit to Not_Owned status
; entry>	none
; exit> 	a = current Write_Mode_Value
Release:
	call	Query	; a = current Write_Mode_Value
	cpi	GenericErr
	rz
;
	mov	b,a	; b = Write_Mode_Value
	lda	M.Value.Mode
	cmp	b	; must be owned by this user
	rnz
;
	mvi	a,Not.Owned.Unit
	mov	m,a	; hl = .WrModeStatus(vol,unit)
;
;		- fall into ModeUpdate
;-------
; update the Write_Mode_Values on the disk
; - volume 0, unit 0, track 1, recs 15 -18
; entry>	a = current Write_Mode_Value
; exit> 	a = current Write_Mode_Value
ModeUpdate:
	push	psw	; save Write_Mode_Value
	xra	a
	sta	MastVol ; volume 0
	sta	MastDsk ; unit 0
	lxi	h,WModTrk
	shld	MastTrk ; track 1
	mvi	a,WModSec
	sta	MastSec ; record 15h
	lxi	h,WrMode.Table
	call	MMwrite
	mvi	a,WModSec+1 ; and record 16h
	sta	MastSec ; records 17 - 18 not used
	lxi	h,WrMode.Table +128	; second record
	call	MMwrite
	pop	psw
	ret
;
;-------
;	- release all units owned by a specific user
; entry>	none
; exit> 	a = user#
Clear:
	lda	M.Value.Mode
;
;		- fall into ClearUser
;-------
;	- release all units owned by a specific user
; entry>	a = user#
; exit> 	none
ClearUser:
	lxi	h,WrMode.Table
	lxi	b,0	; b = unit count, c = dirty flag
..checkUser:
	cmp	m	; does this user own this unit
	jrnz	..nextUnit
;
	mvi	m,Not.Owned.Unit  ; then release it
	mvi	c,1		  ; modified flag true
..nextUnit:
	inx	h
	djnz	..checkUser	  ; 256 units possible
;
	mov	a,c
	ora	a	; update disk image if modified
	cnz	ModeUpdate
	ret
	]		; end ' WriteModes '
  .page
;		- WrMast.asm -

;
;-------
;		- Master Write Routines -
;		  ------ ----- --------
;
;	Write requests on the network will no longer be
; unconditionally honored. The master now requires that
; the user either>
;    - owns the unit for writes
; or - everyone owns the unit
; or - the unit is shared AND the user is running HiDos
;
;	The master receives net requests and parameters
; into the fifteen byte buffer at MastCom  -  we will
; move them to MastParams for safekeeping.
;
;	MastSnd  =>	
;	MastCom  =>  MastSnd +1  =  M.Generic.Mode
;	MastDtn  =>  MastCom +1  =  M.Request.Mode
;	MastSrc  =>  MastDtn +1  =  M.Volume.Mode
;	MastDsk  =>  MastSrc +1  =  M.Unit.Mode
;	MastTrk  =>  MastDsk +1  =  M.Value.Mode
;		     MastDsk +2  =  M.User.Mode
;	MastSec  =>  MastTrk +2
;	MastVol  =>  MastSec +1
;	MastDma  =>  MastVol +1
;		 =>  MastVol +2

;
;-------
; entry>	none
; exit> 	a = MesAck, success
;		a = CmdDeny, refused
MWrite:

  .ifn	WriteModes,[
	mvi	A,mesack	; ack write request
	]		; end not ' WriteModes '

  .ife	WriteModes,[
	call	CheckWriteRequest
	jrc	..doWrite	; a = MesAck
;
	mvi	e,$halfMs	; a = CmdDeny
	jmp	SendUsr 	; refuse write request
;
;-------
; either the user owns this partition
;     or it is a read/write partition
;     or it is a HiDos shared partition
;	 and the user is running HiDos (or lying)
..doWrite:			; a = MesAck
	call	MstRestoreParams
	]		; end ' WriteModes '

	mvi	E,$halfms
	call	SENDUSR ; respond with ack to request
	lxi	H,MASTbuf
	lxi	B,128
	lxi	D,$16ms
	sub	A
	call	RECNET	; receive data from user
	call	ckRECstat
	jrnc	..0good

..fail:
	mvi	a,nack
	mvi	e,$halfms
	call	sendUSR
	call	netERR
	ret

..0good:
	call	qDMAlen
	jrnz	..fail

..1good:
	mvi	A,datack
	mvi	E,$halfms
	call	SENDUSR ; ack data
	lxi	H,MASTbuf
	jmp	MMwrite ; write the data to the disk

  .ife	WriteModes,[
;
;-------
; entry>	none
; exit> 	a = request response
;		C   set means perform write
;		C reset means refuse write request
CheckWriteRequest:
	call	SetUpRequest	; save MastBuf, set Vol
	call	Query		; get Write_Mode_Status
;
;		- fall into CompareStatus
;-------
; entry>	a = Wr_Mode_Status
; exit> 	a = Mesack/CmdDeny
;		C   set means perform write
;		C reset means refuse write request
CompareStatus:
	lxi	h,MastUsr
	cmp	m
	jrz	..accept	; user owns unit
;
	cpi	Rd.Wr.Unit
	jrz	..accept	; anyone may write
;
	cpi	Shared.Unit
	jrnz	..denyWrite
;
	lda	MastVol 	; see if the user says
	rlc			; he is running HiDos
	jrc	..accept
;
..denyWrite:
	xra	a		; Carry reset
	mvi	a,CmdDeny
	ret
;
..accept:
	stc			; Carry set
	mvi	a,MesAck
	ret
;
;-------
; entry>	MastBuf = write request
; exit> 	MastBuf = Wr_Req volume set
;		MastBuf saved in MastParams
SetUpRequest:
  ; save the write request parameters
	lxi	h,MastCom
	lxi	d,MastParams
	lxi	b,lenCom
	ldir
;
	lda	MastVol
	ani	07fh		; top bit = HiDos flag
	sta	M.Volume.Mode	; set Wr_Mode_Volume

;  .MastDsk = .M.Unit.Mode so don't move disk parameter
	ret
;
;-------
; entry>	none
; exit> 	none
MstRestoreParams:
	lxi	h,MastParams
	lxi	d,MastCom
	lxi	b,lenCom
	ldir
;
	lxi	h,MastVol
	res	7,m		; clear the HiDos flag
	ret
	]		; end ' WriteModes '
  .page
;
;-------
; entry>	none
; exir> 	none
KeepNew:
	lxi	h,MastDesc
	lxi	d,PreDesc
	lxi	b,lenNewDesc
	ldir
	ret
;
;-------
; entry>	none
; exit> 	none
; Save read request for possible pre-read
KeepReq:
	lxi	h,MastCom
	lxi	d,NtRdDesc
	lxi	b,lenRdReq
	ldir
	ret
;
;-------
; entry>	none
; exit> 	none
; Process a read request
Mread:
	call	KeepReq ; save read request
	lxi	h,SeqBufd
	mov	a,m	; get preRead flag
	mvi	m,0	; clear it
	cpi	Pre128	; check for 128 byte bufd
	jrnz	..physRead
;
	lxi	h,MastDesc
	lxi	d,PreDesc
	mvi	b,lenNewDesc
	call	CompBuf ; compare req against preRead
	jrnz	..physRead
;
	xra	a	; still doing sequential reads
	sta	InSequence
	lxi	h,PreRdBuf
	jmpr	..InBuf
;
..physRead:
	lxi	H,MASTbuf
	call	MMread	; read sector from disk
	lxi	h,MastBuf
;
..InBuf:
	lxi	B,128
	jmpr 	Minbuff
;
;-------
; entry>	hl = .Buf1
;		de = .Buf2
;		 b = len (1-255)
; exit> 	 Z set if bufs match
CompBuf:
	ldax	d
	cmp	m
	rnz
;
	inx	h
	inx	d
	djnz	CompBuf
	ret

  .ife	HARDshar,[
;
;----------
; Process a read 1K request
Mread1:
	call	KeepReq ; save read request
	lxi	h,SeqBufd
	mov	a,m	; get preRead flag
	mvi	m,0	; clear it
	cpi	Pre1024 ; check for 1024 byte bufd
	jrnz	..physRead
;
	lxi	h,MastDesc
	lxi	d,PreDesc
	mvi	b,lenNewDesc
	call	CompBuf
	jrnz	..physRead
;
	xra	a	; still doing sequential reads
	sta	InSequence
	lxi	h,PreRdBuf
	jmpr	..Minb
;
..physRead:
	lxi	H,MASTbuf
	call	MMrd1	; read 1k from disk
	lxi	h,MastBuf
;
..Minb:	lxi	B,1024
Minbuff:
	mvi	E,0	; no delay necessary
	lda	MASTusr
	call	SENDNET ; send data to user
	lxi	D,$1ms
	call	RECUSR	; receive ack from user
	jrnc	..good
;
	call	NETerr
	ret

..good:
	cpi	datack
	cnz	NETerr
	ret
;
;-------
; Process a hog request
Mhog:
	mvi	A,hogack; tell user he can hog the net
	mvi	E,$halfms
	call	SENDUSR ; for at most 1/60th sec
	lxi	D,$16ms
	call	RECUSR
	cc	NETerr	; error if user has pigged out
	ret
;
;-------
; Process an assign request
Massign:
	lxi	H,MASTnam
	call	MMassign; let MASTas do the work
	lxi	H,HARDstat
	lxi	B,4
	mvi	E,0	; no delay necessary
	jmpr	mwho1

;----------
; Process a who request
Mwho:	
	lxi	H,USERlist
	lxi	B,numusr*16
	mvi	E,$halfms
	lda	MASTusr
	call	SENDNET ; send user table
	lxi	H,SPOOLlist
	lxi	B,lenSPOOL*16
	mvi	E,$halfms*2 ; extra delay for DSC/4
mwho1:	lda	MASTusr
	jmp	SENDNET ; send spool table

;----------
; Process a network info request
;   needed by WHO, SPOOL, HELP
Netinfo:
	.byte	1	 ; version number
	.byte	numusr	 ; number of users
	.word	USERlist ; Location of table
	.byte	0	 ; Disk server count
	.byte	lenSPOOL ; Size of table
	.word	SPOOLlist; Location of table
	.byte	numlock	 ; Number of lock strings
	.word	LOCKlist ; Location of table
			 ; that's all for now
Mnetinfo:
	lxi	H,Netinfo
	lxi	B,128
	mvi	E,$halfms
	jmpr 	mwho1

  .ife	SPOOLopt,[
;----------
; Process a spool start request
Mstart: lda	SPOOLid
	sta	SPL$id
	call	MMstart
	lxi	H,SPL$resp
	lxi	B,7
	mvi	E,0	; no delay necessary
	jmpr	mwho1

;
;----------
; Process a spool stop request
Mstop:  lda	SPOOLid
	sta	SPL$id
	call	MMstop
	mvi	A,mesack
	mvi	E,0	; no delay necessary
	jmp	SENDUSR ; ack request

;----------
; Process a spool request
Mspool:
	call	Mwrite
	jmp	MMspool
	]		; end ' spool opt '

;----------
; Clear all locks for current user
Mclrlock:
	call	MMclrlock
	xra	A
	jmpr	halfsend

;----------
; Process a lock request
Mlock:
	call	MMlock
	jmpr	halfsend

;----------
; Process an unlock request
Munlock:
	call	MMunlock
	jmpr	halfsend

;----------
; Process a hard disk volume status request
Mhdstat:
	lxi	B,MASTbuf
	call	MMhdstat
	lxi	H,MASTbuf
	lxi	B,88h	; 8 bytes + 128 bytes
	mvi	E,0
	lda	MASTusr
	call	SENDNET
	lxi	D,$1ms
	call	RECUSR
	jrnc	..good
;
	call	NETerr	; if error
	ret

..good:
	cpi	HSTack	; Hard STatus ACK
	cnz	NETerr	; Jump if not ACKed
	ret

;----------
; Process a date/time request
Mdattim:
	lxi	H,ticks ; Base of date/time data
	lxi	B,7	; Length of the block
	mvi	E,$halfms ; time delay for 816
	lda	MASTusr ; Reuesting user number
	call	SENDNET
	mvi	E,$1ms	; Give user 1 ms to reply
	call	RECUSR
	jrnc	..good
;
	call	NETerr
	ret

..good: 
	cpi	DTMack	; Check if ack character
	cnz	NETerr	; Error if not ack
	ret
;
;-------
; Process an Instant Logout request
Mlogout:
	lxi	H,MastCom+1	; user number to kill
	lda	MASTusr 	; better be same one
	cmp	M		; who asked
	jrz	..ok	
;
	mvi	A,loutdeny	; you can't kill anyone
	jmpr	halfsend	; but yourself this way 
;
..ok:
.ife WriteModes,[
	call	ClearUser	; kill all Write_Owning
	]
	call	MMclrlock	; clear locks
	call	curUSR		; get activity pointer
	mvi	M,0		; and kill it off
	mvi	A,loutack	; send confirmation
halfsend:
	mvi	E,$halfms
	jmp	SENDUSR
	]		; end ' HARDshare '
  .page
  .sbttl	'hinet read/write/assign  (b83mast.asm)'
  .prntx	'made it to hinet rd/wr/assign'
;-----------------------------------------------------
;  H I N E T  R E A D - W R I T E - A S S I G N
;-----------------------------------------------------
; Master disk read
;  Regs in:   HL = buffer address
;  Regs out:  none
;  Destroyed: A, BC, DE, HL
MMread:

  .ife	FLOPshar,[
	call	saveMAST
	call	DDrd	; read double-density
	jmpr	restMAST
	]		; end ' FLOPshare '

  .ife	HARDshar,[
	call	FetchDiskParams
	jmp	HARDr	; let HARDr do the rest

;----------
; Master disk read 1K
MMrd1:
	call	FetchDiskParams
	jmp	HARD1	; let HARD1 do the rest
;
;-------
; entry>	hl = .data buffer
; exit> 	 a = MastDsk
;		 b = MastVol
;		 c = MastSec
;		de = MastTrk
;		hl = .data buffer
FetchDiskParams:
	lda	MastSec
	mov	C,A	; sector number
	lda	MastVol
	mov	B,A	; HD drive (volume) number
	lded	MastTrk ; track number
	lda	MastDsk ; unit number
	ret
;
;----------
; Master disk write
;  Regs in:   HL = buffer address
;  Regs out:  none
;  Destroyed: A, BC, DE, HL
MMwrite:
	call	FetchDiskParams
	push	h
	call	HardW
	pop	h
	jmp	MIMIC	; mimic the write
	]		; end ' HARDshare '

  .ife	FLOPshar,[
	call	saveMAST
	call	DDwr
	jmpr	restMAST
;	
; Save master user's parameters
saveMAST:
	shld	MASTdma ; store buffer address
	lxi	H,cpmDESC
	lxi	D,saveDESC
	lxi	B,6
	ldir		; save master user's parameters
	lxi	H,mastDESC
	lxi	D,cpmDESC
	lxi	B,6
	ldir		; replace with slave's params
	ret
;
; Restore master user's parameters
restMAST:
	lxi	H,saveDESC
	lxi	D,cpmDESC
	lxi	B,6
	ldir
	ret

saveDESC:.blkb	6
	]		; end ' FLOPshare '
;
;----------
; Assign hard disk partition
;  Regs in:   HL = address of unit name and password
;  Regs out:  BC = unit and size
;	      DE = control byte and volume no
MMassign:
  .ife	HARDshare!Hard8opt,[
	push	H	; save address of name
	mvi	A,assnHARD
	call	CMDhard ; send command to hard disk
	pop	H
	lxi	B,14
	call	SENDHARD; send name and password
	call	RESHARD ; get disk assignment
	lbcd	HARDstat; B = unit, C = size
	lded	HARDstat+2; D = volume, E = control
	ret
	]		; end ' HARDshare and Hard8opt '

  .ife	HardShare!Hard5opt,[
	jmp	do5assign
	]		; end ' Hard5opt master '
  .page
  .sbttl	'mimic routines  (b83mast.asm)'
;-----------------------------------------------------
;  M I M I C   R O U T I N E S
;-----------------------------------------------------
; Poll mimic user every 1/3 sec
CHKmimic:
  .ife	HARDshar,[
	lxi	H,MASTsnd
	mvi	M,poll
	lxi	B,1
	mvi	E,0	; no delay necessary
	mvi	A,MIMICusr
	call	SENDNET ; poll mimic pseudo user
	lxi	D,$1ms
	call	RECUSR	; wait for an answer
	lda	MIMstat
	jrc	..no	; jump if timeout
;
	mvi	A,8	; poll up to 8 times in 4 secs
..no:	ora	A	;  before calling it quits
	rz
;
	dcr	A
	sta	MIMstat
	ret

;----------
; Mimic hard disk writes if mimicker is active
; entry>	hl = DMA address
; exit> 	none
MIMIC:
	lda	MimStat
	ora	A
	rz		; return if mimicker not active
;
..req:
	shld	MimeDma ; save DMA address
	lxi	H,MASTcom
	lxi	B,lencom
	mvi	E,0	; no delay necessary
	mvi	A,MimicUsr
	call	SENDNET ; send write req to mimicker
	lxi	D,$1ms
	call	RECUSR	; get ack
	jrnc	..good
;
..error:
	lxi	h,MimeMsg	; print ' Mimic Error
	call	PrtMsg		; on Request from '
	call	ErrPrint	; print generic error
	call	WaitMaster	; wait for response
	lhld	MimeDma 	; retry if requested
	jmpr	..req
;
..good:
	lhld	MimeDma ; get data adr
	lxi	B,128
	mvi	E,$halfms
	mvi	A,MIMICusr
	call	SENDNET ; send data to mimicker
	lxi	D,$1sec
	call	RECUSR	; get ack
	jrc	..error
	ret

MimeMsg:
	.asciz	[cr][lf]'*** Mimic error on req from'
MimeDma:	.word	0	; mimic data adr
MIMstat:	.byte	0	; mimic status
				; 0 = dead
	]		; end ' HARDshare '
  .page
  .sbttl	'record locking routines  (b83mast.asm)'
  .ife	HARDshare,[
;-------------------------------------------------
;  R E C O R D	 L O C K I N G	 R O U T I N E S
;-------------------------------------------------
;
; Process a network lock request
; exit>    A =	0 = accepted, lock successful
;		1 = denied, lockstring already present
;	       81 = already locked by current user	
;		2 = denied, illegal string length
;	       82 = denied, lock table full
MMlock:
	call	LOOKlock; search table for lock
	ora	A
	jrnz	..newlock; jump if not found
;
	lda	MASTusr
	cmp	M
	jrz	..your
;
	mvi	A,lockdeny; found, so deny the request
	ret
	
..your: mvi	A,yourlock	
	ret
	
..newlock:
	lxi	H,locklist; check free space in table
	lxi	D,16
	mvi	B,numlock
..look: mov	A,M	; see if entry in use
	cpi	0FFh
	jrz	..store ; jump if its available
;
	dad	D
	djnz	..look
;
	mvi	A,lockfull ; no space available
	ret

..store:
	lda	MASTusr
	mov	M,A	; save user number
	inx	H
	lxi	D,MASTcom+1
	lxi	B,lenlock+1
	xchg
	ldir		; move lock to locklist
	xra	A       ; acknowledge
	ret
;
;----------
; Process an unlock request
; exit>    A =	0 => accepted, unlock successful
;		1 => denied, another user lock
;		2 => denied, illegal string length
;	       82 => lock string not locked
MMunlock:
	call	LOOKlock
	ora	A
	jrz	..oldlock; jump if lock found
;
	mvi	A,notlocked ; lock not found
	ret

..oldlock:
	lda	MASTusr
	cmp	M
	jrnz	..notyour
;
	mvi	M,0FFh	; clear the lock
	xra	A	; success
	ret
;
..notyour:
	mvi	A,lockdeny
	ret	

;----------
; Search the lock table for match with lock string
;  Regs out: A	= 0    if match found
;	     A	= 0FFh if not match found
;	     HL = address of match
; ***  NOTE THAT A LENGTH ERROR WILL RETURN FAILURE
;      DIRECTLY TO THE CALLER OF THE CALLER OF LOOKLOCK
LOOKlock:
  ; Check for lock string too short or too long
	lda	MASTcom+1
	ora	A	; error if length = 0
	jrz	..error
;
	cpi	lenlock+1; error if length > lenlock
	jrc	..ok

..error:
	pop	H	; pop return address
	mvi	A,locknack
	ret
;
;--
..ok:	
  ; Fill lock string with blanks, a = length
	lxi	H,MastCom +2	; hl = 1st lockstr byte
	mvi	D,0
	mov	E,A
	dad	D		; hl = after last byte
	mvi	A,lenLock
	sub	E
	mov	B,A
	jrz	..start
;
..bfill:
	mvi	M,' '
	inx	H
	djnz	..bfill
;
; Start searching at the beginning of the locklist
..start:
	lxi	H,locklist
	mvi	C,numlock
;
; Check whether entry is in use
..look: 
	mvi	b,lenlock +1	; check count also
	mov	A,M	; see if entry is in use
	inx	H
	cpi	0FFh
	jrz	..noteq ; jump if not in use
;
	lxi	D,MASTcom+1
;
; Compare strings
..cmp:	
	ldax	D	; compare lock string
	cmp	M	; with table entry
	jrnz	..noteq
;
	inx	H
	inx	D
	djnz	..cmp
;
; Match found, so compute address of match and return
; let's do this the easy way; HL points into lockstring

	mov	a,l	; just force hl to be on the
	ani	0f0h	; next lower 16 byte boundary
	mov	l,a
	xra	a	; return a = 0 for success
	ret		; and we're done
;
; Match not found, so continue search to end of table
..noteq:
	mvi	D,0
	mov	E,B
	inx	D
	dad	D	; compute address of next entry
	dcr	C
	jrnz	..look
;
	mvi	A,0FFh	; match not found
	ret

;----------
; Clear current user's locks from locklist
MMclrlock:
	lda	MASTusr
MMclear:
	lxi	H,locklist
	lxi	D,16
	mvi	B,numlock
..loop: cmp	M	; check for match with userno
	jrnz	..repeat
;
	mvi	M,0FFh	; if match, then delete entry
..repeat:
	dad	D
	djnz	..loop	; check all entries
	ret
	]		; end ' HARDshare '
