  .page
  .sbttl	'process a timer interrupt (b83misc.asm)'

; +++++++++++++++++++++++++++++++++++++++++++++++
; +						+
; +	Timer Interrupt and Misc Routines	+
; +						+
; +	last modified>	12apr84 kgh		+
; +						+
; +++++++++++++++++++++++++++++++++++++++++++++++

;----------
; Process a timer interrupt

  .ife	TIMERopt,[
OPTM10	=	OPTM10+ (1<(Clock-10h)) ; set opt map bit
TIME.SP:.word	0
	.byte	76h,76h,76h,76h,76h,76h,76h,76h
	.byte	76h,76h,76h,76h,76h,76h,76h,76h
	.byte	76h,76h,76h,76h,76h,76h,76h,76h
	.byte	76h,76h,76h,76h,76h,76h,76h,76h
TIMEstack:

TIMERint:
	push	PSW

  .ife	MASTopt,[
	lda	LOCALflag
	ora	A
	jrz	..saveregs
	]

	ei
..saveregs:
	sspd	TIME.SP
	lxi	SP,TIMEstack
	push	H
	push	D
	push	B
;
  .ife	MASTopt!AHEADopt,[
    .ifn	FoxOpt,[

	; check for char from master console
	; but not if local user while
	; waiting for spool selection
	; or if DMS-15 master

	lda	LOCALflag
	ora	a		; nonzero then master
	jrnz	..ckSIO
;
	lda	SPLman		; local user - do we
	ora	a		; need spool info
	jrnz	..uptime

..ckSIO:
   ; check for char from master console
	in	sio1ac
	bit	RxRdy,a
	jrz	..uptime

..charIN:
	call	getCHAR ; also see if buf is full
	jrnz	..putCHAR ; if no, save char
;
	mvi	C,bell	; ring bell if buffer full
	call	ConOut
	jmpr	..uptime

..putCHAR:
	call	plusBUF
	]	; end ' not FoxOpt '
	]	; end ' Master and AheadOpt '

; Update fractions of a second
..uptime:
	lxi	H,ticks
	lda	ticsec	; 60 for U.S., 50 for Europe
	inr	M
	cmp	M
	jrnz	..timeout
;
	mvi	M,0
	inx	H
;
;	The master will poll login users and send the
; bootstrap code at NxtUsr if the OneSecFlag flag is
; set. This gives a more uniform time for net boots
; than waiting till the end of a polling sequence.

  .ife	Master,[
	mvi	a,0ffh
	sta	OneSecFlag	; time for 1 sec funcs
;
; Jump to the local user once per second
	call	LOCALtime
	lxi	H,secs
	]		; end ' master '
;
; Update seconds
	mvi	A,60
	inr	M
	cmp	M
	jrnz	..timeout
;
	mvi	M,0
	inx	H
;
; Update minutes
	inr	M
	sub	M
	jrnz	..timeout
;
	mov	M,A
	inx	H
;
; Update hours
	mvi	A,24
	inr	M
	sub	M
	jrnz	..timeout
;
	mov	M,A
;
; Update days
	inx	H
	inx	H
	inr	M
;
; Decrement each active down-counter, and call each
; time-out routine whose counter has reached zero
; -- unless DMA is in progress
..timeout:
	lda	lockbyte
	ora	A
	jrnz	..ret
;
	lxi	H,counters

 .ife	Hard5opt,[
    .ifn	Master,[
	mov	a,m		; actTimer should
	ora	a		; not wrap around
	jrz	..0
;
	lda	Hd5busy 	; if hard5disk is
	ora	a		; not busy and
	jrnz	..0		; actBuf is dirty
;
	dcr	m		; and after 1 sec
	jrnz	..0		; of no activity,
;				; then flush the buffer
	call	flushACT
	jmpr	..ret
;
..0:	inx	h		; hl = next counter
	]		; end ' not master '
	]		; end ' Hard5opt '

; Unload the floppy disk head after
; 1 second of inactivity
  .ife	OptFlopAny,[
	mov	A,M
	ora	A
	jrz	..1
;
	dcr	M
	jrnz	..1

	call	offMOTOR	; also flush buffer
	jmpr	..ret

..1:	inx	H
	]		; end ' either floppy '
;
; Invoke the network master every 1/60 second
  .ife	MASTopt,[
	mov	A,M
	ora	A
	jrz	..ret
;
	dcr	M
	jrnz	..ret

..mast: pop	B
	pop	D
	lspd	TIME.SP
	pop	PSW
	lxi	H,MastLoop
	push	H
	lhld	TIMEstack-2; restore HL
	reti		; goto network master code
	]		; end ' master '
;
; Restore the user's registers and return
..ret:	
	pop	B
	pop	D
	pop	H
	lspd	TIME.SP
	pop	PSW
	ei
	reti

  .ife	Master,[
;
;------
; LocalTime vectors to Interupt by default
; - but there's nothing we want to do here.
INTERUPT:
	ret

; the OneSecFlag is used in MastLoop
OneSecFlag:
	.byte	0
	]		; end ' Master '

; Event down-counters are stored here

counters:
  .ifn	Master,[
    .ife	Hard5opt,[
ActTimer:
	.byte	0
	]	; end ' Hard5opt '
	]	; end ' not master '

   .ife OptFlopAny,[
timeMOTOR:
	.byte	0
	]	; end ' OptFlopAny '

   .ife MASTopt, [
timeMAST:  
	.byte	0
	]	; end ' master opt '
	]	; end ' timeropt '
  .page
  .sbttl	'process a front panel interupt'
  .ife	FRONTopt,[
;----------
; On a front-panel interrupt, jump to location 30h.
; This will cause a warm boot if the CCP is running,
; or will return to DDT if it is running.  Any program
; can intercept front-panel interrupts by changing
; the jump intruction at location 30h.
OPTM10	=   OPTM10 +(1<(IntButton-10h)) ; set opt map bit

FRONTint:
	push	PSW
	in	PIOAD	; read interrupt status
	ani	80h	; if not high, then must be HLT
	jrz	HALTerr ; cause getting here clears HLT
;
	pop	PSW
	xthl
	lxi	H,..1	; but if front panel int. then
	xthl
	ei
	reti

..1:	rst	6

; If a HALT intruction is executed, print an error
; message and resume at the next instruction
HALTmsg:
	.asciz	[bell][cr][lf]'*** HALT inst at '
HALTerr:
	pop	PSW	;balance the stack
	lxi	H,HALTmsg
	call	PRTMSG	; print 'HALT inst at '
	pop	H	; get HALT ret address
	push	H	; save ret adr
	dcx	H	; compute address of HLT instr
	call	PrtWord ; print the Halt adr
	lxi	H,waituser
	push	H	; insure that if user warm
	ei		; boots that RETI has been
	reti		; exec'd (for peripherals)
	]		; end ' FRONTopt '
  .page
  .sbttl	'PRTMSG print a message'
;----------
; Print a variable length message
;  Regs in:   HL = address of message (ended by null)
PRTMSG: 
	mov	A,M	; get a byte
	ora	A	; if null, then return
	rz
;
	mov	C,A	; put it where ConOut wants it
	call	ConOut	; output the byte
	inx	H	; point to next byte
	jmpr	PRTMSG

;----------
; Print a fixed length message
;  Regs in:  HL = address of message
;	     B	= length of message
PRTSTR:
	mov	C,M	; get a byte
	call	ConOut	; print it
	inx	H	; point to next byte
	djnz	PRTSTR	; loop until all bytes printed
	ret
;
;-------
; Formatted buffer print
; entry>	 b = buffer length ( not > 255 byte )
;		hl = buffer address
; exit> 	none
PrtBuf:
	push	B
	push	H
	mvi	C,' '
	call	ConOut
	mvi	C,' '
	call	ConOut
	pop	H
	pop	B
	mov	A,M
	call	PrtByt
	inx	H
	djnz	PrtBuf
	ret
;
;-------
; Print a word in hex format
; entry>	hl = 16 bit word to print
; exit> 	none
PrtWord:
	mov	a,h
	push	h	; ConOut will trash H
	call	PrtByt
	pop	h
	mov	a,l
;			; fall into PrtByt
;-------
; Print a byte in hex format
;  Regs in:  A = byte to be printed
PrtByt:
	push	PSW
	rrc
	rrc
	rrc
	rrc
	call	..nib	; print upper nibble
	pop	PSW	; print lower nibble
..nib:	ani	0Fh
	adi	'0'	; convert 0-9 to hex
	cpi	'9'+1
	jrc	..out
	adi	'A'-('9'+1); convert 10-15 to hex
..out:	mov	C,A
	jmp	ConOut
  .page
  .sbttl	'lock the DMA chip'
;----------
; Lock the DMA chip (prevent anyone else from using
;		     it until current user is finished)
lockbyte:	.byte	0	; initially unlocked

lockDMA:
	ei
	nop
	di		; Allow an int to happen
	lda	lockbyte
	ora	A
	jrnz	lockDMA ; Loop if DMA in use
;
	cma
	sta	lockbyte; reserve the DMA channel
	ret		; EI in caller
  .page
  .sbttl	'handle an i/o error'
;----------
; I/O error messages

msgSTAR:	.asciz	[bell][cr][lf]'*** '
msgERR: 	.asciz	' error'

  .ife	Netopt&Hard8opt&OptFlopAny,[
blanks: 	.asciz	[cr][lf]'       '

msgRTRY:	.ascii	[cr][lf]'key <ctl-C> to abort,'
		.ascii	' <CR> to retry, or <ESC> to'
		.asciz	' ignore'
	]		; end ' Net, Hard8, AnyFlop '

  .ife	Hard8opt,[
msgCONT:	.ascii	[cr][lf]'Cold Boot or '
		.asciz	'key <ESC> to ignore'

msgHDC: 	.ascii	[cr][lf]'HDC buf: '
		.ascii	'Cmd Sec Track   Na  Na  Cnt '
		.asciz	'Na  Status'
	]		; end ' Hard8opt '

  .ife	Master,[
msgAbort:	.ascii	[cr][lf]'Cold Boot or '
		.ascii	'key <CR> to retry, '
		.asciz	'<ESC> to ignore'
	]		; end ' Master '

  .ife	OptFlopAny,[
msgFDC: 	.ascii	[cr][lf]'FDC buf: '
		.ascii	'Cmd Dsk Trk Hd  Sec Den Max '
		.asciz	'Gap Len Status'
	]		; end ' OptFlopAny '
;
;-----------
; Error code table
  .ife	NetOpt&Hard8opt&OptFlopAny,[

ErrTab:
    .ife	OptFlopAny,[
	.word	NRDYerr ; drive not ready
	.ascii	'NRDY'
	.word	DATAerr ; DATA CRC error
	.ascii	'DATA'
	.word	TRACerr ; head positioned on wrong trck
	.ascii	'TRAC'
	.word	ENDTerr ; access beyond end-of-track
	.ascii	'ENDT'
	.word	IDerr	; ID CRC error
	.ascii	' ID '
	.word	ORUNerr ; FDC not serviced in time
	.ascii	'ORUN'
	.word	SECTerr ; sector cannot be found
	.ascii	'SECT'
	.word	PROTerr ; disk write-protected
	.ascii	'PROT'
	.word	DENSerr ; missing ID address mark
	.ascii	'DENS'
	.word	MADRerr ; missing DATA address mark
	.ascii	'MADR'
	]		; end ' either floppy '

  .ife	Hard8opt,[
	.word	HDSKerr ; hard disk ctrlr. error
	.ascii	'HDSK'
	.word	HSELerr ; hard disk select error
	.ascii	'HSEL'
	]		; end ' Hard8opt '

numerr	==	(.-errtab)/6
	.ascii	'I/O '	; default error code
;
;-------
; Print a four-letter error code, and then wait
; for the user to type <return>, <control-C>,
; <Escape> or to cold boot (depending on error).

IOERR:
	pop	D	; get return address 
	push	D	; save return adr
	push	B	; save pointer to THS
	dcx	D	; compute adr of caller
	dcx	D
	dcx	D
;
; Search the error table for the address of the caller
	lxi	H,errtab
	mvi	B,numerr
findadr:
	mov	A,M	; get lower byte of address
	cmp	E
	inx	H
	mov	A,M	; get upper byte of address
	inx	H	; point to ASCII string
	jrnz	..1	; jump if no match
;
	cmp	D
	jrz	foundadr; jump if match

..1:	inx	H	; pointer to next address
	inx	H
	inx	H
	inx	H
	djnz	findadr ; check next address, if any
;
; If the retry mode bit in low core equals zero
; then the error code number will be returned in 'a'
; FDTEST sets the retry mode bit to 0 so that errors
; can be automatically intercepted and diagnosed.
foundadr:
  .ife	BootFlopAny,[
	lda	Mode
	bit	ModeTRY,A
	jrnz	prterr	; if not zero, ask the user
;
	mvi	a,1	; reset error retry count
	sta	RTRYflop
	pop	B	; throw away THS address
	pop	d	; eat return adr
	lxi	D,errtab-4
	ora	a	; clear carry flag
	dsbc	D	; compute offset from "errtab"
	mov	A,L
	rrc		; divide by 2
	ret		; return 3, 6, 9, ...
	]		; end ' FLOP or MINI boot '

; Print an error message
prterr:
	push	H
	lxi	H,msgSTAR; print "*** " header mss
	call	PRTMSG
	pop	H
	mvi	B,4
	call	PRTSTR	; print a four-letter code
	lxi	H,msgERR
	call	PRTMSG	; print " error "
	pop	h

; Check if floppy or HD error
; DMS-15 hard disk errors handled separately
  .ife	OptFlopAny,[
	push	h
	lxi	d,FLOPstat+3
	ora	a
	dsbc	d
	pop	h
	jrz	..fd
	]		; end ' either floppy '
;
  .ifn	Hard8opt,[jmpr	waituser]
;
  .ife	Hard8opt,[
	lxi	D,HARDstat+1
	ora	A	; reset carry
	dsbc	D
	jrnz	waituser

..hd:
; display cmd buffer and user

  .ife	NETopt, [call	errPRINT]

; Print hard disk status buffer
	lxi	H,msgHDC	; print "HDC buf: "
	call	prtmsg		; and error desc
	lxi	h,blanks
	call	prtMSG		; line up buffer
	lxi	H,HARDcom
	mvi	B,16
	call	PrtBuf		; display HARDcom buffer
..HDuser:
	lda	MODE
	bit	modeCONT,A
	rz
;
	lxi	H,msgCONT
	call	PRTMSG	; print "cold boot or key
			; <ESC> to ignore" etc
	call	CONIN
	cpi	Esc	; wait for <ESC>
	rz		; ignore the error
;
	jmpr	..HDuser
	]		; end ' Hard8opt '

  .ife	OptFlopAny,[
..fd:
	lxi	H,msgFDC; print 'FDC buf: '
	call	prtMSG	; and error descriptions
	lxi	h,blanks
	call	prtMSG	; line up buffer
;
; Print floppy status buffer
	lxi	H,FLOPcom
	mvi	B,16
	call	PrtBuf	; print FLOPcom buffer
	lxi	H,RTRYflop
	mvi	M,retry ; re-init RTRYflop
	]		; end ' either floppy '
;			; fall into WaitUser
;-------
; Wait for the user to hit <return> or <control-C>
; entry>	none
; exit> 	none
waituser:
	lxi	h,msgRTRY
	call	PRTMSG	; print "key <ctl-c> etc."

	call	CONIN
	cpi	cntlC
	jz	reBoot	; warm boot if ctl-c
;
	cpi	CR
	rz		; return and retry if CR
;
	cpi	Esc	; loop until valid input
	jrnz	WaitUser
;
	pop	h	; eat return address
	ret		; return up one level
;
;------
; - Wait for a Hard5 retry request on the master
; entry>	none
; exit> 	none
  .ife	Master,[
WaitMaster:
	lxi	h,msgAbort
	call	PrtMsg
	call	ConIn
	cpi	CR
	rz		; retry function
;
	cpi	Esc
	jrnz	WaitMaster
;
	pop	h	; eat retry adr
	ret		; and just continue
	]		; end ' Master '
	]	; end ' NetOpt, Hard8opt, OptFlopAny '
;
;----------
; Handle an invalid BIOS call
CALLmsg:
	.asciz	[bell][cr][lf]'*** CALL error at '
CALLerr:
	lxi	H,CALLmsg
	call	PRTMSG		; '*** CALL error at '
	pop	h		; get return adr
	call	PrtCallAdr	; print caller's adr
	push	h		; restore ret adr
	jmpr	waituser
;
;----------
; Handle a spooling error
  .ife	SPOOLopt,[
SPOLerr:
	lxi	H,SPOLmsg
	call	PRTMSG
	jmpr	waituser

SPOLmsg:
	.asciz	[bell][cr][lf]'*** SPOOL error'
	]		; end ' SPOOLopt '
;
;----------
; Handle an unexpected interrupt
INTmsg:
	.asciz	[bell][cr][lf]'*** INT error at '
IntErr:
	xthl		; save hl, get ret adr
	push	D	; save all regs
	push	B
	push	PSW
	push	h	; save return adr

	lxi	H,INTmsg
	call	PRTMSG	; '*** INT error at '
	pop	h	; get the return adr
	push	h	; and keep a copy
;
	call	PrtWord ; print the return adr
	pop	h	; don't want it on stack yet
;
	pop	PSW	; and the original regs
	pop	B
	pop	D
	xthl		; restore hl and return adr
	ei
	reti
;
;-------
; entry>	hl = previous caller's return adr
; exit> 	hl = previous caller's return adr
;	computes previous caller's adr, prints it, and
;	leaves with caller's return adr unchanged in hl
PrtCallAdr:
	push	h	; save orig. call adr
	dcx	h
	dcx	h
	dcx	h	; compute calling adr
	call	PrtWord
	pop	h	; hl = ret adr
	ret
.page
;
;-------
; +++		Poll-Prime Code 	+++
;
; Set the address of the poll-prime data structure
; Return the last address set in HL.

  .ifn	MASTopt,[
    .ife	NETopt, [
;------
; entry>	bc = new Poll-Prime adr
; exit> 	hl = old Poll-Prime adr
SETppa:
	lhld	PPAadr
	sbcd	PPAadr
	ret

; Poll-prime related data areas and equates

PPmlen	==	129
; poll-prime msg length, 1st byte is the source user#

PPAadr:
	.word	PPAdefault
PPAdefault:
	.byte	0	; Default is to ignore
			; poll-prime commands.
	]		; end ' NETopt '
	]		; end ' not MASTopt '
;
;-------
; Return pointer to machine/BIOS description block
; entry>  none
; exit>   HL = addr of description block
Describe:
	lxi	H,MachDesc
	ret
