  .page
  .sbttl	'data storage module   (b83data.asm)'
  .prntx	'made it to data storage'
; +++++++++++++++++++++++++++++++++++++++++++++++
; +						+
; +	Data Storage Module			+
; +						+
; +	last modified>	13apr84 kgh		+
; +	  					+
; +++++++++++++++++++++++++++++++++++++++++++++++


;	Sector translation table for single density
;	floppy - no table present unless flop8opt.

sectab:
  .ife	Flop8opt,[
	.byte	01,07,13,19,25,05,11,17,23,03,09,15,21
	.byte	02,08,14,20,26,06,12,18,24,04,10,16,22
	]		; end ' Flop8opt '

LastSysAdr	==	.-1	; last byte to sysgen

; +++++++++++++++++++++++++++++++++++++++
; +	5 Inch Hard Disk Data Storage	+
; +++++++++++++++++++++++++++++++++++++++

  .ife	Hard5opt,[

TrkOffTable:	.blkw	64	; unit track offsets
MaxTable:	.blkw	64	; max track table
xERRbuf:	.blkb	4	; error buffer
HARDstat:	.blkb	4	; cmd status buffer

  .ife	Master,[
SeqList:	.blkb	(NumUsr * 2)
TempBuf:	.blkb	SecSize
BufBase:	.blkb	(SecSize * NumDesc)
Rd1kBuf:	.blkb	(SecSize * 4)
	]		; end ' Hard5 master '

  .ifn	Master,[
ActBuf: 	.blkb	1024	; actual disk buffer
	]		; end ' Hard5 and not master '

LastReadAdr	==	. - 1

	]		; end ' Hard5opt '

; +++++++++++++++++++++++++++++++++++++++
; +	8 Inch Hard Disk Data Storage	+
; +++++++++++++++++++++++++++++++++++++++

  .ife	Hard8opt ! Master,[
SeqList:	.blkb	(NumUsr * 5)
	]		; end ' Hard8 master '

; +++++++++++++++++++++++++++++++++++++++
; +	Master Buffering Data Storage	+
; +++++++++++++++++++++++++++++++++++++++

  .ife	Master,[
PreRdBuf:	.blkb	1024
	]		; end ' Master '

  .ife	WriteModes,[
    .ife	Master,[
Ack.WrMode:	.byte	MesAck
Value.WrMode:	.byte	0ffh
Name.WrMode:	.blkb	8
len.Wr.Status	=	. - Ack.Wr.Mode

WrMode.Table:	.blkb	256

    ; save the remote request parameters
MastParams:
	.blkb	lenCom
	]		; end ' master '

  .ife	NetOpt,[
askSpecific:	.byte	5ah	; dummy value
askVolume:	.byte	5ah	; dummy value
askUnit:	.byte	5ah	; dummy value
askValue:	.byte	5ah	; dummy value
askUser:	.byte	5ah	; dummy value
lenAskMode	==	. - askSpecific

askCpmDrive:	.byte	0ffh	; local drive#	

ExitData:	.word	0	; usrs status block ptr

ModeTable:
	.blkb	NumDisks
lenWrTable	=	. - ModeTable

    ; save the users net request
NetParams:
	.blkb	lenCom


;		- Messages -
;		  --------

DriveMsg:
	.ascii	[cr][lf]'*** Drive '
DriveLtr:
	.asciz	'x: is '

OwnedMsg:
	.asciz	'already owned by '

ReadOnlyMsg:
	.asciz	'Read_Only '

ShareMsg:
	.asciz	'Shared '

AlreadyMsg:
	.asciz	'already owned by you '

UnKnownMsg:
	.asciz	'confused '

  .ifn	BiosGrants,[
ModeFailure:
	.asciz	'not owned by you '
	]		; end ' not BiosGrants '
	]		; end ' NetOpt '
	]		; end ' WriteModes '
;
;----------
; Size of check and allocation vectors

  .ife	BootFlopAny,[
lencv0	==	32	; max 128 directory entries
lenav0	==	32	; max 256 blocks
lencv1	==	32	; max 128 directory entries
lenav1	==	32	; max 256 blocks
lencv2	==	32	; max 128 directory entries
lenav2	==	32	; max 256 blocks

    .ifn	OptHardAny,[
lencv3	==	32	; max 128 directory entries
lenav3	==	32	; max 256 blocks
	]		; end ' not any hard option '

    .ife	OptHardAny,[
lencv3	==	256	; max 1024 directory entries
lenav3	==	256	; max 2048 blocks
	]		; end ' some hard option '

lencv4	==	32	; max 128 directory entries
lenav4	==	32	; max 256 blocks
lencv5	==	32	; max 128 directory entries
lenav5	==	32	; max 256 blocks
lencv6	==	32	; max 128 directory entries
lenav6	==	32	; max 256 blocks
lencv7	==	32	; max 128 directory entries
lenav7	==	32	; max 256 blocks

lencv8	==	32	; max 128 directory entries
lenav8	==	32	; max 256 blocks
lencv9	==	32	; max 128 directory entries
lenav9	==	32	; max 256 blocks
lnCV10	==	32	; max 128 directory entries
lnAV10	==	32	; max 256 blocks
lnCV11	==	32	; max 128 directory entries
lnAV11	==	32	; max 256 blocks

lnCV12	==	32	; max 128 directory entries
lnAV12	==	32	; max 256 blocks
lnCV13	==	32	; max 128 directory entries
lnAV13	==	32	; max 256 blocks
lnCV14	==	32	; max 128 directory entries
lnAV14	==	32	; max 256 blocks
lnCV15	==	32	; max 128 directory entries
lnAV15	==	32	; max 256 blocks
	]		; end ' either floppy boot '

; reclaim check vector space if running new hidos
  .ife	HiDosOpt,[ lencv == 0 ]
		 [ lencv == 256 ]

  .ife	NetBoot&BootHardAny,[
lencv0	==	lencv	; max 1024 directory entries
lenav0	==	256	; max 2048 blocks
lencv1	==	lencv	; max 1024 directory entries
lenav1	==	256	; max 2048 blocks
lencv2	==	lencv	; max 1024 directory entries
lenav2	==	256	; max 2048 blocks
lencv3	==	lencv	; max 1024 directory entries
lenav3	==	256	; max 2048 blocks

lencv4	==	lencv	; max 1024 directory entries
lenav4	==	256	; max 2048 blocks
lencv5	==	lencv	; max 1024 directory entries
lenav5	==	256	; max 2048 blocks
lencv6	==	lencv	; max 1024 directory entries
lenav6	==	256	; max 2048 blocks
lencv7	==	lencv	; max 1024 directory entries
lenav7	==	256	; max 2048 blocks

lencv8	==	lencv	; max 1024 directory entries
lenav8	==	256	; max 2048 blocks
lencv9	==	lencv	; max 1024 directory entries
lenav9	==	256	; max 2048 blocks
lnCV10	==	lencv	; max 1024 directory entries
lnAV10	==	256	; max 2048 blocks
lnCV11	==	lencv	; max 1024 directory entries
lnAV11	==	256	; max 2048 blocks

lnCV12	==	lencv	; max 1024 directory entries
lnAV12	==	256	; max 2048 blocks
lnCV13	==	lencv	; max 1024 directory entries
lnAV13	==	256	; max 2048 blocks
lnCV14	==	lencv	; max 1024 directory entries
lnAV14	==	256	; max 2048 blocks
lnCV15	==	lencv	; max 1024 directory entries
lnAV15	==	256	; max 2048 blocks
	]		; end ' HARD or NET boot '


; --	Storage for check and alloc vectors    --

GenDisk =	0

  .ifg	NumDisks - GenDisk,[

check0: .blkb	lencv0
alloc0: .blkb	lenav0

GenDisk =	GenDisk + 1
	]		; end ' if valid drive '

  .ifg	NumDisks - GenDisk,[

check1: .blkb	lencv1
alloc1: .blkb	lenav1

GenDisk =	GenDisk + 1
	]		; end ' if valid drive '

  .ifg	NumDisks - GenDisk,[

check2: .blkb	lencv2
alloc2: .blkb	lenav2

GenDisk =	GenDisk + 1
	]		; end ' if valid drive '

  .ifg	NumDisks - GenDisk,[

check3: .blkb	lencv3
alloc3: .blkb	lenav3

GenDisk =	GenDisk + 1
	]		; end ' if valid drive '

  .ifg	NumDisks - GenDisk,[

check4: .blkb	lencv4
alloc4: .blkb	lenav4

GenDisk =	GenDisk + 1
	]		; end ' if valid drive '

  .ifg	NumDisks - GenDisk,[

check5: .blkb	lencv5
alloc5: .blkb	lenav5

GenDisk =	GenDisk + 1
	]		; end ' if valid drive '

  .ifg	NumDisks - GenDisk,[

check6: .blkb	lencv6
alloc6: .blkb	lenav6

GenDisk =	GenDisk + 1
	]		; end ' if valid drive '

  .ifg	NumDisks - GenDisk,[

check7: .blkb	lencv7
alloc7: .blkb	lenav7

GenDisk =	GenDisk + 1
	]		; end ' if valid drive '

  .ifg	NumDisks - GenDisk,[

check8: .blkb	lencv8
alloc8: .blkb	lenav8

GenDisk =	GenDisk + 1
	]		; end ' if valid drive '

  .ifg	NumDisks - GenDisk,[

check9: .blkb	lencv9
alloc9: .blkb	lenav9

GenDisk =	GenDisk + 1
	]		; end ' if valid drive '

  .ifg	NumDisks - GenDisk,[

ckVc10: .blkb	lnCV10
alVc10: .blkb	lnAV10

GenDisk =	GenDisk + 1
	]		; end ' if valid drive '

  .ifg	NumDisks - GenDisk,[

ckVc11: .blkb	lnCV11
alVc11: .blkb	lnAV11

GenDisk =	GenDisk + 1
	]		; end ' if valid drive '

  .ifg	NumDisks - GenDisk,[

ckVc12: .blkb	lnCV12
alVc12: .blkb	lnAV12

GenDisk =	GenDisk + 1
	]		; end ' if valid drive '

  .ifg	NumDisks - GenDisk,[

ckVc13: .blkb	lnCV13
alVc13: .blkb	lnAV13

GenDisk =	GenDisk + 1
	]		; end ' if valid drive '

  .ifg	NumDisks - GenDisk,[

ckVc14: .blkb	lnCV14
alVc14: .blkb	lnAV14

GenDisk =	GenDisk + 1
	]		; end ' if valid drive '

  .ifg	NumDisks - GenDisk,[

ckVc15: .blkb	lnCV15
alVc15: .blkb	lnAV15

GenDisk =	GenDisk + 1
	]		; end ' if valid drive '

; --	Storage for directory data	--

dirbuf: .blkb	128	; directory buffer

  .ife	master, [

; reserve minimum 48 bytes for MASTER STACK
; MastStack > LastByte means master code len is ok

EndMastStack	==	.
	.blkb	48]

LastByte	=	. - 1	; Last memory loc used
  .page
  .sbttl	'assembly time messages (b83data.asm)'

.ife	master!Hard8opt,[
  .ifg	MastStack -LastByte,[
	.prntx 'bios len is ok for hard 8 master'
	][
	.prntx 'bios is TOO LONG for hard 8 master'
	]	; bios len message
	]	; end ' hard 8 master '

.ife	master!Hard5opt,[
  .ifg	MASTstack -LastByte,[
	.prntx 'bios len is ok for hard 5 master'
	][
	.prntx 'bios is TOO LONG for hard 5 master'
	]	; bios len message
	]	; end ' hard 5 master '

.ife	station,[
  .ifg	NetBuff -LastByte,[
	.prntx 'bios len is ok for station'
	][
	.prntx 'bios is TOO LONG for station'
	]	; bios len message
	]	; end ' station '

.ife	alone!Flop5boot,[
  .ifg	RdBuff -LastByte,[
	.prntx 'bios len is ok for 5" flop boot'
	][
	.prntx 'bios is TOO LONG for 5" flop boot'
	]	; len message
  .ifg	((RdBuff -180h +lenCold) -Bios) -(16 *256),[
	.prntx	'bios needs MORE than one track'
	]	; 1 track message
	]	; end ' fox flop stand alone '

.ife	alone!Hard5boot,[
  .ifg	RdBuff -LastByte,[
	.prntx	'bios len is ok for 5" hard boot'
	][
	.prntx	'bios is TOO LONG for 5" hard boot'
	]	; len message
	]	; end ' fox hard disk boot '

.ife	alone!Flop8boot,[
  .ifg	RdBuff -LastByte,[
	.prntx 'bios len is ok for 8" flop boot'
	][
	.prntx 'bios is TOO LONG for 8" flop boot'
	]	; len message
  .ifg	((RdBuff -180h +lenCold) -Bios) -(16 *256),[
	.prntx	'bios needs MORE than one track'
	]	; 1 track message
	]	; end ' 8 inch flop stand alone '

.ife	alone!Hard8boot,[
  .ifg	RdBuff -LastByte,[
	.prntx	'bios len is ok for hard 8 boot'
	][
	.prntx	'bios is TOO LONG for hard 8 boot'
	]	; len message
	]	; end ' 8 inch hard stand alone '

.ife	master, [
  .ifg	len1strap -(TIME.SP -Net1strap),[
	.prntx	'boot phase 1 length is ok'
	][
	.prntx	'boot phase 1 is TOO LONG'
	]	; boot phase 1 message
	]	; end ' mastopt '
