  .page
  .sbttl	'local hard 5 disk reads and writes'
  .prntx	'made it to local hard 5 rd/wr'

; +++++++++++++++++++++++++++++++++++++++++++++++++++++
; +						      +
; +	DMS-15   5 Inch Local Hard Disk Drivers	      +
; +						      +
; +	last modified>	27oct83	jlw		      +
; +						      +
; +++++++++++++++++++++++++++++++++++++++++++++++++++++

; +
; +	--    CP/M mapping functions	--
; +	      ---- ------- ---------

;
;-------
; entry>	none
; exit>		cpmDesc -> hd5desc
;	Note that only the local user has a valid
;	DPB, so only he can call cpmMap (and only
;	he needs to)
Hd5prep:
	lxi	h,cpmTrk	; set hd5 Trk, Sec
	lxi	d,hd5Trk	; Vol and DMA adr
	lxi	b,6
	ldir
;
	call	cpmMap		; we need unit#, not
	sta	hd5dsk		; cpm logical drive#
	dcx	h
	dcx	h
	mov	a,m
	sta	hd5vol		; also volume#
	ret
;
;-------
; entry>       none
; exit> 	-- data xferred --
;		A  =	0 if success
Hd5read:
  	call	Hd5prep		; cpmDesc -> hd5Desc
RdHrd5:
	mvi	A,0FFH		; FF = read, 0 = write
	jmpr	HardWork
;
;-------
; entry>       none
; exit> 	-- data xferred --
;		Z  =	error code 
Hd5write:
	call	Hd5prep		; cpmDesc -> hd5Desc
	lda	LocType
	sta	WrType		; type of write op
WrHrd5:
	lda	ticsec		; 1 second timer
	sta	actTIMER	; reset timer
	xra	A	
;			; fall into HardWork
;-------
; entry>     a = direction to transfer
; exit>      data read or written
;	     A = 0 if successful
HardWork:
	sta	qRDorWR     ; FF = read, 0 = write
	call	COMPsec     ; see whether desired rec
	jrz	..disp	    ; is in our buffer already
;
	call	flushACT    ; maybe flush buf before rd
	call	setACT	    ; Hd5 desc -> ACT desc
	call	ckTYPE	    ; pre-read 1k block unless
	cnz	xPreRead    ; writing to a previously
;			    ; unwritten group
..disp:
	call	getDISP
	lxi	h,actBUF
	dad	D	    ; adr of buffered rec in HL
	lded	hd5dma	    ; user data adr
	lda	qRDorWR     ; which way to move data
	ora	A	    ; 0 for write op
	jrz	..write     ; 0ffh for read op
;
..read: 	; hl = buffer adr
		; de = user data adr
	call	bufswap     ; xfer to hd5dma loc
	xra	A	    ; won't get here if XEBEC
			    ; error so return success
	ret		    ; flag to cp/m
;
..write:	; hl = buffer adr
		; de = user data adr
	xchg
	call	bufswap     ; get it into XEBbuf
	mvi	a,0ffh
	sta	actDIRTY    ; buf data not same as disk
	lda	wrTYPE
	dcr	a	    ; writeDirectory = (1)
	cz	flushACT    ; don't buffer dir writes
;
	xra	a	; return success flag to cp/m
	ret
;
;-------
; entry>	none
; exit>		writes actBUF to disk
;		clears buf dirty flag
; used>		all
flushACT:
	lda	actDIRTY; don't flush if actBUF
	ora	a	; is not dirty
	rz
;
	call	make5busy ; rets a = current op
	push	psw	; save the direction flag
	mvi	m,0	; say current op is write
;
	lxi	h,actBUF
	call	WRITE1k	; write the buffer
;
	pop	psw
	sta	qRDorWR	; restore rd/wr flag
	xra	a
	sta	actDIRTY; mark buffer as clean
	sta	Hd5busy	; tell int routine it's
	ret		; ok to flush the buffer
;
;-------
; Go get 1K containing the desired CP/M record
; entry>	none
; exit>		none
xPreRead:
	call	make5busy   ; returns a = xfer opcode
	push	psw	    ; save the direction flag
	mvi	m,0ffh	    ; force read operation
;
	lxi	H,actBUF    ; rcvd data buf adr
	call	fREAD1k     ; go get it
;
	pop	psw	    ; restore rd/wr flag
	sta	qRdorWr
	xra	a
	sta	Hd5busy	    ; tell int routine its
	ret		    ; ok to flush the buffer
;
;-------
; entry>	none
; exit>		a = current op flag
make5busy:
	lxi	h,Hd5busy   ; tell interrupt routine
	mvi	m,0ffh	    ; not to flush the buffer
	lxi	h,qRdorWr
	mov	a,m	    ; get current op flag
	ret
;
;------
; entry>	hl = source
;		de = dest
; exit> 	-- data xferred --
bufSWAP:
	lxi	B,recSIZE	; (128)
	ldir
	ret
;
;-------
; entry>	none
; exit> 	z  set only if this is a write
;		   to a prev unallocated group
ckTYPE:
	lda	qRDorWR
	ora	a
	rnz		; z reset if this is a read
;
	lda	wrTYPE	 ; = 0 <write prev alloc>
	cpi	wrUNalloc; = 1 <write directory>
	ret		 ; = 2 <write unAlloc block>
;
;-------
; entry>	none
; exit> 	de = byte displacement
; used>		de,hl,a
getDISP:
	lxi	H,actSEC    ; addr of 1K boundary
	lda	hd5sec
	sub	M	    ; how far into buffer it is
	mov	D,A
	mvi	E,0	    ; DE has sectors * 256
	jmp	divDEby2    ; get byte displacement
;
;-------
; Compares hd5 disk, track, sector with the
; ones showing the current contents of actBUF.
; entry>   nothing
; exit>    Z set if match

COMPsec:
	lxi	H,actDSK    ; what we've got
	lxi	D,hd5dsk    ; what we want
	mvi	b,3
	call	..comp	    ; compare DSK,TRK(hi)
	rnz		    ; TRK(lo)
;
	ldax	D	    ; logical record
	dcr	A
	ani	0F8h	    ; convert to 1K boundary
	inr	A
	cmp	M	    ; actSEC
	rnz		    ; sec mis-match
;
	inx	H
	inx	D	    ; point to volume
	mvi	b,1
;
..comp:
	ldax	D
	cmp	M
	inx	H
	inx	D
	rnz		; z set if match
;
	djnz	..comp
	ret
;
;-------
; entry>	DE =	sec/trk (from dpb)
;		A  =	log sector no.
; exit> 	HL =	log unit adr for XEBEC cont
;
; multiply (hd5trk+CurTrkOff) by 2 for
; (log base 2 of DE) times -
; (ie. mult HL by DE, DE must = some power of 2)
; then add the hd5sec-1 and divide by
; [(bytes/sec)/(bytes/record)]	 (currently = 2)
; log adr =
;   [(((trk# + CurTrkOff) X (sec/trk)) + sec#-1) / 2]
; 
; Also the size of the disk requires 17 bits,
; thus 'bit17' flags the overflow
;
calcLOGadr:
	push	PSW
	xra	A
	sta	bit17	; reset the overflow flag
	lhld	actTRK
	lbcd	CurTrkOff
	dad	b	; add in unit trk offset
;
	push	h	; save logical track
	lbcd	CurMaxTrk
	ora	a	; subtract Max track
	dsbc	b	; from logical track
	pop	h	; restore log track
	jrnc	..TrkErr; jmp if log trk => max trk
;
..loop:
	call	divDEby2; sectors/track
	jrc	..endMULT
;
	dad	H
	jrnc	..loop
;
	lda	bit17	; current value
	adi	80h
	sta	bit17	; store overflow flag
	jrnc	..loop	; not more than 17 bits used
;
			; can't use more than 17 bits
..trkERR:
	pop	h		; ActSec is on stack
	lxi	h,BadTrack
	call	prtMSG		; print error msg
	lhld	ActTrk
	mov	a,h		; print hi Track
	call	PrtByt
	mov	a,l		; print lo Track
	jmpr	..BadMap
;
..secERR:
	lxi	h,BadSect	; print error msg
	call	PrtMsg
	lda	ActSec
;
..BadMap:
	call	PrtByt
	mvi	c,'h'		; tell user it's in hex
	call	ConOut
	call	xHaveErr	; and handle error
	lda	ActSec
	jmpr	DoLogAdr
;
..endMULT:
	pop	psw	; here's the logical sector
	dcr	A	; xebec sec# start at 0
	jm	..secERR
;
	mov	C,A
	mvi	B,0
	dad	B	; (bytes/sec)/(bytes/rec)
	call	divHLby2
..fudge:
	lda	bit17
	add	H	; add overflow (we know this
	mov	H,A	; addition WON'T overflow)
	ret
;
;-------
; entry>	none
; exit> 	CurTrkOff, CurMaxTrk set
; used>		de,hl
SetCurPtrs:
	lda	ActDsk
	mov	e,a		; unit #
	mvi	d,0
	push	d		; need for CurMaxTrk
	lxi	h,TrkOffTable	; hl = trk offset table
	dad	d
	dad	d		; word table
	mov	e,m
	inx	h
	mov	d,m		; de = # of offset trks
	sded	CurTrkOff
;
	pop	d		; de = unit#
	lxi	h,MaxTable	; hl = Max Track table
	dad	d
	dad	d
	mov	e,m
	inx	h
	mov	d,m		; de = cur max track
	sded	CurMaxTrk	
	ret
;
;-------
; set the phys adr to match the logical adr
; entry>	none
; exit> 	none
;		sets actDSK,TRK,SEC,VOL
; used>		a,bc,de,hl
setACT:
	di			; can't flush buffer
	lxi	H,hd5dsk	; inside this routine
	lxi	D,actDSK
	lxi	B,5
	ldir

	lda	hd5sec	    ; jimmy the sector to lie
	dcr	A	    ; on a 1K boundary
	ani	0F8h
	inr	A
	sta	actSEC
;			; fall into DoLogAdr
;-------
; entry>	A  =	logical sector
; exit> 	physical sector number put
;		into xebec command block
DoLogAdr:
	di			; no ints while
	push	PSW		; changing cmd block
	call	setLogUnitNo	; get volume right
	call	SetCurPtrs	; set Trk offset, max
	lxi	d,RecPerTrk	; ** MUST be same as
				; ** HD DPB sec/track 
	pop	psw		; here's the sector
	call	calcLOGadr	; hl = Mid,Low Adr

; HighAdr is always 0 for CMI 15 meg drv
; -logical unit number is stored NOT inverted
	mov	a,h
	mov	h,l
	mov	l,a		; hl = Low,Mid Adr
	shld	MidAdr
	ei			; ints ok now
	ret
;
;-------
;	read/write common code
; entry>	HL  =	pointer to DPB-1
; exit> 	none
; used>		A, HL
setLogUnitNo:
	lda	ActVol
	ani	1		; LUN always < 2
	rrc			; HighAdr always 0
	rrc
	rrc
	sta	HighAdr
	ret
;
;-------
; entry>	hl =	buffer adr
; exit> 	-- data read --
;		A  =	0 if success
fREAD1k:
	mvi	b,1024/SecSize	; 1024 / 256 = 4
	jmpr	justXFER	; 1024 / 512 = 2
;
;-------
; Write 1024 bytes to the hard disk.
; entry>	HL =	data buffer address
; exit> 	z  =	error code
;		-- data written --
WRITE1k:
	mvi	b,1024/SecSize	; 1024 / 256 = 4
;
;-------
; Transfer data to the hard disk.
; entry>	HL =	data buffer address
;		 b =	no. of sectors to xfer
; exit> 	z  =	error code
;		-- data xferred --
justXFER:
	shld	CurDataBuf	; for error handling
	mov	a,b
	sta	CountFld
	push	H

	lxi	H,0		; figure xfer length
	lxi	D,secSIZE
..dad:	dad	D
	djnz	..dad
;
	push	h		; save xfer len 
	lda	qRDorWR
	ora	a
	jrnz	..read
;
	mvi	A,xWRITE
	call	CmdHard5	; send write command
	pop	b		; get xfer len
	pop	H		; get xfer adr
	call	xSENDdata	; send data bytes
	jmpr	..fini
;
..read:
	mvi	A,xREAD
	call	CmdHard5	; send read command
	pop	B		; get xfer len
	pop	H		; get buffer address
	call	xRCVdata	; get data

..fini:
	call	xGetRetStatus
	rz
;
	call	xHaveErr
	lhld	CurDataBuf	; retrieve data adr
	lda	CountFld	; and #secs to xfer
	mov	b,a
	lda	xErrBuf		; check for corrected
	ani	3fh		; data CRC error
	cpi	FixedData
	jrnz	JustXfer	; retry function
;
; We had an automatically corrected data CRC error on a
; multiple sector transfer - the command was aborted
; after sending the corrected data.

	lhld	MidAdr		; LUN is stored
	mov	a,h		; NOT inverted, more's
	mov	h,l		; the pity
	mov	l,a
	lded	xErrBuf +2	; get last LUN
	inr	d		; and increment
	jrnc	..setMid
;
	inr	e		; still not inverted
..setMid:
	push	d		; save new LUN
	mov	a,d		; and invert it also
	mov	d,e
	mov	e,a
	xchg			; hl = error LUN +1
	xra	a		; de = first LUN req
	dsbc	d		; hl = #secs xfer'd
	mov	b,l		;  b = #good secs <256
	lxi	d,SecSize
	lhld	CurDataBuf
	lda	CountFld
..inxParams:
	dad	d
	dcr	a
	djnz	..inxParams
;
	pop	d		; get new LUN
	ora	a		; check for at least 1
	rz			; sector left to xfer
;
	sded	MidAdr		; set LUN for ReRead
	mov	b,a		; get sector count
	jmpr	JustXfer	; and retry func
;
;-------
; Get hard disk subsystem status
;  Regs in:	bc = block address
;		on return block has 8 byte hard disk
;		command status followed by 128 byte
;		volume information block
;  Regs out:	none
;  Destroyed:	A, BC, DE, HL
HDstat:

; Read the volume information from the Xebec
; "firmware" on Volume 0, Track 0, sector 1.

	push	B	; save block address
	pop	H
	mvi	B,5
..fill: mvi	M,0
	inx	H
	djnz	..fill
;
	mvi	M,'X'	; say it's XEBEC disk

	inx	H
	mvi	M,0	; byte 6 zeroed out
;
	push	H
	call	xInErrBytes	; rets err status
	call	xGetRetStatus
	pop	H
	inx	H
	mov	M,A
	rnz		; don't read if disk is down

	inx	H	; begin volume info blocks
	push	H	; save adr to read into later

	call	flushACT; maybe flush buf before read
	call	PointFirm; aim stuff at firmware sector
	lda	actSEC	; needed for DoLogAdr
	call	DoLogAdr; set logical unit adr
	call	xPreRead; get 1K containing it
	lxi	H,actBUF; where data is now
	pop	D	; where user wants it
	jmp	bufswap ; send it on over
;
;-------
; Set actDSK, TRK, SEC to aim at phys.sec 0000
; entry>	none
; exit>		A = old unit assignment
;	   	HL = adr of same in DPB
; used>		all
PointFirm:
	mvi	b,1
;	jmpr	physZero
;
;-------
; Set actDSK, TRK, SEC to aim at physical
; vol0, disk0, track0, sector passed in B reg
; entry>	 b = actSEC
; exit>		 a = old unit assignment
;		 c = old hd5dsk
;	   	hl = adr of rec/trk(hi) in DPB
;		de = rec/trk
; used>		all
physZero:
	xra	a
	sta	actDSK	; partition 0
	sta	actVOL	; volume 0
	lxi	H,0
	shld	actTRK	; track 0
	mov	a,b
	sta	actSEC	; set sector
	ret
  .page
;	++	Error Messages
;		----- --------

BadTrack:	.asciz	[cr][lf]'*** bad cpmTRK> '
BadSect:	.asciz	[cr][lf]'*** bad cpmSEC> '
xFatalErr:	.asciz	[cr][lf]'*** Fatal'
xNotFatalErr:	.asciz	[cr][lf]'***'
xRestofErr:	.asciz	' Hard5 error at '
xCmdMsg:	.asciz	[cr][lf]'command>'
xStatusMsg:	.asciz	[cr][lf]'status> '


;		XEBEC command block  
;		----- ------- -----

xOPcode:	.byte	0
HighAdr:	.byte	0
MidAdr: 	.byte	0
LowAdr: 	.byte	0
CountFld:	.blkb	1	; numSecs to transfer
ctl$fld:	.byte	7	; 15 uSec buf'd step


;		Data Storage
;		---- -------

Hd5busy:	.byte	0	; init to not busy
bit17:		.byte	0	; overflow flag
qRDorWR:	.byte	0FFh
ActDirty:	.byte	0	; init to buffer clean
CurTrkOff: 	.word	0	; trk incr for cur unit
CurMaxTrk:	.word	0	; Last legal track +1
CurDataBuf:	.word	80h	; last hard5 DMA
