  .page
  .sbttl	'SENDNET (b83netio.asm)'

; +++++++++++++++++++++++++++++++++++++++++++++++
; +						+
; +	  Network I/O Routines			+
; +						+
; +	last modified>	05apr84 kgh		+
; +						+
; +++++++++++++++++++++++++++++++++++++++++++++++

;
;----------
; Send a message to the master
;  Regs in:   A = message to be sent
;  Regs out:  none
;  Destroyed: A, BC, DE, HL
SENDMSG:
	lxi	H,NETmsg
	mov	M,A
	lxi	B,1
	sub	A	; master number = 0
			; fall thru to SENDnet
;
;----------
; Transmit a block on the network
;  Regs in:   HL = block address
;	      BC = byte count
;	      E  = delay time (master only)
;	      A  = user number
;  Regs out:  none
;  Destroyed: A, BC, DE, HL
; SendNet is extremely time-critical, particularly
; for DSC-4's, so modify it at your own risk.
SENDNET: 

  .ifn	MASTopt,[
	mvi   e,$halfms]; delay approx 1/2 mSecs

	inr	E	; delay so that receiver has
..spin: dcr	E	; time to prepare for message
	jrnz	..spin	

	mov	D,A	; save user number
	shld	DMANSadr; store block address
	dcx	B	; DMA chip wants real size - 1
	sbcd	DMANSsize
	mov	A,C
	ora	B
	di		; no ints while reprogramming
	jrz	..notDMA

; send a data block using DMA
..useDMA:
	lxi	H,DMATdone; setup the DMA vector
	shld	DMAvect
	mvi	A,1	; multiplex SIO1B to DMA
	out	PIOAD

	lxi	H,DMANSprog; program the DMA chip
	lxi	B,DMAN$<8+DMA
	outir

	lxi	H,SENDprog
	lxi	B,SEND$<8+SIO1BC
	outir

	mvi	b,9
	djnz	.	; force 3 leading flags

	lxi	h,sDMAflag
	mvi	m,0	; reset dma done flag
	mov	a,d
	di
	out	sio1bd	; send user number
	mvi	a,enaDMA
	out	DMA	; enable dma chip
	mvi	a,rstEOM
	out	sio1bc	; reset underrun flag (SIO)
	ei
..testDONE:
	mov	a,m	; DMATdone sets sDMAflag
	ora	a
	jrz	..testDONE
	jmpr	..fin

; send one data byte so no need to use DMA
..notDMA:
	lxi	H,SENDprog
	lxi	B,SEND$<8+SIO1BC
	outir

	mvi	b,9
	djnz	.	; force 3 leading flags

	lbcd	DMANSadr
	ldax	b
	mov	e,a	; get message byte
	mvi	c,sio1bd
	di
	outp	D	; send userno
	mvi	a,rstEOM
	out	sio1bc	; reset under run flag
..wait:
	in	sio1bc
	bit	TxRdy,a
	jrz	..wait
;
	outp	E	; send message byte

; Handle the end of the transmission
..fin:	
	mvi	B,20h	; force CRC bytes
	djnz	.	; and min 3 closing flags

	mvi	A,rstCHANNEL
	out	SIO1BC	; reset the SIO chip
	ei
	ret
  .page
  .sbttl	'RecTime, RecMsg, RecNet, and NackPoll (b83netio.asm)'
;
;---------------
; RECtime sets the timeout interval for RECNET
; Only assembled for a HiNet station
; Regs in:	BC = timeout constant
; Regs out:	none
; Destroyed:	none

  .ife	station,[
RECtime:
	sbcd	Rtime
	ret

Rtime:	
	.word	$4sec
	]		; end ' station '

;----------
; Receive a message from the master
;  Regs in:   none
;  Regs out:  A = xmission err status
;  NETmsg = receive message char
;  Destroyed: BC, DE, HL
RECMSG:
	lhld	USRadr
	mov	a,m	; get user number
	lxi	H,NETmsg
	lxi	B,1	; fall thru to RECnet

;----------
; Receive a block from the network
;  Regs in:   HL = block address
;	      BC = maximum byte count
;	      DE = timeout count (master only)
;	      A  = user number
;  Regs out:  A  = error status
;		   bit 7 reset	= time-out
;		   bit 6 set	= CRC error
;		   bit 5 set	= receiver overrun
;		   bit 0 set	= poll only rcv'd
;  Destroyed: A, BC, DE, HL
RECNET:
	call	RECbegin  ; program the SIO chip

;----------
; Wait for next poll from network and don't ack
; ENTRY>	none
; EXIT> 	see RECnet  
;  Destroyed: BC, HL
NACKpoll:
	ei		  ; make sure SIO can interrupt
	lxi	H,ACKflag ; point to ack/nack status
	mvi	M,1	  ; don't ack polls (REClast)
	lxi	h,RECstat ; point to receiver status
	mvi	m,60h	  ; init RECstat to errors

  .ifn	MASTopt,[
	lded	Rtime	 ; if slave, timeout is 4 sec
	]
;
; Wait for block received from network cable
..wait: mvi	B,8	; inner loop count
..loop: mov	A,M	; check receiver status
	bit	4,A
	rnz		; return if block received
	djnz	..loop
;
	dcx	D	; decrement timeout count
	mov	A,E
	ora	D
	jrnz	..wait	; fall through if timeout
;
	di		; prevent real SIO int
	call	REClast ; pretend we received a block
	res	pollRCV,m ; no valid poll rcv'd
	mov	a,m	; return error status
	ret

;----------
; Program the SIO to acknowledge polls from the master
;  Regs in:   none
;  Regs out:  none
ACKpoll:
	xra	a
	sta	ACKflag ; let RecLast acknowledge polls
;
; SIO programming sometimes fails to take so inside
; ConStat keep a counter and force a call to AckPoll
; if it wraps around -	reset the counter upon every
; call to AckPoll.
;
  .ife	station,[
	sta	failed2ack
	]		; end ' station '
			; fall into begAck:
;---------------------
; starts the poll acking sequence
begACK:
	lxi	h,NETmsg; put poll here
	lxi	b,1	; receive one byte
	lda	NETusr	; addressed to us

;----------
; Program the SIO chip to receive a block
RECbegin:
	sta	RECadr	; station address
	shld	DMANRadr; DMA address
	dcx	B 
	sbcd	DMANRsize; DMA rcv len = real len-1
	mov	A,C
	ora	B
	di		; no ints while prog vects!
	jrz	..prog
;
; Receive more than one byte
	lxi	H,REClast; setup the DMA vector
	shld	DMAvect
	mvi	A,1	; multiplex SIO1B to DMA
	out	PIOAD
	lxi	H,DMANRprog; program the DMA chip
	lxi	B,DMAN$<8+DMA
	outir
..prog:
	lxi	H,RECfirst; setup interrupt vectors
	shld	SIO1vect+4
	lxi	H,REClast
	shld	SIO1vect+6
	lxi	H,RECprog; program the SIO chip
	lxi	B,REC$<8+SIO1BC
	outir
	ei		; make sure interrupts enabled
	ret
  .page
;	Using the prom CONIN and CONOUT routines during
; the net boot prevents accessing location 47h (NETusr)
;	USRadr is initialized to NETusr because it
; assembles with station code as well.
;			24MAR82MdG

USRadr:
	.word	NETusr

Nbootusr:
	.byte	0	; User number is here
			; during net boot
ACKflag:	
	.byte	0	; ACKPOLL/NACKPOLL flag

sDMAflag:
	.byte	0	; 0 = DMA not done

rcvDMAlen:
	.word	0	; actual rcv'd block length

RECstat:
	.byte	60h	; rcv status - init to timeout,
			; crc & ovr err - no poll rcv'd
REC.SP: 
	.word	0	; SP before interrupt

  .ife	Station,[
RcvIntErrs:
	.byte	0	; RecLast error count

failed2ack:
	.byte	0	; counter for forced PollAck
	]		; end ' not master '
  .page
  .sbttl	'SDLC interupts (b83netio.asm)'
;----------
; SDLC receive interrupt on first char
RECfirst:
	push	PSW
	push	h
	in	SIO1BD	; flush user number
	lhld	DMANRsize; if len = 0, don't use DMA
	mov	a,l
	ora	h
	jrz	..noDMA
;
; use the dma chip to receive a block of data
	mvi	A,enaDMA; enable DMA
	out	DMA
	jmpr	..ret

..noDMA:
	in	sio1bd	; get message byte
	lhld	DMANRadr; get buffer address
	mov	m,a	; put message into buffer
	dad	h	; done for timing
	in	sio1bd	; flush first crc byte

..ret:	
	pop	h
	pop	PSW
	ei
	reti
;
;----------
; SDLC receive interrupt on last char
REClast:
	sspd	REC.SP
	lxi	SP,RECstck
	push	D
	push	PSW
	push	h
	push	b

	lxi	h,1<8+rstCHAN
	in	sio1bd	; flush 1st crc byte if dma
			; 2nd if not dma
	mvi	c,sio1bc; hinet control port
	outp	h	; get ready to read reg 1
	inp	a	; read receive status
	outp	l	; reset sio1b channel
	ani	0e0h	; mask relevant bits
	set	4,a	; no timeout
	sta	RECstat
;
  .ifn	Master, [lxi	d,..begRet] ; in case of error

	lhld	DMANRsize; if len = 0, don't use DMA
	mov	a,l
	ora	h
	jrz	..pastDMA
;
	lxi	h,ckDMAlen	; program the DMA chip
	lxi	b,DMAlen$<8+DMA ; to send actual rcv'd
	outir			; data length

	lxi	h,rcvDMAlen	; store actual rcv'd
	lxi	b,2<8+DMA	; data length at
	inir			; rcvDMAlen

	mvi	A,rstDMA	; reset the DMA chip
	out	DMA

  .ifn	Master, [lxi	d,..ret]; in case of error

..pastDMA:

    .ifn	MASTopt,[
; treat poll prime data block as special case
; - PPack or PPnack based on RecStat
	lhld	PPAadr
	mov	A,M	; Get PP status byte
	cpi	2
	jrz	..PPblk ; Jump if we got data blk
;
; if there was a network xmission error
; then don't respond to anything 
	lda	RecStat
	cpi	90h	; = EOM, no crc or ovr errors
	jrz	..ckSize
;
	lxi	h,RcvIntErrs
	inr	m	; errNet is used by NetErr
	xchg
	pchl
;
; If DMA size > 0, msg was neither a valid 
; poll nor a valid poll-prime

..ckSize:
	lhld	DMANRsize
	mov	a,l	; Non-zero if data block
	ora	h
	jnz	..ret

; Check if msg. was a poll-prime
	lhld	DMANRadr
	mov	a,m	; Get msg. byte
	cpi	POLLpr
	jrnz	..ckPOLL; jump if not poll-prime

..isPrime:
; Reset internal time-out bit used by RECNET
	lxi	h,RECstat
	res	4,m
;
; Check to see if we are accepting poll-primes
	lhld	PPAadr
	mov	A,M	; Get poll-prime status
	cpi	1
	lxi	b,1	; len of msg (for SendNet)
	mvi	a,PPusr ; net adr (for SendNet)
	jrz	..PrmAck; jump if acking poll-primes
;
	lxi	h,NetMsg
	mvi	m,PPnack
	call	SendNet ; PPnack the PPusr
	jmpr	..begRET
;
; Update status byte
..PrmAck:
	mvi	M,2	; Still pointing at PP status

; Send poll-prime acknowledge
	lxi	H,NETmsg
	mvi	M,PPack ; sending poll-prime ack
	call	SENDNET
;
; Call RecBegin to receive a PP data block
	lhld	PPAadr
	lxi	D,3
	dad	D	; Point to PP data area
	lxi	B,PPmlen; PP msg. length
	lda	NETusr	; Our user number
	call	RECbegin; Reprogram the SIO
	jmpr	..ret

..ckPOLL:
; insure we received a poll
	cpi	poll	; if poll, should we ack
	jrnz	..begRET; ensure SIO is re-programmed

; Check to ack poll
..qACK:
	lxi	h,RECstat
	set	pollRCV,m ; flag for poll rcv'd 
	lda	ACKflag
	rrc
	jrc	..ret	; Jump if no pollack wanted
;
; Ack the poll

    .ife	OptFlopAny,[
	lda	flopBUSY; don't answer if
	ora	a	; flop is in use
	jrnz	..skipACK
	]		; end ' OptFlopAny '
;
	mvi	A,pollack
	call	SENDMSG
			
..skipACK:
	call	ACKpoll
	jmpr	..ret

..PPblk:
; Update PP status
	lhld	PPAadr
	lda	RECstat
	res	4,a	; Pretend no poll rcvd
	ori	3	; Indicate PP data blk rcvd
	sta	RECstat
	mov	M,A	; Store PP status
;
; check for errrors on data block receive
	ani	80h+crc$ovr
	xri	80h	; toggle timeout bit
	mvi	a,PPack ; ack reception
	jrz	..blkResp
;
	mvi	m,1	; ready to ack PPrimes
	mvi	a,PPnack; nack reception
;
..blkResp:
	lxi	h,NetMsg
	mov	m,a	; send PPack or PPnack
	lxi	b,1	; with msg len = 1
	mvi	a,PPusr ; to default PollPrime user
	call	SendNet
;
; Reprogram SIO for polls
..begRET:
	call	begACK
..ret:
	]		; end ' not MASTopt '

	pop	b
	pop	h
	pop	PSW
	pop	D
	lspd	REC.SP
	ei		; ints ok now
	reti
;
;----------
; DMA transmit complete interrupt
DMATdone:
	push	psw
	mvi	A,rstDMA; reset the DMA chip
	out	DMA	; and IEO line
	sta	sDMAflag
	pop	psw
	ret
  .page
  .sbttl	'psuedo numbers, network messages, commands (b83netio.asm)'
;---------------
; ***	Pseudo-user numbers	***
BOOTusr ==	254	; boot pseudo user number
LOGusr	==	253	; login pseudo user number
MIMICusr==	252	; mimic pseudo user number
PPusr	==	251	; poll-prime pseudo user number

;----------
; Network messages and commands
poll	==	'P'	; poll from master
POLLpr	==	'U'	; poll-prime from user
pollack ==	'A'	; poll-received ack
PPack	==	'V'	; poll-prime-received ack
PPnack	==	'W'	; poll-prime received nack
datack	==	'D'	; data received ack
mesack	==	'M'	; message received ack
CmdDeny	==	4fh	; command deny
nack	==	'N'	; negative acknowledge
logack	==	'L'	; login acknowledge
lognack ==	'N'	; login conflict
logdeny ==	'D'	; login denied
lockack ==	0	; lock acknowledge
lockdeny==	1	; lock denied
locknack==	2	; lock error
notlocked ==    82h	; unlock not found
lockfull ==    	82h     ; lock table full
yourlock ==     81h     ; lock already locked by you
hogack	==	'H'	; hog acknowledge
hogdeny ==	'D'	; hog denied
HSTack	==	'S'	; HD status rcve ack
DTMack	==	'T'	; date/time rcve ack
loutack ==	'A'	; instant logout ack
loutdeny==	'D'	; instant logout deny
whoNET	==	10h	; who command
readNET ==	11h	; read command
writeNET==	12h	; write command
loginNET==	13h	; login command
startNET==	14h	; start spool command
AckSpStart ==	04h	; Ack spool start req
read1NET==	15h	; read 1K command
stopNET ==	16h	; stop spool command
assnNET ==	17h	; assign command
hogNET	==	18h	; hog command
lockNET ==	19h	; lock command
unlockNE==	1Ah	; unlock command
clrlockN==	1Bh	; clearlocks command
spoolNET==	1Ch	; spool command
hdstNET ==	1DH	; hard disk volume status cmd
dttmNET ==	1Eh	; date/time status
loutNET ==	1Fh	; instant logout
WrtMode	==	20h	; generic Mode request
  .page
;
;------------------------------------------------
; Network protocols:
;
;		MASTER	   SLAVE
;		------	   -----
; Poll: 	poll   --> 
;		       <-- pollack
; -----------------------------------------------
; Write:	poll   -->
;		       <-- writeNET
;		mesack -->
;		       <-- DATA
;		datack -->
; -----------------------------------------------
; Read: 	poll   -->
;		       <-- readNET
;		DATA   -->
;		       <-- datack
; -----------------------------------------------
; Login:	poll   -->
;		       <-- loginNET
;		logack -->
;	       (logdeny)
; -----------------------------------------------
; Assign:	poll   -->
;		       <-- assignNET
;		DATA   -->
;------------------------------------------------
; Hog:		poll   -->
;		       <-- hogNET
;		hogack -->
;	       (hogdeny).
;		       <-- pollack
;------------------------------------------------
  .page
  .sbttl	'sio and dma commands for network activity (b83netio.asm)'
  .prntx	'made it to sio and dma commands'
; SIO commands
SENDprog:
	.byte	    00011000b ; channel reset
	.byte	14h,00100000b ; SDLC mode
	.byte	  3,00100000b ; auto enables
	.byte	11h,11000100b ; no interrupts
	.byte	  5,11101011b ; transmitter enable
	.byte	    10000000b ; reset CRC generator
SEND$	==	.-SENDprog

RECprog:
	.byte	    00011000b ; channel reset
	.byte	  4,00100000b ; SDLC mode
	.byte	  2,SIO1vect&0FFh ; interrupt vector
	.byte	    01000000b ; reset crc check
	.byte	15h,10000000b ; transmit disable
	.byte	  3,11111100b ; receiver info
	.byte	6
RECadr: .byte	0	      ; user number
	.byte	  7,01111110b ; flag byte
	.byte	11h,11101100b ; interrupt on first byte
	.byte	23h
RECable:.byte	    11111101b ; enable receiver
REC$	==	.-RECprog

;----------
; DMA commands
DMANSprog:
	.byte	0C3h	; master reset		     2D
	.byte	0C7h	; reset port A		     2D
	.byte	0CBh	; reset port B		     2D
	.byte	79h	; write
DMANSadr:.word	0	; filled by SENDNET or RECstart
DMANSsiz:.word	0	; filled by SENDNET or RECstart
	.byte	14h	; port A inc, memory	     1B
	.byte	28h	; port B fixed, I/O	     1B
	.byte	95h	; byte mode		     2B
	.byte	SIO1BD	; port B
	.byte	12h	; interrupt at end of block
	.byte	DMAvect&0FFh ; interrupt vector
	.byte	92h	; stop at end of block
	.byte	0CFh	; load starting address      2C
	.byte	writeDMA; write
	.byte	0CFh	; load starting address      1A
	.byte	0ABh	; enable interrupts	     2D
DMAN$	==	.-DMANSprog

DMANRprog:
	.byte	0C3h	; master reset		     2D
	.byte	0C7h	; reset port A		     2D
	.byte	0CBh	; reset port B		     2D
	.byte	7Dh	; read
DMANRadr:.word	0	; filled by SENDNET or RECstart
DMANRsiz:.word	0	; filled by SENDNET or RECstart
	.byte	14h	; port A inc, memory	     1B
	.byte	28h	; port B fixed, I/O	     1B
	.byte	95h	; byte mode		     2B
	.byte	SIO1BD	; port B
	.byte	12h	; interrupt at end of block
	.byte	DMAvect&0FFh ; interrupt vector
	.byte	92h	; stop at end of block
	.byte	0CFh	; load starting address      2C
	.byte	readDMA ; read
	.byte	0CFh	; load starting address      1A
	.byte	0ABh	; enable interrupts	     2D

ckDMAlen:
	.byte	0bbh	; set read status mask	     2D
	.byte	06h	; read the byte counter      2D
	.byte	0a7h	; initiate read sequence     2D
DMAlen$ ==	.-ckDMAlen

