  .page
  .sbttl	'master send/receive/boot phase 1 (b83nutil.asm)'

; +++++++++++++++++++++++++++++++++++++++++++++++
; +						+
; +	Send/Receive User, Boot Phase 1 Code	+
; +						+
; +	last modified>	05apr84 kgh		+
; +						+
; +++++++++++++++++++++++++++++++++++++++++++++++

;  M A S T E R	 U T I L I T Y	 R O U T I N E S

  .ife	MASTopt,[
;
;------
; Send a message to a network user
;  Regs in:   A = message to be sent
;  Regs out:  none
;  Destroyed: A, BC, DE, HL
SENDUSR:
	lxi	H,MASTsnd
	mov	M,A
	lxi	B,1
	lda	MASTusr
	jmp	SENDNET
;
;----------
; Send a message to the user who is trying to login
;  Regs in:   A = message to be sent
;  Regs out:  none
;  Destroyed: A, BC, DE, HL
SENDLUSR:
	lxi	H,LOGresp
	mov	M,A
	mvi	A,LOGusr
	jmp	SENDNET
;
;----------
; Receive a message from a network user
;  Regs in:   DE = timeout counter
;  Regs out:  A  = message received
;	      carry flag set if user timed-out
;	      or crc or overrrun error
;  Destroyed: A, BC, DE, HL
RECUSR:
	lxi	H,MASTsnd
	lxi	B,1
	sub	A
	call	RECNET
	call	ckRECstat
	jrnc	..end	; no error
	jrz	..end	; no err mss for dead user
;
	call	NetErr
	stc		; set carry if crc error
..end:	lda	MASTsnd
	ret
;
;----------
; Receive a command from a network user
;  Regs out:  A  = first byte of command
;	      carry flag set if user timed-out
;	      or crc or ovrun err
;  Destroyed: A, BC, DE, HL
RECCMD:
	lxi	H,MASTcom
	lxi	B,lencom
	lxi	D,$1ms
	sub	A
	call	RECNET
	call	ckRECstat
	jrnc	..end	; no error
	jrz	..end	; no err mss for dead user
;
	call	NetErr
	stc		; ret carry set for err
..end:	lda	MASTcom
	ret

;----------
; Get the user list pointer for the current user
;  Regs in:   none
;  Regs out:  HL = pointer to activity counter
;  Destroyed: DE
curUSR:
	lxi	D,userlist
	lhld	MASTusr ; L = current user number
	mvi	H,0
	dad	H	; multiply HL by 16
	dad	H
	dad	H
	dad	H
	dad	D	; compute address of activity
	ret

;----------
; Save time of most recent HiNet request
;  Regs in:  HL = pointer to user table entry
savereq:
  .ife	HARDshar,[
	lxi	D,12	; point to time in WHO table
	dad	D
	xchg
	lxi	H,secs	; get time from low core
	lxi	B,3	; save secs, mins, hrs
	ldir
	stax	D	; store request for WHO command
	]	; end ' HARDshare '
	ret
	]	; end of ' if MASTopt '
;
;------- 
; check the status of a net xmission
; entry>	a = RECstat
; exit> 	timeout = Z set,   C set
;		crc$ovr = Z reset, C set
;		no err	= Z reset, C reset
ckRECstat:
	stc
	bit	timeout,a
	rz
;
	ani	crc$ovr ; crc or ovrrun error
	jrz	..good
;
	stc		; <ani> resets carry
	ret		; set it for error

..good: 
	ori	0ffh
	ret
;
;-------
;	Network error messages
Return: .asciz	[cr][lf]''	; used in askname
Spaces: .asciz	'    '
Umsg:	.asciz	[cr][lf]'*** User '
Nmsg:	.asciz	' Net error at '
Lmsg:	.asciz	'LATE'
Cmsg:	.asciz	'CRC'
Omsg:	.asciz	'OVR'
Smsg:	.asciz	'SYNC'
Nhdr:	.byte	cr,lf

  .ife	Master,[
	.ascii	'MAST'
	]		; end ' master '

  .ife	Station,[
	.ascii	'NET '
	]		; end ' station '

	.ascii	'buf: '
	.ascii	'Mst Usr To  Frm Dsk Track   '
	.asciz	'Sec Vol DmaAdr'
;
;----------
; Handle a network error - print an error message
; only if ModeMsg bit is set
NetErr:
	push	psw
	lxi	h,ErrNet
	inr	M	; increment error count
	call	pErrMode
	jrnz	..print
;
	pop	psw	; restore flags
	ret
;
..print:
	pop	psw	; restore flags
;			; fall into ErrPrint
;--------
ErrPrint:
	xthl		; get return address
	push	psw	; save flags
	push	h	; save return address
	lxi	H,Umsg
	call	PRTMSG	; print "*** User "

  .ife	MASTopt,[lda	MASTusr]
		[lda	NETusr ]

	call	PRTBYT	; print user number in hex

  .ife	MASTopt,[
	mvi	c,' '
	call	conOUT	; print a space
	call	curUSR
	inx	h	; adr of name field in who tbl
	mvi	b,8
	call	PRTSTR	; print users name
	]		; end of 'if MASTopt'

	lxi	h,Spaces
	call	prtMSG

; determine error type. Sequence of checks is:
;	a)	late
;	b)	over run
;	c)	crc
;	d)	sync	(presumed if none of above)
;
; over run is tested before crc just in case
; an ovr error might also trigger a crc error

	lda	RECstat ; get REClast error byte
	rlc		; test for time-out
	jrc	..qOVR	; bit 7 is reset if error
;
	lxi	h,Lmsg	; print 'LATE'
	jmpr	..Eprint

..qOVR:
	bit	6,a	; ovr bit rotated 1 bit left
	jrz	..qCRC	; ovr bit set upon error
;
	lxi	h,Omsg	; print 'OVR'
	jmpr	..Eprint

..qCRC:
	lxi	h,Smsg	; rdy to print 'SYNC'
	rlc		; test for CRC error
	jrnc	..Eprint; crc bit set upon error
;
	lxi	h,Cmsg	; print 'CRC'
..Eprint:
	call	prtMSG
	lxi	h,Nmsg	; print ' NET error at '
	call	prtMSG

	pop	h	; get caller's adr
	call	prtCALLadr; print caller's adr
	push	h	; restore ret adr

	lxi	h,Nhdr	; print 'NET ' or 'MAST'
	call	prtmsg	; and error description
	lxi	h,Blanks
	call	PrtMsg	; line up buffer dump

  .ife	MASTopt,[lxi	H,MASTsnd]; Mast buffer
		[lxi	H,NETmsg] ; else net buffer

	mvi	B,11
	call	prtBUF	; print command buffer
;
	pop	h	; get return address
	pop	psw	; restore flags
	xthl		; restore return address
	ret

;------------
; Determine whether to print net errors.
; Regs in:  none
; Regs out: NZ if ok to print errors
;	     Z if error print suppressed
;	    HL = .Mode
; Trashed:  HL, flags
pErrMode:
	lxi	H,Mode
	bit	ModeMSG,M
	ret
  .page
;----------
; Input a string from the console
;  Regs in:   HL = pointer to string
;	      E  = 0 means don't echo string
;		   1 means echo string
;
  .ife	MASTopt,[
INMSG:
	mov	D,L	; remember start of string
..nxtchr:
	push	H
	push	D
	call	CONIN	; if master, do normal CONIN
	pop	D
	pop	H
	ani	7Fh	; mask out parity bit
..ok:	cpi	cr
	rz
;
	mov	C,A
	bit	0,E
	jrz	..save	; jump to avoid echo
;
	cpi	rubout
	jrz	..back
;
	cpi	backsp
	jrnz	..echo	; jump to echo

..back: mov	A,D
	cmp	L
	jrz	..nxtchr; don't backspace too far
;
	dcx	H
	mvi	M,' '	; overwrite char with blank
	push	h	; the input address
	push	d	; the echo/no-echo flag
	lxi	H,BACKmsg
	call	prtMSG	; Output to console: BS, SP, BS
	pop	d	; restore the echo flag
	pop	h	; Restore the input addr
	jmpr	..nxtchr
;
..echo:
	push	h
	push	d
	call	conOUT	; echo the char
	pop	d
	pop	h
	mov	A,C
..save:
	cpi	'a'	; convert lower to upper case
	jm	..store
;
	cpi	'z'+1
	jp	..store
;
	sui	'a'-'A'
..store:
	mov	M,A
	inx	H
	jmpr	..nxtchr
;
;----------
; Ask for user name and password
 .ife HARDshar,[
askname:
	call	INITname; Blank the user name and psw
	lxi	H,NAMEmsg
	call	prtMSG	; string out routine
;
	lxi	H,BOOTnam
	mvi	E,1	; echo chars
	call	INMSG	; get name
;
	lxi	H,PSWmsg
	call	prtMSG	; string out routine
;
	lxi	H,BOOTpsw
	mvi	E,0	; don't echo chars
	call	INMSG	; get password
;
	lxi	h,Return
	jmp	prtMSG	; <cr><lf>

NAMEmsg:.asciz	[cr][lf]'Name: '
PSWmsg: .asciz	[cr][lf]'Password: '
	]		; end 'HARDshare'
  .page
  .sbttl	'hinet station boot - phase 2 (b83nutil.asm)'
  .prntx	'made it to boot phase 2'
;------------------------------------------------------
; H I N E T   S T A T I O N   B O O T  -  P H A S E  2
;------------------------------------------------------
; Boot Phase 2 is no longer contained in the Master BIOS,
; but is read in from the hard disk and configured in 
; NetBuf.  There is no pressing need to have these equates
; here at all, except that for consistency some of the
; Master cold-boot arrangement resembles the cold-boot 
; on Z80 stations.


NET2strap==	1000h	; true only for Z80 systems
DSKSdef ==	NET2strap + 1 + 3; room for length byte
				 ; and initial jump
	]	; end ' MASTopt '

;-----------------------
;	---	REClast stack
; put here so running master will be happy
; and booting station will also be happy
; and running station will be happy

	.byte	76h,76h,76h,76h,76h,76h,76h,76h
	.byte	76h,76h,76h,76h,76h,76h,76h,76h
	.byte	76h,76h,76h,76h,76h,76h,76h,76h
	.byte	76h,76h,76h,76h,76h,76h,76h,76h
RECstck:

  .ife	master,[	; restart master code
  .page
  .sbttl	'hinet station boot - phase 1 (b83nutil.asm)'

;------------------------------------------------------
; H I N E T   S T A T I O N   B O O T  -  P H A S E  1
;------------------------------------------------------
; The following code is broadcast on the network
; once per second.  To log in, a station must load
; this program into location 9000h, and execute it.

BP1base ==	9000h	; bootstrap executes at 9000h	
off1set ==	.-BP1base
BP2base ==	1000h
len1strap==	380h	; length expected by PROM
len2strap==	400h	; len of FIRST block of phase 2

NET1strap:
	lixd	03FEh	; 1280's expect this here
			; Now setup DSC/4 mem map; keep
			; pages 0 and 9 in local mem
	lxi	H,memmap-off1set
	lxi	B,0<8+SETMAP
..map:	outi
	mvi	A,11h
	add	B
	mov	B,A
	jrnz	..map
;
	in	ONMAP	; activate DSC/4 memory map

    ; move PROM to RAM before setting int vector
    ; (avoids ram trash bug)

	lxi	H,0		; move from 0000H
	lxi	D,0A000H	; to 0A000H (ram)
	lxi	B,1000H 	; 4K bytes
;
	push	H		; 0000h is boot PROM
	push	D
	push	B
	ldir

	in	OFFPROM 	; disable PROM in bank 0

	lxi	B,0<8+SETMAP	; map in some RAM
	mvi	A,0F0h		; to move back to
	outp	A
;
	pop	B		; move back from
	pop	H		; 0A000h to
	pop	D		; 0000H 
	ldir		
;
; Move remainder of boot code to high core
	lxi	H,9000h
	lxi	D,NET1strap
	lxi	B,len1strap
	ldir
	jmp	BOOT	; execute rest of bootstrap

    ; DSC/4 memory map
memmap: .byte	0FFh, 000h, 0F1h, 0F2h ; pages F,0,1,2
	.byte	0F3h, 0F4h, 0F5h, 0F6h ; pages 3,4,5,6
	.byte	0F7h, 0F8h, 000h, 0FAh ; pages 7,8,9,A
	.byte	0FBh, 0FCh, 0FDh, 0FEh ; pages B,C,D,E

HiNetMsg:
	 .byte	cr,lf

  .ife	HiDosOpt,[.ascii    'HiDos  ']

	.ascii	'HiNet '
	.byte	version+'0','.',revision/100+'0'
	.byte	(revision@100)/10+'0'
	.byte	(revision@100)@10+'0'
	.word	(((mod+'0') & 0ffh) <8) + patch
	.byte	0

  .page
  .sbttl	'relocated bootstrap code (b83nutil.asm)'
;----------
; Relocated bootstrap code
BOOT:
	lxi	B,90h<8+SETMAP	; pick up some more of	
	mvi	A,0F9h		; the memory map
	outp	A		; (leave page 0 for now)

	lxi	SP,1000h; setup a stack
	mvi	A,(vectors>8)&0FFh
	stai		; setup interrupt register
	im2
	mvi	A,45h	; set counter mode
	out	CTC1
	mvi	A,2	; 2 = 1Mhz/baudrate
	out	CTC1
;
; Set the user number addr
	lxi	H,Nbootusr
	shld	USRadr
	mvi	M,LOGusr; Store login user number
;
; Try to log in with the PROM serial # as user name
	call	cvSER	; Convert serial # to ASCII
			; and store at BOOTnam
	lxi	H,HiNetMsg
	rst	3	; print HiNet version

			; wait for poll then log in
	call	..poll	; won't return if successful
			; If unsuccessful, something is
			; VERY wrong!
	lxi	H,DeathKnell
	rst	3	; PROM string output routine
	rst	7	; give up and go to PROM monitor
;
;-------
..poll: 	; Wait for user 253 poll then req login
	lxi	D,$4sec
	call	RECMSG
	bit	timeout,a	; ensure valid poll
	jrz	..poll
;
	ani	crc$ovr
	jrnz	..poll
;
	lda	NETmsg
	cpi	poll
	jrnz	..poll
;
	lxi	H,BOOTcom	; got poll so send
	lxi	B,1+8+6+4+1	; login request
	mvi	E,$halfms	; with binary serial#
	sub	A
	call	SENDNET
;
; Get response to login request
..logresp:
	lxi	H,BOOTresp	; get login response
	lxi	B,1+1+7+4 
	lxi	D,$4sec
	mvi	A,LOGusr
	call	RECNET
	bit	timeout,a	; and ensure its valid
	jrz	..poll
;
	ani	crc$ovr
	jrnz	..poll
;
	lxi	H,BOOTprom	; make sure the serial#
	lxi	D,BOOTver	; master sent is yours
	mvi	B,4
..cmp:	ldax	D
	cmp	M		; if not then this
	jrnz	..retry 	; is not for you
;
	inx	H
	inx	D
	djnz	..cmp
;
	lda	BOOTresp
	cpi	LOGack		; its yours,
	jrz	..login 	; is it an ack
;
	cpi	logDENY 	; or maybe a nack
	rz
;
..retry:
  ; Delay random period of time, then retry
	ldar		; use refresh register
	ani	31	; (its a good random seed)
	inr	A	; Make it non-zero
	mov	B,A
..outer:
	lxi	H,0	; delay about 400ms per pass
..inner:
	dcx	H
	mov	A,H
	ora	L
	jrnz	..inner
	djnz	..outer ; low 5 bits of R = pass count
;
	jmpr	..poll	; now retry the login
;
;-------
..login:
	lxi	B,00h<8+SETMAP	; get last of mem map
	mvi	A,0F0h
	outp	A
;
; Get the rest of the bootstrap code

	lxi	H,BP2base
	call	rBP2		; read first 1k
	mov	B,M		; 1st byte is length	
	djnz	..get
	jmpr	..got
..get:	push	B
	lxi	B,len2strap	; where to read in
	dad	B
	call	rBP2		; get next chunk
	pop	B
	djnz	..get
..got:	jmp	BP2base + 1;	; go to it

;-----------------------------------
; Receive 1k of Boot Phase 2 code from the net.
; Regs in:  HL = address to read into
; Regs out: same
; Trashed:  all the rest

rBP2:  
	push	H
	lda	BOOTnum     ; get user number
	lxi	B,len2strap
	lxi	D,$4sec
	call	RECNET
	bit	timeout,A   ; if it doesn't arrive,
	pop	H	    ; restart the boot process.
	rnz
	jmp	BOOT	; Note: this must jump back to
			; before the stack is set up!
;-------------------------------------
DeathKnell:
	.asciz	[cr][lf]"Can't log in"
;
;----------
; Convert the lo nybble of reg. A to an ASCII hex digit
; Regs. in: A contains value to convert.
; Regs. out: A contains ASCII digit.
; Destroyed: A
cvDIG:
	ani	0Fh	;Leave only the 4 LSB
	adi	30h
	cpi	3Ah
	rc		;Return if char is 0 thru 9
;
	adi	07h	;Convert to A thru F otherwise
	ret
;
;----------
; Convert a byte in A to 2 ASCII hex digits in HL.
; L is the 1st char (MSD), H is the 2nd (LSD).
; Regs. in: A is the char.
; Regs. out:BC contains ASCII digits.
; Regs. destroyed: A, BC
byt2asc:
	push	PSW	;save the byte
	call	cvDIG	;convert the lo nybble
	mov	C,A	;store the ASCII digit in H
	pop	PSW	;get the byte back
	rar
	rar
	rar
	rar		;shift hi nybble to lo nybble
	call	cvDIG	;convert the nybble
	mov	B,A	;put it in L
	ret		;return
;
;-------
;	Convert the PROM serial number 
;	to an 8 byte ASCII string in the login string.
; Regs. in : none
; Regs. out: none
; Regs. destroyed: A, HL
cvSER:
	call	INITname  ;Blank user name and psw
	lxi	H,03FEh     ;Get the serial num
	lxi	D,BOOTprom  ; store in serial field
	lxi	B,4
	push	H
	ldir
	mvi	A,1	; fake product type (ZSBC-3)
	stax	D	; attach to end of login req

	pop	D	; ptr to serial num
	lxi	H,BOOTnam 
	mvi	B,4	; loop counter for conversion
..cvt:	push	B
	ldax	D	;convert the 1ST byte to ASCII
	call	byt2asc ; get two digits into BC
	mov	M,B	; move one into name field
	inx	H		;restore the serial #
	mov	M,C	; move the other
	inx	H
	inx	D	; point to next byte to convert
	pop	B	; restore loop counter
	djnz	..cvt
	ret
;
;------
  .ife	HARDshar,[
INITname:		;Initialize user name and psw
	lxi	H,BOOTnam
	mvi	M,' '	; fill name and psw with blanks
	lxi	D,BOOTnam+1
	lxi	B,13
	ldir
	inx	H	; point to ser num to clear out
	inx	D	; 4 bytes of ser # and one of
	mvi	M,0	; product type
	lxi	B,4	; 5-1=4
	ldir
	ret
;
backmsg:
	.byte	08h,20h,08h,0
	]		; end ' HARDshare '
	]		; end of MASTER code
