  .page
  .sbttl	'network reads, writes, spools and locks (b83stat.asm)'
  .prntx	'made it to station code'

; +++++++++++++++++++++++++++++++++++++++++++++++
; +						+
; +	Network Station Routines		+
; +						+
; +	last modified>	24apr84 kgh 		+
; +						+
; +++++++++++++++++++++++++++++++++++++++++++++++

.ife BUFFopt,[OPTM10 = OPTM10 + (1<(KNetBuf-10h))]

lenlock 	==	13	; maximum lock length

  .ife	WriteModes,[
NotCpmDrive	==	0ffh	; used in Force command
ExitLen		==	10	; len of ret status
	]

  .ifn	Master,[
WaitCnt:	.byte	0	; time-out counter
Nwait:		.asciz	[cr][lf]'*** Waiting'
	]		; end ' not Master '

;		- wrSlave.asm -

;	Station Write_Ownership Address Equates
;
;	NetMsg   =>
;	NetCom   =>  NetMsg +1	=  N.Generic.Mode
;	NetDtn   =>  NetCom +1	=  N.Request.Mode
;	NetSrc   =>  NetDtn +1	=  N.Volume.Mode
;	NetDsk   =>  NetSrc +1	=  N.Unit.Mode
;	NetTrk   =>  NetDsk +1	=  N.Value.Mode
;		 =>  NetDsk +2	=  N.User.Mode
;	NetSec   =>  NetTrk +2
;	NetVol   =>  NetSec +1
;	NetDma   =>  NetVol +1
;		 =>  NetVol +2

;
;	- Network writes must check the permission
;	  table before writing. If the station does not
;	  have write permission then it must request it
;	  from the master before writing.
;
;	- Permission table format:
; ModeTable:
;	Drive A:	Wr_Mode_Status	(1 byte)
;	Drive B:	Wr_Mode_Status	(1 byte)
;		  . . .
;	  	  . . .
;	Drive O:	Wr_Mode_Status	(1 byte)
;	Drive P:	Wr_Mode_Status	(1 byte)

;	Network parameters need to be saved when an
; automatic Write_Grant_Request is made; they will be
; moved to NetParams for safekeeping.

  .ife	WriteModes,[
;
;------
; 	- Perform a Write_Mode_Function for the user
; Format of entry block>
;   - SpecificRequest,Volume,Unit,Value,User,cp/mDrive
;
; Format of exit block>
;   - MesAck/CmdDeny,Status,UserName/0ffh
;
; entry>	hl = .entry block
;		de = .exit block
; exit>		return data in exit block
MakeModeRequest:

  .ife	Master,[
	push	h
	push	d
;
	lxi	d,N.Request.Mode
	lxi	b,lenAskMode
	ldir
;
	pop	d
	pop	h
	]		; end ' Master '

	sded	ExitData
  	lxi	d,askSpecific
	lxi	b,lenAskMode +1	; save cpmDrive request
	ldir
;
	lda	cpmDsk
	push	psw
;
	dcx	h
	mov	c,m
	cpi	NotCpmDrive	; (0ffh)
	cnz	SelDsk
;
	lda	askSpecific
	cpi	WrRelease
	jrnz	..request
;
; 	- this is a release request
; See if this unit is owned on the requested cpmDrive
; This test is needed because the Master does not know
; if this unit is owned on this cpmDrive or on another.
	call	GetWrModeAdr
	mov	c,m
	lda	NetUsr
	cmp	c
	jrz	..request
;
; this unit is not owned on the requested cp/m drive
	lxi	h,NetMsg
	mvi	m,MesAck	; command understood
	inx	h

  .ife	Master, [inx	h]

	mov	m,c		; hl = .status  (owner)
	inx	h
	call	noName
	jmpr	..retData	; don't do the release
;
..request:
	mvi	a,WrtMode
	call	NtRequest
	call	IsResponseValid
	jrz	..valid
;
	call	NetErr
	jmpr	..request
;
..valid:
	lda	NetMSg
	cpi	MesAck
	cz	UpdateLocalMode	; update local Wr_Table
;
..retData:
	lded	ExitData

  .ife	Station,[
	lxi	h,NetMsg
	lxi	b,ExitLen
	]			; end ' Station '

  .ife	Master, [
	lda	NetMsg
	stax	d
	inx	d
	lxi	h,NetDtn
	lxi	b,ExitLen -1
	]			; end ' Master '

	ldir
;
  .ife	Station,[call	NetRet]	; ack polls

	pop	psw
	mov	c,a
	jmp	SelDsk
;
;-------
; entry>	none
; exit>		none
UpdateLocalMode:
	lda	askSpecific
	call	Dispatch

	.word	exitGrant
	.word	exitRelease
	.word	exitForce
	.word	exitQuery
	.word	exitClear
;
;-------
; entry>	none
; exit>		none
exitForce:
	lda	askCpmDrive	; see if the force was
	cpi	NotCpmDrive	; for one of our cp/m
	rz			; drives
;
;		- fall into exitGrant
;-------
; entry>	none
; exit>		none
exitGrant:
exitRelease:
	call	GetWrModeAdr

  .ife	Station,[lxi	d,NetCom]
  .ife	Master, [lxi	d,NetDtn]

	ldax	d
	mov	m,a
	ret
;
;-------
; entry>	none
; exit>		none
exitQuery:

  .ife	Station,[lxi	h,NetCom]
  .ife	Master, [lxi	h,NetDtn]

	lda	NetUsr
	cmp	m
	cz	maybeMultiple
;
	jmpr	exitGrant	; update local table
;
;-------
; entry>	none
; exit>		none
exitClear:
	lxi	h,ModeTable
	mvi	b,NumDisks
	lda	NetUsr
..clear:
	cmp	m
	jrnz	..next
;
	mvi	m,Not.Owned.Unit
..next:
	inx	h
	djnz	..clear
	ret
;
;-------
; see if this vol/drive is owned on another cp/m drive
; entry>	none
; exit>		Z reset if owned elsewhere
maybeMultiple:
	call	CkMultiple
	rz
;
  .ife	Station,[lxi	h,NetCom]
  .ife	Master, [lxi	h,NetDtn]

	mov	m,a
	inx	h
NoName:
	mvi	b,ExitLen -1
..fill:
	mvi	m,0ffh
	inx	h
	djnz	..fill
;
	ora	a	; a = MultiGrant
	ret
	]		; end ' WriteModes '
  .page
;
;------
; A SetNetMode entry point is needed even if BuffOpt
; was not assembled because programs don't know what
; assembly options were chosen.
; Net Buf Mode -  normal | not this time | not ever
; entry>	c = new mode (0,1 or 2)
; exit> 	a = old mode
SetNetMode:

  .ife	BuffOpt,[
	lxi	h,netbMode
	mov	a,m
	mov	m,c
	]		; end ' BuffOpt '

	ret
;
;----------
; DMA xfer length check -- NOTE that some test programs
; need to find qDMAlen's adr and do so by counting
; back from NetRd (a jump vector) so qDMAlen MUST come
; directly before NetRd
; entry>	none
; exit> 	C reset if actual len = requested len
qDMAlen:
	lhld	rcvDMAlen	; set by DMARdone
	lbcd	DMANRsize	; set by RECnet
	ora	a		; clear carry
	dsbc	b		; should be equal
	ret
;
;----------
; Network read
NETrd:
    .ife	BUFFopt, [mvi C,read1NET]
    .ifn	BUFFopt, [mvi C,readNET]
	jmpr	Network
;
;-------
; - perform a NetWork Write
; entry>	none
; exit>		none
NetWr:

  .ife	WriteModes,[
	call	ckModeStatus	; check write status

    .ifn	BiosGrants,[
	jnz	WrongMode
	]		; end ' not BiosGrants '

    .ife	BiosGrants,[
	jrz	..writeOk	; Z set means writable
;
	call	getPermission	; ask for writable mode
	cnz	SayRefused	; Zreset if refused
;
	call	NetRestoreParams

    .ife	Station,[
	call	NetRet	]	; AckPoll and clear DMA

	jmpr	NetWr
	]		; end ' BiosGrants '

..writeOk:
	]		; end ' WriteModes '

	mvi	c,WriteNet
;
;-------
; Network read/write
; entry>	c = net request
; exit>
NetWork:

  .ife	FlopShare,[
	mov	A,C
	lxi	H,cpmDSK
	lxi	D,NETdsk
	lxi	B,6
	ldir		; set disk, track, sect, DMA
	jmp	NtRequest
	]		; end ' flopshare '

  .ife	HARDshar,[

; +	Note that net rd/wr requests must pass
; +	a DMS unit#, NOT a cpm drive#, and also
; +	must pass a volume#; that is why cpmMap
; +	is called and why cpmDsk/Vol are not used

	mov	A,C
	lxi	H,cpmTRK
	lxi	D,NETtrk
	lxi	B,6
	ldir		; set trk, sec, vol, DMAadr
;
	push	PSW	; save command byte
	call	cpmMAP	; unit # returned in Acc
	sta	NETdsk	; set disk
	dcx	H
	dcx	H	; hl = .physVolume

    .ifn	WriteModes !HiDosOpt,[
	mov	A,M	; Get volume #
	]		; not ' WriteModes and HiDos '

    .ife	WriteModes !HiDosOpt,[
;	- network writes must set the MSB of NetVol
;	  if the station is running HiDos
;
	pop	PSW
	push	PSW		; if this is a HiDos
	cpi	WriteNet	; write then set the
	mov	a,m		; NetVol MSB = 1
	jrnz	..volRdy
;
	set	7,a
..volRdy:
	]		; end ' WriteModes and HiDos '

	sta	NETVol	; Set volume
	pop	PSW
	]		; end ' hardshare '
;
  .ifn  BUFFopt,[
	jmp	NtRequest
	]		; end ' not BUFFopt '
;----------
; See if desired sector is in local network buffer
  .ife	BUFFopt,[
	sta	NETcom
	push	PSW	; save NETcom
	lxi	h,netbMode
	mov	a,m
	cpi	2	; mode = 2 says force net read
	jrz	..invalid
;
	mvi	m,0	; mode = 0 says try the net buf
	dcr	a	; mode = 1 says force net read
	jrz	..invalid
;
	lxi	H,netbDSK
	lxi	D,NETdsk
	ldax	D
	cmp	M	; compare disk
	jrnz	..force ; jump if not equal
;
	inx	H
	inx	D
	ldax	D
	cmp	M	; compare track (low byte)
	jrnz	..force ; jump if not equal
;
	inx	H
	inx	D
	ldax	D
	cmp	M	; compare track (high byte)
	jrnz	..force
;
	inx	H
	inx	D
	ldax	D
	dcr	A	; convert sector to 1K boundary
	ani	0F8h
	ori	1
	cmp	M	; compare sector
	jrnz	..force ; Jump if not equal
;
	inx	H
	inx	D
	ldax	D
	ani	07fh	; mask off high bit
	cmp	M	; Compare volume #
	jrnz	..force	; Jump if wrong volume
;
;----------
; Sector in buffer, so block move it in or out
..inbuff:
	call	FINDsect
	pop	PSW	; get	NETcom		
	sui	read1NET; see if command is a read
	jrz	..move
;
	xchg		; switch HL and DE if write
..move:
	ldir		; move to or from user area
	jnz	NetReq	; we send write_128 if writing
;
	ret		; else done if this is a read
;
;-------
; - mark buf as invalid to force a Network transfer
..invalid:
	lxi	h,netbVol
	mvi	m,0ffh	; mark NetBuf as invalid
;
;		- fall into ..force
;--------
; - force read at 1K boundary or send the write request
..force:
	pop	PSW	; get NETcom
	cpi	writeNET; see if command is a write
	jz	NetReq	; don't modify write params
;
	lda	NETsec
	dcr	A	; For example:
	ani	0F8h	;  sectors 1-8 map to 1
	ori	1	;  sectors 9-16 map to 9
	sta	NETsec
	lxi	H,NETdsk
	lxi	D,netbDSK
	lxi	B,5	; move dsk, trk, sec, vol
	ldir		; update buffer info
	lxi	H,netbVOL
	res	7,M	; clear high bit
	]		; end ' buf option '
;
	jmp	NetReq	; process the I/O request

  .ife	SPOOLopt,[
;----------
; Start spool job
NETstart:
	mvi	A,startNET
	jmpr	NtRequest

;----------
; Stop spool job
NETstop:
	mvi	A,stopNET
	jmpr	NtRequest

;----------
; Spool 128 bytes
NETspool:
	lxi	H,SPOOLsec
	mov	A,M
	cpi	128	; check for last sect on track
	jrnz	..write
;
	lxi	H,trkspl ; get spool track counter	
	inr	M
	lda	SPsiz
	cmp	M	; check for track too big
	jrnz	..notbig
;
	inr	A	; return error code
	ret

..notbig:
	lxi	H,SPOOLtrk
	inr	M	; inc track
	inx	H
	inx	H
	mvi	M,0	; reset sector
..write:
	inr	M	; inc sector
	lxi	H,SPOOLdsk
	lxi	D,NETdsk
	lxi	B,5
	ldir		;set net disk,track,sect,vol
	lxi	H,SPOOLbuf
	shld	NETdma	; set net DMA address
	mvi	A,spoolNET	; write rec to spoolDsk
	jmpr	NtRequest
	]		; end ' spool opt '
;
;----------
; Network lock
NETlock:
  .ife	BUFFopt,[
	mvi	A,0FFh
	sta	netbDSK ; flush read buffer
	]

	mvi	A,lockNET
	call	Lockwork
	mov	A,L
	cpi	081h	; special deny?
lckcont:
	rnz		; no, normal return
;
; yes, look if retried
	lda	lockerr
	ora	A
	rz		;no retries
;
	mvi	L,83h	;retry special status
	ret 
;
;----------
; Network unlock
NETunlock:
	mvi	A,unlockNET
	call	Lockwork
	mov	A,L
	cpi	82h	; special deny?
	jmpr	lckcont
;
;----------
; Network lock/unlock
Lockwork:
	lxi	H,lockerr
	mvi	M,0	; clear retry flag
	lhld	LOCKadr ; point to lock string
	lxi	D,NETcom+1
	lxi	B,lenlock+1
	ldir		; move lock to network command
	call	NtRequest

; if local user on Master then local lock and unlock
;	return expanded status in LOCKstat and
;	lockwork must set up the L register

 .ife MASTopt,[
	lda	LOCKstat
	mov	L,A	; return new status in L
	ani	03h	; mask off old bits
	sta	LOCKstat
	]	; end MASTopt
	ret

lockerr:.byte	0	; retry flag
;----------
; Network HD volume status request
NEThdstat:
	sbcd	HSTadr	; Store addr
	mvi	A,hdstNET
;			; fall into NtRequest
;-------
; entry>	a = net request code
NtRequest:
	sta	NETcom
;			; fall into NetReq
;----------
; Wait for a poll
NetReq:
  .ife	MASTopt,[

..wait:
	lda	NETcom	; wait for master to wake up
	ora	A	;  and process the command
	jrnz	..wait
	ret
	]

  .ifn	MASTopt,[
	call	lockDMA ; reserve the DMA chip
	xra	a
	sta	WaitCnt ; reset time-outs counter
Npoll:
	call	NACKpoll
	bit	timeout,A ; check for time-out
	jrnz	NetIO
;
	lda	WaitCnt ; wait for two timeouts
	inr	a	; together before
	cpi	2	; telling user
	jrnz	..noMessage
;
	lxi	H,Nwait
	call	PrtMsg	; tell user we timed out
	xra	a	; reset time-outs cnt
..noMessage:	
	sta	WaitCnt
Nretry:
	call	ACKpoll ; prepare for another poll
	jmpr	Npoll	; wait some more
;
;----------
; Process the current network command
NetIO:
	bit	pollRCV,a
	jrz	Nretry	; must have received a poll
;			  to continue w/request
	ani	crc$ovr ; crc or ovrun err
	jrz	..ok
;
	call	NETerr	; inc err cnt & disp err
	jmpr	Nretry

..ok:
	lda	NETcom	; get command
	sui	readNet
	jrc	..bad	; illegal command
;
	cpi	..lentab
	jrnc	..bad	; illegal command
;
	call	DISPATCH
..table:
	.word	Nread	; read 128 bytes or 1k
	.word	Nwrite	; write
	.word	..bad	; login

  .ife	SpoolOpt,[.word Nstart] ; start spool
		 [.word ..bad ] ; not used

	.word	Nread	; read 128 bytes or 1K

  .ife	SpoolOpt,[.word Nstop]	; stop spool
		 [.word ..bad]	; not used

	.word	..bad	; assign
	.word	..bad	; hog
	.word	Nlock	; lock
	.word	Nunlock ; unlock
	.word	Nclrlock; clear locks

  .ife	SpoolOpt,[.word Nspool] ; spool
		 [.word ..bad ] ; not used

	.word	Nhdstat ; master HD volume status
	.word	..bad	; date/time
	.word	..bad	; instant logOut

  .ife	WriteModes,[.word NWmode] ; write mode
		   [.word ..bad ] ; not used

..lentab=	(.-..table)/2

..bad:	call	ERRprint; illegal command
	jmp	NETret
;
;----------
; Both 128 and 1024 byte netReads come here. Whether
; 128 or 1k is read across the net is decided only by
; the assembly-time BuffOpt choice, and NOT by the
; run-time choice of readNet or read1Net - so if you
; wish to force a network transfer then call the
; DMS-specific jump vector 'SetNetMode' with
; c = 0   for use the net buffer
;     1   for don't use the net buffer on the next read
;     2   for don't use the net buffer until a warmboot
; a = old mode on return in case you care
Nread:
	call	SENDCMD

  .ife	BUFFopt,[
	lxi	H,netBUFF; data address
	lxi	B,1024
	]

  .ifn	BUFFopt,[
	lhld	NETdma	; data address
	lxi	B,128
	]

	lda	NETusr
	call	RECNET	; receive data from master
	call	ckRECstat
	jrnz	..0good
;
	call	NETerr	; timeout
	jmpr	Nretry

..0good:
	jrc	..fail	; carry set = crc or ovr err
;
	call	qDMAlen
	jrz	..1good

..fail:
	mvi	a,nack
	call	SENDmsg
	call	netERR	; DMA len is bad
	jmp	Nretry
;
..1good:
	mvi	A,datack
	call	SENDMSG ; acknowledge reception

  .ife	BUFFopt,[
	call	FINDsect; find address of sect in buff
	ldir		; move it to user area
	]

	jmp	NETret
;
;-------
; - Write a record to the network hard disk
; Notice that although NetWr checks Wr_Mode_Status
; the spooler doesn't enter through NetWr and the
; local user doesn't come here so the check is needed
; in both places.
;	I now think the above is wrong and the Wr_Mode
; code is not needed at all - so it isn't assembled
; entry>	none
; exit>		none

Nwrite:

;  .ife	WriteModes,[
;	call	ckModeStatus
;	jrz	sendWrite	; Z set -> writing ok
;
;needPermission:
;	call	NetRet		; clear DMA, ack polls
;	call	getPermission	; ask for writable
;	cnz	SayRefused	; Z set -> writing ok
;
;	call	NetRestoreParams; retrieve original
;	jmp	Nretry		; params - retry if req
;
;sendWrite:
;	]		; end ' WriteModes '

  .ife	SpoolOpt,[
Nspool:		]	; end ' SpoolOpt '

	call	Send2master
	jrc	..fail	; Cy set if net error
;
	lda	NetMsg	; get master's response
	cpi	MesAck
	jrz	..xmitData
;
  .ife	WriteModes,[

	cpi	CmdDeny	; sent when not writable

    .ife	BiosGrants,[jrz	needPermission]
    .ifn	BiosGrants,[jnz	WrongMode]

	]		; end ' WriteModes '
;
..fail:
	call	NetErr	; xmission or sync error
	jmp	Nretry
;
..xmitData:
	lhld	NetDma	; data address
	lxi	b,128
	sub	A 
	call	SENDNET ; send data to master
	call	RecMaster
	jrnc	..1good ; Cy reset if good
;
	call	NETerr
	jmp	Nretry
;
..1good:
	lda	NETmsg	; get rcv'd message
	cpi	datack
	jz	NETret
;
	call	NETerr	; error if not acked
	jmp	Nretry


  .ife	SPOOLopt,[
;----------
; Start spool job
Nstart:
	lda	SPLid
	sta	NETcom+1
	call	SENDCMD
	lxi	H,RespSpStart
	lxi	B,7	; AckSpStart,disk,track,sec,vol
	lda	NETusr  ;  and spool size
	call	RECNET	; get spool ack,dsk,trk,sec,vol
	call	ckRECstat 
	jrc	..fail	; transmission error
;
	call	qDMAlen
	jrnz	..fail	; message len error
;
	lda	RespSpStart
	cpi	AckSpStart
	jz	NETret	; master response ok

..fail:
	call	NETerr	; dma len bad
	jmp	Nretry
;
;----------
; Stop spool job
Nstop:
	lda	SPLid
	sta	NETcom+1
	call	Send2master
	jrnc	..0good
;
	call	NETerr	; timeout,crc, or ovr error
	jmp	Nretry

..0good:
	lda	NETmsg	; get rcv'd message
	cpi	mesack
	jrz	NETret
;
	call	NETerr	; not mesack
	jmp	Nretry
	]		; end ' spool opt '
;
;----------
; Send a lock/unlock request to the master
; return expanded status in L
  .ife	HARDshar,[
Nlock:
Nunlock:
	call	Send2master
	jrnc	lockok
;
	call	NETerr
	mvi	A,0ffh
	sta	lockerr	; indicate retry
	jmp	Nretry
;
lockok:	lda	NETmsg
lockcont:
	push	PSW
	call	NETret
	pop	PSW
	mov	L,A
	ani	03h	; mask off old status
	sta	LOCKstat; store status for user
	ret
;
;----------
; Send a clear-locks request to the master
Nclrlock:
	call	SENDCMD
	xra	A
	jmpr	lockcont

;----------
; Request and receive master HD volume status
Nhdstat:
	call	SENDCMD
	lhld	HSTadr	; Rcve data addr
	lxi	B,88h	; 8 + 128  bytes
	lda	NETusr	; Our user number
	call	RECNET	; Rcve the data
	call	ckRECstat
	jrnz	..0good
;
	call	NETerr	; timeout
	jmp	Nretry

..0good:
	jrnc	..1good

..fail:
	mvi	a,nack
	call	sendMSG ; neg acknowledge
	call	NETerr	; crc or overrun err
	jmp	Nretry
;
..1good:
	call	qDMAlen
	jrnz	..fail
;
	mvi	A,HSTack
	call	SENDMSG ; Ack reception
	]	; end ' hardshare '

;----------
; Resume answering polls, then return to caller
NETret: call	ACKpoll ; answer polls again
	sub	A	; CP/M wants A = 0
	sta	lockbyte; release the DMA chip
	ret
;
;-------
; entry>	none
; exit> 	Cy set if net error
Send2master:
	call	SendCmd ; send the NetCom buf
;			; fall into RecMaster
;-------
; entry>	none
; exit> 	Cy set if net error
RecMaster:
	call	RecMsg	; rcv a message from the master
	jmp	ckRecStat	; return the net status
;
;----------
; Send command to network master
SENDCMD:
	lxi	H,NETcom
	lxi	B,lencom
	sub	A
	jmp	SENDNET

	]		; end ' not master '
;
;----------
; Locate current sector in network buffer
;  Regs in:   none
;  Regs out:  HL = address of sector in buffer
;	      DE = CP/M DMA address
;	      BC = number of bytes in sector (ie, 128)
  .ife	BUFFopt,[
FINDsect:
	lda	cpmSEC	; get sector number
	dcr	A
	ani	7	; compute buff no (0-7)
	mov	D,A
	mvi	E,0
	srlr	D
	rarr	E
	lxi	H,netBUFF
	dad	D	; compute buffer address
	lded	cpmDMA
	lxi	B,128
	ret
	]	; end ' buff opt '

  .ife	WriteModes,[
;
;-------
; entry>	none
; exit>		Z set if drive is writable
ckModeStatus:
	call	GetWrModeAdr
	jmpr	ck4writable
;
;-------
; entry>	none
; exit>		hl = .Write_Mode_Status
GetWrModeAdr:
	lxi	h,ModeTable
	lda	cpmDsk
	mov	c,a
	mvi	b,0
	dad	b
	ret
;
  .ife	BiosGrants,[
;-------
; entry>	none
; exit>		none
errorPermission:
	call	NetErr		; command not processed
;		- fall into retryPermission
;
;-------
; entry>	only after getPermission has failed
; exit>		fall into getPermission
retryPermission:
	call	NetRestoreParams

  .ife	Station,[
	call	NetRet	]	; AckPoll and clear DMA

;		- fall into getPermission
;-------
;	- send Write_Grant_Request to master
; entry>	none
; exit>		Z set if Grant_Request is successful
getPermission:
	call	ask4writeMode
	jrnz	retryPermission
;
	call	IsResponseValid
	jrnz	errorPermission
;
	ldax	d
	mov	m,a		; set new Wr_Mode_Stat
	]		; end ' BiosGrants '
;
;		- fall into ck4writable
;-------
; entry>	hl = .ModeTable(drv)
; exit>		Z set if cp/m drive is writable
;		a = current Wr_Mode_Status
ck4writable:
	lda	NetUsr
	cmp	m
	mov	a,m
	rz			; you own this unit
;
  .ife	HiDosOpt,[
	cpi	Shared.Unit
	rz			; HiDos owns this unit
	]		; end ' HiDosOpt '

	cpi	Rd.Wr.Unit	; is it always writable
	rz
;
	cpi	MultiGrant	; if we already own it
	rnz			; then we might be ok
;
	call	CkMultiple
	rnz			; already owned
;
;    the master says we already own this drive -
;    but our Write_Mode_Table does not reflect this.
;    - Update our table and return success.

	push	psw		; save our user number
	call	GetWrModeAdr
	pop	psw		; our user number again
	mov	m,a
	cmp	a		; Z set -> success
	ret
;
;-------
; entry>	none
; exit>		Z set if not already owned
;		a = Wr_Mode_Status
CkMultiple:

; see if we already own this drive on another cpm drive
	lxi	h,ModeTable	; hl = .ownership table

;  b = number of drives, c = drive number
	lxi	b,NumDisks <8 + 00h
	lda	NetUsr		; our user number
;
..ck4owned:
	cmp	m		; see if this might be
	jrz	..prevOwn	; the same one we want
;
..next:
	inr	c		; increment drive no.
	inx	h		; check next drive
	djnz	..ck4owned
;
	cmp	a		; Z set for not owned
	ret	
;
..prevOwn:
	push	psw		; save user number
	push	b		; save ctr, drive#
	push	h		; save ModeTable(i)
;
; we own this drive - see if it is the same physical
; volume and unit as the one to which we are trying
; to write.

	lda	cpmDsk
	push	psw		; save current disk
;
; c = current drive to check
	call	SelDsk		; ret de = .dpb(unit)
	pop	h		; h = old cpmDsk
	push	d		; save dpb(unit)(test)
;
	mov	c,h		; c = old cpmDsk
	call	SelDsk		; de = .dpb(unit)(cur)
	pop	h		; hl = .dpb(unit)(test)
;
	ldax	d		; compare units
	cmp	m
	jrnz	..notThisOne
;
	dcx	h
	dcx	h
	dcx	d
	dcx	d
	ldax	d		; compare volumes
	cmp	m
	jrnz	..notThisOne
;
; clean up the stack
	pop	h		; restore ModeTable(i)
	pop	b		; restore ctr, drive#
;
	lda	cpmDsk		; if the one we found
	cmp	c		; is cpmDsk then ignore
	jrz	..ckNext
;
	pop	psw		; restore user number
;
	ori	0ffh		; Z reset -> refused   
	mvi	a,MultiGrant	; it's a real multiple
	ret			; - we already own it
;
..notThisOne:
	pop	h		; restore ModeTable(i)
	pop	b		; restore ctr, drive#
..ckNext:
	pop	psw		; restore user number
	jmpr	..next
;
    .ife	BiosGrants,[
;-------
; entry>	none
; exit>		a = net rcv status
ask4writeMode:
	lxi	h,NetCom	; save the net params
	lxi	d,NetParams
	lxi	b,lenCom
	ldir
;
	call	cpmMap
	lxi	d,askUnit	; de = .askUnit
	stax	d		;  a = physDsk
	dcx	h
	dcx	h		; hl = .physVolume
	dcx	d
	mov	a,m
	stax	d		; de = .askVolume
	inx	d
	inx	d
	lda	NetUsr
	stax	d		; de = .askValue
	inx	d
	stax	d		; de = .askUser
	mvi	a,WrGrant	; ask for permission
	sta	askSpecific

  .ife	Master,[
	lxi	h,askSpecific
	lxi	d,N.Request.Mode
	lxi	b,lenAskMode
	ldir
	]

	mvi	a,WrtMode
	jmp	NtRequest	; send the command
	]		; end ' BiosGrants '
;
;-------
; entry>	none
; exit>		hl = .WrModeTable(cpmDsk)
;		Z set for success
IsResponseValid:
	lxi	h,NetMsg
	mov	a,m
	cpi	MesAck
	rnz
;
; the local user has the Wr_Status info offset by one
; byte because NetCom is cleared to say the command
; has been proccessed. NetMsg has command ack/nak for
; consistency with the Net users.

    .ife Master,[inx	h]

	inx	h
	xchg			; de = .Wr_Mode_Status
	call	GetWrModeAdr	; hl = .ModeTable(drv)
	xra	a		; set Z flag
	ret

  .ife	Station,[
;
;-------
; entry>	none
; exit>		Zset if request understood
NWmode:
; get the parameters for this request into NetCmd buf
	lxi	h,askSpecific
	lxi	d,N.Request.Mode
	lxi	b,lenAskMode
	ldir
;
	call	SendCmd
	call	RcvWrModeStatus
	call	CkRecStat
	jrnz	..noTimeOut
;
..fail:
	call	NetErr
	ori	0ffh
	ret
;
..noTimeOut:
	jrc	..fail		; Cset = crc or ovr err
;
	call	qDMAlen
	jrnz	..fail		; Zset = right data len
;
	xra	a
	ret
;
;-------
; entry>	none
; exit>		none
RcvWrModeStatus:
	lxi	h,NetMsg	; hl = .receive buffer
	lxi	b,10		; Ack/Nak,value,name
	lda	NetUsr
	jmp	RecNet		; get the response
	]		; end ' Station '
;
;-------
; entry>	a = Write_Mode_Status
; exit>
SayRefused:

  .ife	Station,[
	push	psw		; save error code
	call	NetRet		; start answering polls
	pop	psw		; retrieve error code
	]		; end ' Station '

	lxi	h,OwnedMsg	; hl = .error string
	mvi	e,1		;  e = error type (1)
	cpi	MaxPossible +1
	jrc	SayError
;
	lxi	h,ReadOnlyMsg	; hl .error string
	dcr	e		;  e = error type (0)
	cpi	Rd.Only.Unit
	jrz	SayError
;
	lxi	h,ShareMsg	; hl = error string
	cpi	Shared.Unit
	jrz	SayError
;
	lxi	h,AlreadyMsg	; hl = error string
	cpi	MultiGrant
	jrz	SayError
;
	lxi	h,UnknownErr	; hl = error string
SayError:
	push	d
	push	h
	lda	cpmDsk
	adi	'A'
	sta	DriveLtr
	lxi	h,DriveMsg
	call	PrtMsg
	pop	h
	call	PrtMsg
	pop	d
	dcr	e
	jrnz	..askUser
;
	lxi	h,NetMsg +2
	mvi	b,8
	call	PrtString
..askUser:
    .ife     Master, [jmp	WaitMaster]
    .ife     Station,[jmp	WaitUser]
;
  .ife	BiosGrants,[
;-------
; entry>	none
; exit>		none
NetRestoreParams:
	lxi	h,NetParams
	lxi	d,NetCom
	lxi	b,lenCom
	ldir
	ret
	]		; end ' BiosGrants '
;
  .ifn	BiosGrants,[
;-------
; entry>	none
; exit>		none
WrongMode:
	lxi	h,ModeFailure
	mvi	e,0		; no name to print
	call	SayError
	jmpr	WrongMode	; no exit upon retry

	]		; end ' not BiosGrants '
	]		; end ' WriteModes '

