	.sbttl	'DMS/3, DMS/4 HiNet and CP/M bios --vers  249'


; +++++++++++++++++++++++++++++++++++++++++++++++
; +						+
; +	Hinet bios for CP/M vers 2.2		+
; +						+
; +	last revised>	84apr26 (msh)		+
; +						+
; +++++++++++++++++++++++++++++++++++++++++++++++




version =	2	; CP/M version number
revision=	249	; DMS revision number
patch	=	'a'	; Patch ID (normally blank)
mod	=	0f0h	; internal use only
			; - 0f0h for all releases
			;   (prints as blank)


; quick guide to option selections

zSel	=	Select	; 1 =alone, 2 =master, 3 =stat
zFox	=	FoxOpt	; 0 = default parallel console
zHard5	=	Hard5opt; 0 = hard5opt
zHard8	=	Hard8opt; 0 = hard8opt
zHiDos	=	HiDosOpt; 0 = HiDosOpt, 1 = cp/m
zMode	=	SysMode ; bit-mapped control byte

zBios	=	Bios	; address of bios jump table
zBdos	=	Bdos	; address of bdos
zCCP	=	cpm	; address of ccp
zNumDrvs=	NumDisks; number of logical drives
zLenBios=	lenBios ; byte length of bios
zLast	=	LastByte; last memory byte used
  .page
;---------------
;		TABLE OF CONTENTS		   PAGE
;	(page numbers from master option, use as guide)
;
; modification log				      3
; instructions for generating operating system	     10
; conditional assembly options			     12
; addresses of bios,bdos,ccp, and important tables   16
; important constants				     18
; port definitions and standard CPM entry points     22
; interupt vectors				     23
; non standard jump vectors			     24
; floppy,hard,and net command and status tables      26
; type ahead buffer				     29
; buffer and command status			     30
; cold boot code				     32
; assign a hard disk partition			     47
; disk parameter tables 			     50
; cold boot messages and SIO command strings	     52
; warm boot					     54
; conin,conout,const,list,reader,punch		     59
; type ahead code for various ports		     62
; SELDSK select disk drive			     72
; SETTRK set track				     76
; HOME,SEEK, DELAY				     77
; READ and WRITE disk				     79
; floppy disk reads and writes			     81
; hard disk reads and writes			     92
; network reads,writes,spools and locks 	     99
; master polling				    106
; context switch routines			    110
; login new user				    111
; process local user request			    115
; process remote user request			    117
; hinet read-write-assign			    121
; mimic routines				    123
; record locking routines			    124
; spooling routines				    127
; spooling utilities				    134
; spooling interupt driver			    136
; master utility routines send,receive user etc     139
; hinet station boot - phase 2			    144
; hinet station boot - phase 1			    146
; relocated bootstrap code			    147
; SENDNET					    152
; RECNET					    154
; SDLC interupts				    157
; psuedo numbers, network messages and commands     161
; sio and dma commands for network activity	    163
; process a timer interupt			    165
; process a front panel interupt		    168
; PRTMSG print a message			    169
; lock the DMA chip				    170
; handle an i/o error				    171
; CPMMAP get current disk map			    175
; default logical to physical disk maps 1.4	    177
; default logical to physical disk maps 2.2	    178
; default floppy disk parameter blocks - 8 inch     180
; default floppy disk parameter blocks - 5 inch     182
; sector translation, check and allocation vectors  184
; default custom printer driver 		    185

	.page
	.sbttl	'Modification log (b83vers.asm)'
	.prntx	'bios for CP/M vers 2.2 '
;----------
; DMS/3, DMS/4 CP/M BIOS
;
; Written by Peter Kavaler  July-December 1980,
;  with assistance from Robert Kavaler
;
; Written by Marc de Groot  January 1982-
; Modified by joel wittenberg from 24aug82 on-
;
; Modified by various and sundry types from 
; jan84 on
; 
; Update history:
;
; 1.40 (09/01/80) Initial release
; 1.41	(10/01)   Added S/L bit to pre-comp
;		  Network always at 500 Khz
;		  Network disk shared by master
; 1.42		  Clear DD buffer at offMOTOR
;		  LOGIN code added to master
; 1.421 (10/20)   SENDNET timing problem fixed
; 1.422 (10/22)   Floppy sharing added
;		  Harddisk ASSIGN added
; 1.423 (10/28)   IOBYTE added
;		  Centronix supported
;		  ASSIGN names added
;		  User names added
; 1.424 (11/04)   Changed floppy head settle times
; 1.425 (11/10)   ADDS printer supported
;		  User name table lookup added
;		  Master BIOS expanded by 1K
; 1.426 (11/11)   Added default configuration table
;		  Added boot from floppy drive 1
; 1.427 (11/24)   Added boot from hard disk
;		  Master does real warmboot
;		  Floppy and hard status in fixed loc
; 1.428 (12/04)   Master user must login
;		  Retry SECT, MADR errors
;		  Fixed 850 bug (headno missing)
; 1.429 (12/09)   Allowed DSC/4 on network
;		  Added hard disk timeout
;		  Handle CNTL-P with ADDS AUX port
; 1.430 (12/17)   Floppy network master can warmboot
;		  Remove ASSIGN code from BIOS
;		  Hertz rate in high core
; 1.431 (01/14)   Make compatible with CP/M 2.201
;		  Optional seek rate 3ms for 850
;		  Add hog protocol to network
;		  More extensive WHO info
; 1.432 (01/23)   Change network bootstrap procedure
;		  Add record locking
;		  User dependent IOBYTE
; 1.433 (04/01)   Transmit extra flags in front of msg
;		  Allow local user to talk on net
;		  Fix onMOTOR drive switch bug
;		  Add THS and more hard error msgs
; 1.434 (05/01)   Use DMA for hard disk
;		  Return CPU to local user during DMA
;		  Fix backspace bugs in ED and WORDSTAR
;		  Add 1K network read buffer
;		  Add mimicry
;		  Allow floppy defaults in user table
;		  Remove net code from flop or hardboot
;		  Add flop and hard code to net boot
; 1.435 (05/15)   Implement CP/M 2.2 network
;		  Combine CP/M 1.4 and 2.2 BIOS
; 1.436 (06/12)   Increase timint stack to 16 words
;		  Flush read buffer on record lock
;		  Clear up timing problems in net
; 1.437 (08/14)   Default type-ahead buffer for USER
;		  New parallel port interface
;		  No HALT error on master boot
;		  Ask for date, time on master boot
;		  Print spooling
;		  Diablo print driver (as CUSTOM dev)
;		  Add unassignments
; 1.437A	  Fix INT problem on master
;		  Fix msg intercept on master
;		  Add NOP to RECfirst
;		  Print user error message in hex
;
; (01/18/82)	Marc de Groot started maintenance of
;		the BIOS.
;
; 1.437B	FIXED A BUG IN THE LOGIN RANDOM DELAY
;		TO PREVENT THE DELAY COUNTER FROM
;		BEING ZERO.
;
; 1.437C	Added turnkey boot of remote stations
;		to the station boot code. Putting the
;		PROM serial # in the USERS table as a
;		user name ( with no password ) will
;		cause the machine with that serial no.
;		to auto-boot.
;
; 1.438 	Added type-ahead to port 3.
;
; 1.438A(02/08) Type ahead working on both input and
;		output for port 3.
;
; 1.438B(02/10) Moved the HiNet stn code down 1 page
;		to accomodate the port 3 type-ahead.
;		Port 3 type-ahead does not assemble
;		for the HiNet master.
;
; 1.438C(02/11) Added poll-prime capability.
;
; 1.438D(02/19) CP/M warm boot now re-initializes the
;		SETppa jump and the INTERUPT jump.
;
; 1.438E(03/03) X-ON/X-OFF protocol added to serial
;		print spooling.
;
; 1.438F(03/08) Attempted fix for the LOCKdma bug
;
; 1.438G(03/11) LOCKdma rewritten. #-of-retries bug
;		fixed. Timer interrupt routine
;		shortened. DI and EI added to floppy
;		RESULT routine.
;
; 1.438H(03/11) Took serial port 1 out of list of
;		possible CONIN/CONOUT assignments,
;		and replaced it with parallel port 1
;		for the Fox.
;
; 1.438I(03/13) Made PHASE 2 of the net boot code
;		a fixed length for LOGINFOX.
;
; 1.438J(03/17) Fixed the parallel input status routine
;		to return 0FFh if char ready.
;
; 1.438K(03/19) Pointed the PHASE 1 boot code at the
;		PROM input/output routines. The PROM
;		is shut off after PHASE 1 executes;
;		not before.
;
; 1.438L(03/24) 1.438K contained a common net boot for
;		the FOX and DSC/3 and 4. Somehow the
;		net disk-write operation was
;		affected. This rev has the common
;		net boot and also works correctly.
;
; 1.438M(03/31) Shut off assembly of port 3 typeahead
;		for stand-alone floppy boot systems.
;
; 1.438N(04/05) Set HeadSettle to 7800h. FOXopt added.
;		Numerous changes made for 5 inch disks.
;		SYNC error deleted; made re-tryable.
;		SEEK error deleted; made re-tryable.
;		Default disk table conditionally as-
;		sembles 5 or 8 inch floppy defs. ac-
;		cording to FOXopt.
;
; 1.438O(04/12) Began conversion to dual size floppy
;		capability for network station code.
;		cpmMAP, ASSdef, and ASSIGN changed.
;		Note! Most changes only implemented for
;		CP/M 2.2 on experimental basis.
;	(04/19) Changed SELDSK, SECTRAN, HARDprep, READ
;		WRITE, SEEK, Network, and HOME to agree
;		with new cpmMAP and iobMAP routines.
;	(04/20) Changed ASSIGN again and goSPOOL.
;	(04/22) Changed ASSdef, and the station code
;		booted. NOTE: the system has only been
;		tested as HiNet station code under 2.2
;	(04/28) Errors were found in the poll-prime
;		protocol. Proper initialization of the
;		poll-prime addr added to WBOOT.
;
; 1.438P(05/03) Added Flop5opt and changed FOXopt to
;		agree with existing cond. assy. style
;		for implementing various media types.
;		Note that Flop8opt is for 8 inch and
;		Flop5opt is for 5 inch. FOXopt is for
;		FOX specific stuff only (init IOBYTE,
;		etc.)
;	(05/04) Added Flop5boot and started converting
;		code that suffers when both Flop8opt
;		and Flop5opt are selected.
;	(05/06) Added set5 and set8 to change the max
;		number of sectors and gap length when
;		changing disks.
;	(05/10) Modified ASSIGN to set MEDIUM to NET.
;
; 1.438Q(05/10) Started modifying code to make stand-
;		alone systems work properly.
;	(05/12) Changed ASSdef to set both the media
;		type and the unit no. to 0FFh if
;		the drive is unassigned. (Previously
;		set only unit no. to 0FFh.)
;
; 1.438R(05/13) Started fix for poll-prime. Poll-prime
;		ack now 'V' instead of being the same
;		as pollack ('A').
;
; 1.438S(05/20) Various experimental changes made to
;		fix poll-prime.
;	(05/24) Fixed problem of setting bit 4 in
;		RECstat when a poll-prime comes.
;
; 1.438T(05/23) Rewrote REClast to finally fix the
;		poll-prime problem.
;
; 1.438U(05/26) Began changes to fit the expanded
;		stand-alone floppy-boot system on an 8"
;		disk. Eliminate the user printer driver
;		from the stand-alone code.
;
; 1.438V(06/02) Fixed assembly error in stand-alone
;		harddisk version. Result buffer print
;		only assembled if TESTopt = 0.
;
; 1.438X(06/14) Fix for strange net read error.
;		Added code to print the err code
;		returned printed by the hard disk
;		controller.
;	(06/16) Changes for mult. hard disks put into
;		HARDr,HARDw,HARDrd,HARDwr.
;
; 1.438Y(06/16) Continued changes for multiple HDs.
;
; 1.438Z(06/17) Repointed cpmMAP at DSKBOOT+2. Changed
;		calls to ASSIGN.
;
; 1.439 (06/18) Got the master BIOS to boot. Added
;		HDstat.
;
; 1.439A (6/23) Attempted to fix HDstat.
;
; 1.439C (6/30) Fixed HDstat for network station.
;
; 1.439D(07/02) Changed the floppy gap length for mini
;		floppies if FOXopt=0. The net station
;		BIOS still runs at half speed for some
;		reason.
;
; 1.439E(07/06) Added code for HDstat network requests.
;		Nhdstat,NEThdstat added. HDC errors now
;		all print HDSK error, along with an
;		error code.
; 1.440A(07/13) Moved the BIOS down to 0EF00h for the
;		8 inch stand-alone code. Corresponding
;		changes were made in FBOOT.ASM
;
; 1.440B(07/14) Fixed HDstat for local HD on net stn.
;		Moved cold boot code from floppy rd
;		buffer to the check/allocation
;		vector buffer if floppy boot.
;
; 1.440C(07/15) The cold boot for floppy boot is now
;		at rdbuffer-200h, which moves it into
;		the check/allocation vector area. The
;		equates do not insure the code ends up
;		in the vectors, so care must be taken
;		when moving the check/alloc vector
;		area. It is now necessary to move the
;		BIOS high mem constants down with DDT.
;		(See 'instructions for generating
;		operating system').
;
; 1.440D(07/16) Int enable for port 3 in CBOOT now
;		dependent on AH3opt, not AHEADopt
;
;
; 1.441 (07/17) All versions working except for HD
;		stand-alone. HD stand-alone does not
;		recover from the CCP cmd. S: <ret>
;		properly. It logs to C: with another
;		MP/M user number. USER 0 restores it.
;		Changed the BIOS length value so 100h
;		added only for 8 inch stand alone
;		instead of all non Flop5opt configs.
;
; 1.441A(07/22) Added code to allow stand-alone stns
;		to execute one cmd line on cold boot.
;
; 1.441B(07/22) Put floppy specify in SELDSK.
;
; 1.441C(07/26) Added HiNet date/time protocol.
;		Moved the station code down 1
;		page, to 0DE00h.
;
; 1.441D(07/27) Fixed IOERR to print the HD and floppy
;		result buffers more cleanly.
;	(07/29) No retries on HDSK error; IOERR waits
;		for one key press and warm boots.
;
; 1.441E(07/30) HiNet station code now works in
;		diskless stations.
;
; 1.441f(8/3/82) Hard disk select waits for status
;		return from firmware.
;
; 1.441g(8/3/82) Hard disk select status receive is
;		done with inline code instead of a
;		call to reshard.
;	--RELEASED--
;
; 1.441i(8/23/82) Spool code makes use of volume info.
;		Source changed to agree with ddt 
;		patches which created version 1.441h.
;	--RELEASED--
;
; 1.441j(8/24/82) Maintenance now being done by
;		joel wittenberg...
;		No more fatal HDerr on boot when
;		prtspool is on vol<>0 and prtspool 
;		partition is > corresponding vol0 part.
;	
; 1.441k(8/26/82) Prtspool now ok on any vol, any unit
;
; 1.442b(9/09/82)	Floppy, hard disk, and net
;		error handling improved; now keeping
;		floppy retry cnt in memory; IOERR
;		returns to caller, not to callers'
;		caller (1 level too far). REHOME
;		not performed unless failed op had a
;		track error. NRDYerr added, others
;		now work correctly.
;			NETerrs now save the callers'
;		address and print the user's number
;		and the MASTbuffer contents.
;			Hard disk errors now call 
;		NETerr (if on the master), print 
;		the HARDstat buffer contents, 
;		and either continue or query the 
;		master user depending upon 
;		MODE bit 7 (prev not used). 
;			Changed stat boot phase 1 to 
;		relocate ram before setting int vector.
;			Moved station BIOS code down
;		one page, so CPM2cf.com must now be 
;		used. Added check for too large a
;		code segment - it and the bios offsets 
;		are currently correct for hard master 
;		or station only. 5 inch disk drivers
;		not fully updated.
;
; 1.442c(13/09/82)	Removed bogus, non-functional
;		typeahead OUTPUT buffer for port3,
;		replaced it with the standard port
;		output code.
;
; 1.442d(14/09/82)	One change in SIO programming
;		req'd to make new port3 code work.
;		Changed retry function in floppy driver
;		to restart drive motor (for 5 inch).
;		Also changed default mode byte to
;		inhibit user mss. Changed HALTerr.
;
; 1.442e(14/09/82)	Changed HALTerr again just
;		a bit so that warm boot by operator
;		will still have exec'd a RETI.
;
; 1.442f(21/09/82)	Slight changes to error
;		messages and flop err mask; just
;		for consistency with prev versions.
;		Functionally no different.
;
; 1.442g(27/09/82)	NRDYerr given only for
;		current disk. Hard disks no longer
;		check dir entries on warm boot
;	--RELEASED--
;
; 1.442h(06/10/82)	BIOS is 100h larger if it is
;		stand alone floppy boot. FOX parallel
;		port now usable for printer if no 
;		hard disk is installed (station only-
;		use 2411 for stand-alone). Bios is too
;		large for any stand-alone boot.
;	
; 1.442i 12/10/82	Master now checks for CRC and
;		ovr err on net xmissions; net errs now
;		show user name and no. NETerr now
;		callable from station code. HD errs
;		always show user name, no. and cmd
;		buffer. Missing a poll no longer
;		affects freq of polling.
;			Hard disks check dir entries
;		again-potential problem otherwise
;		with mult users on the same partition.
;			Because of all this the bios is
;		once again moved down one page.
;		CPM2ce.com for master.
;
; 1.442j 22/10/82	Net error handling much better:
;		Same comments as (i) but all working.
;		Still no checks to insure that length
;		of rcv'd message is correct. Stat login
;		ignores backspace and delete
;	-- TOM LEWIS (england) has this code --
;
; 1.442k 10nov82	Changed '*** waiting' message
;		time to 8 seconds
;
; 1.442l 15nov82	Sign-on accepts backspace and
;		delete again. (commented out for space
;		but it does work). CP/M 1.4 support
;		removed
;	
; hfox2.242m 17nov82	commented conditional assembly
;		end points. Allows hard boot and 
;		5 1/4 floppies
;
; hfox243b 15dec82	FOX hard disk stand alone boot
;		Uses normal hard disk DPB's. Boot disk
;		adr ret'd by cpmMAP points to a real
;		DPB. Drive 'd' defaults to M0 if
;		TESTopt equ zero.
;			CP/M checks the system track
;		offset value in the dpb before setting
;		cpmTRACK -- so the dpb has a sys track
;		offset of zero, and the offset is
;		calculated in calcLOGadr.
;			Does 1K buffered reads; does
;		read-before-write only if desired
;		sector is not in the 1K buffer;
;		writes are 256 bytes and are never
;		buffered.
;			Doesn't pre-read on write to
;		previously unallocated group.
;			Good only for stand alone
;		FOX - not network HD fox.
;
; hfox243c 16dec82	HDstat gets real status byte,
;		and reads volume info from disk
;		"firmware" (first sector of volume 0)
;
; hfox243d 20dec82	Writes are buffered and always
;		1024 bytes except that DIRECTORY writes
;		are written immediately
;
; hfox243e 21dec82	Timer int flushes the fox hard
;		disk buffer after 1 second of no hard
;		disk activity
;
; hfox243f 22dec82	Changed flushACT to use current
;		command block (avoids incorrect disk
;		write when an assign is done after a
;		buf write but before a	disk write).
;		More changes made for master and
;		stations but it's not there yet
;			Fox-15 station code to be
;		stored on tracks 7 and 8 on the
;		master
;			No hard disk code is
;		assembled for a Flop5boot
;
; bios243g 04jan83	Happy New Year!
;		Changed setACT to set physical adr
;		as well as logical
;		
; bios243h 17jan83	ASSdef uses DSKdef unless hard
;		disk fox boot
;
; bios243i 18jan83	Changed error handling (Kenny
;		found some problems)
;
; bios243j 27jan83	Changed ASSIGN and related cold
;		boot routines for FOX-15 master. Wrote
;		MMassign, HARDr, HARD1, and HARDw.
;		Removed outchr and outmsg - using
;		conout and prtMSG instead.
;
;---------------
;	***	updated with substantial changes made
;	***	in non-fox15 version (bios244a.asm);
;	***	first fox w/update will be called
;	***	bios244f.asm. Bios244f.asm not working
;	***	as master or station; 8 inch assembly
;	***	not tested. Descriptions of updates
;	***	follow:
;
; bios244  11mar83	Changed error handling (Kenny
;		found some problems). Changed REClast
;		and NETio  to insure that a poll was
;		rcv'd. SENDnet no longer polls the
;		SIO to find end of transmission.
;		This fixes the intermittent failure
;		to turn off the SIO.
;			Changed RECfirst to alter
;		timing. 
;			Added check in REClast to
;		store actual rcv'd data length in
;		rcvDMAlen. All routines which call
;		RECnet for a data block will check
;		that the correct len was rcv'd.
;		Also all checks for using dma now
;		check actual len not just LSB.
;			REClast also uses a local
;		stack, carefully placed at end of
;		boot phase 2 code - stack loc must
;		be ok during running mast, running
;		station, and booting station.
;			DMANRdone deleted - int.
;		vectors to REClast instead.
;			PRNTint has bigger stack
;		and disables further printer ints
;		until done to cure intermittent
;		crashes.
;			Master disables serial print
;		ints while polling to prevent print/
;		rec(first/last) conflicts.
;			FOX and 5000 stations now
;		have default typeahead buffers at
;		cold boot.
;			Master will poll users and
;		count them down to 224, then poll
;		less frequently (cur once every 32
;		poll cycles) to avoid premature 
;		logouts.
;			Changed errPRINT and IOerr
;		to print out meanings of err bytes
;		and the actual type of net error.
;			Master console now polled
;		in timer int to avoid intermittent
;		timing problem.
;			Bug in HD drivers fixed -
;		error in read would still expect
;		data but HD ctlr won't send data
;		so bios would hang.
;			Note that several hard disk
;		controller bugs were found by this
;		code so new firmware should be
;		wrun0'd. Also Term Cnt mod to old
;		cpu boards is mandatory.
;
; bios244a14 09apr83	Terminal Count FDC mod not
;		needed anymore. Changed login so
;		serial number(bin) is sent back
;		and forth to overcome SIO weakness
;		in not noticing concurrent xmission
;		when 2 stats login together. Hard
;		disk controller sends error back on
;		select command when auto flush was
;		bad; master will retry the select.
;			Parallel spooler ok, Rec
;		Begin/Last changed to fix (again)
;		the intermittent sation logouts.
;
; bios244f9		Assembles and runs normal 8"
;		master and 5/8" stations, no 5" HD
;
; bios244g0		Changed IOERR and SEEK so
;		FLOP/MINI test can get error status
;
; bios244g2 25apr83	Different assy opts added.
;		No step settle wait for same track.
;
; bios244g6 28apr83	Various experimental changes
;		made for flop enhancements; runs
;		hard5alone
;
; bios244g7 02may83	Terminal Count fix not yet
;		working. First changes for DMS-15
;		Master/Station.
;
; b244h0 04may83	Changed 5 " precomp algorithm
;		Changed 5000 conin to wait until conout
;		char has gone (avoid half duplex clash
;		with crt controller).
;
; b244h7 23may83	Assembles and runs as DMS-15
;		master but buggy and no stations yet.
;		Added Hd5busy flag.
;
; b246a  26may83	Fixed preRead problem. Changes
;		in error reporting and do5assign (maybe
;		not so buggy now). Vers 246a as ver 245
;		released for standard system.
;
; b246a1 02jun83	Minor changes to various Hard5
;		drivers; do5assign not used in master
;		cold boot.
;
; b246a2 07jun83	Got assign working and now have
;		changed to using hd5desc and local user
;		calls Hrd5prep to get unit# and volume.
;		Also keeping alloc table in dedicated
;		buf for performance so size has changed
;		again.
;
; b246a3 16jun83	Assembles options separately,
;		including no mass storage. New option
;		len equates for more accurate sizing.
;
; b246d  23jun83	Hd5opt checks rd/wr requests
;		against unit boundary limits. Added
;		netbMode (always/never/not now) and
;		default TypeAhead on stations w/o
;		Type AheadOpt. Also AddsOpt supports
;		all 5 terminal types, selected by
;		DMS specific jump vector.
;
; b246d1  27jun83	Master sends Start Spool Ack
;		to station/local user to indicate it
;		has understood the request and they
;		check that a valid AckSpStart was
;		received (86 station was failing to
;		send a recognizable StSpoolRequest).
;
; b246e0  18jul83	Added HiDosOpt conditional
;		assy for extra DPB fields etc. Also
;		HiDos max file size is 32 MegByte.
;
; b246e2  27jul83	Changed flop cold boot address
;		to be at RdBuf - 180h, ie., RdBuf -
;		(check/alloc vector len) - (DirBuf len)
;		This guarantees that the cold boot is
;		in unInitialized memory as long as data
;		storage is not moved.
;
; b246e3  10aug83	Hard5 bufferred master working.
;
; b246e4  16aug83	Read modified polling working.
;		DMS-15 master, alone, and station now
;		completely integrated with 103 code.
;
; b246e5  17aug83	1 to 16 cp/m drives selected
;		at assembly time
;
; b246f   25aug83	PreRead data in separate buffer
;		for greater hit ratio.
;
; b246g   30aug83	zNumSysRecs, ZwarmTrack, and
;		zWarmRecord are now global for easy
;		reference. Zoffset gives zdti offset
;		to use when linking bios to cp/m sys.
;		Also length of system for warm boot
;		data is calaculated in a clearer
;		manner. All stations' sytem code now
;		located on tracks 7 and 8.
;
; b246h   15sep83	cp/m drives #4-15 default to
;		unassigned (media byte is 0ffh). Fixed
;		master 8" buf alloc bug, preRead bug,
;		5/8" master warm boot bug (AckPoll),
;		5" master w/serial console input bug,
;		phantom mimic death bug, RWtest bug,
;		and hopefully the spool '01' bug.
;
; b246i   19sep83	Minor changes -- mimic error
;		message on master changed, flop5boot
;		w/hard5opt inits hard5 now, parallel
;		spool print dependent on FoxOpt not
;		hard5opt, flopBoot w/hardOpt calculate
;		size check by>
;		((RdBuff -180h) -Bios) -(#sec *SecSize)
;			Note that flop boots with 5"
;		hard disks are too large to fit and 8"
;		hard disks can only use 2 drives so to
;		not confuse users no flop boots will
;		have hard disks available.
;
; b246j   22sep83	Minor changes for smaller code.
;		Added port3 debug mode - when ModeDebug
;		is set then port3 i/o also uses the
;		console device (based upon the qHrd5
;		bit of the iobyte).
;
; b246k   26sep83	Corrected 2 typo's - 1 in Hard5
;		ckSequence, the other in Hard8 preRead.
;		Changed Hard8 Master lenBios equate for
;		slightly better fit.
;
; b246l   01oct83	Kenny found some problems in
;		Hard5 error handling - multiple sector
;		xfers didn't recover correctly from
;		corrected data CRC errors.
;
; b246m   04oct83	Added 1 sec flag for login user
;		polling - master timer sets NowCkLogin
;		once / sec; master checks and clears it
;		before every poll and polls the login
;		user if it is set.
;
; b246n   04oct83	Now Boot Phase 1, Cklogin, and
;		CkSpool are done if OneSecFlag is true
;		- Boot Phase 1 is no longer done at the
;		end of the polling sequence.
;			Experimental 6.56 mSec delay
;		added on 8 inch hard master preread if
;		HDC says the read was from a buffer.
;		A flag is set on preReads to tell the
;		8" HDC that this is a preRead. Both of
;		these changes await the HDC firmware
;		release that implements them.
;			Login conflict random delay
;		mask changed to 1f (NumUsr-1).
;
; b246o   10oct83	Master and station always asm a
;		jump to SetNetMode in the DMS-specific
;		jump table - this routine is null if
;		BuffOpt is false.
;			readNet commands now correctly
;		vector to Nread, which reads either 1k
;		or 128 bytes across the net depending
;		only on whether BuffOpt was selected at
;		assembly time.
;
; 246p	  18oct83	DriveDopt should now work for
;		Hard8Boot assemblys. Station assemblies
;		don't give you the choice of assembling
;		both hard disk drivers.
;
; 246q	  27oct83	RecLast changed to exit quickly
;		if xmission error detected (no poll or
;		pollPrime Ack, etc). WaitSpool called
;		in i/o status routines because ConIn
;		was calling it only once. NotReady errs
;		unload head after 1 second unless func
;		is retried.
;
; 246r	  02nov83	AckPoll clears failed2ack flag.
;		ConStat increments failed2ack and
;		if < failed2ack =0 > and < Ackflag =0 >
;		   and < (PPAadr) != 2 >
;		then it calls AckPoll
;
; 246s	  08nov83	Changed RecLast to NOT delay
;		832 uSecs before sending PPack/PPnack
;		after PP_data_block is received.
;
; 246t	  09nov83	Changed b83defs.asm to allow
;		a better fit to various options.
;
; 246u	  18nov83	Changed test for asking if Flop
;		controller exists to 'cpi 80h' - some
;		3b's were saying they had a FDC.
;
; bios247 28nov83	***	FULL RELEASE	***
;			- renamed 246u to 247
;
; 247a	  05dec83	Separated Boot (merged 247
;		and the Separated Boot BIOS originally
;		based on 246h)
;
; 247b	  04jan83 (jlw) HDC software reset installed
;
; 247c	  06jan84 (dsb) B83MAST: cleaned, parameterized
;	       Boot Phase 1: put lixd 3FE so 1280's can
;		work; fixed bug in serial # comparison.
; 247d	  11jan84 (dsb) B83DEFS: Changed calculation of
;		  zOffset to account for splitting off
;		  CCP/BDOS, adding header to stations.
;		Also, product map is now automatically
;		 generated (doesn't ask at assby time).
;	       (jlw) B83FLOP: fixed specify bug that
;		should have been invariably fatal since
;		 before separated boot, but wasn't.
;
; b247d2   12jan84 (jlw) Changed LookLock to be more
;		rational; CBoot len to be 900h; WaitUsr
;		to allow Ignore; OneSecFlag now set
;		in-line instead of in INTERUPT; and
;		continuing Wr_Mode changes.
;
; b247d3   17jan84 (jlw)	More Wr_Mode changes.
;
; b247d4   21jan84 (jlw)	More Wr_Mode changes.
;
; b247d5-7 25jan84 (jlw)	More Wr_Mode changes.
;
; b247d9   26jan84 (jlw)	etc.; to SW test / beta
;
; b247dA   02feb84 (dsb) fix bad constants affecting
;		user name lookup, record locking and
;		first-write table initialization;
;		fixed some conditional assby places;
;		master cboot knows to look for HPM2xx
;		if HiDos and DPM2xx otherwise.
;
; b247e0   02feb84 (jlw)	Added bios jump table
;		entry for making Wr_Mode calls, also
;		added Clear(all) disk locks
;	
; b247e2   06feb84 (jlw)	Added Wr-Mode Master
;		initialization for multiple volumes.
;
; b247e3   06feb84 (dsb)	High-memory constants
;		are copied elsewhere for safekeeping &
;		a new jump table entry returns the addr
;		of the place they're copied to.
;		Master clears all write ownership for a
;		newly logged-in user.
;
; b247e4   06feb84 (jlw)	MakeModeRequest updates
;		the local WrModeTable for all required
;		functions. Cold boot assign does auto
;		WrGrant if the assign name hibyte/hibit
;		is set.
;
; b247e5   07feb84 (jlw)	Fixed bug in multiple
;		volume Wr_Modes. Changed lenBios equ's
;		for better fit
;
; b247e6   10feb84 (jlw)	Fixed cold boot Getc
;		to work for master dpm file on first
;		entry of a record. Also shortened some
;		assorted disk code by using subroutines
;
; b247e7   15feb84 (jlw)	Fixed a cold boot bug;
;		some minor cleanup.
;
; b247e8   17feb84 (dsb)	Some assby options get 
;		too long & we haven't time to fix them
;		for release so I'm putting in an assby-
;		time memory size fudge factor.
;
; b247e9   22feb84 (msh)	Change station cold
;		boot length from 0400h to 0500h. Need
;		the extra room for HiDos on a 15/501.
;
; b247f1   23feb84 (dsb)	Changed handler for
;		login requesting "generic CP/M" -- it
;		now means "HiDos or CP/M 86", rather
;		than "CP/M 2 or CP/M 86".  If a user
;		wants CP/M 2.x he must specifically ask
;		for it (OS request byte must be 11h,
;		not 10h).
;
; b247f2   24feb84 (msh)	(per jlw) Changed
;		NetWork to kill net buffer on a forced
;		write. If a read follows a forced
;		write to the same 1k blk the data that
;		would normally be returned is outdated.
;
; b247f3   27feb84 (jlw)	Kill the NetBuf on xfer
;		only if it is forced by the NetBufMode
;		flag, and not by a buffer miss.
;
; b247f4   28feb84 (msh)	Master Cold boot code
;		now looks for new bdos name. LenBDOS
;		reduced by 100 hex for HiDos.
;
; b247g1   01mar84 (dsb)	Boot Phase 1 maps in
;		lowest bank on DSC-4.  Master puts the
;		right serial number in logdeny if serial
;		number search fails.  Errors that cause
;		log-deny print message on Master, with
;		failed search pattern, IFF ModeMSG set.
; b247g2   04mar84 (dsb)	Fixed bug in error re-
;		porting on Master when login denied.
;
; b247g3   04mar84 (jlw)	Changed Nspool to start
;		after the Wr_Mode checks in Nwrite:
;
; bios248  06mar84 (jlw)	Renamed bios 247g3 to
;		bios 248 for March release
;
; bios248a 08mar84 (jlw)	Clears a possible cold-
;		boot request for Wr_Grant status from
;		the default assign name before moving
;		the name to the DPB. Bios 248 was Not
;		released - i hope bios 248a will be.
;
; b248a0   15mar84 (jlw)       automatic Wr_Mode_Grants
;		conditional upon BiosGrants, normally
;		set false. This fixes BDOS buffering
;		problem
;
; b248a1   20mar84 (dsb)	header generators allow
;		for IBM PC card (product type 8).  Can
;		log in a station that's not in the
;		Machine Table.
;
; b248a2   26mar84 (dsb)	fix bug in bit-map test
;
; b248a3   29mar84 (mep)	Increase number of
;		logged in users to 64, number of lock
;		strings to 128, eliminate check vector
;		if HiDos, and convert diskette Fn 
;		assignments in cold boot to Mn or Dn.
;		Also, rearrange floppy & net buffers.
;		Add wait in network date, add netinfo
;		protocol, add TRANSFER bios data, add
;		b83cnfg.asm for easy assembly.
;
; b248a4  04apr84 (kgh)		Fixed 3 bugs in 248a3
;		code. Also modified record lock status
;		reporting and cold boot partition type
;		checking.	
;
; b248a5  10apr84 (kgh)		Modified spooler to
;		have 16 spool buffers and link them
;		for file printing also reclaimed the
;		two sectors that were being lost at
;		the beginning of each spool buffer.
;		Added spool id field to spool start
;		and stop protocols. Also improved
;		front panel interrupt routine for
;		linking thru RST 6.
;
;  b248a6  14apr84 (kgh) 	Debugged spooler
;		routines and improved user inerface
;
;  b248a7  16apr84 (kgh) 	Fixed 32M dpb	
;
;  b248a8  18apr84 (kgh) 	Fixed Foxopt in cond ass
;		also added 100h fudge factor to lenBios
;		for station foxopt. Fixed introduced bug
;		in Mread and Mread1 when trimming code
;		also 16M and 32M support
;
;   b248a9 19apr84 (msh)	Changed conditional
;		Assembly for Stand Alone Hidos and
;		updated SA cboot size to 0500h 
;
;  b248b0  19apr84 (kgh)	Cleaned up problems
;		with net buffer writes (vol high bit)	
;
;  b248b1  23apr84 (kgh)	Fixed 32M dpb
;
;  b249	   24apr84 (kgh)	Fixed lock on stations
;		and went for final release
;
;  b249a   84apr26 (msh)	Need updated bios for 
;		two drive floppy system so syslib will
;		work. Change cold boot loader to calc
;		location based upon number of drives.
;		This should be for floppy systems only.
;----------
;
  .page
  .sbttl	'instructions for generating operating system (b83vers.asm)'
;----------
; Many different standard versions of CP/M 2.2 can be
; generated by assembling this BIOS, depending upon
; which conditional assembly options are chosen.
; The procedure for generating a complete operating
; system for each common case is outlined below.
;
;
;	A>azm bios83 o
;		zLast equates to vvvv
;		   common maximum values are>
;			Master			-> f4ff
;			Station
;			  with	NetBuf &  flops -> f9ff
;			  with	NetBuf & !flops -> fbff
;			  with !NetBuf &  flops -> fdff
;			  with !NetBuf & !flops -> ffff
;			Alone
;			  with	flops		-> fdff
;			  with !flops		-> ffff
;
;		zBios equates to ww00
;			ww = dpm2ww.com
;
;		zOffset equates to zzzz
;			zzzz = zdti offset value
;
; For floppy boot:
;
;	A>zdti
;	-f100 a000 0	; initialize memory with 0
;	-i5fb213.hex OR
;	-i8fb213.hex
;
;	-r7900		; read in boot loader
;			; now at 900h
;
;	-ihidosnn.vvv
;	-r900		; read in ccp and bdos
;			; now at a00h
;
;	-ib83main.hex
;	-rzOffset	; read in bios
;
;	-^C
;	A>save xx bios83.com
;	where xx is 1 less than the largest 'Next'
;	displayed by zdti (high byte only), converted
;	to decimal.
;
;	A>Sysgen
;
; For hard boot:
;	A>zdti
;	-f100 a000 0	; fill mem with 0
;	-ibios83.hex
;	-rzoffset
; If the value for zoffset is right you should be able
; to see cold boot code (di, lxi SP,80 etc.) at 100h.
;	-^C
;	A>save xx filename.com
; Filename is the name by which this program will be
; known to SYSLIB and to the cold-boot loader (which
; loader may have to be patched to look for the right
; name).
;	A>SYSLIB

; Now write cold boot loader to disk, unless it already
; is there and already knows the right system to load.
;	A>Wrun0 5hmboot.com 2 1  OR  ; Hard5 mast
;	A>Wrun0 5haboot.com 2 1  OR  ; hard5 alone
;	A>Wrun0 MastBoot.com 2 1 OR  ; Hard8 mast
;	A>Wrun0 HardBoot.com 2 1     ; Hard8 alone
;
; For net boot:
;	A>zdti
;	-f100 a000 0	; fill mem with 0
;	-ibios83.hex
;	-rzoffset     
; For stations, zoffset will end in 80h, not 00h.  If
; the value for zoffset is right you should be able to
; see a block between 100h and 180h which contains the
; ascii string "THIS IS A HEADER", and the "NEXT" value
; shown by ZDTI will end in 80h, not 00h.
;	-^C
;	A>save xx filename.com
;   In this case the value xx is the decimal
; representation of the high byte of the "NEXT" value.
; You do not subtract one as usual, because the extra
; 80h must be brought along.
;   Filename is the name by which this program will be
; known to SYSLIB, but the name will not be used by any
; other part of the boot process.
;	A>SYSLIB
;
;  - END OF SYSTEM GENERATION INSTRUCTIONS -

