MODULE CONS8086;
{ Raw CP/M-86 compatible console routines }

{ Relevant BIOS calls }
CONST
  BCONST	=	2;	{ XIOS/BIOS call }
  BCONIN	=	3;	{ XIOS/BIOS call }
  BCONOUT	=	4;	{ XIOS/BIOS call }
  BLSTOUT	=	5;
  dir_cons_io	=	6;	{ BDOS call }

TYPE
  ASCII_char_set = set of char;
  pt_string = ^string;
  ptr = ^integer;

  BIOS_entry_table = RECORD
		      cmd  : byte;
		      case Boolean of
		        true: (CXval : integer;
		      	       DXval : integer);
			false:(CXch  : char);
		     END; { RECORD }

  address	   = RECORD
		     case Boolean of
			  true: (offset:integer;
				 segment:integer);
			 false: (p:ptr);
		     END; { RECORD and Case }

VAR
{$E-}
  table  : BIOS_entry_table;
  a	 : address;
  dontcare : ptr;
  status,
    inpt   : byte;
{$E+}

EXTERNAL FUNCTION @BDOS86(func:integer; parm:ptr):char;
(************ NOT USED ************************************
{ call_BIOS_direct sets up a direct BIOS call to BIOS function
    func, and passes CX and DX appropriately.  }
FUNCTION call_BIOS_direct(func:integer; parm:ptr):char;
CONST
  direct_bios_call = $32;
VAR
  CX_DX : address;
BEGIN
  CX_DX.p := parm;
  table.cmd  := func;		 { BIOS function # }
  table.CXval := CX_DX.offset;
  table.DXval := CX_DX.segment;
  call_BIOS_direct := @BDOS86(direct_bios_call,addr(table));
END;
************* NOT USED ***************************************)

PROCEDURE console_BIOS_direct(func:integer; ch:char; var ret:char);
CONST
  direct_bios_call = $32;
BEGIN
  table.cmd := func;
  table.CXch := ch;
  ret := @BDOS86(direct_bios_call,addr(table));
END;

PROCEDURE cinit;
{ Set up directo bios calls.  }
BEGIN
{ Nothing needs to be done in CP/M-86
  since BDOS provides for direct BIOS calls }
END;

FUNCTION cstat:byte;
VAR
  dontcare, ret : char;
BEGIN
  console_BIOS_direct(BCONST, dontcare, ret);
  cstat := ord(ret);
END;

PROCEDURE out_ch(ch:char);
VAR
  dontcare : char;
BEGIN
  console_BIOS_direct(BCONOUT, ch, dontcare);
END;

PROCEDURE out_lst(ch:char);
VAR
  dontcare : char;
BEGIN
  console_BIOS_direct(BLSTOUT, ch, dontcare);
END;

FUNCTION keypressed : Boolean;	   { Uses direct BIOS call to constat }
BEGIN
  keypressed := (cstat<>0);
END;

FUNCTION in_echo : char;
VAR
  ch : char;
BEGIN
  ch := in_nech;
  in_echo := ch;
  out_ch(ch);
END;

FUNCTION in_nech : char;
VAR
  dontcare, ret : char;
BEGIN
{ NOTE: This call must use a DIRECT XIOS CONIN call so that when running
  under MP/M-86, console blocking will occur.   }
  console_BIOS_direct(BCONIN, dontcare, ret);
  in_nech := ret;
END;

MODEND.
