{ Include file MAILCOMM-- contains routines common to 
			  SENDMAIL and GETMAIL		     }

EXTERNAL FUNCTION @CMD:pstrg;
EXTERNAL PROCEDURE @HLT;

EXTERNAL PROCEDURE GDate(var date:date_array);
EXTERNAL PROCEDURE GTime(var time: time_array);

EXTERNAL PROCEDURE lock(s:rec_ptr);
EXTERNAL PROCEDURE unlock(s:rec_ptr);

EXTERNAL PROCEDURE C_init;	     { Set up direct BIOS calls }
EXTERNAL FUNCTION keypressed : Boolean;
EXTERNAL FUNCTION in_echo : char;    { Get console char and echo }
EXTERNAL FUNCTION in_nech :char;     { Get console char, no echo }
EXTERNAL PROCEDURE out_ch(ch:char);  { Send char to CONOUT }

EXTERNAL PROCEDURE p26_show_names(bad:string);
EXTERNAL PROCEDURE p35_read_and_echo_console_string(l:integer;s:string;
							echo:Boolean);
EXTERNAL PROCEDURE ucase(source:string; var up:string);

EXTERNAL FUNCTION ch_ucase(c:char):char;

EXTERNAL PROCEDURE strip_lead_blanks(var s:string);

EXTERNAL PROCEDURE remove_trail_blanks(var s: string);

EXTERNAL PROCEDURE clean(source:string; var result:string);

EXTERNAL PROCEDURE conv_i_s(i:byte; var s:string);

EXTERNAL PROCEDURE goto_row_col(row,col:byte);
(********
EXTERNAL PROCEDURE AM_PM(hour:byte;var resulting_hour:byte;var phrase:string);
	 ***************)

PROCEDURE p0_open_mail_partition;
VAR
  ptr : pstrg;
  posn : integer;
  pass : string[6];
  alien: Boolean;

{internal} PROCEDURE get_user_name;
	   BEGIN
    		writeln([addr(out_ch)]);
    		write([addr(out_ch)],'To whom do I have the pleasure of speaking? ');
    		write([addr(out_ch)],'[        ]',bs,bs,bs,bs,bs,bs,bs,bs,bs);
    		p35_read_and_echo_console_string(sizeof(source)-1,source,true);
    		clean(source,source);
	   END;

{internal} PROCEDURE get_header;
	   BEGIN
	     writeln([addr(out_ch)]);
	     if length(source)=0 then ERROR('');
	     s_no := f1_find_header(source);
	     if s_no=null then
	        begin
		  writeln([addr(out_ch)],'I don''t know you.');
		  writeln([addr(out_ch)],'Enter another name (or <CR> to quit)'); 
	        end
	     else
	        begin  { Have found name, now see about password. }
		  if NOT alien then 
		  with indx^.n_head[s_no] do
	 	   begin
	             if length(password)>0 then
	      		begin
			  write([addr(out_ch)],'Password: [      ]',
				     bs,bs,bs,bs,bs,bs,bs);
			  p35_read_and_echo_console_string(sizeof(pass)-1,
				pass,false);
			  writeln([addr(out_ch)]);
			  if pass<>password then ERROR('Not a valid Password!');
			end; {If password check required }
	           end; { with indx^ etc. }
	 	end; { else we recognize name }
	   END;

{internal} PROCEDURE init_VDT;
	   BEGIN
	     with indx^.n_head[s_no] do
  		begin
    		  clr_scrn := uclr_scrn;
    		  clr_line := uclr_line;
		  goto_esc := ugoto;
		  offset   := uoff;
		  row_first := r_then_c;
		  r_zero   := ur_zero;
		  c_zero   := uc_zero;
		  scrn_len := uscrn_len;
		end;
	   END;

BEGIN
  ptr := @CMD;
  if length(ptr^)=0 then cpm_drive := 'B'
  else
     begin
       posn := 1;
       while (ptr^[posn]=' ') AND (posn<=length(ptr^)) do
	     posn := posn + 1;
       if posn>length(ptr^) then ERROR('Confused by command line.');
       cpm_drive := ptr^[posn];
     end;
{ 'G' for 8086 version, 'D' for 8080 version }
  if NOT (cpm_drive in ['A'..'H']) 
     then ERROR('Illegal Drive for Mail Partition');
  assign(indx,concat(cpm_drive,':INDEX.ML'));
  reset(indx);
  if ioresult=255 then ERROR('Can''t find INDEX.ML');
  assign(msg,concat(cpm_drive,':MSG.ML'));
  reset(msg);
  if ioresult=255 then ERROR('Can''t find MSG.ML');

{ OK so far, so find out who this is... }
  writeln([addr(out_ch)]);
  writeln([addr(out_ch)]);
  REPEAT
    writeln([addr(out_ch)]);
    alien := false;
    get_user_name;
    if source='@' then { User at an alien terminal }
       begin
	 alien := true;
	 writeln([addr(out_ch)]);
	 write([addr(out_ch)],'Whose terminal are you using? ');
	 write([addr(out_ch)],'[        ]',bs,bs,bs,bs,bs,bs,bs,bs,bs);
    	 p35_read_and_echo_console_string(sizeof(source)-1,source,true);
	 clean(source,source);
	 writeln([addr(out_ch)]);
	 get_header;
	   if s_no<>null then 
	      begin
		init_VDT;	 
		get_user_name;	{ Now see if we'll let them on board. }
	      end;
       end;
    get_header;
			     UNTIL s_no<>null;
    if NOT alien then init_VDT;
END;


FUNCTION f1_find_header(who:string):integer;
VAR
  up_lim,
    l : integer;
  found : Boolean;
  u_name,
    u_who : string[8];
BEGIN
  up_lim := indx^.params.numb_names;
  found := false;
  l := 1;
  clean(who,u_who);
  while (l<=up_lim) AND (NOT found) do
    with indx^.n_head[l] do
      begin
	ucase(name,u_name);
	if u_name=u_who then
	   begin
	     f1_find_header := l;
	     found := true;
	   end
	else
	   l := l + 1;
      end;
  if NOT found then f1_find_header := null;
END;

PROCEDURE p11_draw_line;
VAR
  l : integer;
BEGIN
  for l:= 1 to sc_width do write([addr(out_ch)],'-');
  writeln([addr(out_ch)]);
END;

PROCEDURE twnb(ch:char);
BEGIN
  if wnb(ext,ch) then ERROR('Trouble writing');
END;

PROCEDURE twnbeol;
CONST
  ord_LF	=	$0A;
BEGIN
  twnb(cr); twnb(chr(ord_LF));
END;

PROCEDURE p110_draw_file_line;
VAR
  l : integer;
BEGIN
  for l:= 1 to sc_width do twnb('-');
  twnbeol;
END;


FUNCTION p31_ext_file_name_Ok(fname:string;var exists:Boolean):Boolean;
VAR
  f : string [15];
  ior : integer;
BEGIN
  clean(fname,f);
  if (f[1]=cpm_drive) and (f[2]=':') then
     begin
       writeln([addr(out_ch)]);
       writeln([addr(out_ch)],'Sorry, but you may not use the ');
       writeln([addr(out_ch)],'Mail Partition for this file.');
       p31_ext_file_name_Ok := false;
     end
  else
     begin
       assign(ext,f);
       p31_ext_file_name_Ok := true;
       reset(ext);
       if f[4]=':' then exists := false 	  { CON:, LST: etc. }
      else exists := (ioresult<>255);
     end;
END;

PROCEDURE p33_get_ext_file_name(var fi_name:string; sending: Boolean);
VAR
  i : integer;
BEGIN
  writeln([addr(out_ch)],'Please enter the file name.');
  if sending then  writeln([addr(out_ch)],'   Use  LST: for the printer,');
  writeln([addr(out_ch)],'   Just hit <CR> to quit.');
  write([addr(out_ch)],  '                 File: [              ]');
  for i:=1 to 15 do write([addr(out_ch)],bs);
{ WARNING! WARNING! 14 is hardwired in as SIZEOF(fi_name)
  since... mumble... Pascal can't compute SIZEOF of course,
  since fi_name is an argument... and well it's late at night...}
  p35_read_and_echo_console_string(14,fi_name,true);
  writeln([addr(out_ch)]);
  ucase(fi_name,fi_name);
END;

PROCEDURE p7_return_msg_to_free_list(ret_msg_ptr:rec_ptr);
VAR
  cursor,
    temp :rec_ptr;
  blk : m0_message_block;
BEGIN
{ Step 1:  Link all blocks of message together via name_link.
  Step 2:  Lock free list
  Step 3:  Insert all re-linked blocks at front of free list
  Step 4:  Unlock free list		   }
  cursor := ret_msg_ptr;
  seekread(msg,ret_msg_ptr);	    { Get first block of message }
  while msg^.msg_link <> null do
    begin
      msg^.name_link := msg^.msg_link;
      seekwrite(msg,cursor);
      cursor := msg^.msg_link;
      seekread(msg,cursor);
    end;
{ Here, msg^ contains last block of message.  Want to hold it
  for a while until we figure out what name_link it needs to
  point to rest of free list. }
  blk := msg^;
  lock(indx^.free);
  seekread(msg,indx^.free);	{ Get free list header record }
  temp := msg^.name_link;	{ Pointer to rest of free list }
  msg^.name_link := ret_msg_ptr;{ Top of message now first item on free list }
  seekwrite(msg,indx^.free);	{ Re-install free list header }
  blk.name_link := temp;
  msg^ := blk;
  seekwrite(msg,cursor);	{ Free list now contiguous again }
  unlock(indx^.free);
END;

{ End include file MAILCOMM }
