	.title	'Spool control program'
	.sbttl	'SPOOL'
version	==	1
revision==	0
;----------
; Control spooling - accept following commands:
;
; WAKE  - wake all waiting spool jobs
; ABORT - abort current printing job
; RETRY - restart current printing job
; MODE  - select spooling mode
;
;	1.  AUTOMATIC on serial port 2, print when done.
;	2.  AUTOMATIC on serial port 2, wait when done.
;	3.  AUTOMATIC on parallel port 2, print when done.
;	4.  AUTOMATIC on parallel port 2, wait when done.
;	5.  MANUAL, print when done.
;	6.  MANUAL, wait when done.
;
SPLready==	2	; status of ready job
SPLprint==	3	; status of printing job
SPLdone	==	4	; status of completed job
SPLwait ==	5	; status of waiting job
Mode	==	4Eh	; spool mode byte
modeSPL	==	2	; 0 = automatic
			; 1 = manual
modePRT	==	3	; 0 = serial
			; 1 = parallel
modeWAIT==	4	; 0 = immediate printing
			; 1 = delayed printing
lenentry==	16	; length of spool table entry
numentry==	16	; number of spool table entries
SPLtable==	0F500h	; address of spool table
bell	==	07h	; BELL
cr	==	0Dh	; RETURN
lf	==	0Ah	; LINEFEED
BDOS	==	5	; BDOS entry point
;----------
	.pabs
	.phex
	.loc	100h
	lda	47h	; get user number
	ora	A	; OK if HiNet master
	jrz	findcmd
	lxi	D,errmsg
	mvi	C,9
	call	BDOS
	ret
errmsg:	.ascii	"The SPOOL command can be used only at the master station.$"
;----------
; Look at command line
findcmd:
	lda	80h
	ora	A	; print help message
	jz	help	; if no command word entered
	lxi	D,commands
..next:	ldax	D
	ora	A
	jrz	synerr
	res	0,B	; assume match
	lxi	H,82h
..cmp:	
	ldax	D
	ora	A	; check for end of entry
	jrz	..chk
	cmp	M
	jrz	..yes
	set	0,B	; no match
..yes:	inx	H
	inx	D
	jmpr	..cmp
..chk:	
	inx	D
	bit	0,B
	jrz	..match
	inx	D
	inx	D
	jmpr	..next
..match:
	ldax	D
	mov	L,A
	inx	D
	ldax	D
	mov	H,A
	pchl		; jump to appropriate routine
;----------
; Spool options
commands:
	.asciz	"WAKE"
	.word	wake
	.asciz	"RETRY"
	.word	retry
	.asciz	"ABORT"
	.word	abort
	.asciz	"MODE"
	.word	setmode
	.byte	0	; end of command list
;----------
; Syntax error
synerr:
	lxi	D,synmsg
	mvi	C,9
	call	BDOS
	jmpr	help
synmsg:	.ascii	[bell][cr][lf]'*** SPOOL command syntax error$'
;----------
; Help the user
help:
	lxi	D,helpmsg
	mvi	C,9
	call	BDOS
	ret
helpmsg:
	.ascii	[cr][lf]"SPOOL version "
	.byte	version+'0','.'
	.byte	revision/10+'0',revision@10+'0'
	.ascii	[cr][lf]
	.ascii	[cr][lf]"Spooling options"
	.ascii	[cr][lf]"----------------"
	.ascii	[cr][lf]
	.ascii	[cr][lf]"ABORT - abort current print job"
	.ascii	[cr][lf]"RETRY - retry current print job"
	.ascii	[cr][lf]"WAKE  - activate all waiting jobs"
	.ascii	[cr][lf]"MODE  - set spooling mode"
	.ascii	[cr][lf]
	.ascii	[cr][lf]" MODE1 - AUTOMATIC on serial port 2, print when done."
	.ascii	[cr][lf]" MODE2 - AUTOMATIC on serial port 2, wait when done."
	.ascii	[cr][lf]" MODE3 - AUTOMATIC on parallel port 2, print when done."
	.ascii	[cr][lf]" MODE4 - AUTOMATIC on parallel port 2, wait when done."
	.ascii	[cr][lf]" MODE5 - MANUAL, print when done."
	.ascii	[cr][lf]" MODE6 - MANUAL, wait when done."
	.ascii	[cr][lf]
	.ascii	[cr][lf]"For example, the command 'SPOOL ABORT'"
	.ascii	[cr][lf]"will stop the printer and erase the file"
	.ascii	[cr][lf]"which is currently being printed."
	.ascii	[cr][lf]
	.byte	'$'
;---------------
; Abort current print job
abort:
	lxi	H,SPLtable
	lxi	D,lenentry
	mvi	B,numentry
	di
..search:
	mov	A,M
	cpi	SPLprint
	jrz	..abort
	dad	D
	djnz	..search
	ei
	lxi	D,nonemsg
	mvi	C,9
	call	BDOS
	ret
..abort:mvi	M,SPLdone
	ei
	ret
nonemsg:.ascii	"Sorry, no spool job is currently printing.$"
;----------
; Retry current print job
retry:
	lxi	H,SPLtable
	lxi	D,lenentry
	mvi	B,numentry
	di
..search:
	mov	A,M
	cpi	SPLprint
	jrz	..retry
	dad	D
	djnz	..search
	ei
	lxi	D,nonemsg
	mvi	C,9
	call	BDOS
	ret
..retry:mvi	M,SPLready
	ei
	ret
;---------------
; Wake waiting spool jobs
wake:
	lxi	H,SPLtable
	lxi	D,lenentry
	mvi	B,numentry
	di
..search:
	mov	A,M
	cpi	SPLwait
	jrnz	..next
	mvi	M,SPLready
..next:
	dad	D
	djnz	..search
	ei
	ret
;----------
; Set spool mode
setmode:
;
; Print current mode
	lxi	D,oldmsg
	mvi	C,9
	call	BDOS
	call	prtmode
;
; Make sure that nobody is printing right now
	lxi	H,SPLtable
	lxi	D,lenentry
	mvi	B,numentry
..search:
	mov	A,M
	cpi	SPLprint
	jz	..noprint
	dad	D
	djnz	..search
;
; If new mode on command line, use it
	lda	86h	; should be here
	cpi	'1'
	jrc	..chknext
	cpi	'7'
	jrnc	..chknext
	sui	'0'
	jmpr	..ok	; use mode on command line
..chknext:
	lda	87h	; must be here, if at all
	cpi	'1'
	jrc	..prnt
	cpi	'7'
	jrnc	..prnt
	sui	'0'
	jmpr	..ok	; use mode on command line
..prnt:
	lxi	D,askmsg
	mvi	C,9
	call	BDOS
..ask:
	lxi	D,askbuff
	mvi	C,10
	call	BDOS
	lda	askbuff+2
	sui	'0'
..ok:
	cpi	1
	jrz	..1
	cpi	2
	jrz	..2
	cpi	3
	jrz	..3
	cpi	4
	jrz	..4
	cpi	5
	jrz	..5
	cpi	6
	jrz	..6
	lxi	D,reaskmsg
	mvi	C,9
	call	BDOS
	jmpr	..ask
;
; Select mode bits
..1:
	mvi	B,(0<modeWAIT)+(0<modePRT)+(0<modeSPL)
	jmpr	..change
..2:
	mvi	B,(1<modeWAIT)+(0<modePRT)+(0<modeSPL)
	jmpr	..change
..3:
	mvi	B,(0<modeWAIT)+(1<modePRT)+(0<modeSPL)
	jmpr	..change
..4:
	mvi	B,(1<modeWAIT)+(1<modePRT)+(0<modeSPL)
	jmpr	..change
..5:
	mvi	B,(0<modeWAIT)+(0<modePRT)+(1<modeSPL)
	jmpr	..change
..6:
	mvi	B,(1<modeWAIT)+(0<modePRT)+(1<modeSPL)
;
; Mask into mode byte in low core
..change:
	lxi	H,Mode
	mov	A,M
	ani	11100011b ; throw away old bits
	ora	B
	mov	M,A
	lxi	D,newmsg
	mvi	C,9
	call	BDOS
	jmpr	prtmode	; print new spool mode
;
; The spool mode cannot be changed while a file is printing
..noprint:
	lxi	D,prntmsg
	mvi	C,9
	jmp	BDOS
;----------
; Console buffer
askbuff:.byte	10,0
	.blkb	10
;----------
; Print current spool mode
prtmode:
	lda	Mode
	bit	modeSPL,A
	jrz	..auto
	lxi	D,manmsg
	mvi	C,9
	call	BDOS
	jmpr	..chkwait
..auto:	lxi	D,automsg
	mvi	C,9
	call	BDOS
	lda	Mode
	bit	modePRT,A
	jrz	..serial
	lxi	D,parmsg
	mvi	C,9
	call	BDOS
	jmpr	..chkwait
..serial:
	lxi	D,sermsg
	mvi	C,9
	call	BDOS
..chkwait:
	lda	Mode
	bit	modeWAIT,A
	jrz	..immed
	lxi	D,delaymsg
	mvi	C,9
	jmp	BDOS
..immed:
	lxi	D,immedmsg
	mvi	C,9
	jmp	BDOS
;----------
; Spooling messages
oldmsg: .ascii	[cr][lf]"The current spool mode is $"
newmsg:	.ascii	[cr][lf]"The new spool mode is $"
automsg:.ascii	"AUTOMATIC$"
parmsg:	.ascii	" on parallel port 2, $"
sermsg: .ascii	" on serial port 2, $"
manmsg: .ascii	"MANUAL, $"
delaymsg:.ascii "wait when done."[cr][lf]
	.byte	'$'
immedmsg:.ascii	"print when done."[cr][lf]
	.byte	'$'

prntmsg:.ascii	[cr][lf]"The spool mode cannot be changed "
	.ascii		"while a file is being printed.$"

askmsg:	.ascii	[cr][lf]"Enter a digit from 1 to 6 "
	.ascii		"to select a new spooling mode:"
	.ascii	[cr][lf]
	.ascii	[cr][lf]"1.  AUTOMATIC on serial port 2, print when done."
	.ascii	[cr][lf]"2.  AUTOMATIC on serial port 2, wait when done."
	.ascii	[cr][lf]"3.  AUTOMATIC on parallel port 2, print when done."
	.ascii	[cr][lf]"4.  AUTOMATIC on parallel port 2, wait when done."
	.ascii	[cr][lf]"5.  MANUAL, print when done."
	.ascii	[cr][lf]"6.  MANUAL, wait when done."
	.ascii	[cr][lf]
	.ascii	[cr][lf]"Your selection, please (control-C to abort): "
	.byte	'$'
reaskmsg:.ascii	[cr][lf]"Please enter a digit from 1 to 6 (or control-C): $"
.end
