h45036
s 00107/00000/00000
d D 1.1 83/03/23 16:17:18 bog 1 0
c date and time created 83/03/23 16:17:18 by bog
e
u
4
U
t
T
I 1
#############################################################################
#									    #
#	This material is confidential and is furnished under		    #
#	a written license agreement.  It may not be used,		    #
#	copied or disclosed to others except in accordance		    #
#	with the terms of that agreement.				    #
#									    #
#	Copyright (C) 1982 Graphic Software Systems, Inc.		    #
#	All rights reserved.						    #
#									    #
#############################################################################
#									    #
#	Function:  							    #
#		Character Function EmIKb (Ch)				    #
#			Output	Ch:	Character in [all keys,EMPTY]	    #
#		    Get Ch from the keyboard; filter for special keys.	    #
#		    Fetch from BanStr during init time.			    #
#									    #
#	Called By:							    #
#		Subroutine EmPoll ()					    #
#		    4012/4014 Emulator Main Polling Loop		    #
#									    #
#	Routines Called:						    #
#		Subroutine GETKB (Ch)					    #
#			Output	Ch:	Integer in [EMPTY,NUL..DEL]	    #
#		    Get Ch from the keyboard.  Other special keys may	    #
#		    also be returned.					    #
#									    #
#############################################################################
 
CHARACTER Function EmIKb(Ch)
CHARACTER Ch
 
CHARACTER Char			#Local holder of this character
CHARACTER C			#Local temporary
CHARACTER Ptr			#Local pointer at target strings
CHARACTER PMatch		#Ptr to match string prior to this char
 
LOGICAL CMatch			#True if continuing match found
 
BEGINCOMMON
COMMON(SPECIALKEYS)
COMMON(CONFIG)
ENDCOMMON
 
If (CfgPtr > CfgLen) {		#Post-initialization
  If (KbTos > 0) {		#Kb stack not empty
    Char = KbStak(KbTos)	#Pop top of stack
    KbTos = KbTos-1
    }
   Else {			#Stack empty
    GETKB(Char)			#Get actual keyboard character
    }
  }
 Else {				#Init time
  Char = Config(CfgPtr)		# Get keystrikes from intialization
  CfgPtr = CfgPtr+1		#  table for configuration
  }
 
If ((Char != EMPTY) & !Edting) {
  LookLn = LookLn+1			#Bump length of current match try
  CMatch = FALSE			#No continuing match found yet
  For (Ptr = TargPt; Ptr != 0; Ptr = Target(Ptr)) {	#Loop through targets
    If ((Target(Ptr+MATCHSOFAR) != 0) |	#Continue match?
	(LookLn == 1)) {		#or first time?
      C = Ptr+LookLn		#Look at char corresponding to this
      If (Target(C+STRING) == Char) {	#Still matching?
	If (LookLn == Target(Ptr+STRINGLENGTH)) {#Definite match
	  Char = Target(Ptr+TRANSLATION)
	  CMatch = FALSE	#Force definite match
	  LookLn = 0		#Force empty stack
	  Break		#Fall out of For
	  }
	 Else {			#Not yet a definite match
	  Target(Ptr+MATCHSOFAR) = 1	#Show continuing match
	  CMatch = TRUE		# & set cont found sw
	  }
	}
       Else {			#No longer matches
	Target(Ptr+MATCHSOFAR) = 0	#Show no longer a match
	PMatch = Ptr			#Point to prior match string
	}
      }
    }
  If (CMatch) {			#Continuing match
    Char = EMPTY			#Return EMPTY for polling
    }
   Else {				#Definite match or no match
    If (LookLn > 1) {		#Unget last back thru 2nd chars
      Call EmPKb(Char)		#Push key on stack
      For (C = PMatch+LookLn+eval(STRING-1);
		C > PMatch+eval(STRING+1);
		C = C-1) {
	Call EmPKb(Target(C))	#Push next-last thru 2nd
	}
      Char = Target(PMatch+eval(STRING+1))#Return 1st char looked for
      }
    LookLn = 0			#Reset for next time through
    }
  }
 
Ch = Char
EmIKb = Char
 
Return
 
End
E 1
