h50741
s 00000/00000/00066
d D 1.2 83/03/31 12:36:16 mmm 2 1
c 
e
s 00066/00000/00000
d D 1.1 83/03/15 21:41:05 tes 1 0
c date and time created 83/03/15 21:41:05 by tes
e
u
4
U
t
T
I 1
subroutine grqch (wkid, chdnr, inich, stat, chnr)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Request choice                                         #
#                                                                      #
#     Input Parameters:                                                #
#            wkid   - workstation identifier                           #
#            chdnr  - choice device number                             #
#            inich  - initial choice number                            #
#     Output Parameters:                                               #
#            stat - status (OK = 1, NONE = 0)                          #
#            chnr - choice number                                      #
#                                                                      #
#     Errors:                                                          #
#            7 GKS not in proper state: GKS must be in one of the      #
#              states WSOP, WSAC or SGOP                               #
#           20 Specified workstation identifier is invalid             #
#           25 Specified workstation is not open                       #
#           36 Specified workstation is neither an input workstation   #
#              nor an output/input workstation                         #
#                                                                      #
#     Routines Called:                                                 #
#            gzddop - call current device driver                       #
#            errchk - perform appropriate error checking               #
#                                                                      #
########################################################################
integer wkid, chdnr, inich, stat, chnr
 
ifdef(`ERROR_ON',`
   integer errchk, errind, ierdum(1)
   ')

integer contrl(5), intin(2), intout(1), ptsdum(1)
 
include(`gkscom')
 
ifdef(`ERROR_ON',`
      rounum = GRQCH
      errind = errchk(wkid, ierdum)
      ')
 
   contrl(OPCODE) = INPUTxCHOICE
   contrl(VERTICESxIN) = 0

   intin(1) = chdnr
   intin(2) = inich
   contrl(5) = NONE  # initialize output for non-choice devices 
   intout(1) = NONE

   call gzddop (contrl, intin, ptsdum, intout, ptsdum)

   # Return the choice (zero means no choice) and status
   stat = contrl(5)
 
   chnr = intout(1)

   return
end
E 1
