h60282
s 00002/00002/00071
d D 1.2 83/03/31 12:40:13 mmm 2 1
c 
e
s 00073/00000/00000
d D 1.1 83/03/15 21:42:40 tes 1 0
c date and time created 83/03/15 21:42:40 by tes
e
u
4
U
t
T
I 1
subroutine gslwsf (lwidsf)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Set line width scale factor                            #
#                                                                      #
#     Input Parameters:                                                #
#            lwidsf - line width scale factor                          #
#      Output Parameters:                                              #
#            none                                                      #
#                                                                      #
#      Errors:                                                         #
#            8  GKS not in proper state: GKS must be in one of the     #
#               states GKOP, WSOP, WSAC, or SGOP                       #
#                                                                      #
#     Routines Called:                                                 #
#            errchk - perform appropriate error checking               #
#            gzddop - d/i driver interface                             #
#                                                                      #
########################################################################
real lwidsf

integer contrl(5), opcd, vertin, idummy(1), ptsin(2), ptsin1, ptsin2,
	ptsout(2), ptsou1, nomwid

D 2
REALS GETREAL
E 2
I 2
real gtreal 
E 2

ifdef(`ERROR_ON',`
   integer errchk, errind, ierdum(1)
   ')

include(`gkscom')

equivalence (contrl(OPCODE), opcd), (contrl(VERTICESxIN), vertin),
	    (ptsin(1), ptsin1), (ptsin(2), ptsin2),
	    (ptsout(1), ptsou1)

ifdef(`ERROR_ON',`
      rounum = GSLWSF
      errind = errchk(ierdum(1), ierdum)
      ')

   #     contrl(OPCODE) = SETxPOLYLINExLINExWIDTH
   opcd = SETxPOLYLINExLINExWIDTH
   #     contrl(VERTICESxIN) = 1
   vertin = 1

   nomwid = mnlnwd
   if (nomwid <= 0) nomwid = 1 # Check for mnlnwd = 0 for continous devices

   #     ptsin(1) = lwidsf * nomwid  (convert scale factor to linewidth)
D 2
   ptsin1 = GETREAL(lwidsf) * float(nomwid) + 0.5 
E 2
I 2
   ptsin1 = gtreal (lwidsf, 0) * float(nomwid) + 0.5 
E 2
   #     ptsin(2) = 0.0
   ptsin2 = 0.0

   #  Set output to nomwid for devices which don't support linewidths
   #     ptsout(1) = nomwid
   ptsou1 = nomwid

   call gzddop (contrl, idummy, ptsin, idummy, ptsout)

   # Set line width scale factor in common
   lnwdsf = float(ptsou1) / float(nomwid)

   return
end
E 1
