h64592
s 00000/00000/00067
d D 1.2 83/03/31 12:45:01 mmm 2 1
c 
e
s 00067/00000/00000
d D 1.1 83/03/15 21:44:32 tes 1 0
c date and time created 83/03/15 21:44:32 by tes
e
u
4
U
t
T
I 1
subroutine gwddc2 (linein, linout, q1move, q2move, qgone)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#          COPYRIGHT (C) 1981 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: transform and clip a line from world to device coord.  #
#                                                                      #
#     Input Parameters:                                                #
#            linein - world coordinates of input line                  #
#                                                                      #
#     Output Parameters:                                               #
#            linout - device coordinates of transformed, clipped line  #
#            q1move - .TRUE. if first point has been moved             #
#            q2move - .TRUE. if second point has been moved            #
#            qgone  - .TRUE. if input line is not visible              #
#                                                                      #
#     Routines Called:                                                 #
#            gzndcd - transform a point from ndc to device space       #
#            gzwndc - transform a point from world to ndc space        #
#            gzclip - clip a line in to the current clipping edge      #
#                                                                      #
########################################################################
integer linout(4)
real linein(4)           
logical q1move, q2move, qgone

real xndc1, yndc1, xndc2, yndc2, pndc1(2), pndc2(2),
     xdc1, ydc1, xdc2, ydc2, pdc1(2), pdc2(2)

include(`gkscom')
 
equivalence (xndc1, pndc1(1)), (yndc1, pndc1(2)), (xndc2, pndc2(1)),
	    (yndc2, pndc2(2)),
            (xdc1, pdc1(1)), (ydc1, pdc1(2)), (xdc2, pdc2(1)), (ydc2, pdc2(2))

   # Transform line from world to ndc space

   call gzwndc (linein(1), linein(2), xndc1, yndc1)
   call gzwndc (linein(3), linein(4), xndc2, yndc2)
   
   # Clip line to world window
   
   call gzclip (pndc1, pndc2, q1move, q2move, qgone)
   if (!qgone) {
      
      # If any portion of the line is still visible then
      # convert to workstation coordinates

      call gzndcd (xndc1, yndc1, xdc1, ydc1)
      call gzndcd (xndc2, yndc2, xdc2, ydc2)
	 
      linout(1) = xdc1
      linout(2) = ydc1
      linout(3) = xdc2
      linout(4) = ydc2
      }
   return
end
E 1
